function [ doResample, effectiveSampleSize ] = resamplecheck( logParticleWeights, essThreshold, nParticles )
    % Return a logical scalar indicating whether a sample of particles
    % should be resampled, based on computing the effective sample size
    % (ESS) and comparing against a threshold.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % logParticleWeights - column vector of the (log) particle weights.
    %
    % essThreshold - numeric scalar: the threshold of ESS below which
    % resampling is triggered. Lowering this value will improve
    % computational performance of the algorithm but adversely affect
    % accuracy of results. A balance must be saught.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 16.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if size(logParticleWeights, 2) ~= 1,
        error('logParticleWeights should be a column vector!')
    end
    if any(logParticleWeights > 0),
        error('logParticleWeights should be a vector of log probabilities!')
    end
    if nargin < 3,
        nParticles = length(logParticleWeights);
    else
        if length(logParticleWeights) ~= nParticles,
            error('logParticleWeights must have nParticles elements!')
        end
    end

    effectiveSampleSize = computeess( logParticleWeights, nParticles );
    if effectiveSampleSize < essThreshold,
        doResample = true;
    else
        doResample = false;
    end
end