function logPoissonLikelihoodFactor = computepoissonloglikleihoodnormalisingconstant( discreteSpikeTrainsMat, discreteTimeBinWidth )
    % This function computes the (log) normalising factor for the joint
    % spikes likelihood (all spike trains) under the Poisson model, at each
    % time of the discretised observations process.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % discreteSpikeTrainsMat - matrix of spike trains as counts in
    % fixed-width time bins. Time indexes rows, spike trains index columns.
    %
    % discreteTimeBinWidth - the bin width, in seconds.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 03.07.2013 - created, coded.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if nargin < 2,
        error('Insufficient arguments!')
    end
    if islogical(discreteSpikeTrainsMat),
        error('For the Poisson spike count model we should not have a logical discretised spike trains matrix!')
    end

    sumOfCounts = sum(discreteSpikeTrainsMat, 2);
    sumOfLogFactorials = nan([size(discreteSpikeTrainsMat, 1), 1]);
    timeBinLogVec = any(~isnan(discreteSpikeTrainsMat), 2);
    sumOfLogFactorials(timeBinLogVec) = log(10) * sum(logfactorial(discreteSpikeTrainsMat(timeBinLogVec, :)), 2);

    logPoissonLikelihoodFactor = log(discreteTimeBinWidth) * sumOfCounts - sumOfLogFactorials;
end