function y = sumlogprobmat(x, dim)
    % Sum a matrix of log probabilities in a specified dimension with
    % avoidance of underflow.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 13.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    maxX = max(x, [], dim);
    maxX(maxX == -Inf) = 0;
    y = log(sum(exp(bsxfun(@minus, x, maxX)), dim)) + maxX;
end