function augStateComponents = formaugmentedstatecomponents( nStates, nAugStates )
    % Form a matrix of two columns that lists the components (true state,
    % distinct state count) that constitute each 'augmented' state.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % augStateComponents - 2-D matrix with 2 columns. Augmented states
    % index rows. The first column is the corresponding 'true' state, and
    % the second column is the corresponding 'max' state or count of how
    % many distinct true states have been exhibited so far when this
    % augmented state is exhibited.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % CHANGELOG
    % 01.10.2014 - copied from old version.
    %
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if nargin < 2,
        nAugStates = nStates * (nStates + 1) / 2;
    end
    
    augStateComponents = zeros([nAugStates, 2]);

    ii = 1;
    for iState = 1:nStates,
        for iAug = 1:iState,
            augStateComponents(ii, 1) = iAug;
            augStateComponents(ii, 2) = iState;
            ii = ii + 1;
        end
    end
end