% DATA PARAMETERS
% In units of raw data.
dataInterval = [];
dataIntervalProportions = [0, 1];
% In units of raw data.
% Kenan day 3 (LT1), all epochs.
% analysisIntervals = [
%   9259176, 20449218;
%   20449516, 30328616;
%   30330344, 42614639;
%   42614889, 53132370;
%   53138724, 69446636
% ];
% Jasper trained (TM1), all epochs.
analysisIntervals = [
   22210616, 61400366; % 22210616 (pc used) or 22210939 (pfc only) or 22212229 (hpc only).
   61400367, 83969729; %61400367.86, 83969728.39;
   83969730, 123913441
];
analysisIntervalsProportions = [0, 1];
% For purposes of converting time to seconds.
timeConversionFactor = 1e-4;
% Spatial discretisation parameters.
maxSpatialDimensionSize = 32;
smoothingWidth = 2;
% Fixed interval width, in seconds, between position observations. If NaN
% given we will use the mean of the intervals of the supplied data.
% (This is ignored in discrete time model.)
posObsInterval = 1;

% MODEL PARAMETERS
% Which model to use?
% 1: discrete time HMM.
% 2: continuous time MJP.
modelIndicator = 1;
% Maximum permitted number of states.
maxNStates = 8;
% Should we estimate the number of states (up to maxNStates)? If false we
% use maxNStates as number of states.
estimateNStates = true;
% Which prior should we use on number of states?
% 1 for uniform.
% 2 for geometric with parameter 1/maxNStates.
stateDimPriorIndicator = 1;
% Should we use the augmented state space idea of Chopin (2007)? Necessary
% to make the model identifiable with exchangeable parameters. Also
% necessary to estimate the number of states.
useAugStateModel = true;
% What initial state distribution should we use? If we are using the
% augmented state model this is ignored.
% 1 for uniform.
% 2 for stationary distribution of Markov jump process.
% 3 to perform inference for these.
initialStateModelIndicator = 3;
% Cts-time model:
% Multiplicative factor for the greatest Markov process jump rate, to be
% used as rate in the dominating Poisson process. Must be greater than 1.
% Greater values make algorithm converge faster but require longer
% computation time. Recommended between 2 and 10.
dominatingRateScalingFactor = 2;
% Cts-time model:
% 1 for continuous time events arrival model.
% 0 for no spike train model.
% Discrete-time model:
% 1 for Bernoulli model.
% 2 for Poisson count model.
% 0 for no spike train model.
spikeTrainModelIndicator = 2;
% 1 for continuous space Ornstein-Uhlenbeck model.
% 2 for discrete space model.
% 0 for no position model.
positionModelIndicator = 2;
% Cts-time position model:
% 1 for uncorrelated, isotropic.
% 2 for uncorrelated, anisotropic.
% 3 for correlated, anisotropic (only implemented for discrete space
% model).
% 0 for no inference, use fixed value.
positionJitterModelIndicator = 3;
% PRIOR DISTRIBUTIONS
% Cts-time model:
% 1 for Gam(1, 1).
% 2 for Gam(1/2, 1/2).
% 3 for near-Jeffreys.
% 4 to specify below.
jumpRatePriorIndicator = 4;
% Cts-time model:
jumpRateGammaHyperparams = [1, 10];
% 1 for Dirichlet, all ones.
initialStateDistPriorIndicator = 1;
% Spike train model:
% 1 for Gam(1, 1).
% 2 for Gam(1/2, 1/2).
% 3 for near-Jeffreys.
spikeRatePriorIndicator = 2;
% Test.
randomWalkState = 0;
% Cts-time position model:
% Lower and upper limits (exclusive) for drift rates. Should be between 0
% and 1.
driftRatePriorLowerBound = 0;
driftRatePriorUpperBound = 1;
% Cts-time position model:
% (Ignored in the current implementation.)
% 1 for Gam(1, 1).
% 2 for Gam(1/2, 1/2).
% 3 for near-Jeffreys.
% 4 for prior based on 'state field' ideal (see below).
% 5 for specified Gamma (see below).
jitterPriorIndicator = 4;
jitterGammaHyperparams = [100, 1];
% Position model covariance: this can be thought of as the a priori average
% size of a 'state field', as a proportion of the shortest dimension of the
% maze.
stateFieldSizeAsProportionOfShortestMazeDim = 1/8;
% This can be thought of as the number of position observations we used to
% arrive at the previous parameter. Must be at least 2.
nPriorObservationsForPositionModel = 2;
% For correlated position model only: Pearson's correlation coefficient for
% the two spatial dimensions.
priorSpatialCorrelationCoef = 0;

% ALGORITHM PARAMETERS
debugMode = false;
% 1: SMC algorithm.
% 2: Gibbs sampler, alone.
inferenceAlgorithmIndicator = 1;
% Test. Leave as 1.
nSweepsForMjpPost = 1;
% SMC PARAMETERS
% Number of particles. Greater means more accurate inferences but longer
% computation time.
nParticles = 500;
% The fast move kernel improves computation time but has unknown effects on
% Monte Carlo variance of sample, probably adverse. Experimental only.
useFastMoveKernel = false;
useResampling = true;
% Should we resample at every time step of the SMC algorithm?
alwaysResample = false;
% Test. Leave as false.
alwaysSampleParameters = false;
% Time step in discrete time algorithm.
updateStepInterval = 2;
% Number of particle update steps. The previous parameter overrides this.
nUpdateSteps = 100;
% ESS: measure of particle population degeneracy. When it reaches this
% threshold we resample. The greater the better, but longer computation
% time implied. Must be greater than 1.
essThreshold = nParticles / 10;
% Number of iterations of the particle 'move' kernel to employ each time we
% resample particles. Positive integer. Greater values mean faster
% convergence but longer computations.
nGibbsSweepsPerResampleMove = 1;
% Next 4 parameters control the 'positive discrimination' method of
% maintaining particle populations at small state space dimension.
usePositiveDiscrimination = true;
positiveDiscriminationThreshold = 1/(1.5*maxNStates);
% This would maintain all subpopulations at the same size.
% positiveDiscriminationThreshold = 1/maxNStates;
allowSmallSubpopulationsToGoExtinct = true;
smallSubpopulationBuffer = 2;
% Upper limit to number of jumps we can sample for an MJP. Will bias
% inference results unless left as NaN.
maxNJumpsLimit = NaN;
% For memory management.
% memorySafetyFactor = 0.95;
memorySafetyFactor = 2;
% Gibbs sampler parameters.
nStreams = 10;
nGibbsSweeps = 5;
nBurnInSweeps = 0;
% Plotting parameters.
exportPlots = true;
displayPlots = false;
linuxPdfDirectory = '/home/marc/docs/phd/images/pdf/';
linuxEpsDirectory = '/home/marc/docs/phd/images/eps/';
linuxPngDirectory = '/home/marc/docs/phd/images/png/';
windowsPdfDirectory = 'O:\Documents\phd\images\pdf\';
windowsEpsDirectory = 'O:\Documents\phd\images\eps\';
windowsPngDirectory = 'O:\Documents\phd\images\png\';
doPng = false;
doEps = true;
doPdf = true;
box = 'on';
% To pause model fitting computations. Leave as [] if unused.
% Day (of month), hour, minute e.g. [04, 09, 30] for the 4th at 9:30am.
pauseTime = [];

% SIMULATION PARAMETERS
% Leave this as 2.
simModelIndicator = 2;
% Data start and end times, in seconds.
simDataIntervals = [
    0, 1000
];
% 1 for a RUN epoch, 0 for a SLEEP epoch. In a SLEEP epoch, a position
% trajectory is sampled, and spikes sampled conditioned on those positions.
% Thus a position model is required in order to simulate SLEEP data.
intervalTypes = [1];
nSimStates = 6;
% 1 for uniform.
% 2 for stationary distribution of Markov jump process.
simInitialStateModelIndicator = 2;
% Continuous time:
% 1 for continuous time events arrival model.
% 0 for no spike train model.
% Discrete time:
% 1 for Bernoulli.
% 2 for Poisson count.
% 0 for no spike train model.
simSpikeTrainModelIndicator = 1;
nSimSpikeTrains = 10;
% 1 for continuous space Ornstein-Uhlenbeck model.
% 2 for discrete position model.
% 0 for no position model.
simPositionModelIndicator = 1;
% 1 for Gam(1, 1).
% 3 for near-Jeffreys.
% 4 to specify gamma parameters.
simJumpRateDistIndicator = 4;
% To specify:
% simJumpRateGammaHyperparams = [1, 50];
% simJumpRateGammaHyperparams = [1, 20];
simJumpRateGammaHyperparams = [25, 1000];
% 1 for Dirichlet, all ones.
simInitialStateDistDistIndicator = 1;
% Spike train model:
% 1 for Gam(1, 1).
% 3 for near-Jeffreys.
% 4 to specify gamma parameters.
simSpikeRateDistIndicator = 4;
% To specify:
% spikeRateGammaHyperparams = [1/8, 1/8];
spikeRateGammaHyperparams = [1, 5/3];
% Make one state a random walk?
% Put 0 if not using.
simRandomWalkState = 0;
% Position model:
% Lower and upper limits (exclusive) for drift rates (not including random
% walk state).
simDriftRateLowerBound = 0.8;
simDriftRateUpperBound = 1;
% 0 for constant observation error: see below.
% 1 for Gam(1, 1).
% 3 for near-Jeffreys.
simPositionObsErrorDistIndicator = 0;
% For constant observation error. Interpretation: what is probability of
% mistaking the true position by more than one pixel?
simPositionObsErrorTolerance = 0.01;
% 0 for fixed value.
% 1 for uncorrelated, isotropic.
% 2 for uncorrelated, anisotropic.
% 3 for correlated model.
simPositionJitterModelIndicator = 2;
% 1 for Gam(1, 1).
% 3 for near-Jeffreys.
% 4 for prior based on 'state field' ideal (see below).
% 5 for specified Gamma (see below).
simJitterDistIndicator = 4;
simJitterGammaHyperparams = [1, 0.01];
% Jitter covariance: this can be thought of as the a priori average size of
% a 'state field', as a proportion of the shortest dimension of the maze.
simStateFieldSizeAsProportionOfShortestMazeDim = 1/8;
% To add dimension to the previous parameter.
simDiscreteMazeDims = [32, 32];
% This can be thought of as the number of position observations we used to
% arrive at the previous parameter. Must be at least 2.
nPriorObservationsForSimPositionModel = 20;
% For correlated jitter model only: Pearson's correlation coefficient for
% the two spatial dimensions.
simPriorSpatialCorrelationCoef = 0;
% The size of the area in which we simulate position data, in pixels.
simMazeDims = [100, 100];
% The meaning of this parameter is: how many distinct positions can we
% sample from in simulating the asymptotic mean position?
nPossibleDistinctMeans = 100;
% Minimum distance between possible distinct means, in pixels.
simPosMeanSpacing = 10;
% Time interval between simulated position observations, in seconds.
simPosObsInterval = 1;
% Position discretisation resolution for simulated data.
simMaxSpatialDimensionSize = 16;
simSmoothingWidth = 15;
% This will enforce transitions that simulate a linear track (i.e. directed
% travel rather than random wandering) in RUN data. An additional parameter
% must then be supplied: linearTrackGeneratorMat.
doLinearTrackProcess = false;
