        parameter(kmaxmax=10,nkmax=20)

        character ck,sep
        character*6 num
        character*16 word,tag,prfx
        logical qfile,qq,qsave,qperm,qsokal
        integer count,seed,sweep
        real ld,logr2pi,logratio,lp,lpn,target,logdt
        dimension sc(nkmax,kmaxmax),av(nkmax,kmaxmax),
     &	b(nkmax,nkmax,kmaxmax)
        dimension nk(kmaxmax),ld(kmaxmax),count(nkmax),par(nkmax),
     &	parn(nkmax)
        dimension work(nkmax)
        real*8 xr(32768),xi(32768)

        data sep/"/"/

c.. function target(k,par):
c                 k=0       - returns k=kmax
c            1<=k<=kmax   - evaluates log posterior at (k,par)
c       kmax+1<=k<=2*kmax - returns k = nk(k-kmax)
c     2*kmax+1<=k<=3*kmax - returns par = starting values
c     3*kmax+1<=k<=4*kmax - returns par = spread parameters

        logr2pi = 0.5*log(2*3.141592653)
        condt = 0.0

c.. command line arguments

        nsweep = 1000
        tag = ''
        ndf = 0
        seed = 0
        qsave = .false.
        qperm = .false.
        qsokal = .true.
        nsokal = 1

        do ia = 1,iargc()
           call getarg(ia,word)
           if(word(1:2).eq.'-n') then
                read(word,'(2x,i14)') nsweep
           else if(word(1:2).eq.'-t') then
                read(word,'(2x,i14)') ndf
           else if(word(1:2).eq.'-p') then
                qperm = .true.
           else if(word(1:5).eq.'-seed') then
                read(word,'(5x,i11)') seed
           else if(word(1:5).eq.'-save') then
                qsave = .true.
           else if(word(1:2).eq.'-s') then
                read(word,'(2x,i14)') nsokal
                if(nsokal.eq.0) qsokal = .false.
           else if(word(1:1).ne.'-') then
                tag = word
           end if
        end do

        call sdrni(seed)

c.. file stuff

        if(tag.eq.'') stop 99

        do nctag = 16,1,-1
          if(tag(nctag:nctag).ne.' ') go to 1
        end do
        stop 98
1       continue

        inquire(file=tag(1:nctag)//sep//"runs",exist=qfile)

        ijk = 1

2       istd = 6-int(log10(0.5+ijk))
        write(num,'(i6)') ijk

        inquire(file=tag(1:nctag)//sep//num(istd:6)//"_log",exist=qq)
        if(qq) then
                ijk = ijk+1
                go to 2
        end if

        prfx = tag(1:nctag)//sep//num(istd:6)
        npf = nctag+8-istd

        open(7,file=prfx(1:npf)//"_log")
        open(8,file=prfx(1:npf)//"_acf")
        open(9,file=prfx(1:npf)//"_model")
        
        do lun=0,7,7
        write(lun,'("auto-rj")') 
        write(lun,'("nsweep =",i12)') nsweep
        write(lun,'("seed   =",i12)') seed
        if(ndf.eq.0) then
           write(lun,'("normal proposals")')
        else
           write(lun,'("t(",i2,") proposals")') ndf
        end if
        if(qperm) write(lun,'("permuting")')
        write(lun,'("run:",a16)') prfx(1:npf)
        end do

        do k = 1,kmaxmax
        do nk2 = 1,nkmax
        do nk1 = 1,nkmax
        b(nk1,nk2,k) = 77.7
        end do
        end do
        end do

c--- Phase 1: either read moments and scale factors from file --------
c    or run Random Walk Metropolis on each model

        if(qfile) then

           open(5,file=tag(1:nctag)//sep//"runs")

           read(5,*) kmax,nsweep0
           if(kmax.gt.kmaxmax) stop 99

           do k = 1,kmax
                read(5,*) nk(k),ld(k)
                read(5,*) (sc(j,k),j=1,nk(k))
                read(5,*) (av(j,k),j=1,nk(k))
                do j1 = 1,nk(k)
                   read(5,*) (b(j1,j2,k),j2=1,nk(k))
                end do
           end do

           close(5)

        else

           write(0,'(a33)') '... setting up, doing rwm for k ='
           k = 0
           lp = target(k,par)
           kmax = k
           if(kmax.gt.kmaxmax) stop 99

           do k = 1,kmax

                write(0,'(i3,$)') k

                nkk = kmax+k
                lp = target(nkk,par)
                nk(k) = nkk
                lp = target(2*kmax+k,par)
                lp = target(3*kmax+k,sc(1,k))

                do j = 1,nkk
                   av(j,k) = 0.0
                   do j1 = 1,j
                        b(j,j1,k) = 0.0
                   end do
                end do

                lp = target(k,par)

                nacc = 0

                do sweep = 1,nsweep

                   if(ndf.eq.0) then
                        call gauss(parn,nkk)
                   else
                        call rt(parn,nkk,ndf)
                   end if
                   do j = 1,nkk
                        parn(j) = parn(j)*sc(j,k)+par(j)
                   end do
                   lpn = target(k,parn)
                   if(sdrand().lt.exp(lpn-lp)) then
                        do j = 1,nkk
                           par(j) = parn(j)
                        end do
                        lp = lpn
                        nacc = nacc+1
                   end if

                   if(sweep.gt.1) con2 = 1.0/(real(sweep)*real(sweep-1))
                   do j = 1,nkk
                        av(j,k) = av(j,k)+par(j)
                        if(sweep.gt.1) then
                        do j1 = 1,j
                           b(j,j1,k) = b(j,j1,k)+con2*(av(j,k)-
     &			   sweep*par(j))*(av(j1,k)-sweep*par(j1))
                        end do
                        end if
                   end do

                end do

                write(0,'("(",i3,")",$)') int(0.5+(100.0*nacc)/nsweep)

                con1 = 1.0/nsweep
                con2 = 1.0/(nsweep-1)
                do j = 1,nkk
                   av(j,k) = con1*av(j,k)
                   do j1 = 1,j
                        b(j,j1,k) = con2*b(j,j1,k)
                   end do
                end do

                call chol(nkk,b(1,1,k),nkmax)

                ld(k) = 1.0
                do j = 1,nkk
                   ld(k) = ld(k)*b(j,j,k)
                end do
                ld(k) = log(ld(k))

           end do
        write(0,*)

        if(qsave) then

           open(4,file=tag(1:nctag)//sep//"runs")

           write(4,*) kmax,nsweep

           do k = 1,kmax
                write(4,*) nk(k),ld(k)
                write(4,*) (sc(j,k),j=1,nk(k))
                write(4,*) (av(j,k),j=1,nk(k))
                do j1 = 1,nk(k)
                   write(4,*) (b(j1,j2,k),j2=1,nk(k))
                end do
           end do

           close(4)

        end if

        end if

c--- Phase 2: start automatic jumping -------------------------

c.. housekeeping

        do lun=0,7,7
        write(lun,'("kmax = ",i3/"nk:", 10i3)') kmax,(nk(k),k=1,kmax)
c       write(lun,'("ld:",6f10.4/(3x,6f10.4))') (ld(k),k=1,kmax)
        end do
        
        do k = 1,kmax
           write(ck,'(i1)') k
           open(10+k,file=prfx(1:npf)//"_par"//ck)
        end do

        do k = 1,kmax
           count(k) = 0
        end do
        nacc = 0

        nsweep = nsweep*10

c.. set up length of record for autocorrelation estimation

        if(qsokal) then
           nkeep = nsweep/(2*nsokal)
           nkeep = 2**min(15,int((log(real(nkeep))/log(2.0))+0.001))
           keep = nburnin+nsweep-nkeep*nsokal
        end if

c.. initialise state

        k = 1
        nkk = nk(k)
        do j = 1,nkk
           par(j) = av(j,k)
        end do
        lp = target(k,par)

        write(0,'(a17,$)') '... auto-jumping:'

c.. main loop

        do sweep = 1,nsweep

        if(mod(sweep,nsweep/10).eq.0) then
            write(0,'(i3,$)') (nsweep-sweep)/(nsweep/10)
        end if

c.. within model RWM move

        if(ndf.eq.0) then
           call gauss(parn,nkk)
        else
           call rt(parn,nkk,ndf)
        end if

        do j = 1,nkk
           parn(j) = parn(j)*sc(j,k)+par(j)
        end do
        lpn = target(k,parn)
        if(sdrand().lt.exp(lpn-lp)) then
           do j = 1,nkk
                par(j) = parn(j)
           end do
           lp = lpn
        end if

c.. between model move

        do j = 1,nkk
           work(j) = par(j)-av(j,k)
        end do
        do i = 1,nkk
           do j = 1,i-1
                work(i) = work(i)-b(i,j,k)*work(j)
           end do
           work(i) = work(i)/b(i,i,k)
        end do

        kn = min(kmax-1,1+int((kmax-1)*sdrand()))
        if(kn.ge.k) kn = kn+1
        nkkn = nk(kn)

        logratio = 0.0

        if(nkk.lt.nkkn) then
           if(ndf.eq.0) then
                call gauss(work(nkk+1),nkkn-nkk)
                do i = nkk+1,nkkn
                   logratio = logratio+0.5*work(i)**2+logr2pi
                end do
           else
                call rt(work(nkk+1),nkkn-nkk,ndf)
                do i = nkk+1,nkkn
                   logratio = logratio-logdt(work(i),ndf,condt)
                end do
           end if

           if(qperm) call perm(work,nkkn)

        else if(nkk.eq.nkkn) then

           if(qperm) call perm(work,nkk)

        else

           if(qperm) call perm(work,nkk)

           if(ndf.eq.0) then
                do i = nkkn+1,nkk
                   logratio = logratio-0.5*work(i)**2-logr2pi
                end do
           else
                do i = nkkn+1,nkk
                   logratio = logratio+logdt(work(i),ndf,condt)
                end do
           end if

        end if

        do i = 1,nkkn
           parn(i) = av(i,kn)
           do j = 1,i
                parn(i) = parn(i)+b(i,j,kn)*work(j)
           end do
        end do

        lpn = target(kn,parn)
        logratio = logratio+lpn-lp+ld(kn)-ld(k)
        if(sdrand().lt.exp(max(-30.0,min(0.0,logratio)))) then
           do j = 1,nkkn
                par(j) = parn(j)
           end do
           lp = lpn
           k = kn
           nkk = nkkn
           nacc = nacc+1
        end if

c.. record

        if(qsokal) then
        if(sweep.gt.keep.and.mod(sweep-keep,nsokal).eq.0) then
           xr((sweep-keep)/nsokal) = k
        end if
        end if

        count(k) = count(k)+1   

        if(mod(sweep,max(1,nsweep/10000)).eq.0) write(9,*) k
        if(mod(sweep,max(1,nsweep/5000)).eq.0)
     &	write(10+k,*) (par(j),j=1,nkk)

        end do

c.. output

        if(qsokal) call sokal(nkeep,xr(1),xi(1),var,tau,m)

        write(0,*)
        do lun = 0,7,7
        write(lun,'("model frequencies:",8i8/(10x,8i8))')
     &	(count(k),k=1,kmax)
        write(lun,'("percentage jumps accepted:",f5.1)')
     &	(100.0*nacc)/sweep
        if(qsokal)
     &   write(lun,'("nkeep, nsokal, tau   ",2i5,f10.4/)') 
     &   nkeep,nsokal,tau
        end do
        if(qsokal) write(8,'(i6/(8f10.6))') m,(xr(i),i=1,m)

c----------------------------------------------

        stop
        end

c+++++++++++++++++++++++++++++++++++++++++++++++++

        subroutine chol(p,a,lda)

        integer p
        dimension a(lda,p)

c.. calculates Cholesky square root of matrix a,
c   result overwriting input array.
c   (uses lower triangle of a only, writes lower triangle)

        do 1 j = 1,p

        sum = a(j,j)
        do 2 k = 1,j-1
2       sum = sum-a(j,k)**2
        a(j,j) = sqrt(sum)

        do 3 i = j+1,p
        sum = a(i,j)
        do 4 k = 1,j-1
4       sum = sum-a(i,k)*a(j,k)
3       a(i,j) = sum/a(j,j)

1       continue

        return

        end

c+++++++++++++++++++++++++++++++++++++++++++++++++

        subroutine perm(work,nkk)
        dimension work(nkk)

        do i = nkk,2,-1
           j = min(i,1+int(i*sdrand()))
           if(i.ne.j) then
                temp = work(i)
                work(i) = work(j)
                work(j) = temp
           end if
        end do

        return
        end

c+++++++++++++++++++++++++++++++++++++++++++++++++

        real function logdt(x,ndf,condt)
        data pi/3.141592653/
        if(condt.eq.0.0) condt = dlgama(dble(0.5*(ndf+1)))
     &  -dlgama(dble(0.5*ndf))-0.5*log(ndf*pi)
        logdt = condt-0.5*(ndf+1)*log(1.0+x**2/ndf)
        return
        end

c+++++++++++++++++++++++++++++++++++++++++++++++++

        subroutine rt(x,n,ndf)
        real x(n)

        s = 0.5*ndf
        call gauss(x,n)
        do i = 1,n
                x(i) = x(i)/sqrt(rgamma(s)/s)
        end do

        return
        end

