        real function target(k,params)

c.. function target(k,params):
c                 k=0       - returns k=kmax
c            1<=k<=kmax   - evaluates log posterior at (k,params)
c       kmax+1<=k<=2*kmax - returns k = nk(k-kmax)
c     2*kmax+1<=k<=3*kmax - returns params = starting values
c     3*kmax+1<=k<=4*kmax - returns params = spread parameters

c.. for details of model see Green (Highly Structured Stochastic Systems,
c       OUP, 2003, Chapter 6), p193 and
c       Dellaportas, Forster and Ntzoufras (Statistics and 
c       Computing, 12, 27-36, 2002)
c       - model choice in a 2 by 2 factorial experiment with 
c       binomial responses

        real params(4),y(4),x(4,4),phi(4),logr2pi,bin(4,5),bsc(4,5)
        integer cols(4,5),nk(5),n(4)

        data y/6,4,15,5/
        data n/21,26,20,12/
        data x/4*1,2*-1,2*1,-1,1,-1,1,1,-1,-1,1/
        data nk/1,2,2,3,4/
        data cols/1,0,0,0,1,1,0,0,1,0,1,0,1,1,1,0,1,1,1,1/
        data phi/4*0.125/
        data bin/-0.5,3*0.0,-0.4,0.9,2*0.0,-0.6,-0.7,2*0.0,
     &  -0.5,0.9,-0.6,0.0,-0.5,0.9,-0.6,-0.2/
        data bsc/0.25,3*0.0,2*0.25,2*0.0,2*0.25,2*0.0,
     &  3*0.25,0.0,0.3,0.25,0.25,0.23/
        data kmax/5/

        logr2pi = 0.5*log(2*3.141592653)

c.. number of models

        if(k.eq.0) then
                k = kmax
                return

c.. return log posterior

        else if(1.le.k.and.k.le.kmax) then

        target = 0.0

        do i = 1,4
           eta = 0.0
           jj = 0
           do j = 1,4
                if(cols(j,k).eq.1) then
                   jj = jj+1
                   eta = eta+x(i,j)*params(jj)
                end if
           end do
           target = target+eta*y(i)-n(i)*log(1.0+exp(eta))
        end do

        jj = 0
        do j = 1,4
           if(cols(j,k).eq.1) then
                jj = jj+1
                target = target-0.5*phi(j)*params(jj)**2+0.5*log(phi(j))-logr2pi
           end if
        end do
        
c.. dimension of model

        else if(kmax+1.le.k.and.k.le.2*kmax) then
                k = nk(k-kmax)

c.. starting values

        else if(2*kmax+1.le.k.and.k.le.3*kmax) then
                kk = k-2*kmax
                do j = 1,nk(kk)
                   params(j) = bin(j,kk)
                end do
                
c.. spread parameters

        else if(3*kmax+1.le.k.and.k.le.4*kmax) then
                kk = k-3*kmax
                do j = 1,nk(kk)
                   params(j) = bsc(j,kk)
                end do

c.. error: k out of range

        else 
                write(*,*) k
                stop 88 
        end if

        return

        end
