        subroutine sokal(n,xr,xi,var,tau,m)

c.. estimates integrated autocorrelation time
c   using method of Sokal.
c   (but note that my definition is the sum from
c   - infinity to infinity of the autocorrelation function,
c   hence twice Sokal's definition.)

        real*8 xr(n),xi(n)

        if(n.gt.2**20) stop 66

c.. use FFT to compute autocorrelations (in xr)
c   and variance (in var).

        do 1 i = 1,n
1       xi(i) = 0.0
        call fastf(xr,xi,n)

        do 2 i = 1,n
        xr(i) = xr(i)**2+xi(i)**2
2       xi(i) = 0.0
        xr(1) = 0.0
        call fastf(xr,xi,n)
        var = xr(1)/(n*(n-1))
        c = 1.0/xr(1)
        do 3 i = 1,n
3       xr(i) = xr(i)*c

c.. use Sokal's adaptive truncated periodogram method
c   to estimate integrated autocorrelation time (in tau).

        sum = -0.333333333
        do 4 i = 1,n
        sum = sum+xr(i)-0.166666667
        if(sum.lt.0.0) go to 5
4       continue
5       tau = 2.0*(sum+real(i-1)/6)
        m = i

        return
        end

c-------------------------------------------

        subroutine fastf(xreal,ximag,isize)
c
c radix 4 complex discrete fast Fourier transform
c without usual normalisation
c Eric Renshaw -> PJG 20 March 1987
c
c xreal = array which on input contains real part of data
c for transformation and on output gives real part of the
c result,type real, dimension iabs(isize) or greater.
c ximag = array which on input contains imaginary part
c for transformation and on output gives imaginary part of
c the result, type real, dimension iabs(isize) or greater.
c isize = integer variable or constant specifying length and
c type of transform. The length is iabs(isize) which must be
c a power of 2, minimum length 4, maximum 2**20. Illegal length
c leads to stop 99. If isize is positive the forward transform 
c is calculated. If negative the inverse transform is found.
c
c.. The transform is defined by
c      out(r) = sum(j = 0 to n-1) in(j)*exp(-2*pi*i*r*j/n)
c                       if isize = n > 0,
c      out(r) = sum(j = 0 to n-1) in(j)*exp(2*pi*i*r*j/n)
c                       if isize = -n < 0,
c      for r = 0,1,2,...,(n-1),
c      where i = sqrt(-1), and both in(j) and out(j)
c      are stored in xreal(j+1)+i*ximag(j+1)
c
        double precision xreal(1),ximag(1)
        real*8 pie,z,bcos,bsin,tempr,cw1,sw1,xs0,xs1,xs2,xs3
        real*8 ys0,ys1,ys2,ys3,x1,x2,x3,y1,y2,y3
        integer l(20)
        equivalence(l1,l(1)),(l2,l(2)),(l3,l(3)),(l4,l(4)),
     1   (l5,l(5)),(l6,l(6)),(l7,l(7)),(l8,l(8)),(l9,l(9)),
     2  (l10,l(10)),(l11,l(11)),(l12,l(12)),(l13,l(13)),
     3  (l14,l(14)),(l15,l(15)),(l16,l(16)),(l17,l(17)),
     4  (l18,l(18)),(l19,l(19)),(l20,l(20))

        pie = 3.141592653589793
        n=iabs(isize)

        if(n.lt.4) stop 99

c if this is to be an inverse transform, conjugate the data

        if(isize.lt.0) then
        do 3 k=1,n
    3   ximag(k)=-ximag(k)
        end if

c set up initial values of transform split

        if(mod(n,2).ne.0) stop 99
        ifacc=1
        ifaca=n/4

        itime=0

5       ifcab=ifaca*4
        itime=itime+2

c do the transforms required by this stage

        z=pie/dble(ifcab)
        bcos=-2.*(dsin(z)**2)
        bsin=dsin(2.*z)
        cw1=1.
        sw1=0.
        do 10 litla=1,ifaca
        do 8 i0=litla,n,ifcab
c this is the main calculation of radix 4 transforms
        i1=i0+ifaca
        i2=i1+ifaca
        i3=i2+ifaca
        xs0=xreal(i0)+xreal(i2)
        xs1=xreal(i0)-xreal(i2)
        ys0=ximag(i0)+ximag(i2)
        ys1=ximag(i0)-ximag(i2)
        xs2=xreal(i1)+xreal(i3)
        xs3=xreal(i1)-xreal(i3)
        ys2=ximag(i1)+ximag(i3)
        ys3=ximag(i1)-ximag(i3)
        xreal(i0)=xs0+xs2
        ximag(i0)=ys0+ys2
        x1=xs1+ys3
        y1=ys1-xs3
        x2=xs0-xs2
        y2=ys0-ys2
        x3=xs1-ys3
        y3=ys1+xs3

        if(litla.eq.1) then
        xreal(i2)=x1
        ximag(i2)=y1
        xreal(i1)=x2
        ximag(i1)=y2
        xreal(i3)=x3
        ximag(i3)=y3
        else
c multiply by twiddle factors if required
        xreal(i2)=x1*cw1+y1*sw1
        ximag(i2)=y1*cw1-x1*sw1
        xreal(i1)=x2*cw2+y2*sw2
        ximag(i1)=y2*cw2-x2*sw2
        xreal(i3)=x3*cw3+y3*sw3
        ximag(i3)=y3*cw3-x3*sw3
        end if

8       continue

        if(litla.lt.ifaca) then

c calculate a new set of twiddle factors
        z=cw1*bcos-sw1*bsin+cw1
        sw1=bcos*sw1+bsin*cw1+sw1
        tempr=1.5-0.5*(z*z+sw1*sw1)
        cw1=z*tempr
        sw1=sw1*tempr
        cw2=cw1*cw1-sw1*sw1
        sw2=2.*cw1*sw1
        cw3=cw1*cw2-sw1*sw2
        sw3=cw1*sw2+cw2*sw1

        end if

10      continue

        if(ifaca.gt.1) then
c set up the transform split for the next stage
        if(mod(ifaca,2).ne.0) stop 99
        ifacc=ifacc*4
        ifaca=ifaca/4
        if(ifaca.gt.0) go to 5
c this is the calculation of a radix two stage
        do 13 k=1,n,2
        tempr=xreal(k)+xreal(k+1)
        xreal(k+1)=xreal(k)-xreal(k+1)
        xreal(k)=tempr
        tempr=ximag(k)+ximag(k+1)
        ximag(k+1)=ximag(k)-ximag(k+1)
13      ximag(k)=tempr
        itime=itime+1
        end if

c if this was an inverse transform, conjugate the result
        if(isize.lt.0) then
        do 16 k=1,n
 16   ximag(k)=-ximag(k)
        end if

c unscramble the result
        if(itime.gt.20) stop 99
        i1=20-itime
        do 20 k=1,i1
 20   l(k)=1
        ii=1
        i1=i1+1
        do 21 k=i1,20
          ii=ii*2
 21   l(k)=ii
        ii=1
        do 23 j1=1,l1
         do 23 j2=j1,l2,l1
          do 23 j3=j2,l3,l2
           do 23 j4=j3,l4,l3
            do 23 j5=j4,l5,l4
             do 23 j6=j5,l6,l5
              do 23 j7=j6,l7,l6
               do 23 j8=j7,l8,l7
                do 23 j9=j8,l9,l8
                 do 23 j10=j9,l10,l9
                  do 23 j11=j10,l11,l10
                   do 23 j12=j11,l12,l11
                    do 23 j13=j12,l13,l12
                     do 23 j14=j13,l14,l13
                      do 23 j15=j14,l15,l14
                       do 23 j16=j15,l16,l15
                        do 23 j17=j16,l17,l16
                         do 23 j18=j17,l18,l17
                          do 23 j19=j18,l19,l18
                           do 23 j20=j19,l20,l19
                            if(ii-j20)22,23,23
22                          tempr=xreal(ii)
                            xreal(ii)=xreal(j20)
                            xreal(j20)=tempr
                            tempr=ximag(ii)
                            ximag(ii)=ximag(j20)
                            ximag(j20)=tempr
23                          ii=ii+1
24    return
        end
