        real function target(k,params)

c.. function target(k,params):
c                 k=0       - returns k=kmax
c            1<=k<=kmax   - evaluates log posterior at (k,params)
c       kmax+1<=k<=2*kmax - returns k = nk(k-kmax)
c     2*kmax+1<=k<=3*kmax - returns params = starting values
c     3*kmax+1<=k<=4*kmax - returns params = spread parameters

c.. for details of model see Green (Highly Structured Stochastic Systems,
c       OUP, 2003, Chapter 6), p193 and
c       Green (Biometrika, 82, 711-32, 1995)
c       Multiple change point analysis for point process of coal
c       mining disasters.

        real params(21),h(0:10),s(11),ds(0:10)
        real logratio,logl,lambda
        real*8 dlgama
        real y(191)
        data y/74,231,354,356,480,492,496,506,722,802,814,847,
     &  913,1145,1971,2011,2023,2052,2242,2339,2404,2590,
     &  2613,2705,2902,3333,3349,3503,3598,3623,3642,3720,
     &  3922,3958,4068,4344,4360,4448,4673,4726,4743,5281,
     &  5468,5502,5603,5644,5783,5825,5826,6076,6156,6159,
     &  6483,6539,6570,6666,6736,6777,6870,6894,6985,7128,
     &  7144,7171,7315,7360,7366,7574,7603,7715,7758,7951,
     &  8085,8505,8600,8725,8759,8886,9104,9106,9106,9484,
     &  9520,9535,9566,9781,9792,9929,9933,9948,10020,
     &  10116,10240,10290,10410,10613,10789,10844,10937,
     &  10996,11311,11370,11431,11432,11445,11634,11979,
     &  11999,12080,12366,12480,12588,12776,13009,13037,
     &  13059,13120,13198,13297,13623,13898,13952,14169,
     &  14282,14314,14702,14853,15214,15526,15880,16187,
     &  16462,16540,16557,17762,18406,18873,19744,19792,
     &  19915,20371,20869,20918,21049,21231,21486,21680,
     &  21904,22470,22932,23160,23966,24483,26126,26180,
     &  26506,27818,28166,28911,29128,29248,29523,29543,
     &  29609,29901,29905,30273,30580,30916,30935,31264,
     &  31594,31906,32442,32587,32662,33026,33063,33082,
     &  33238,33285,33414,35044,35073,35290,35297,35315,
     &  36673,39039,39991,40623/
        data alpha,beta,lambda/1.0,200.0,3.0/
        data kmax/6/

c.. number of models

        if(k.eq.0) then
                k = kmax
                return

c.. return log posterior

        else if(1.le.k.and.k.le.kmax) then

        logl = log(40907.0)

        abcon = alpha*log(beta)-dlgama(dble(alpha))

        h(0) = params(1)
        do j = 1,k
           s(j) = params(k+1+j)
           h(j) = params(1+j)
           if(j.ne.1) ds(j-1) = s(j)-s(j-1)
        end do
        ds(0) = s(1)
        ds(k) = 40907.0-s(k)
        s(k+1) = 40907.0

        do j = 0,k
           if(h(j).le.0.0.or.ds(j).le.0.0) then
                target = -10000.0
                return
           end if
        end do

        target = -lambda+k*log(lambda)-dlgama(dble(real(k+1)))
        
        do j = 0,k
           target = target+abcon+(alpha-1.0)*log(h(j))-beta*h(j)
           target = target+log(ds(j))
        end do
        target = target+dlgama(dble(2.0*real(k+1)))-(2.0*k+1.0)*logl
        
        nsofar = 0
        top = s(1)
        j = 0
        do i = 1,191
1          if(y(i).gt.top) then
                nj = i-1-nsofar
                nsofar = i-1
                target = target+nj*log(h(j))-h(j)*ds(j)
                j = j+1
                if(j.gt.k) return
                top = s(j+1)
                go to 1
           end if
        end do
        nj = 191-nsofar
        target = target+nj*log(h(j))-h(j)*ds(j)
        
        return

c.. dimension of model

        else if(kmax+1.le.k.and.k.le.2*kmax) then
                k = 2*(k-kmax)+1

c.. starting values

        else if(2*kmax+1.le.k.and.k.le.3*kmax) then
                kk = k-2*kmax
                do j = 1,kk+1
                   params(j) = alpha/beta
                end do
                do j = 1,kk
                   params(kk+1+j) = 40907.0*j/real(kk+1)
                end do

c.. spread parameters

        else if(3*kmax+1.le.k.and.k.le.4*kmax) then
                kk = k-3*kmax
                do j = 1,kk+1
                   params(j) = (0.3/real(kk+1))*alpha/beta
                end do
                do j = 1,kk
                   params(kk+1+j) = 0.06*40907.0/real(kk+1)
                end do

c.. error: k out of range

        else 
                write(*,*) k
                stop 88 
        end if

        end

