        real function target(k,params)

c.. function target(k,params):
c                 k=0       - returns k=kmax
c            1<=k<=kmax   - evaluates log posterior at (k,params)
c       kmax+1<=k<=2*kmax - returns k = nk(k-kmax)
c     2*kmax+1<=k<=3*kmax - returns params = starting values
c     3*kmax+1<=k<=4*kmax - returns params = spread parameters

c.. Toy model - with probability 0.4, variable is
c       double-exponential, with density exp(-2|x|), and
c       with probability 0.6, it is standard bivariate normal,
c       with correlation rho=0.8
c     Starting values are all set to 0, and spread parameters to 0.7

        real params(2)
        data twopi,rho/6.283185,0.8/

c.. number of submodels

        if(k.eq.0) then

                k = 2

c.. log target density for submodel 1

        else if(k.eq.1) then

                target = log(0.4)-2.0*abs(params(1))

c.. and 2

        else if(k.eq.2) then

                target = log(0.6)-log(twopi)-0.5*log(1-rho**2)
     &          -0.5*(params(1)**2-2.0*rho*params(1)*params(2)
     &          +params(2)**2)/(1.0-rho**2)

c.. dimensions of submodels

        else if(3.le.k.and.k.le.4) then

                k = k-2

c.. initial values

        else if(5.le.k.and.k.le.6) then

                params(1) = 0.0
                if(k.eq.6) params(2) = 0.0

c.. scale factors

        else if(7.le.k.and.k.le.8) then

                params(1) = 0.7
                if(k.eq.8) params(2) = 0.7

c.. error check

        else

                stop 99

        end if

        return
        end


        

                