domain<-function(name=NULL) 
{
# create new working domain (with standard name .Grpp) and optionally give it an alias
	pos<-1
	env<-as.environment(pos)
	assign('.Grpp',new.env(parent=emptyenv()),env)
	if(!is.null(name)) assign(name,.Grpp,env)
	class(.Grpp)<-c('environment','domain')
}

revisit<-function(name=NULL) 
{
# re-set working domain to previously named domain
	pos<-1
	env<-as.environment(pos)
	if(!is.null(name)) assign('.Grpp',get(name,.GlobalEnv),env)
}

list.domains<-function()
{
x<-ls(all.names=TRUE,envir=.GlobalEnv)
x[as.vector(sapply(x,function(z) 'domain'%in%class(get(z))))]
}

get.nc<-function() 
{
# normalising constant
make()
sum(.Grpp$tcq[[1]])
}
