require(KinMix)
require(ribd)

##Reading allele frequency database
db <- read.csv("database-anon.csv", stringsAsFactors=FALSE, header=T, fill = TRUE, sep = ",")
db <- merge(db,data.frame(marker="Marker17",allele=34,frequency=0.001),all=T)

## Normalise all frequencies
for(m in unique(db$marker))
{
  f<-db[db$marker==m,]$frequency
  db[db$marker==m,]$frequency<-f/sum(f)
}

#set threshold C
C<-50

## Read in daughter's profile
Dgt<-read.csv("daughter-anon.csv",sep = ",", header = TRUE,stringsAsFactors=FALSE)
Dgt$marker<-as.character(Dgt$marker)
Dgt$allele1<-as.numeric(Dgt$allele1)
Dgt$allele2<-as.numeric(Dgt$allele2)

