C 
C 
C    FORTRAN TILE 4 CREATED 1 SEPTEMBER 1977 
C    PROGRAM TESTA 4.6 DATED 28 JANUARY 1981 
C 
C    COPYRIGHT (C) 1981 UNIVERSITY OF BATH 
C 
C    This program tests the TILE 4 routines 
C        SCATRC 
C        TILE4M 
C        EXTEND 
C        SHOVEL 
C        ADDPT 
C        SUBPT 
C        TRYPT 
C        TDUMP 
C    and all the routines they call.  The program is not designed 
C    to be a stringent test. However, when run, it will give an 
C    output that the user may check against the standard output 
C    supplied with the TILE 4 package. 
C 
C    Set up the program constants and initialise those variables 
C    that need to be initialised. 
C 
C2      INTEGER*2 L 
        EXTERNAL UNI4M 
        DIMENSION CN(3,4),JADDR(4),PT(2,100),NADDR(100),L(1000) 
        DATA JCNS,NPTS,LTOP/4,100,1000/ 
        DATA NSTART/0/ 
        DATA MSEED/186599/ 
        DATA NSUB,KIR,KTRY/50,40,10/ 
        DATA NPRINT/10/ 
        DATA NDUMP/11/ 
        DATA EPSCN,EPSPT/0.0,0.0/ 
        DATA XMIN,XMAX,YMIN,YMAX/0.0,1.0,0.0,1.0/ 
        M = MSEED 
C 
C    Call SCATRC to generate NSUB random points in the 
C    unit square. 
C 
        CALL SCATRC(CN,JCNS,PT,NSUB,IFLAG,UNI4M,MSEED, 
     1    XMIN,XMAX,YMIN,YMAX) 
        IF(IFLAG.EQ.0) GOTO 1 
        WRITE(NPRINT,9001) IFLAG 
        STOP 601 
C 
C    Tessellate those NSUB points. 
C 
    1   CALL TILE4M(CN,JCNS,JADDR,PT,NSUB,NADDR,NFREE,NSTART,NPTSIN, 
     1    L,LTOP,LPTR,LBASE,EPSCN,EPSPT,IFLAG,IGARB) 
        IF(IFLAG.EQ.0) GOTO 2 
        IF(IFLAG.EQ.5) GOTO 7 
        WRITE(NPRINT,9001) IFLAG 
        STOP 602 
    7   WRITE(NPRINT,9007)IFLAG 
C 
C    Print the triangulation obtained. 
C 
    2   WRITE(NPRINT,9002) 
        CALL SHOVEL(CN,JCNS,JADDR,PT,NSUB,NADDR,NFREE,NSTART, 
     1    NPTSIN,L,LTOP,LPTR,LBASE,IGARB,NPRINT) 
C 
C    Extend the chain in NADDR from NSUB to NPTS. 
C 
        CALL EXTEND(NADDR,NPTS,NSUB) 
C 
C    Insert and remove KIR points at random. 
C 
        DO 4  K = 1,KIR 
C 
C    Choose whether to insert or remove a point. 
C 
        IF(UNI4M(M).GT.0.5) GOTO 3 
C 
C    Insert an extra random point. 
C 
        XPT = UNI4M(M) 
        YPT = UNI4M(M) 
        CALL ADDPT(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART,NPTSIN, 
     1    L,LTOP,LPTR,LBASE,EPSCN,EPSPT,IFLAG,IGARB,XPT,YPT,NINDEX) 
        IF(IFLAG.EQ.0.OR.IFLAG.EQ.5) GOTO 4 
        WRITE(NPRINT,9001) IFLAG 
        STOP 603 
C 
C    Remove a random point. 
C 
    3   NINDEX = 1+IFIX(UNI4M(M)*FLOAT(NPTSIN)) 
        IF(NADDR(NINDEX).LE.0) GOTO 4 
        CALL SUBPT(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART,NPTSIN, 
     1    L,LTOP,LPTR,LBASE,IFLAG,IGARB,XPT,YPT,NINDEX) 
        IF(IFLAG.EQ.0) GOTO 4 
        WRITE(NPRINT,9001) IFLAG 
        STOP 604 
    4   CONTINUE 
C 
C    Print the triangulation obtained. 
C 
        WRITE(NPRINT,9003) 
        CALL SHOVEL(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART, 
     1    NPTSIN,L,LTOP,LPTR,LBASE,IGARB,NPRINT) 
C 
C    Garbage collect and then dump the triangulation using TDUMP 
C    if required. 
C 
        IF(NDUMP.LE.0) GOTO 10 
        CALL GARBAJ(JCNS,JADDR,NPTS,NADDR,L,LTOP,LPTR,LBASE) 
        CALL TDUMP(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART,NPTSIN, 
     1     L,LTOP,LPTR,LBASE,EPSCN,EPSPT,NDUMP) 
C 
C    Find the contiguities that KTRY random points would 
C    have if they were successfully inserted. 
C 
   10   WRITE(NPRINT,9004) 
        DO 6  K = 1,KTRY 
        XPT = UNI4M(M) 
        YPT = UNI4M(M) 
        CALL TRYPT(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART,NPTSIN, 
     1    L,LTOP,LPTR,LBASE,EPSCN,EPSPT,IFLAG,IGARB,XPT,YPT,NINDEX) 
        IF(IFLAG.EQ.0) GOTO 5 
        IF(IFLAG.EQ.5) GOTO 6 
        WRITE(NPRINT,9001) IFLAG 
        STOP 605 
C 
C    Print contiguities found for XPT,YPT. 
C 
    5   LLO = LPTR+2 
        LHI = LLO-1+L(LLO-1) 
        WRITE(NPRINT,9005) XPT,YPT,(L(LL),LL = LLO,LHI) 
    6   CONTINUE 
C 
C    Run complete. 
C 
        WRITE(NPRINT,9006) 
        STOP 
 9001   FORMAT(///1H ,19(1H*)/1H ,16H ERROR: IFLAG = ,I3/1H ,19(1H*)///) 
 9002   FORMAT(////1H ,23H INITIAL CONTIGUITIES: ) 
 9003   FORMAT(////1H ,33H CONTIGUITIES AFTER RANDOM POINT , 
     1    23HINSERTION AND REMOVAL: ) 
 9004   FORMAT(////1H ,39H CONTIGUITIES OF SINGLE RANDOM POINTS: /) 
 9005   FORMAT(1H ,F7.4,3X,F7.4,3H : ,10(I5,1X),(/15X,10(I5,1X))) 
 9006   FORMAT(////1H ,22HTESTA 4.6 RUN COMPLETE//) 
 9007   FORMAT(///1H ,21(1H*)/1H ,18H WARNING: IFLAG = ,I3/1H , 
     1    21(1H*)///) 
        END 
