C 
C 
C    FORTRAN TILE 4 CREATED 1 SEPTEMBER 1977 
C    PROGRAM TESTB 4.2 DATED 14 JANUARY 1981 
C 
C    COPYRIGHT (C) 1981 UNIVERSITY OF BATH 
C 
C    This program tests the TILE 4 routines 
C         TLOAD 
C         DIRPLT 
C         DIRHAT 
C    and all the routines that they call.  It uses the unformatted 
C    file generated by PROGRAM TESTA as data. 
C 
C    Before this program is run the user must write the six graphics 
C    interface routines specified in the GRAPHICS section of the 
C    TILE 4 documentation. 
C 
C 
C 
C2      INTEGER*2 L 
        COMMON/PLTBLK/DUMMY 
        DIMENSION CN(3,4),JADDR(4),PT(2,100),NADDR(100),L(1000), 
     1    VTX(2,50),NCODE(100),NTAG(100),AV(5),UV(5),IV(5),JV(5) 
        DATA JCNS,NPTS,LTOP,KVTMAX/4,100,1000,50/ 
        DATA NLOAD/11/ 
        DATA AV(1),AV(2),AV(3),AV(4),AV(5)/0.0,0.5,1.0,0.0,0.0/ 
        DATA UV(1),UV(2),UV(3),UV(4),UV(5)/0.02,0.02,0.01,0.03,0.04/ 
        DATA IV(1),IV(2),IV(3),IV(4),IV(5)/1,10,18,33,42/ 
        DATA JV(1),JV(2),JV(3),JV(4),JV(5)/0,0,0,0,0/ 
        DATA IWIN1,IPD1,IPS1,ITD1,ITS1,IPTS1,IMARK1/2,-1,-1,1,1,0,3/ 
        DATA IWIN2,IPD2,IPS2,ITD2,ITS2,IPTS2,IMARK2/2,0,0,-1,-1,0,4/ 
        DATA IWIN3,IPD3,IPS3,ITD3,ITS3,IPTS3,IMARK3/2,0,-1,-1,-1,0,4/ 
        DATA IWINH,IDIFF,ISAME,IPTSH,IMARKH/2,0,-1,-1,0/ 
C 
C    Retrieve the tessellation saved by PROGRAM TESTA. 
C 
        CALL TLOAD(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART, 
     1    NPTSIN,L,LTOP,LPTR,LBASE,EPSCN,EPSPT,NLOAD) 
C 
C    Set entries in the arrays NTAG and NCODE. 
C 
        DO 1  N = 1,NPTS 
        NTAG(N) = N 
C 
C    Give even numbered points code value 1 and odd numbered points 
C    code value 2. 
C 
        NCODE(N) = MOD(N,2)+1 
C 
C    Give locations in the free chain a negative code to flag them 
C    as non-existent. 
C 
        IF(NADDR(N).LE.0) NCODE(N) = -1 
    1   CONTINUE 
C 
C    Plot the triangulation. 
C 
        CALL DIRPLT(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG, 
     1    VTX,KVTMAX,NCODE,NTAG,IWIN1,IPD1,IPS1,ITD1,ITS1, 
     2    IPTS1,IMARK1) 
        IF(IFLAG.NE.0) STOP 606 
C 
C    Plot the tessellation and label the points with their index 
C    numbers. 
C 
        CALL DIRPLT(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,VTX,KVTMAX, 
     1    NCODE,NTAG,IWIN2,IPD2,IPS2,ITD2,ITS2,IPTS2,IMARK2) 
        IF(IFLAG.NE.0) STOP 607 
C 
C    Plot the tessellation omitting the tile boundaries between pairs 
C    of odd index points and pairs of even index points.  In other 
C    words divide the plane into the regions owned by the points with 
C    odd indices and the regions owned by even indices. 
C 
        CALL DIRPLT(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,VTX,KVTMAX, 
     1    NCODE,NTAG,IWIN3,IPD3,IPS3,ITD3,ITS3,IPTS3,IMARK3) 
        IF(IFLAG.NE.0) STOP 610 
C 
C    Change the values in NCODE to divide the points into five classes. 
C 
        DO 2  N = 1,NPTS 
        NCODE(N) = MOD(N,5)+1 
        IF(NADDR(N).LE.0) NCODE(N) = -1 
    2   CONTINUE 
C 
C    Hatch the five different regions of the tessellation in 
C    different styles to produce the next plot. 
C 
        CALL DIRHAT(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,VTX, 
     1    KVTMAX,NCODE,NTAG,IWINH,IDIFF,ISAME,IPTSH,IMARKH,AV,UV, 
     2    IV,JV,5) 
        IF(IFLAG.NE.0) STOP 611 

        STOP 
        END 
