C 
C 
C    FORTRAN TILE 4 CREATED 1 SEPTEMBER 1977 
C    FORTRAN SOLID 2 CREATED 9 DECEMBER 1978 
C    PROGRAM TESTD 4/2.2 DATED 10 JUNE 1981 
C 
C    COPYRIGHT (C) 1981 UNIVERSITY OF BATH 
C 
C 
C    This program tests the SOLID 2 routine 
C        SOLID 
C    and all the routines it calls.  It plots the 
C    data saved by PROGRAM TESTC and generated by 
C    the TILE 4 interpolation routines. 
C 
C 
C 
        COMMON/SOLBLK/U1,U2,U3,UE,V1,V2,V3,VE,W1,W2,W3,WE, 
     1    FUZ,D0,DD,X,Y,ZZ,XINCB,YINCB,K(6),IFUN,IFLAG1,IHAZE,ZMIN, 
     2    I,J,LFREE,X0,Y0,LIN,LMAX,LGUESS,LDJ,LSTART,LEND, 
     3    XE1,YE1,ZE1,PI,QI,PJ,QJ,MS,NS,M2,A,B,A1,B1,NODX,NODY,JGRAD, 
     4    XINCS,YINCS,GX,GY,XHAL,YHAL,RXHAL,RYHAL,MF,NF,MIX2,NIY2, 
     5    POLYA,POLYB1,POLYB2,POLYC,POLYD,IQUAD,XINCS1,XHAL1,YINCS1, 
     6    YHAL1,MTOP,NTOP,IGRADX,IGRADY,MSX,NSY 
C 
        DIMENSION Z(25,25),ZX(25,25),ZY(25,25),AMAX(2,1200), 
     1    LIST(2,1200),F(25,25),DUMMY(1,1) 
        LOGICAL IQUAD1 
        DATA ZSCALE/0.25/ 
        DATA MM,NN/25,25/ 
        DATA XE,YE,ZE/-1.0,-1.0,-1.0/ 
        DATA LENG/1200/ 
        DATA HAZE1/-1.0/ 
        DATA MIX1,NIY1/1,1/ 
        DATA MSX1,NSY1/1,1/ 
        DATA IQUAD1/.TRUE./ 
        DATA NSTORE/13/ 
C 
C    Read in the number of functions and the size of the grid. 
C 
        READ(NSTORE,8000)NFMAX,M,N 
        READ(NSTORE,8001)XMIN,XMAX,YMIN,YMAX 
        IF(M.GT.MM.OR.N.GT.NN) STOP 617 
        XL = XMAX-XMIN 
        YL = YMAX-YMIN 
C 
C    Loop through all the functions. 
C 
        DO 1 NFUNC = 1,NFMAX 
C 
C    Read in the function and its reconstruction. 
C 
        DO 2  MS = 1,M 
        DO 2  NS = 1,N 
        READ(NSTORE,8001)F(MS,NS),Z(MS,NS),ZX(MS,NS),ZY(MS,NS) 
C 
C    Reascale everything by the factor ZSCALE. 
C 
        F(MS,NS) = F(MS,NS)*ZSCALE 
        Z(MS,NS) = Z(MS,NS)*ZSCALE 
        ZX(MS,NS) = ZX(MS,NS)*ZSCALE 
    2   ZY(MS,NS) = ZY(MS,NS)*ZSCALE 
C 
C    Plot the original function. 
C 
        CALL SOLID(F,DUMMY,DUMMY,MM,NN,1,1,1,1,M,N,XL,YL, 
     1    XE,YE,ZE,AMAX,LIST,LENG,LMAX1,IFLAG,HAZE1,MIX1, 
     2    NIY1,MSX1,NSY1,IQUAD1,.FALSE.,.FALSE.) 
        IF(IFLAG.NE.0) STOP 620 
C 
C    The first function was the step function and was plotted without 
C    any interpolation between the grid nodes by SOLID.  All the other 
C    plots will be smooth, so set up some interpolation. 
C 
        IF(NFUNC.NE.1) GOTO 4 
        MIX1 = 6 
        NIY1 = 6 
C 
C    Plot the reconstruction. 
C 
    4   CALL SOLID(Z,ZX,ZY,MM,NN,MM,NN,MM,NN,M,N,XL,YL, 
     1    XE,YE,ZE,AMAX,LIST,LENG,LMAX1,IFLAG,HAZE1,MIX1, 
     2    NIY1,MSX1,NSY1,IQUAD1,.TRUE.,.TRUE.) 
        IF(IFLAG.NE.0) STOP 621 
C 
C    Calculate the absolute error. 
C 
        DO 3  MS = 1,M 
        DO 3  NS = 1,N 
    3   Z(MS,NS) = ABS(Z(MS,NS)-F(MS,NS)) 
C 
C    Plot the error. 
C 
        CALL SOLID(Z,DUMMY,DUMMY,MM,NN,1,1,1,1,M,N,XL,YL, 
     1    XE,YE,ZE,AMAX,LIST,LENG,LMAX1,IFLAG,HAZE1,MIX1, 
     2    NIY1,MSX1,NSY1,IQUAD1,.FALSE.,.FALSE.) 
        IF(IFLAG.NE.0) STOP 622 
    1   CONTINUE 
C
C    NEXT LINE ADDED FOR NUMAC/*GHOST
C
        CALL GREND
        STOP 
 8000   FORMAT(3(I13,2X)) 
 8001   FORMAT(4(E13.6,2X)) 
        END 
