C 
C 
C    FORTRAN TILE 4 CREATED 1 SEPTEMBER 1977 
C    PROGRAM TESTE 4.2 DATED 27 MAY 1981 
C 
C    COPYRIGHT (C) 1981 UNIVERSITY OF BATH 
C 
C 
C    This program tests the TILE 4 routines 
C       TLOAD 
C       WINVTX 
C       TILVTX 
C       INFORM 
C       GRAZE 
C       INDISC 
C       SUBDIV 
C       INDIC0 
C       TILVTE 
C       MEAD 
C       NLIST 
C       AREAS 
C       RANPT 
C    and all the routines that they call. 
C 
C 
C2      INTEGER*2 L 
        EXTERNAL UNI4M 
        DIMENSION CN(3,4),JADDR(4),PT(2,100),NADDR(100),L(1000), 
     1    VTX(2,50),RVAL(10),EVAL(10),AVAL(10),PROP(50),NBR(50), 
     2    NCODE(100),PTOFF(2,50) 
        DATA JCNS,NPTS,LTOP/4,100,1000/ 
        DATA KTILE/25/ 
        DATA MSEED/158311/ 
        DATA NWRITE,NLOAD/14,11/ 
        DATA KVTMAX,KNBMAX,MRVAL/50,50,10/ 
        DATA KRANP,R/5,0.1/ 
        M = MSEED 
C 
C    Load the tessellation computed by TESTA. 
C 
        CALL TLOAD(CN,JCNS,JADDR,PT,NPTS,NADDR,NFREE,NSTART, 
     1    NPTSIN,L,LTOP,LPTR,LBASE,EPSCN,EPSPT,NLOAD) 
C 
C    Calculate the vertices and smallest enclosing rectangle 
C    for the window. 
C 
        CALL WINVTX(CN,JCNS,L,LTOP,IFLAG,VTX,KVTMAX,KVTX, 
     1    XMIN,XMAX,YMIN,YMAX) 
        IF(IFLAG.EQ.0) GOTO 1 
        WRITE(NWRITE,9000) IFLAG 
        STOP 623 
    1   WRITE(NWRITE,9001) (VTX(1,K),VTX(2,K),K = 1,KVTX) 
        WRITE(NWRITE,9002) XMIN,YMIN,XMAX,YMAX 
C 
C    Choose KTILE tiles at random. 
C 
        DO 2  KT = 1,KTILE 
        NINDEX = INT(FLOAT(NPTS)*UNI4M(M))+1 
        IF(NADDR(NINDEX).LE.0) GOTO 2 
        XPT = PT(1,NINDEX) 
        YPT = PT(2,NINDEX) 
        WRITE(NWRITE,9003) NINDEX,XPT,YPT 
C 
C    Calculate the neighbour list for the tile and the offsets 
C    of the neighbours. 
C 
        CALL NLIST(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,NINDEX,NBR, 
     1    PTOFF,KNBMAX,KNB) 
        IF(IFLAG.EQ.0) GOTO 3 
        WRITE(NWRITE,9000) IFLAG 
        STOP 624 
    3   WRITE(NWRITE,9004) (NBR(K),PTOFF(1,K),PTOFF(2,K),K = 1,KNB) 
C 
C    Calculate the positions of the tile vertices. 
C 
        CALL TILVTX(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,NINDEX,VTX, 
     1    KVTMAX,KVTX,.FALSE.) 
        IF(IFLAG.EQ.0) GOTO 4 
        WRITE(NWRITE,9000) IFLAG 
        STOP 625 
    4   WRITE(NWRITE,9005) (VTX(1,K),VTX(2,K),K = 1,KVTX) 
C 
C    Calculate size and shape parameters for the tile. 
C 
        CALL INFORM(VTX,KVTX,P,AREA,X,Y,XX,XY,YY) 
        WRITE(NWRITE,9006) P,AREA,X,Y,XX,YY,XY 
C 
C    Calculate the proportional subdivision of the tile by triangles 
C    from the vertices. 
C 
        CALL SUBDIV(VTX,KVTX,PROP) 
        WRITE(NWRITE,9007) (PROP(K),K = 1,KVTX) 
C 
C    Scatter KRANP points uniformly over the tile. 
C 
        WRITE(NWRITE,9008) 
        DO 6  KRP = 1,KRANP 
        CALL RANPT(VTX,KVTX,PROP,UNI4M,M,X,Y) 
    6   WRITE(NWRITE,9009) X,Y 
C 
C    Use TILVTE to compute the offsets of the vertices from the 
C    point position and the edge effect indicator. 
C 
        CALL TILVTE(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,NINDEX, 
     1    VTX,KVTMAX,KVTX,.TRUE.,IEDGE) 
        IF(IFLAG.EQ.0) GOTO 7 
        WRITE(NWRITE,9000) IFLAG 
        STOP 626 
    7   WRITE(NWRITE,9010) (VTX(1,K),VTX(2,K),K = 1,KVTX) 
        IF(IEDGE.GE.0) GOTO 8 
        WRITE(NWRITE,9011) 
        GOTO 10 
    8   IF(IEDGE.NE.0) GOTO 9 
        WRITE(NWRITE,9012) 
        GOTO 10 
    9   WRITE(NWRITE,9013) 
C 
C    Find the area of grass eaten by the goat on its tether of 
C    length R.... 
C 
   10   CALL GRAZE(VTX,KVTX,R,AREA,EATEN,ANGLE) 
        WRITE(NWRITE,9014) AREA,R,EATEN,ANGLE 
C 
C    Calculate Mead's statistics for the tile. 
C 
        CALL MEAD(VTX,KVTX,AREA,ECCIR,ABCEN) 
        WRITE(NWRITE,9015) AREA,ECCIR,ABCEN 
C 
C    Calculate the enclosed and enclosing discs for the tile. 
C 
        CALL AREAS(VTX,KVTX,AIN,AREA,AOUT) 
        WRITE(NWRITE,9016) AIN,AREA,AOUT 
    2   CONTINUE 
C 
C    Set up some radii for use by INDISC. 
C 
C 
C    First set up a characteristic length. 
C 
        CHLENG = 0.5*(XMAX-XMIN+YMAX-YMIN)/SQRT(FLOAT(NPTSIN)) 
        SMLENG = CHLENG/FLOAT(MRVAL) 
C 
C    Now work out the radii. 
C 
        DO 11 NRAD = 1,MRVAL 
   11   RVAL(NRAD) = FLOAT(NRAD)*SMLENG 
C 
C    Calculate area of the window within RVAL of the data points. 
C 
        CALL INDISC(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,VTX,KVTMAX, 
     1    RVAL,EVAL,AVAL,MRVAL,ARETOT,ANGTOT) 
        IF(IFLAG.EQ.0) GOTO 12 
        WRITE(NWRITE,9000) IFLAG 
        STOP 627 
   12   WRITE(NWRITE,9017) ARETOT,ANGTOT 
        WRITE(NWRITE,9018) (RVAL(MR),EVAL(MR),AVAL(MR),MR = 1,MRVAL) 
C 
C    Divide the points into two classes - those with even indicees 
C    and those with odd. 
C 
        DO 13 NPT = 1,NPTS 
        NCODE(NPT) = MOD(NPT,2)+1 
        IF(NADDR(NPT).LE.0) NCODE(NPT) = -1 
   13   CONTINUE 
C 
C    Calculate the area within RVAL of the even points. 
C 
        CALL INDICO(CN,JCNS,PT,NPTS,NADDR,L,LTOP,IFLAG,NCODE, 
     1    VTX,KVTMAX,RVAL,EVAL,AVAL,MRVAL,ARETOT,ANGTOT,1) 
        IF(IFLAG.EQ.0) GOTO 14 
        WRITE(NWRITE,9000) IFLAG 
        STOP 630 
   14   WRITE(NWRITE,9019) ARETOT,ANGTOT 
        WRITE(NWRITE,9018) (RVAL(MR),EVAL(MR),AVAL(MR),MR = 1,MRVAL) 
C 
C    Run complete. 
C 
        WRITE(NWRITE,9020) 
        STOP 
 9000   FORMAT(//1H ,18(1H*)/1H ,15HERROR: IFLAG = ,I3/1H ,18(1H*)//) 
 9001   FORMAT(1H1,26HTHE WINDOW VERTICES ARE AT//1H ,7X,1HX,9X,1HY/ 
     1    (1H ,5X,F6.3,4X,F6.3)) 
 9002   FORMAT(//1H ,48HTHE WINDOW IS CONTAINED WITHIN THE RECTANGLE WIT 
     1    ,1HH/1H ,7X,21HSOUTHWEST CORNER AT (,F6.3,1H,,F6.3,1H)/ 
     2    1H ,3X,25HAND NORTHEAST CORNER AT (,F6.3,1H,,F6.3,1H)/ 
     3    //////1H ,40HCHARACTERISTICS OF RANDOMLY CHOSEN TILES/1H  , 
     4    40(1H=)//) 
 9003   FORMAT(1H ,20HTILE OF POINT INDEX ,I3,14H AT POSITION (,F6.3, 
     1    1H,,F6.3,1H)//) 
 9004   FORMAT(1H ,15HHAS NEIGHBOURS://1H ,7X,17HINDEX    X OFFSET, 
     1    12H    Y OFFSET/(1H ,8X,I3,6X,F6.3,6X,F6.3)) 
 9005   FORMAT(//1H ,20HITS VERTICES ARE AT://1H ,11X,1HX,8X,1HY/ 
     1    (1H ,9X,F6.3,3X,F6.3)) 
 9006   FORMAT(//1H ,17HITS PERIMETER IS ,F7.3/ 
     1    1H ,12HITS AREA IS ,F8.4/ 
     2    1H ,45HFOR A UNIFORM PROBABILITY MEASURE ON THE TILE/ 
     3    1H ,26HTHE MEAN IS AT THE POINT (,F6.3,1H,,F6.3,1H)/ 
     4    1H ,37HAND THE VARIANCES AND COVARIANCE ARE ,3(F8.4,2X)) 
 9007   FORMAT(//1H ,31HITS PROPORTIONAL SUBDIVISION IS/(1H ,9X,F6.4)) 
 9008   FORMAT(//1H ,45HA REALISATION OF A POINT PROCESS UNIFORM OVER, 
     1    10H THE TILE://1H ,11X,1HX,8X,1HY) 
 9009   FORMAT(1H ,9X,F6.3,3X,F6.3) 
 9010   FORMAT(//1H ,43HTILE VERTEX OFFSETS FROM THE POINT POSITION// 
     1    1H ,11X,20HX OFFSET    Y OFFSET/(1H ,12X,F6.3,6X,F6.3)) 
 9011   FORMAT(/1H ,40HTHE POINT IS CONTIGUOUS TO A CONSTRAINT.) 
 9012   FORMAT(/1H ,40HTHE POINT WOULD NOT BE AFFECTED IF THE W, 
     1    20HINDOW WERE ENLARGED.) 
 9013   FORMAT(/1H ,40HTHE POINT WOULD BE AFFECTED IF THE WINDO, 
     1    16HW WERE ENLARGED.) 
 9014   FORMAT(//1H ,24HTHE AREA OF THE TILE IS ,F7.4,11H AND A GOAT, 
     1    23H ON A TETHER OF LENGTH ,F7.4,13H WOULD GRAZE  / 
     2    1H ,11HAN AREA OF ,F7.4,34H OF THE TILE.  THE TETHER IS AN EF, 
     3    23HFECTIVE RESTRAINT OVER ,F7.4,9H RADIANS.) 
 9015   FORMAT(//1H ,31HMEAD'S STATISTICS FOR THE TILE:/ 
     1    1H ,13X,7HAREA = ,F8.4/1H ,4X,16HECCIRCULARITY = ,F8.4/1H ,5X, 
     2    15HABCENTRICITY = ,F8.4) 
 9016   FORMAT(//1H ,15HA DISC OF AREA ,F8.4,23H COULD BE CONTAINED IN , 
     1    25HTHE TILE, WHICH HAS AREA ,F8.4,1H./ 
     2    1H ,15HA DISC OF AREA ,F8.4,24H WOULD CONTAIN THE TILE./////) 
 9017   FORMAT(///////1H ,35HTHE TOTAL AREA OF ALL THE TILES IS: ,F8.4/ 
     1    1H ,45HTHE NUMBER OF ACCEPTED POINTS TIMES 2*PI IS: ,F9.4) 
 9018   FORMAT(//1H ,44HRADIUS, TOTAL AREA WITHIN THAT RADIUS OF THE , 
     1    8H POINTS,/1H ,36HAND TOTAL ANGLE SUBTENDED AT THEM BY, 
     2    28H THE PERIMETER OF THAT AREA:// 
     3    1H ,5X,25HRADIUS     AREA     ANGLE/(1H ,3X,F8.4,3X,F8.4,2X, 
     4    F8.4)) 
 9019   FORMAT(//1H ,34HTILE AREA OF EVEN INDEXED POINTS: ,F8.4/ 
     1    1H ,34HNUMBER OF EVEN POINTS TIMES 2*PI: ,F8.4) 
 9020   FORMAT(////1H ,22HTESTE 4.2 RUN COMPLETE) 
        END 
