Attach("texmodel.m");

// Set up x,y and p, the base ring and the prime; e.g. R:=GF(5)(t)[x,y] with p:=t is also fine
R<x,y>:=PolynomialRing(Rationals(),2);    
p:=5; 
 
// List of curves for which we want regular models
L:=[y^2+x^3+p^3*x,p^3+x^4+x^2+x*y^2, y^2-(x-1)*(x-2)*(x-3)*(x-p)*(x-2*p)*(x-3*p)*(x-4*p), 
    y^2+x^5+x+p^6, y^2+x^5+x^2+p^6, y^3+x^3+p^5+x^2+p^3*x^2*y^3];

// Set up TeX settings - spacing, fonts, etc. [See first intrinsic -Model in texmodel.m for more]
S:=DefaultSettings("0.6,0.6","0.8,0.7");   // <- (xscale,yscale) for Delta and for special fibre
S["ShowCharts"]:=false;                    // <- whether to how variable transformations to see the principal components of the special fibre
S["ShowEquation"]:=8;                      // <- print equation f=... if it has <=8 terms; :="true" always print it, ":=false" never.

"Computing the models -> test.inc file";
Rewrite("test.inc");
for f in L do
  M:=Model(f,p: Style:=S);     // "Model" also accepts elliptic, hyperelliptic and plane curves
  writeq("test.inc",M);
  writeq("test.inc","\n\\medskip\\hrule\n\n\\bigskip\n\n");
end for; 

"Compiling test.tex -> test.pdf";
System("pdflatex test.tex");
