"nox.x" <-
c(0, 0.03873745, 0.04734577, 0.07030129, 0.09469154, 0.09612626, 
0.1047346, 0.1348637, 0.1463415, 0.1721664, 0.2022956, 0.2137733, 
0.2166428, 0.2266858, 0.2281205, 0.2309900, 0.2309900, 0.2582496, 
0.2783357, 0.2840746, 0.3070301, 0.3242468, 0.3256815, 0.3299857, 
0.3328551, 0.3730273, 0.3758967, 0.3859397, 0.3916786, 0.3916786, 
0.3959828, 0.3974175, 0.3988522, 0.4031564, 0.446198, 0.4777618, 
0.4835007, 0.492109, 0.5121951, 0.5136298, 0.5222382, 0.5337159, 
0.5394548, 0.5667145, 0.5724534, 0.6212339, 0.6341463, 0.6527977, 
0.6685796, 0.6700143, 0.6700143, 0.6757532, 0.6800574, 0.6901004, 
0.7101865, 0.7187948, 0.7202296, 0.7274032, 0.7317073, 0.7317073, 
0.7675753, 0.76901, 0.7704448, 0.7733142, 0.7833572, 0.8220947, 
0.8321377, 0.8436155, 0.846485, 0.8651363, 0.8708752, 0.8737446, 
0.8852224, 0.8852224, 0.9081779, 0.918221, 0.9253945, 0.9268293, 
0.938307, 0.9526542, 0.9555237, 0.9756098, 0.9813486, 0.9928264, 
0.9956958, 0.9971306, 0.9985653, 1)
"nox.y" <-
c(0.53, 0.37, 0.374, 0.678, 1.192, 0.923, 0.563, 0.561, 0.571, 
1.9, 1.777, 1.587, 1.59, 1.369, 1.527, 0.926, 1.139, 1.419, 1.397, 
2.219, 1.62, 2.295, 1.634, 1.732, 1.869, 2.064, 3.361, 3.677, 
3.148, 2.202, 2.471, 3.76, 3.517, 3.388, 3.931, 3.423, 3.519, 
3.206, 3.656, 3.567, 3.488, 3.741, 3.536, 3.669, 4.028, 3.952, 
3.623, 3.732, 3.12, 2.964, 3.29, 2.836, 2.845, 2.881, 2.581, 
2.739, 2.085, 2.358, 2.157, 2.571, 1.947, 1.836, 1.806, 1.962, 
1.719, 1.498, 1.39, 1.17, 1.2, 0.981, 1.013, 1.021, 1, 0.866, 
0.756, 0.812, 0.797, 0.966, 0.76, 0.727, 0.586, 0.606, 0.962, 
0.754, 0.414, 0.672, 0.638, 0.542)
"nox" <-
structure(c(3.741, 2.295, 1.498, 2.881, 0.76, 3.12, 0.638, 1.17, 
2.358, 0.606, 3.669, 1, 0.981, 1.192, 0.926, 1.59, 1.806, 1.962, 
4.028, 3.148, 1.836, 2.845, 1.013, 0.414, 0.812, 0.374, 3.623, 
1.869, 2.836, 3.567, 0.866, 1.369, 0.542, 2.739, 1.2, 1.719, 
3.423, 1.634, 1.021, 2.157, 3.361, 1.39, 1.947, 0.962, 0.571, 
2.219, 1.419, 3.519, 1.732, 3.206, 2.471, 1.777, 2.571, 3.952, 
3.931, 1.587, 1.397, 3.536, 2.202, 0.756, 1.62, 3.656, 2.964, 
3.76, 0.672, 3.677, 3.517, 3.29, 1.139, 0.727, 2.581, 0.923, 
1.527, 3.388, 2.085, 0.966, 3.488, 0.754, 0.797, 2.064, 3.732, 
0.586, 0.561, 0.563, 0.678, 0.37, 0.53, 1.9, 0.907, 0.761, 1.108, 
1.016, 1.189, 1.001, 1.231, 1.123, 1.042, 1.215, 0.93, 1.152, 
1.138, 0.601, 0.696, 0.686, 1.072, 1.074, 0.934, 0.808, 1.071, 
1.009, 1.142, 1.229, 1.175, 0.568, 0.977, 0.767, 1.006, 0.893, 
1.152, 0.693, 1.232, 1.036, 1.125, 1.081, 0.868, 0.762, 1.144, 
1.045, 0.797, 1.115, 1.07, 1.219, 0.637, 0.733, 0.715, 0.872, 
0.765, 0.878, 0.811, 0.676, 1.045, 0.968, 0.846, 0.684, 0.729, 
0.911, 0.808, 1.168, 0.749, 0.892, 1.002, 0.812, 1.23, 0.804, 
0.813, 1.002, 0.696, 1.199, 1.03, 0.602, 0.694, 0.816, 1.037, 
1.181, 0.899, 1.227, 1.18, 0.795, 0.99, 1.201, 0.629, 0.608, 
0.584, 0.562, 0.535, 0.655), .Dim = c(88, 2))
"blocks"<-
function(t)
{
        out <- double(length(t))
        for(i in (1:length(blockst)))
                out <- out + (blocksh[i] * (1 + sign(t - blockst[i])))/2
        out
}
"blocksh"<-
c(4, -5, 3, -4, 5, -4.2000000000000002, 2.1000000000000001, 4.2999999999999998,
        -3.1000000000000001
        , 2.1000000000000001, -4.2000000000000002)
"blockst"<-
c(0.10000000000000001, 0.13, 0.14999999999999999, 0.23000000000000001, 0.25,
        0.40000000000000002, 0.44, 0.65000000000000002, 0.76000000000000001,
        0.78000000000000003, 0.81000000000000005)
"bumpsw"<-
c(0.0050000000000000001, 0.0050000000000000001, 0.0060000000000000001, 0.01,
        0.01, 0.029999999999999999, 0.01, 0.01, 0.0050000000000000001,
        0.0080000000000000002, 0.0050000000000000001)
"bumps"<-
function(t)
{
        out <- double(length(t))
        for(i in (1:length(bumpst)))
                out <- out + bumpsh[i]/(1 + abs((t - bumpst[i])/bumpsw[i]))^4
        out
}
"bumpsh"<-
c(4, 5, 3, 4, 5, 4.2000000000000002, 2.1000000000000001, 4.2999999999999998,
        3.1000000000000001, 5.0999999999999996, 4.2000000000000002)
"bumpst"<-
c(0.10000000000000001, 0.13, 0.14999999999999999, 0.23000000000000001, 0.25,
        0.40000000000000002, 0.44, 0.65000000000000002, 0.76000000000000001,
        0.78000000000000003, 0.81000000000000005)
"doppler"<-
function(t)
{
        sqrt(t * (1 - t)) * sin((2 * pi * 1.05)/(t + 0.050000000000000003))
}
"heavisine"<-
function(t)
{
        4 * sin(4 * pi * t) - sign(t - 0.29999999999999999) - sign(
                0.71999999999999997 - t)
}

