crash.nl<-mad(crash.y[2*(1:66)]-crash.y[2*(1:66)-1])/sqrt(2)
crash.robust<-alg61(crash.x,crash.y,0.03001,crash.nl)
crash.grid<-makegrid(crash.robust$t,crash.robust$y,256)
crash.irregwd<-irregwd(crash.grid,family="DaubExPhase",filter.number=6)
crash.thresh<-threshold(crash.irregwd,dev=mymadmad,noise.level=crash.nl,policy="universal",type="hard")
crash.wr<-wr(crash.thresh)
crash.gridnonrob<-makegrid(crash.x,crash.y,256)
crash.irregwdnonrob<-irregwd(crash.gridnonrob,family="DaubExPhase",filter.number=6)
crash.threshnonrob<-threshold(crash.irregwdnonrob,dev=mymadmad,policy="universal",type="hard")
crash.wrnonrob<-wr(crash.threshnonrob)
crash.wdclass<-wd(crash.y[1:128],filter.number=6,family="DaubExPhase")
crash.threshclass<-threshold(crash.wdclass,dev=mymadmad,policy="universal",type="hard")
crash.wrclass<-wr(crash.threshclass)
postscript("haerdle.ps")
par(mfrow=c(2,2))
plot(crash.x,crash.y,xlab="x",ylab="y")
lines(crash.x[1:128],crash.wrclass)
title("Classical Wavelet Thresholding")
plot(crash.x,crash.y,xlab="x",ylab="y")
lines(crash.grid$gridt, crash.wrnonrob)
title("Thresholding for Unequally Spaced Data")
plot(crash.robust$t,crash.robust$y,xlab="x",ylab="y")
title("Cleaned Data")
plot(crash.x,crash.y,xlab="x",ylab="y")
lines(crash.grid$gridt, crash.wr)
title("Robust Thresholding")
dev.off()
crash.min<-min(crash[,1])
crash.int<-max(crash[,1])-min(crash[,1])
postscript("crash.ps")
par(mfrow=c(2,2))
crash.rob<-alg61(crash.x,crash.y,0.03001,crash.nl)
crash.grid<-makegrid(crash.rob$t,crash.rob$y,128)
crash.irregwd<-irregwd(crash.grid,filter.number=4)
crash.threshb<-threshold(crash.irregwd,dev=mymadmad,noise.level=crash.nl)
crash.61b<-wr(crash.threshb)
plot(crash.x*crash.int+crash.min,crash.y,xlab="Time",ylab="Acceleration")
lines(crgrid(128)*crash.int+crash.min,crash.61b,lty=1)
title("Single outlier removing")
crash.rob<-alg63(crash.x,crash.y,0.1,0.02,crash.nl)
crash.grid<-makegrid(crash.rob$t,crash.rob$y,128)
crash.irregwd<-irregwd(crash.grid,filter.number=4)
crash.threshb<-threshold(crash.irregwd,dev=mymadmad,noise.level=crash.nl)
crash.63b<-wr(crash.threshb)
plot(crash.x*crash.int+crash.min,crash.y,xlab="Time",ylab="Acceleration")
lines(crgrid(128)*crash.int+crash.min,crash.63b,lty=1)
title("Multiple outlier removing")
crash.rob<-alg63s(crash.x,crash.y,0.1,0.02,crash.nl)
crash.grid<-makegrid(crash.rob$t,crash.rob$y,128)
crash.irregwd<-irregwd(crash.grid,filter.number=4)
crash.threshb<-threshold(crash.irregwd,dev=mymadmad,noise.level=crash.nl)
crash.63sb<-wr(crash.threshb)
plot(crash.x*crash.int+crash.min,crash.y,xlab="Time",ylab="Acceleration")
lines(crgrid(128)*crash.int+crash.min,crash.63sb,lty=1)
title("Simplified multiple outlier removing")
crash.65<-alg65(crash.x,crash.y,0.03,128,crash.nl,covtable=covtable.normal,filter.number=4,firstthreshlevel=2)
plot(crash.x*crash.int+crash.min,crash.y,xlab="Time",ylab="Acceleration")
lines(crgrid(128)*crash.int+crash.min,crash.65)
title("Median Filter + Thresholding")
dev.off()
