"accessc"<-
function(irregwd.structure, level, boundary = F)
{
	ctmp <- class(irregwd.structure)
	if(is.null(ctmp))
		stop("irregwd.structure has no class")
	else if(ctmp != "irregwd")
		stop("irregwd.structure is not of class irregwd")
	if(level < 0)
		stop("Must have a positive level")
	else if(level > (irregwd.structure$nlevels - 1))
		stop("Cannot exceed maximum number of levels")
	level <- level + 1
	first.last.d <- irregwd.structure$fl.dbase$first.last.d
	first.level <- first.last.d[level, 1]
	last.level <- first.last.d[level, 2]
	offset.level <- first.last.d[level, 3]
	if(boundary == T) {
		n <- last.level - first.level + 1
		coefs <- irregwd.structure$c[(offset.level + 1):(offset.level + 
			n)]
	}
	else {
		n <- 2^(level - 1)
		coefs <- irregwd.structure$c[(offset.level + 1 - first.level):(
			offset.level + n - first.level)]
	}
	return(coefs)
}
"makegrid"<-
function(time, y, gridn = 2^(floor(log(length(time) - 1, 2)) + 1))
{
	tmp <- .C("makegrid",
		x = as.double(time),
		y = as.double(y),
		n = length(time),
		gridt = as.double(rep(0, gridn)),
		gridy = as.double(rep(0, gridn)),
		gridn = as.integer(gridn),
		G = as.double(rep(0, gridn)),
		Gindex = as.integer(rep(0, gridn)))
	l <- list(gridt = tmp$gridt, gridy = tmp$gridy, G = tmp$G, Gindex = tmp$
		Gindex)
	class(l) <- "griddata"
	l
}
"irregwd"<-
function(gd, filter.number = 2, family = "DaubExPhase", bc = "periodic", 
	verbose = F)
{
	type <- "wavelet"
	if(verbose == T)
		cat("wd: Argument checking...")
	ctmp <- class(gd)
	if(is.null(ctmp))
		stop("gd has no class")
	else if(ctmp != "griddata")
		stop("gd is not of class griddata")
	data <- gd$gridy
	if(!is.atomic(data))
		stop("Data is not atomic")
	DataLength <- length(data)	#
#
# Check that we have a power of 2 data elements
#
	nlevels <- nlevels(data)	#
	if(is.na(nlevels)) stop("Data length is not power of two")	
	# Check for correct type
#
	if(type != "wavelet" && type != "station")
		stop("Unknown type of wavelet decomposition")
	if(type == "station" && bc != "periodic") stop(
			"Can only do periodic boundary conditions with station"
			)	#
# Select the appropriate filter
#
	if(verbose == T)
		cat("...done\nFilter...")
	filter <- filter.select(filter.number = filter.number, family = family)
		#
#
# Build the first/last database
#
	if(verbose == T)
		cat("...selected\nFirst/last database...")
	fl.dbase <- first.last(LengthH = length(filter$H), DataLength = 
		DataLength, type = type, bc = bc)	#
#
# Save time series attribute if there is one
#
	dtspar <- tspar(data)	#
#
# Put in the data
#
	C <- rep(0, fl.dbase$ntotal)
	C[1:DataLength] <- data	#
	if(verbose == T)
		error <- 1
	else error <- 0
	if(verbose == T) cat("built\n")	#
#
# Compute the decomposition
#
	if(verbose == T)
		cat("Decomposing...\n")
	nbc <- switch(bc,
		periodic = 1,
		symmetric = 2)
	if(is.null(nbc))
		stop("Unknown boundary condition")
	ntype <- switch(type,
		wavelet = 1,
		station = 2)
	if(is.null(filter$G)) {
		wavelet.decomposition <- .C("wavedecomp",
			C = as.double(C),
			D = as.double(rep(0, fl.dbase$ntotal.d)),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
		tmp <- .C("computec",
			n = as.integer(length(gd$Gleft)),
			c = as.double(rep(0, fl.dbase$ntotal.d)),
			gridn = as.integer(length(gd$G)),
			G = as.double(gd$G),
			Gindex = as.integer(gd$Gindex),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nbc = as.integer(nbc))
	}
	else {
		wavelet.decomposition <- .C("comwd",
			CR = as.double(Re(C)),
			CI = as.double(Im(C)),
			LengthC = as.integer(fl.dbase$ntotal),
			DR = as.double(rep(0, fl.dbase$ntotal.d)),
			DI = as.double(rep(0, fl.dbase$ntotal.d)),
			LengthD = as.integer(fl.dbase$ntotal.d),
			HR = as.double(Re(filter$H)),
			HI = as.double( - Im(filter$H)),
			GR = as.double(Re(filter$G)),
			GI = as.double( - Im(filter$G)),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
	}
	if(verbose == T)
		cat("done\n")
	error <- wavelet.decomposition$error
	if(error != 0) {
		cat("Error ", error, " occured in wavedecomp\n")
		stop("Error")
	}
	if(is.null(filter$G)) {
		l <- list(C = wavelet.decomposition$C, D = 
			wavelet.decomposition$D, c = tmp$c * (tmp$c > 0), 
			nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	else {
		l <- list(C = complex(real = wavelet.decomposition$CR, im = 
			wavelet.decomposition$CI), D = complex(real = 
			wavelet.decomposition$DR, im = wavelet.decomposition$DI
			), nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	class(l) <- "irregwd"
	if(!is.null(dtspar))
		tspar(l) <- dtspar
	l
}
"threshold.irregwd"<-
function(irregwd, levels = 3:(wd$nlevels - 1), type = "hard", policy = 
	"universal", by.level = F, value = 0, dev = var, boundary = F, verbose
	 = F, return.threshold = F, force.sure = F, cvtol = 0.01, Q = 
	0.050000000000000003, alpha = 0.050000000000000003, noise.level = -1, 
	firstthreshlevel = 1)
{
	if(verbose == T)
		cat("threshold.irregwd:\n")
	if(IsEarly(wd)) {
		ConvertMessage()
		stop()
	}
#
#	Check class of wd
#
	if(verbose == T)
		cat("Argument checking\n")
	ctmp <- class(irregwd)
	if(is.null(ctmp))
		stop("irregwd has no class")
	else if(ctmp != "irregwd")
		stop("irregwd is not of class irregwd")
	wd <- irregwd
	class(wd) <- "wd"
	if(policy != "universal" && policy != "manual" && policy != 
		"probability" && policy != "sure" && policy != "mannum" && 
		policy != "cv" && policy != "fdr" && policy != "op1" && policy != 
		"op2" && policy != "LSuniversal")
		stop("Only policys are universal, manual, mannum, sure, LSuniversal, cv, op1, op2 and probability at present"
			)
	if(type != "hard" && type != "soft")
		stop("Only hard or soft thresholding at  present")
	r <- range(levels)
	if(r[1] < 0)
		stop("levels out of range, level too small")
	if(r[2] > wd$nlevels - 1)
		stop("levels out of range, level too big")
	if(r[1] > wd$nlevels - 1) {
		warning("no thresholding done")
		return(wd)
	}
	if(r[2] < 0) {
		warning("no thresholding done")
		return(wd)
	}
	n <- 2^wd$nlevels
	nthresh <- length(levels)	#
# Estimate sigma
	if(by.level == F) {
		if(noise.level < 0) {
			d <- NULL
			ccc <- NULL
			for(i in 1:nthresh) {
				d <- c(d, accessD(wd, level = levels[i], 
				  boundary = boundary))
				ccc <- c(ccc, accessc(irregwd, level = levels[i
				  ], boundary = boundary))
			}
			ind <- (1:length(d))[abs(ccc) > 1.0000000000000001e-05]
			sigma <- sqrt(dev(d[ind]/sqrt(ccc[ind])))
			sigma <- rep(sigma, nthresh)
		}
		else sigma <- rep(noise.level, nthresh)
	}
	else {
		for(i in 1:nthresh) {
			d <- accessD(wd, level = levels[i], boundary = boundary
				)
			ccc <- accessc(irregwd, level = levels[i], boundary = 
				boundary)
			ind <- (1:length(d))[abs(ccc) > 1.0000000000000001e-05]
			sigma[i] <- sqrt(dev(d[ind]/sqrt(ccc[ind])))
		}
	}
	print(sigma)
	d <- NULL
	ccc <- NULL	#
#	Check to see if we're thresholding a complex wavelet transform.
#	We can only do certain things in this case
#
	if(is.complex(wd$D)) {
		stop("Complex transform not implemented")
	}
#
#
#	Decide which policy to adopt
#		The next if-else construction should define a vector called
#		"thresh" that contains the threshold value for each level
#		in "levels". This may be the same threshold value
#		a global threshold.
#
	if(policy == "universal") {
#
#
#		Donoho and Johnstone's universal policy
#
		if(verbose == T) cat("Universal policy...")
		if(by.level == F) {
			if(verbose == T)
				cat("All levels at once\n")
			for(i in 1:nthresh)
				d <- c(d, accessD(wd, level = levels[i], 
				  boundary = boundary))
			nd <- length(d)
			thresh <- sqrt(2 * log(nd))
			if(verbose == T)
				cat("Global threshold is: ", thresh, "\n")
			thresh <- rep(thresh, length = nthresh)
		}
		else {
			if(verbose == T)
				cat("Level by level\n")
			thresh <- rep(0, length = nthresh)
			for(i in 1:nthresh) {
				d <- accessD(wd, level = levels[i], boundary = 
				  boundary)
				nd <- length(d)
				thresh[i] <- sqrt(2 * log(nd))
				if(verbose == T)
				  cat("Threshold for level: ", levels[i], 
				    " is ", thresh[i], "\n")
			}
		}
		expo <- 1
	}
	else if(policy == "LSuniversal") {
#
#
#		The universal policy modified for local spectral smoothing
#		This should only be used via the LocalSpec function
#
		if(verbose == T) cat("Local spectral universal policy...")
		if(by.level == F) {
			if(verbose == T)
				cat("All levels at once\n")
			for(i in 1:nthresh)
				d <- c(d, accessD(wd, level = levels[i], 
				  boundary = boundary))
			nd <- length(d)
			thresh <- log(nd)
			if(verbose == T)
				cat("Global threshold is: ", thresh, "\n")
			thresh <- rep(thresh, length = nthresh)
		}
		else {
			if(verbose == T)
				cat("Level by level\n")
			thresh <- rep(0, length = nthresh)
			for(i in 1:nthresh) {
				d <- accessD(wd, level = levels[i], boundary = 
				  boundary)
				nd <- length(d)
				thresh[i] <- log(nd)
				if(verbose == T)
				  cat("Threshold for level: ", levels[i], 
				    " is ", thresh[i], "\n")
			}
		}
		expo <- 1
	}
	else if(policy == "sure") {
		if(type == "hard")
			stop("Can only do soft thresholding with sure policy")
		if(by.level == F) {
			if(verbose == T)
				cat("All levels at once\n")
			for(i in 1:nthresh) {
				d <- c(d, accessD(wd, level = levels[i], 
				  boundary = boundary))
				ccc <- c(ccc, accessc(irregwd, level = levels[i
				  ], boundary = boundary))
			}
			ind <- (1:length(d))[abs(ccc) > 1.0000000000000001e-05]
			nd <- length(ind)
			neta.d <- (log(nd, base = 2)^(3/2))
			sd2 <- (sum((d[ind]/(sigma[1] * ccc)[ind])^2 - 1)/nd)
			if(verbose == T) {
				cat("neta.d is ", neta.d, "\nsd2 is ", sd2, 
				  "\n")
				cat("nd is ", nd, "\n")
				cat("noise.level ", noise.level, "\n")
			}
			if(force.sure == T || sd2 > neta.d/sqrt(nd)) {
				if(verbose == T) {
				  cat("SURE: Using SURE\n")
				}
				thresh <- newsure(sqrt(ccc) * sigma[1], d)
				expo <- 0
			}
			else {
				if(verbose == T)
				  cat("SURE: (sparse) using sqrt 2log n\n")
				thresh <- sqrt(2 * log(nd))
			}
			thresh <- rep(thresh, length = nthresh)
			if(verbose == T)
				cat("Global threshold is ", thresh, "\n")
		}
		else {
#
#
#		By level is true
#
			print("Sure for level- and coefficient-dependenet thresholding is not adapted"
				)
			if(verbose == T)
				cat("Level by level\n")
			thresh <- rep(0, length = nthresh)
			collect <- NULL
			for(i in 1:nthresh)
				collect <- c(collect, accessD(wd, level = 
				  levels[i], boundary = boundary))
			noise.level <- sqrt(dev(collect))
			for(i in 1:nthresh) {
				d <- accessD(wd, level = levels[i], boundary = 
				  boundary)
				nd <- length(d)
				neta.d <- (log(nd, base = 2)^(3/2))
				sd2 <- (sum((d/noise.level)^2 - 1)/nd)
				if(verbose == T) {
				  cat("neta.d is ", neta.d, "\nsd2 is ", sd2, 
				    "\n")
				  cat("nd is ", nd, "\n")
				  cat("noise.level ", noise.level, "\n")
				}
				if(force.sure == T || sd2 > neta.d/sqrt(nd)) {
				  if(verbose == T) {
				    cat("SURE: Using SURE\n")
				  }
				  thresh[i] <- sure(d/noise.level)
				}
				else {
				  if(verbose == T)
				    cat("SURE: (sparse) using sqrt 2log n\n")
				  thresh[i] <- sqrt(2 * log(nd))
				}
				if(verbose == T)
				  cat("Threshold for level: ", levels[i], 
				    " is ", thresh[i], "\n")
			}
		}
	}
	else if(policy == "manual") {
#
#
#		User supplied threshold policy
#
		if(verbose == T) cat("Manual policy\n")
		thresh <- rep(value, length = nthresh)
		if(length(value) != 1 && length(value) != nthresh)
			warning("your threshold is not the same length as number of levels"
				)
		expo <- 0
	}
	else if(policy == "mannum") {
		if(verbose == T) {
			cat("Manual policy using ", value, " of the")
			cat(" largest coefficients\n")
		}
		if(value < 1) {
			stop("Have to select an integer larger than 1 for value"
				)
		}
		else if(value > length(wd$D)) {
			stop(paste("There are only ", length(wd$D), 
				" coefficients, you specified ", value))
		}
		coefs <- wd$D
		scoefs <- sort(abs(coefs))
		scoefs <- min(rev(scoefs)[1:value])
		wd$D[abs(wd$D) < scoefs] <- 0
		return(wd)
	}
	else if(policy == "probability") {
#
#
#		Threshold is quantile based
#
		if(verbose == T) cat("Probability policy...")
		if(by.level == F) {
			if(verbose == T)
				cat("All levels at once\n")
			for(i in 1:nthresh)
				d <- c(d, accessD(wd, level = levels[i], 
				  boundary = boundary))
			if(length(value) != 1)
				stop("Length of value should be 1")
			thresh <- rep(quantile(abs(d), prob = value), length = 
				nthresh)
			if(verbose == T)
				cat("Global threshold is: ", thresh[1], "\n")
		}
		else {
			if(verbose == T)
				cat("Level by level\n")
			thresh <- rep(0, length = nthresh)
			if(length(value) == 1)
				value <- rep(value, nthresh)
			if(length(value) != nthresh)
				stop("Wrong number of probability values")
			for(i in 1:nthresh) {
				d <- accessD(wd, level = levels[i], boundary = 
				  boundary)
				thresh[i] <- quantile(abs(d), prob = value[i])
				if(verbose == T)
				  cat("Threshold for level: ", levels[i], 
				    " is ", thresh[i], "\n")
			}
		}
	}
	if(return.threshold == T)
		return(thresh)
	for(i in firstthreshlevel:nthresh) {
		d <- accessD(wd, level = levels[i], boundary = boundary)
		ccc <- accessc(irregwd, level = levels[i], boundary = boundary)
		actthresh <- thresh[i] * (sigma[i] * sqrt(ccc))^expo	
	# is vector
		if(type == "hard") {
			d[abs(d) <= actthresh] <- 0
			if(verbose == T)
				cat("Level: ", levels[i], " there are ", sum(d == 
				  0), " zeroes\n")
		}
		else if(type == "soft") {
			d <- (d * (abs(d) - actthresh) * (abs(d) > actthresh))/
				abs(d)
			d[is.na(d)] <- 0
		}
		wd <- putD(wd, level = levels[i], v = d, boundary = boundary)
	}
	wd
}
"plot.irregwd"<-
function(irregwd, xlabels, first.level = 1, main = 
	"Wavelet Decomposition Coefficients", scaling = "by.level", rhlab = F, 
	sub, ...)
{
#
#       Check class of wd
#
	ctmp <- class(irregwd)
	if(is.null(ctmp))
		stop("irregwd has no class")
	else if(ctmp != "irregwd")
		stop("irregwd is not of class irregwd")
	wd <- irregwd
	class(wd) <- "wd"
	levels <- wd$nlevels
	nlevels <- levels - first.level
	n <- 2^(levels - 1)
	if(missing(sub))
		sub <- wd$filter$name
	plot(c(0, 0, n, n), c(0, nlevels + 1, nlevels + 1, 0), type = "n", xlab
		 = "Translate", ylab = "Resolution Level", main = main, yaxt = 
		"n", xaxt = "n", sub = sub, ...)
	axis(2, at = 1:(nlevels), labels = ((levels - 1):first.level))
	if(missing(xlabels)) {
		axx <- c(0, 2^(nlevels - 2), 2^(nlevels - 1), 2^(nlevels - 1) + 
			2^(nlevels - 2), 2^nlevels)
		axis(1, at = axx)
	}
	else {
		axx <- pretty(1:n, nint = 3)
		if(axx[length(axx)] > n)
			axx[length(axx)] <- n
		axx[axx == 0] <- 1
		axl <- signif(xlabels[axx], dig = 3)
		axis(1, at = axx, labels = axl)
	}
	x <- 1:n
	height <- 1
	first.last.d <- wd$fl.dbase$first.last.d
	axr <- NULL
	if(scaling == "global") {
		my <- 0
		for(i in ((levels - 1):first.level)) {
			y <- accessc(irregwd, i)
			my <- max(c(my, abs(y)))
		}
	}
	for(i in ((levels - 1):first.level)) {
		n <- 2^i
		y <- accessc(irregwd, i)
		xplot <- x
		ly <- length(y)
		if(scaling == "by.level")
			my <- max(abs(y))
		y <- (0.5 * y)/my
		axr <- c(axr, my)
		segments(xplot, height, xplot, height + y)
		if(i != first.level) {
			x1 <- x[seq(1, n - 1, 2)]
			x2 <- x[seq(2, n, 2)]
			x <- (x1 + x2)/2
			height <- height + 1
		}
	}
	if(rhlab == T)
		axis(4, at = 1:length(axr), labels = signif(axr, 3))
	axr
}


"mymadmad"<-
function(y)
{
        mad(y)^2
}
"newsure"<-
function(s, x)
{
        x <- abs(x)
        d <- length(x)
        sl <- sort.list(x)
        y <- x[sl]
        sigma <- s[sl]
        cy <- cumsum(y^2)
        cy <- c(0, cy[1:(length(cy) - 1)])
        csigma <- cumsum(sigma^2)
        csigma <- c(0, csigma[1:(length(csigma) - 1)])
        ans <- d - 2 * csigma + cy + d:1 * y^2
        m <- min(ans)
        index <- (1:length(ans))[m == ans]
        return(y[index])
}

"tttt"<-
function(irregwd, s = 1, levels = 3:(irregwd$nlevels - 1), type = "hard", 
	policy = "universal", value = 0, dev = var, boundary = F, verbose = F, 
	return.threshold = F, by.level = F, noise.level = -1)
{
	if(verbose == T)
		cat("Argument checking\n")
	ctmp <- class(irregwd)
	if(is.null(ctmp))
		stop("irregwd has no class")
	else if(ctmp != "irregwd")
		stop("irregwd is not of class irregwd")
	if(policy != "universal" && policy != "manual" && policy != 
		"probability")
		stop("Only policys are universal, manual and probability at present"
			)
	if(type != "hard" && type != "soft")
		stop("Only hard or soft thresholding at  present")
	r <- range(levels)
	if(r[1] < 0)
		stop("levels out of range, level too small")
	if(r[2] > irregwd$nlevels - 1)
		stop("levels out of range, level too big")
	if(r[1] > irregwd$nlevels - 1) {
		warning("no thresholding done")
		return(irregwd)
	}
	if(r[2] < 0) {
		warning("no thresholding done")
		return(irregwd)
	}
	n <- 2^irregwd$nlevels
	nthresh <- length(levels)
	wd <- irregwd
	class(wd) <- "wd"
	if(noise.level < 0) {
		d <- accessD(wd, level = wd$nlevels - 1, boundary = boundary)
		ccc <- abs(accessc(irregwd, level = wd$nlevels - 1, boundary = 
			boundary))
		d <- d[ccc > 0.0001]
		ccc <- ccc[ccc > 0.0001]
		fraction <- d/sqrt(ccc)
		noise.level <- sqrt(dev(fraction))
		nl1 <- sqrt(dev((d/sqrt(ccc))[1:(length(d)/2)]))
		nl2 <- sqrt(dev((d/sqrt(ccc))[(length(d)/2):(length(d))]))
	}
	print(c("noise level: ", noise.level))
	if(policy == "universal") {
		if(verbose == T)
			cat("Universal policy...")
		if(by.level) {
			thresh <- rep(0, nthresh)
			for(i in 1:nthresh) {
				d <- accessD(wd, level = levels[i], boundary = 
				  boundary)
				ccc <- accessc(irregwd, level = levels[i], 
				  boundary = boundary)
				d <- accessD(wd, level = wd$nlevels - 1, 
				  boundary = boundary)
				ccc <- abs(accessc(irregwd, level = wd$nlevels - 
				  1, boundary = boundary))
				d <- d[ccc > 0.0001]
				ccc <- ccc[ccc > 0.0001]
				fraction <- d/sqrt(ccc)
				localnoiselevel <- sqrt(dev(fraction))
				thresh[i] <- (sqrt(2 * log(n)) * 
				  localnoiselevel)/noise.level
			}
		}
		else {
			thresh <- rep(sqrt(2 * log(n)), nthresh)
			if(verbose == T)
				cat("Global threshold is: ", thresh, "\n")
		}
	}
	else if(policy == "manual") {
		if(verbose == T)
			cat("Manual policy\n")
		thresh <- rep(value, nthresh)
	}
	if(return.threshold == T)
		return(thresh)
	for(i in 1:nthresh) {
		d <- accessD(wd, level = levels[i], boundary = boundary)
		ccc <- accessc(irregwd, level = levels[i], boundary = boundary)
		ccc <- abs(ccc)
		if(type == "hard") {
			d[abs(d) <= thresh[i] * (noise.level * sqrt(ccc))^s] <- 
				0
			if(verbose == T)
				cat("Level: ", levels[i], " there are ", sum(d == 
				  0), " zeroes\n")
		}
		else if(type == "soft") {
			ind <- 1:length(d)
			d[ind] <- sign(d[ind]) * (abs(d[ind]) - thresh[i] * (
				nl1 * sqrt(ccc[ind]))^s) * (abs(d[ind]) > 
				thresh[i] * (nl1 * sqrt(ccc[ind]))^s)
			d[ - ind] <- sign(d[ - ind]) * (abs(d[ - ind]) - thresh[
				i] * (nl2 * sqrt(ccc[ - ind]))^s) * (abs(d[ - 
				ind]) > thresh[i] * (nl2 * sqrt(ccc[ - ind]))^s
				)
		}
		wd <- putD(wd, level = levels[i], v = d, boundary = boundary)
	}
	wd
}
"irregwd2"<-
function(gd, filter.number = 2, family = "DaubExPhase", bc = "periodic", 
	verbose = F)
{
	type <- "wavelet"
	if(verbose == T)
		cat("wd: Argument checking...")
	ctmp <- class(gd)
	if(is.null(ctmp))
		stop("gd has no class")
	else if(ctmp != "griddata")
		stop("gd is not of class griddata")
	data <- gd$gridy
	if(!is.atomic(data))
		stop("Data is not atomic")
	DataLength <- length(data)	#
#
# Check that we have a power of 2 data elements
#
	nlevels <- nlevels(data)	#
	if(is.na(nlevels)) stop("Data length is not power of two")	
	# Check for correct type
#
	if(type != "wavelet" && type != "station")
		stop("Unknown type of wavelet decomposition")
	if(type == "station" && bc != "periodic") stop(
			"Can only do periodic boundary conditions with station"
			)	#
# Select the appropriate filter
#
	if(verbose == T)
		cat("...done\nFilter...")
	filter <- filter.select(filter.number = filter.number, family = family)
		#
#
# Build the first/last database
#
	if(verbose == T)
		cat("...selected\nFirst/last database...")
	fl.dbase <- first.last(LengthH = length(filter$H), DataLength = 
		DataLength, type = type, bc = bc)	#
#
# Save time series attribute if there is one
#
	dtspar <- tspar(data)	#
#
# Put in the data
#
	C <- rep(0, fl.dbase$ntotal)
	C[1:DataLength] <- data	#
	if(verbose == T)
		error <- 1
	else error <- 0
	if(verbose == T) cat("built\n")	#
#
# Compute the decomposition
#
	if(verbose == T)
		cat("Decomposing...\n")
	nbc <- switch(bc,
		periodic = 1,
		symmetric = 2)
	if(is.null(nbc))
		stop("Unknown boundary condition")
	ntype <- switch(type,
		wavelet = 1,
		station = 2)
	if(is.null(filter$G)) {
		wavelet.decomposition <- .C("wavedecomp",
			C = as.double(C),
			D = as.double(rep(0, fl.dbase$ntotal.d)),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
		tmp <- .C("computec2",
			n = as.integer(length(gd$Gleft)),
			c = as.double(rep(0, fl.dbase$ntotal.d)),
			gridn = as.integer(length(gd$G)),
			G = as.double(gd$G),
			Gindex = as.integer(gd$Gindex),
			observn = as.integer(gd$observn),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nbc = as.integer(nbc))
	}
	else {
		wavelet.decomposition <- .C("comwd",
			CR = as.double(Re(C)),
			CI = as.double(Im(C)),
			LengthC = as.integer(fl.dbase$ntotal),
			DR = as.double(rep(0, fl.dbase$ntotal.d)),
			DI = as.double(rep(0, fl.dbase$ntotal.d)),
			LengthD = as.integer(fl.dbase$ntotal.d),
			HR = as.double(Re(filter$H)),
			HI = as.double( - Im(filter$H)),
			GR = as.double(Re(filter$G)),
			GI = as.double( - Im(filter$G)),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
	}
	if(verbose == T)
		cat("done\n")
	error <- wavelet.decomposition$error
	if(error != 0) {
		cat("Error ", error, " occured in wavedecomp\n")
		stop("Error")
	}
	if(is.null(filter$G)) {
		l <- list(C = wavelet.decomposition$C, D = 
			wavelet.decomposition$D, c = tmp$c * (tmp$c > 0), 
			nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	else {
		l <- list(C = complex(real = wavelet.decomposition$CR, im = 
			wavelet.decomposition$CI), D = complex(real = 
			wavelet.decomposition$DR, im = wavelet.decomposition$DI
			), nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	class(l) <- "irregwd"
	if(!is.null(dtspar))
		tspar(l) <- dtspar
	l
}
"makegrid2"<-
function(time, y, gridn = 2^(floor(log(length(time) - 1, 2)) + 1))
{
	tmp <- .C("makegrid2",
		x = as.double(time),
		y = as.double(y),
		n = length(time),
		gridt = as.double(rep(0, gridn)),
		gridy = as.double(rep(0, gridn)),
		gridn = as.integer(gridn),
		G = as.double(rep(0, gridn)),
		Gindex = as.integer(rep(0, gridn)),
		observn = integer(length(time)))
	l <- list(gridt = tmp$gridt, gridy = tmp$gridy, G = tmp$G, Gindex = tmp$
		Gindex, observn = tmp$observn)
	class(l) <- "griddata"
	l
}

"crgrid"<-
function (n) 
{
        ((1:n) - 0.5)/n
}

