postscript("balloondata.ps")
plot(balloon.x,balloon.y,xlab="Time",ylab="Radiation",pch=16,cex=0.08)
dev.off()
q()
bnl<-0.06
auswahl<-3*(1:(length(balloon.x)/3))
balloon.x<-crgrid(length(balloon.y))
postscript("balloon.ps")
par(mfrow=c(2,2))
balloon.rob<-alg61(balloon.x,balloon.y,150/4984,bnl)
balloon.grid<-makegrid(balloon.rob$t,balloon.rob$y,4096)
balloon.irregwd<-irregwd(balloon.grid,filter.number=4)
balloon.threshb<-threshold(balloon.irregwd,dev=mymadmad,noise.level=bnl)
balloon.61b<-wr(balloon.threshb)
plot(balloon.x[auswahl],balloon.y[auswahl],xlab="Time",ylab="Radiation",pch=16,cex=0.05)
lines(crgrid(4096),balloon.61b)
title("Single outlier removing (Alg. 6.1)")
balloon.rob<-alg63(balloon.x,balloon.y,200/4984, 40/4984,bnl)
balloon.grid<-makegrid(balloon.rob$t,balloon.rob$y,4096)
balloon.irregwd<-irregwd(balloon.grid,filter.number=4)
balloon.threshb<-threshold(balloon.irregwd,dev=mymadmad,noise.level=bnl)
balloon.63b<-wr(balloon.threshb)
plot(balloon.x[auswahl],balloon.y[auswahl],xlab="Time",ylab="Radiation",pch=16,cex=0.05)
lines(crgrid(4096),balloon.63b)
title("Multiple outlier removing (Alg. 6.3)")
balloon.rob<-alg63s(balloon.x,balloon.y,200/4984, 40/4984,bnl)
balloon.grid<-makegrid(balloon.rob$t,balloon.rob$y,4096)
balloon.irregwd<-irregwd(balloon.grid,filter.number=4,bc="symmetric")
balloon.threshb<-threshold(balloon.irregwd,dev=mymadmad,noise.level=bnl)
balloon.63sb<-wr(balloon.threshb)
plot(balloon.x[auswahl],balloon.y[auswahl],xlab="Time",ylab="Radiation",pch=16,cex=0.05)
lines(crgrid(4096),balloon.63sb)
title("Simplified multiple outlier removing (Alg. 6.3, simpl.)")
balloon2.65<-alg65(balloon.x[auswahl],balloon.y[auswahl],151/4984,4096,0.2,covtable=covtable.normal,filter.number=4)
plot(balloon.x,balloon.y,xlab="Time",ylab="Radiation",pch=16,cex=0.05)
lines(crgrid(4096),balloon2.65)
title("Median Filter + Thresholding (Alg. 6.4)")
dev.off()
