sinexmpl.y<-sin(crgrid(2048)*2*pi)
sinexmpl.noisy<-rcauchy(2048,0,0.1)
sinexmpl.wd<-wd(sinexmpl.y+sinexmpl.noisy,filter.number=8)
sinexmpl.thresh<-threshold(sinexmpl.wd,dev=mymadmad,policy="universal",type="soft")
sinexmpl.wr<-wr(sinexmpl.thresh)
sinexmpl.thresh2<-sinexmpl.thresh
sinexmpl.thresh2$D[1:(1024+512+256+128)]<-0
sinexmpl.wr2<-wr(sinexmpl.thresh2)
postscript("sincauchy.ps")
par(mfrow=c(2,2))
plot(sinexmpl.y,type="l",xlab="x",ylab="y")
title("A sine curve")
plot(sinexmpl.y+sinexmpl.noisy,type="l",xlab="x",ylab="y")
title("The same curve disturbed with Cauchy noise")
plot(sinexmpl.wr,type="l",xlab="x",ylab="y")
title("A reconstruction with VisuShrink")
plot(sinexmpl.wr2,type="l",xlab="x",ylab="y")
title("The four finest levels also set to zero")
dev.off()
lambda<-1
sincauchy.min<-0
sincauchy.int<-2*pi
sincauchy.y<-sinexmpl.y+sinexmpl.noisy
sincauchy.x<-crgrid(2048)
sincauchy.nl<-mad(sincauchy.y[2*(1:1024)]-sincauchy.y[2*(1:1024)-1])/sqrt(2)
sin.y<-lambda*sin(sincauchy.x*sincauchy.int)
postscript("sincauchyrob.ps")
par(mfrow=c(2,2))
sincauchy.rob<-alg61(sincauchy.x,sincauchy.y,15/1024,sincauchy.nl)
sincauchy.grid<-makegrid(sincauchy.rob$t,sincauchy.rob$y,2048)
sincauchy.irregwd<-irregwd(sincauchy.grid,filter.number=4)
sincauchy.threshb<-threshold(sincauchy.irregwd,dev=mymadmad,noise.level=sincauchy.nl)
sincauchy.61b<-wr(sincauchy.threshb)
plot(sincauchy.x*sincauchy.int+sincauchy.min,sin.y,xlab="x",ylab="y",ylim=c(-lambda-0.5,lambda+0.5),type="l",lty=2)
lines(crgrid(2048)*sincauchy.int+sincauchy.min,sincauchy.61b,lty=1)
title("Single outlier removing (Alg. 6.1)")
sincauchy.rob<-alg63(sincauchy.x,sincauchy.y,15/1024,3/1024,sincauchy.nl)
sincauchy.grid<-makegrid(sincauchy.rob$t,sincauchy.rob$y,2048)
sincauchy.irregwd<-irregwd(sincauchy.grid,filter.number=4)
sincauchy.threshb<-threshold(sincauchy.irregwd,dev=mymadmad,noise.level=sincauchy.nl)
sincauchy.63b<-wr(sincauchy.threshb)
plot(sincauchy.x*sincauchy.int+sincauchy.min,sin.y,xlab="x",ylab="y",ylim=c(-lambda-0.5,lambda+0.5),type="l",lty=2)
lines(crgrid(2048)*sincauchy.int+sincauchy.min,sincauchy.63b,lty=1)
title("Multiple outlier removing (Alg. 6.3)")
sincauchy.rob<-alg63s(sincauchy.x,sincauchy.y,15/1024,3/1024,sincauchy.nl)
sincauchy.grid<-makegrid(sincauchy.rob$t,sincauchy.rob$y,2048)
sincauchy.irregwd<-irregwd(sincauchy.grid,filter.number=4)
sincauchy.threshb<-threshold(sincauchy.irregwd,dev=mymadmad,noise.level=sincauchy.nl)
sincauchy.63sb<-wr(sincauchy.threshb)
plot(sincauchy.x*sincauchy.int+sincauchy.min,sin.y,xlab="x",ylab="y",ylim=c(-lambda-0.5,lambda+0.5),type="l",lty=2)
lines(crgrid(2048)*sincauchy.int+sincauchy.min,sincauchy.63sb,lty=1)
title("Simplified multiple outlier removing (Alg. 6.3, simpl.)")
sincauchy.65<-alg65(sincauchy.x,sincauchy.y,3.2/2048,2048,sincauchy.nl,covtable=covtable.cauchy,filter.number=4,rdist=rcauchy)
plot(sincauchy.x*sincauchy.int+sincauchy.min,sin.y,xlab="x",ylab="y",ylim=c(-lambda-0.5,lambda+0.5),type="l",lty=2)
lines(crgrid(2048)*sincauchy.int+sincauchy.min,sincauchy.65)
title("Median Filter + Thresholding (Alg. 6.4)")
dev.off()
