"alg61"<-
function(t, y, gamma, noise.level)
{
	tmp <- .C("alg61",
		t = as.double(t),
		y = as.double(y),
		as.integer(length(t)),
		as.double(gamma),
		as.double(noise.level),
		isoutl = logical(length(t)))
	list(t = t[!tmp$isoutl], y = y[!tmp$isoutl])
}
"alg63"<-
function(t, y, kappa, mu, noise.level)
{
	tmp <- .C("alg63",
		t = as.double(t),
		y = as.double(y),
		as.integer(length(t)),
		as.double(kappa),
		as.double(mu),
		as.double(noise.level),
		isoutl = logical(length(t)))
	list(t = t[!tmp$isoutl], y = y[!tmp$isoutl])
}
"alg63s"<-
function(t, y, kappa, mu, noise.level)
{
	tmp <- .C("alg63s",
		t = as.double(t),
		y = as.double(y),
		as.integer(length(t)),
		as.double(kappa),
		as.double(mu),
		as.double(noise.level),
		isoutl = logical(length(t)))
	list(t = t[!tmp$isoutl], y = y[!tmp$isoutl])
}
"alg65"<-
function(aaa.t, aaa.y, width, gridn = 2048, noise.level, covtable = 
	covtable.normal, filter.number = 5, rdist = rnorm, ...)
{
	aaa.med <- medfilter(t = aaa.t, y = aaa.y, width = width, gridn = gridn
		)
	aaa.medfiltwd <- medfiltwd(aaa.med, covtable = covtable, filter.number
		 = filter.number)
	thresh <- simulmax(aaa.t, filter.number = filter.number, width = width, 
		covtable = covtable, rdist = rdist, gridn = gridn)
	aaa.thresh <- threshold(aaa.medfiltwd, policy = "manual", value = 
		thresh, noise.level = noise.level, ...)
	wr(aaa.thresh)
}
"medfilter"<-
function(t = crgrid(length(y)), y, gridn, width)
{
	ind <- order(t)
	t <- t[ind]
	y <- y[ind]
	tmp <- .C("medfilter",
		as.double(t),
		as.double(y),
		as.integer(length(y)),
		as.integer(gridn),
		as.double(width),
		outy = double(gridn),
		widthes = integer(gridn),
		leftbdr = integer(gridn),
		rightbdr = integer(gridn),
		outt = double(gridn))
	l <- list(gridt = tmp$outt, gridy = tmp$outy, widthes = tmp$widthes, 
		leftbdr = tmp$leftbdr, rightbdr = tmp$rightbdr)
	class(l) <- "medfiltdata"
	l
}
"medfiltwd"<-
function(gd, filter.number = 2, family = "DaubExPhase", covtable = 
	covtable.normal, bc = "periodic", verbose = F)
{
	type <- "wavelet"
	if(verbose == T)
		cat("wd: Argument checking...")
	ctmp <- class(gd)
	if(is.null(ctmp))
		stop("gd has no class")
	else if(ctmp != "medfiltdata")
		stop("gd is not of class medfiltdata")
	data <- gd$gridy
	if(!is.atomic(data))
		stop("Data is not atomic")
	DataLength <- length(data)	#
#
# Check that we have a power of 2 data elements
#
	nlevels <- nlevels(data)	#
	if(is.na(nlevels)) stop("Data length is not power of two")	
	# Check for correct type
#
	if(type != "wavelet" && type != "station")
		stop("Unknown type of wavelet decomposition")
	if(type == "station" && bc != "periodic") stop(
			"Can only do periodic boundary conditions with station"
			)	#
# Select the appropriate filter
#
	if(verbose == T)
		cat("...done\nFilter...")
	filter <- filter.select(filter.number = filter.number, family = family)
		#
#
# Build the first/last database
#
	if(verbose == T)
		cat("...selected\nFirst/last database...")
	fl.dbase <- first.last(LengthH = length(filter$H), DataLength = 
		DataLength, type = type, bc = bc)	#
#
# Save time series attribute if there is one
#
	dtspar <- tspar(data)	#
#
# Put in the data
#
	C <- rep(0, fl.dbase$ntotal)
	C[1:DataLength] <- data	#
	if(verbose == T)
		error <- 1
	else error <- 0
	if(verbose == T) cat("built\n")	#
#
# Compute the decomposition
#
	if(verbose == T)
		cat("Decomposing...\n")
	nbc <- switch(bc,
		periodic = 1,
		symmetric = 2)
	if(is.null(nbc))
		stop("Unknown boundary condition")
	ntype <- switch(type,
		wavelet = 1,
		station = 2)
	if(is.null(filter$G)) {
		wavelet.decomposition <- .C("wavedecomp",
			C = as.double(C),
			D = as.double(rep(0, fl.dbase$ntotal.d)),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
		tmp <- .C("computecalg65",
			c = as.double(rep(0, fl.dbase$ntotal.d)),
			gridn = as.integer(length(gd$gridt)),
			leftbdr = as.integer(gd$leftbdr),
			rightbdr = as.integer(gd$rightbdr),
			widthes = as.integer(gd$widthes),
			covs = as.double(covtable),
			H = as.double(filter$H),
			LengthH = as.integer(length(filter$H)),
			nbc = as.integer(nbc))
	}
	else {
		wavelet.decomposition <- .C("comwd",
			CR = as.double(Re(C)),
			CI = as.double(Im(C)),
			LengthC = as.integer(fl.dbase$ntotal),
			DR = as.double(rep(0, fl.dbase$ntotal.d)),
			DI = as.double(rep(0, fl.dbase$ntotal.d)),
			LengthD = as.integer(fl.dbase$ntotal.d),
			HR = as.double(Re(filter$H)),
			HI = as.double( - Im(filter$H)),
			GR = as.double(Re(filter$G)),
			GI = as.double( - Im(filter$G)),
			LengthH = as.integer(length(filter$H)),
			nlevels = as.integer(nlevels),
			firstC = as.integer(fl.dbase$first.last.c[, 1]),
			lastC = as.integer(fl.dbase$first.last.c[, 2]),
			offsetC = as.integer(fl.dbase$first.last.c[, 3]),
			firstD = as.integer(fl.dbase$first.last.d[, 1]),
			lastD = as.integer(fl.dbase$first.last.d[, 2]),
			offsetD = as.integer(fl.dbase$first.last.d[, 3]),
			ntype = as.integer(ntype),
			nbc = as.integer(nbc),
			error = as.integer(error))
	}
	if(verbose == T)
		cat("done\n")
	error <- wavelet.decomposition$error
	if(error != 0) {
		cat("Error ", error, " occured in wavedecomp\n")
		stop("Error")
	}
	if(is.null(filter$G)) {
		l <- list(C = wavelet.decomposition$C, D = 
			wavelet.decomposition$D, c = tmp$c * (tmp$c > 0), 
			nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	else {
		l <- list(C = complex(real = wavelet.decomposition$CR, im = 
			wavelet.decomposition$CI), D = complex(real = 
			wavelet.decomposition$DR, im = wavelet.decomposition$DI
			), nlevels = wavelet.decomposition$nlevels, fl.dbase = 
			fl.dbase, filter = filter, type = type, bc = bc, date
			 = date())
	}
	class(l) <- "irregwd"
	if(!is.null(dtspar))
		tspar(l) <- dtspar
	l
}
"simulmax"<-
function(t = crgrid(gridn), nsimul = 20, filter.number = 1, gridn = 2048, 
	covtable = covtable.normal, rdist = rnorm, width = 0.0015)
{
	y.mwd <- medfiltwd(medfilter(t, double(length(t)), gridn, width), 
		covtable = covtable, filter.number = filter.number)
	res <- matrix(double(nsimul * (y.mwd$nlevels - 3)), ncol = (y.mwd$
		nlevels - 3))
	for(i in 1:nsimul) {
		print(i)
		y.wd <- wd(medfilter(t, rdist(length(t)), gridn, width)$gridy, 
			filter.number = filter.number)
		for(j in (3:(y.wd$nlevels - 1))) {
			ind <- (accessc(y.mwd, j) > 0.0001)
			if(length(ind) > 0)
				res[i, j - 2] <- max(abs(accessD(y.wd, j)[ind]/
				  sqrt(accessc(y.mwd, j)[ind])))
			else res[i, j - 2] <- 0
		}
	}
	apply(res, 2, quantile, prob = c(0.90000000000000002))
}
"covtable.normal"<-
c(1.0008330000000001, 0.33361109999999999, 0.1178208, 0.24832029999999999, 
	0.44950440000000003, 0.2001667, 0.072147520000000007, 0.1495232, 
	0.24012820000000001, 0.04459113, 0.091536660000000006, 
	0.14241429999999999, 0.20065810000000001, 0.28766700000000001, 
	0.1429762, 0.052072060000000003, 0.10698829999999999, 
	0.16736519999999999, 0.032355780000000001, 0.066056699999999996, 
	0.10171139999999999, 0.14041429999999999, 0.18515470000000001, 
	0.023555510000000002, 0.04790353, 0.073301290000000005, 0.1001585, 
	0.1292537, 0.1625006, 0.2112802, 0.1112037, 0.040756269999999997, 
	0.083298720000000007, 0.12880240000000001, 0.025412850000000001, 
	0.051697310000000003, 0.0791544, 0.10826710000000001, 
	0.14001749999999999, 0.018542869999999999, 0.037610230000000001, 
	0.057337079999999999, 0.077922240000000004, 0.099691890000000005, 
	0.12326910000000001, 0.15030019999999999, 0.014620330000000001, 
	0.02959314, 0.044992230000000001, 0.060920229999999999, 
	0.077530199999999994, 0.095073370000000004, 0.1140306, 0.1356116, 
	0.16693459999999999, 0.090984860000000001, 0.03348715, 0.06819973, 
	0.1047652, 0.02093155, 0.042474199999999997, 0.064799259999999997, 
	0.088161429999999999, 0.11300250000000001, 0.015298229999999999, 
	0.030969920000000001, 0.047095159999999997, 0.063785599999999998, 
	0.081208840000000004, 0.099643229999999999, 0.1196406, 0.01207652, 
	0.024406959999999998, 0.037036449999999999, 0.050025170000000001, 
	0.063457520000000003, 0.077460029999999999, 0.092241740000000003, 
	0.1082053, 0.1264055, 0.0099844500000000006, 0.020153480000000001, 
	0.030535340000000001, 0.041166479999999998, 0.05209569, 0.06339156, 
	0.075157119999999994, 0.087562570000000006, 0.1009356, 0.1161103, 
	0.1379958, 0.076987189999999997, 0.02842124, 0.0577352, 
	0.088316119999999998, 0.01779739, 0.036047129999999997, 0.05485611, 
	0.074374759999999998, 0.094839199999999999, 0.01302392, 
	0.026327570000000002, 0.039962499999999998, 0.053997650000000001, 
	0.068530460000000001, 0.083708850000000001, 0.09978426, 
	0.010290759999999999, 0.020773449999999999, 0.0314778, 
	0.042442220000000003, 0.053718200000000001, 0.065378350000000002, 
	0.077532229999999994, 0.090362339999999999, 0.1042278, 
	0.0085141969999999994, 0.017168929999999999, 0.025983180000000002, 
	0.034980749999999998, 0.044192479999999999, 0.053659779999999997, 
	0.063441010000000006, 0.073624090000000003, 0.084354890000000002, 
	0.095915780000000006, 0.1090455, 0.0072646530000000003, 
	0.014636959999999999, 0.02212983, 0.02975916, 0.037544950000000001, 
	0.045513100000000001, 0.05369848, 0.062150270000000001, 
	0.070942649999999996, 0.080198729999999996, 0.090156730000000004, 
	0.1014289, 0.1176323, 0.066722229999999993, 0.02468793, 
	0.050055099999999998, 0.076342549999999995, 0.01548132, 0.03131105, 
	0.047560409999999997, 0.064325549999999995, 0.081747330000000007, 
	0.01134027, 0.02289801, 0.034708389999999999, 0.046816999999999998, 
	0.059285409999999997, 0.072201479999999998, 0.085700750000000006, 
	0.0089671239999999999, 0.01808456, 0.02737299, 0.036858420000000003, 
	0.046574619999999997, 0.056567050000000001, 0.066900180000000004, 
	0.077671989999999996, 0.089047870000000001, 0.0074234260000000003, 
	0.01495758, 0.02261585, 0.030414699999999999, 0.03837488, 
	0.046523290000000002, 0.054896170000000001, 0.063544799999999999, 
	0.072546719999999995, 0.082031419999999994, 0.092253230000000006, 
	0.0063369760000000002, 0.01275919, 0.019275879999999999, 0.0258982, 
	0.032639880000000003, 0.039518230000000001, 0.04655575, 
	0.053782730000000001, 0.061241990000000003, 0.068998290000000004, 
	0.077159450000000004, 0.085935159999999997, 0.09587524, 
	0.0055299390000000002, 0.011127659999999999, 0.01679982, 
	0.022554370000000001, 0.0284009, 0.034351220000000002, 
	0.040420270000000001, 0.046627439999999999, 0.052998900000000002, 
	0.05957167, 0.066401779999999994, 0.073582620000000001, 
	0.081295839999999994, 0.090011999999999995, 0.10252799999999999, 
	0.058872559999999997, 0.0218222, 0.044178509999999997, 
	0.067233269999999998, 0.013699569999999999, 0.027675769999999999, 
	0.041978460000000002, 0.056672779999999999, 0.071849460000000004, 
	0.010043150000000001, 0.02026027, 0.030676470000000001, 0.04132342, 
	0.052242530000000002, 0.063490160000000004, 0.075147660000000005, 
	0.0079463069999999997, 0.016013599999999999, 0.02421684, 
	0.032574510000000001, 0.041109899999999998, 0.049853370000000001, 
	0.058846019999999999, 0.068146449999999997, 0.077844540000000004, 
	0.0065815429999999996, 0.013252659999999999, 0.020023160000000002, 
	0.026904919999999999, 0.033912560000000001, 0.041064570000000002, 
	0.048384980000000001, 0.055906240000000003, 0.063674449999999994, 
	0.071759699999999996, 0.080280149999999995, 0.0056205420000000001, 
	0.01131033, 0.0170762, 0.022926309999999998, 0.0288705, 
	0.034920920000000001, 0.04109293, 0.047406469999999999, 
	0.053888510000000001, 0.060577239999999997, 0.06753062, 
	0.074845659999999994, 0.082713140000000004, 0.0049063750000000001, 
	0.00986801, 0.014889889999999999, 0.01997788, 0.025138939999999999, 
	0.03038153, 0.035716060000000001, 0.041155700000000003, 
	0.046717590000000003, 0.052424859999999997, 0.05831033, 0.06442378, 
	0.070848369999999994, 0.07774665, 0.085546349999999993, 
	0.0043543540000000004, 0.0087539019999999992, 0.0132024, 0.01770422, 
	0.02226448, 0.02688931, 0.031586110000000001, 0.036364019999999997, 
	0.04123462, 0.046212980000000001, 0.051319469999999999, 
	0.056583019999999998, 0.062047520000000002, 0.067786449999999998, 
	0.073943449999999994, 0.080893430000000002, 0.090879909999999994, 
	0.052675439999999997, 0.019552940000000001, 0.039536880000000003, 
	0.06006885, 0.012286139999999999, 0.02479727, 0.037569650000000003, 
	0.050649430000000002, 0.064098450000000001, 0.0090129219999999996, 
	0.018168219999999999, 0.027484430000000001, 0.03698448, 
	0.046697519999999999, 0.056661839999999998, 0.066930100000000006, 
	0.0071348150000000001, 0.014369140000000001, 0.021714190000000001, 
	0.029183520000000001, 0.036793920000000001, 0.044566639999999998, 
	0.05252946, 0.060720209999999997, 0.06919314, 0.0059118460000000001, 
	0.011897680000000001, 0.01796493, 0.024122439999999998, 
	0.030380910000000001, 0.036753569999999999, 0.043257169999999998, 
	0.049913550000000001, 0.056752299999999999, 0.063815629999999998, 
	0.071168140000000005, 0.0050503359999999999, 0.01015808, 0.01532845, 
	0.02056759, 0.025882800000000001, 0.031282940000000002, 
	0.036778949999999998, 0.042384669999999999, 0.048118130000000002, 
	0.054003750000000003, 0.060076240000000003, 0.066388470000000005, 
	0.073029629999999998, 0.0044098760000000001, 0.0088657079999999999, 
	0.013371330000000001, 0.017931200000000001, 0.022550560000000001, 
	0.02723563, 0.03199399, 0.036834989999999998, 0.041770439999999999, 
	0.04681577, 0.051991820000000001, 0.057328230000000001, 
	0.062870079999999995, 0.06869306, 0.074946399999999996, 
	0.0039146670000000001, 0.0078670230000000008, 0.011859979999999999, 
	0.01589687, 0.01998161, 0.02411874, 0.028313749999999999, 
	0.032573230000000002, 0.03690537, 0.041320519999999999, 
	0.045832190000000002, 0.050458650000000001, 0.055225900000000001, 
	0.060173459999999998, 0.065367670000000003, 0.070938780000000007, 
	0.077231099999999997, 0.0035201189999999999, 0.0070717430000000001, 
	0.010657140000000001, 0.014278890000000001, 0.017939960000000001, 
	0.021643829999999999, 0.02539454, 0.029196969999999999, 
	0.033057000000000003, 0.036981920000000001, 0.04098098, 
	0.045066210000000002, 0.049253970000000001, 0.053567509999999999, 
	0.05804223, 0.062737660000000001, 0.067770709999999998, 
	0.073448739999999998, 0.081624310000000005, 0.047658739999999998, 
	0.017711399999999999, 0.035777910000000003, 0.054285809999999997, 
	0.01113742, 0.022461410000000001, 0.033999179999999997, 
	0.045784619999999998, 0.057861750000000003, 0.0081747699999999996, 
	0.016468219999999999, 0.024894449999999999, 0.03347058, 
	0.042217890000000001, 0.051163590000000002, 0.060343689999999998, 
	0.0064741169999999997, 0.013031549999999999, 0.019680900000000001, 
	0.02643245, 0.033298660000000001, 0.040294999999999997, 
	0.047441120000000003, 0.054762829999999998, 0.062295400000000001, 
	0.0053662759999999997, 0.010794720000000001, 0.016291099999999999, 
	0.021862179999999998, 0.027516019999999999, 0.033262430000000003, 
	0.039113540000000002, 0.045084730000000003, 0.051196119999999998, 
	0.057475070000000003, 0.063960810000000007, 0.0045856029999999997, 
	0.0092195980000000007, 0.01390606, 0.018649740000000001, 0.0234562, 
	0.028332110000000001, 0.033285530000000001, 0.038326440000000003, 
	0.043467510000000001, 0.048725259999999999, 0.054122110000000001, 
	0.059690069999999998, 0.065478159999999994, 0.004005064, 
	0.0080489740000000004, 0.01213475, 0.016265849999999998, 0.02044632, 
	0.024680899999999999, 0.028975250000000001, 0.033336249999999998, 
	0.037772399999999998, 0.042294470000000001, 0.046916510000000002, 
	0.05165761, 0.056544909999999997, 0.061619920000000002, 
	0.066952680000000001, 0.0035560660000000001, 0.0071440660000000001, 
	0.010766299999999999, 0.0144254, 0.018124379999999999, 
	0.021866750000000001, 0.025656660000000001, 0.029499040000000001, 
	0.03339988, 0.0373666, 0.041408599999999997, 0.045538160000000001, 
	0.049771919999999997, 0.054133590000000002, 0.058659349999999999, 
	0.063410149999999998, 0.068506510000000007, 0.0031982489999999998, 
	0.0064232500000000001, 0.0096768040000000007, 0.012960950000000001, 
	0.016278020000000001, 0.019630689999999999, 0.023022069999999999, 
	0.026455840000000001, 0.029936379999999999, 0.033469020000000002, 
	0.037060360000000001, 0.040718740000000003, 0.044455109999999999, 
	0.048284269999999997, 0.052227379999999997, 0.056316680000000001, 
	0.060606510000000002, 0.065204040000000005, 0.070394059999999994, 
	0.0029062799999999998, 0.0058353190000000003, 0.0087885570000000007, 
	0.01176761, 0.014774320000000001, 0.01781077, 0.02087936, 
	0.023982920000000001, 0.027124740000000001, 0.03030878, 0.03353983, 
	0.036823839999999997, 0.040168370000000002, 0.043583289999999997, 
	0.047082010000000001, 0.050683680000000002, 0.054417559999999997, 
	0.05833298, 0.06252742, 0.067258799999999994, 0.07409309, 
	0.043514499999999998, 0.01618702, 0.032671680000000002, 0.04951941, 
	0.010185339999999999, 0.02052791, 0.031048639999999999, 0.04177314, 
	0.052733879999999997, 0.0074794830000000003, 0.01505943, 
	0.022750800000000002, 0.03056673, 0.038523219999999997, 
	0.046640290000000001, 0.054943659999999998, 0.0059256760000000004, 
	0.011922139999999999, 0.017996149999999999, 0.024155670000000001, 
	0.030410220000000002, 0.036771390000000001, 0.043253609999999998, 
	0.049875240000000001, 0.056660519999999999, 0.004913171, 
	0.0098793360000000007, 0.014903049999999999, 0.0199896, 
	0.025145250000000001, 0.03037743, 0.035695209999999998, 
	0.041109840000000002, 0.046635610000000001, 0.052291259999999999, 
	0.05810241, 0.0041994770000000001, 0.0084403150000000003, 
	0.012725759999999999, 0.017059560000000001, 0.021446070000000001, 
	0.025890400000000001, 0.030398680000000001, 0.03497836, 
	0.039638640000000003, 0.044391229999999997, 0.049251450000000002, 
	0.054240139999999999, 0.059387179999999998, 0.003668611, 
	0.0073705059999999998, 0.011108099999999999, 0.014884150000000001, 
	0.018701829999999999, 0.022564839999999999, 0.026477529999999999, 
	0.030445090000000001, 0.034473829999999997, 0.038571590000000003, 
	0.042748269999999998, 0.047016870000000002, 0.051395009999999998, 
	0.05590792, 0.060594250000000002, 0.0032579390000000001, 0.006543297, 
	0.0098579280000000002, 0.013203929999999999, 0.016583710000000002, 0.02,
	0.023456040000000001, 0.0269556, 0.030503209999999999, 
	0.034104339999999997, 0.037765819999999999, 0.04149626, 
	0.045306970000000002, 0.04921329, 0.053237119999999999, 
	0.057411990000000003, 0.061794689999999999, 0.0029305949999999998, 
	0.005884205, 0.0088622869999999999, 0.01186648, 0.014898639999999999, 
	0.01796089, 0.02105568, 0.024185829999999998, 0.027354710000000001, 
	0.030566320000000001, 0.033825529999999999, 0.037138369999999997, 
	0.0405125, 0.043957950000000003, 0.047488330000000002, 
	0.051123109999999999, 0.054892040000000003, 0.058845450000000001, 
	0.063083249999999993, 0.0026634419999999998, 0.0053464979999999999, 
	0.008050336, 0.010776269999999999, 0.01352576, 0.016300470000000001, 
	0.019102319999999999, 0.02193349, 0.024796539999999999, 0.02769448, 
	0.030630910000000001, 0.033610210000000001, 0.03663781, 0.03972063, 
	0.042867679999999998, 0.046091269999999997, 0.04940895, 0.05284763, 
	0.056452790000000003, 0.06031458, 0.064673820000000007, 
	0.0024412069999999999, 0.0048993420000000001, 0.0073753600000000001, 
	0.0098703200000000001, 0.012385409999999999, 0.01492197, 
	0.017481500000000001, 0.02006573, 0.022676669999999999, 
	0.025316620000000001, 0.027988329999999999, 0.03069508, 
	0.033440860000000003, 0.036230610000000003, 0.039070639999999997, 
	0.041969190000000003, 0.044937499999999998, 0.047991640000000002, 
	0.05115625, 0.054473100000000003, 0.058025010000000002, 0.06203268, 
	0.067845630000000004, 0.040033340000000001, 0.01490434, 0.03006174, 
	0.045523019999999997, 0.0093833479999999997, 0.018901009999999999, 
	0.02856943, 0.03840843, 0.04844263, 0.0068933579999999996, 
	0.013872860000000001, 0.020947219999999999, 0.028126689999999999, 
	0.035423650000000001, 0.042853219999999997, 0.050434430000000002, 
	0.0054630759999999999, 0.01098705, 0.01657732, 0.022240200000000002, 
	0.027983109999999999, 0.03381497, 0.039746660000000003, 
	0.045791739999999997, 0.051967560000000003, 0.0045308120000000004, 
	0.0091073409999999997, 0.013733250000000001, 0.01841278, 
	0.023150830000000001, 0.027953209999999999, 0.032826880000000003, 
	0.037780300000000003, 0.042823970000000003, 0.047971310000000003, 
	0.053239960000000003, 0.003873521, 0.0077828100000000002, 0.0117305, 
	0.0157196, 0.01975356, 0.023836429999999999, 0.02797295, 
	0.032168809999999999, 0.036430940000000002, 0.040767909999999997, 
	0.045190649999999999, 0.049713489999999999, 0.054356010000000003, 
	0.0033845030000000001, 0.0067978520000000001, 0.010242009999999999, 
	0.013719220000000001, 0.017232009999999999, 0.020783309999999999, 
	0.02437655, 0.028015749999999999, 0.03170572, 0.035452320000000002, 
	0.039262810000000002, 0.043146410000000003, 0.047115230000000001, 
	0.051185750000000002, 0.055381600000000003, 0.0030061300000000001, 
	0.0060360680000000003, 0.0090913330000000001, 0.01217363, 
	0.015284890000000001, 0.018427320000000001, 0.02160347, 
	0.024816290000000001, 0.028069279999999999, 0.031366619999999998, 
	0.034713389999999997, 0.038115879999999998, 0.041582109999999999, 
	0.045122570000000001, 0.048751530000000001, 0.05248945, 0.05636774, 
	0.0027044780000000002, 0.0054289749999999999, 0.0081746879999999994, 
	0.01094296, 0.013735290000000001, 0.016553379999999999, 
	0.019399199999999998, 0.02227498, 0.025183339999999999, 
	0.028127369999999999, 0.031110769999999999, 0.03413803, 0.03721472, 
	0.040347929999999997, 0.043546950000000001, 0.046824419999999999, 
	0.050198430000000002, 0.053696760000000003, 0.057366559999999997, 
	0.0024582530000000001, 0.0049335919999999997, 0.0074269829999999998, 
	0.0099394979999999997, 0.01247234, 0.01502685, 0.017604559999999998, 
	0.020207220000000001, 0.022836840000000001, 0.025495770000000001, 
	0.02818679, 0.030913199999999998, 0.033679050000000002, 
	0.036489349999999997, 0.039350459999999997, 0.042270740000000001, 
	0.045261570000000001, 0.048339239999999999, 0.051528749999999998, 
	0.054872530000000003, 0.058455149999999997, 0.002253396, 0.00452156, 
	0.0068052820000000002, 0.0091054359999999997, 0.011422989999999999, 
	0.01375904, 0.016114799999999999, 0.01849166, 0.020891199999999999, 
	0.023315249999999999, 0.025765940000000001, 0.028245800000000001, 
	0.03075783, 0.033305700000000001, 0.035893969999999997, 
	0.038528449999999999, 0.041216740000000002, 0.043969220000000003, 
	0.046800750000000002, 0.049734199999999999, 0.052808330000000001, 
	0.056100369999999997, 0.059817750000000003, 0.0020802469999999999, 
	0.0041733949999999999, 0.0062800989999999999, 0.0084010820000000007, 
	0.01053714, 0.01268917, 0.014858150000000001, 0.017045210000000002, 
	0.019251620000000001, 0.021478830000000001, 0.023728519999999999, 
	0.026002629999999999, 0.028303479999999999, 0.030633830000000001, 
	0.032997060000000002, 0.035397350000000001, 0.037840039999999998, 
	0.040332140000000002, 0.042883209999999998, 0.045506989999999997, 
	0.048224580000000003, 0.051071890000000002, 0.054120540000000002, 
	0.057562450000000001, 0.062579590000000004, 0.037067910000000003, 
	0.013810080000000001, 0.027837959999999998, 0.042123880000000002, 
	0.008698529, 0.01751312, 0.026456940000000002, 0.035545640000000003, 
	0.044798329999999997, 0.0063925309999999999, 0.01285975, 
	0.019408689999999999, 0.026047529999999999, 0.032786009999999997, 
	0.039635869999999997, 0.04661154, 0.0050675950000000003, 0.01018814, 
	0.015366029999999999, 0.020606320000000001, 0.025914940000000001, 
	0.031298890000000003, 0.036766569999999998, 0.042328280000000003, 
	0.047996860000000002, 0.0042037990000000003, 0.0084474470000000003, 
	0.012733939999999999, 0.017066709999999999, 0.02144969, 
	0.025887509999999999, 0.030385590000000001, 0.034950479999999999, 
	0.039590119999999999, 0.044314430000000002, 0.049136079999999999, 
	0.003594655, 0.0072205560000000004, 0.01087987, 0.014575029999999999, 
	0.01830886, 0.022084579999999999, 0.025905950000000001, 
	0.029777419999999999, 0.033704310000000001, 0.037693110000000002, 
	0.041751879999999998, 0.045890889999999997, 0.05012366, 
	0.0031413740000000002, 0.0063079950000000003, 0.0095014869999999994, 
	0.012723679999999999, 0.01597664, 0.019262729999999999, 
	0.022584690000000001, 0.025945699999999999, 0.029349509999999999, 
	0.032800610000000001, 0.036304469999999998, 0.039867899999999998, 
	0.043499549999999998, 0.047210769999999999, 0.051017109999999997, 
	0.0027905920000000002, 0.0056020590000000004, 0.0084356580000000004, 
	0.0112928, 0.01417505, 0.017084220000000001, 0.020022350000000001, 
	0.022991810000000001, 0.025995339999999999, 0.02903621, 
	0.032118290000000001, 0.035246329999999999, 0.038426210000000002, 
	0.04166541, 0.044973770000000003, 0.048364690000000002, 
	0.051857420000000001, 0.0025108940000000001, 0.0050393670000000003, 
	0.0075864160000000003, 0.01015315, 0.0127408, 0.01535078, 
	0.017984650000000001, 0.020644220000000001, 0.023331589999999999, 
	0.02604917, 0.028799849999999998, 0.031587049999999998, 0.03441495, 
	0.037288750000000002, 0.040215069999999999, 0.043202570000000003, 
	0.04626309, 0.049413609999999997, 0.052680270000000001, 
	0.0022825559999999998, 0.0045801369999999998, 0.00689355, 
	0.0092236850000000006, 0.01157153, 0.0139382, 0.01632494, 
	0.018733159999999999, 0.021164490000000001, 0.023620780000000001, 
	0.026104209999999999, 0.028617360000000001, 0.031163300000000001, 
	0.033745780000000003, 0.036369459999999999, 0.039040279999999997, 
	0.041766020000000001, 0.044557300000000001, 0.047429369999999998, 
	0.050405690000000003, 0.053526230000000001, 0.0020925560000000002, 
	0.004198116, 0.0063173409999999998, 0.0084509600000000004, 0.01059978, 
	0.01276469, 0.01494671, 0.017146950000000001, 0.019366700000000001, 
	0.02160743, 0.023870820000000001, 0.026158850000000001, 
	0.028473849999999998, 0.030818620000000001, 0.033196549999999998, 
	0.03561189, 0.038070010000000001, 0.040578009999999998, 
	0.043145549999999998, 0.045786510000000002, 0.048522280000000001, 
	0.051389240000000003, 0.054460250000000002, 0.0019319459999999999, 
	0.0038752639999999998, 0.0058305060000000001, 0.007798274, 
	0.0097792360000000002, 0.011774130000000001, 0.013783760000000001, 
	0.015809070000000001, 0.01785107, 0.01991093, 0.021990010000000001, 
	0.024089849999999999, 0.026212240000000001, 0.02835934, 0.0305337, 
	0.032738440000000001, 0.03497745, 0.037255669999999998, 
	0.039579629999999998, 0.041958210000000003, 0.04440421, 
	0.046937329999999999, 0.049591169999999997, 0.052432909999999999, 
	0.055644010000000001, 0.001794368, 0.0035987720000000001, 
	0.0054136760000000001, 0.0072395869999999996, 0.0090770610000000009, 
	0.010926709999999999, 0.012789210000000001, 0.014665320000000001, 
	0.01655589, 0.018461849999999998, 0.020384309999999999, 
	0.022324480000000001, 0.024283800000000001, 0.02626394, 
	0.028266880000000001, 0.030294970000000001, 0.032351110000000002, 
	0.034438900000000001, 0.036562919999999999, 0.03872921, 
	0.040946049999999998, 0.043225310000000003, 0.045585349999999997, 
	0.048057500000000003, 0.050704539999999999, 0.053695769999999997, 
	0.058080630000000001, 0.034511500000000001, 0.01286555, 
	0.025920519999999999, 0.039197339999999997, 0.0081069339999999997, 
	0.01631517, 0.024635399999999998, 0.033080199999999997, 
	0.041664720000000002, 0.005959626, 0.01198463, 0.018080769999999999, 
	0.024254680000000001, 0.030514159999999999, 0.036868489999999997, 
	0.043328890000000002, 0.004725595, 0.0094976569999999996, 
	0.014319800000000001, 0.019196169999999999, 0.02413154, 
	0.029131520000000001, 0.034202740000000002, 0.039353180000000001, 
	0.044592640000000003, 0.0039209049999999997, 0.0078768589999999999, 
	0.01187034, 0.015904169999999999, 0.019981550000000001, 
	0.024106220000000001, 0.02828251, 0.032515559999999999, 
	0.036811539999999997, 0.041177989999999998, 0.045624320000000003, 
	0.003353342, 0.0067342189999999996, 0.010144429999999999, 
	0.013586000000000001, 0.017061219999999998, 0.020572730000000001, 
	0.024123550000000001, 0.027717220000000001, 0.031357929999999999, 
	0.035050690000000002, 0.038801620000000002, 0.042618339999999998, 
	0.046510589999999997, 0.0029309340000000001, 0.0058841539999999999, 
	0.0088610189999999995, 0.01186304, 0.014891939999999999, 
	0.017949639999999999, 0.021038370000000001, 0.024160669999999999, 
	0.02731954, 0.030518489999999999, 0.033761760000000002, 
	0.037054480000000001, 0.040403069999999999, 0.043815680000000003, 
	0.047303089999999999, 0.002603995, 0.005226446, 0.0078684080000000003, 
	0.01053105, 0.01321569, 0.01592381, 0.01865706, 0.02141738, 
	0.024206970000000001, 0.027028409999999999, 0.02988474, 
	0.032779620000000002, 0.035717480000000003, 0.038703870000000001, 
	0.041745820000000003, 0.044852620000000003, 0.048036919999999997, 
	0.0023432729999999999, 0.0047021110000000001, 0.0070773499999999996, 
	0.0094699220000000004, 0.01188086, 0.014311310000000001, 
	0.016762579999999999, 0.019236139999999999, 0.021733679999999998, 
	0.02425714, 0.026808809999999999, 0.02939135, 0.032007979999999998, 
	0.03466263, 0.037360169999999998, 0.040106799999999998, 
	0.042910690000000001, 0.045783009999999999, 0.048739789999999998, 
	0.0021304000000000002, 0.0042741209999999996, 0.0064318420000000001, 
	0.0086043130000000006, 0.010792360000000001, 0.01299691, 0.01521899, 
	0.017459769999999999, 0.01972055, 0.022002859999999999, 
	0.024308420000000001, 0.02663927, 0.028997820000000001, 0.03138693, 
	0.033810119999999999, 0.036271739999999997, 0.038777369999999999, 
	0.041334320000000001, 0.043952570000000003, 0.0466465, 
	0.049438299999999998, 0.0019532479999999999, 0.0039180380000000004, 
	0.0058949299999999996, 0.0078845370000000005, 0.0098875379999999995, 
	0.011904680000000001, 0.013936799999999999, 0.01598482, 
	0.018049800000000001, 0.02013293, 0.022235580000000001, 
	0.024359309999999999, 0.02650597, 0.02867774, 0.030877209999999999, 
	0.033107579999999998, 0.035372790000000001, 0.037677889999999999, 
	0.040029540000000002, 0.042436790000000002, 0.044912710000000002, 
	0.047477470000000001, 0.050165510000000003, 0.001803483, 0.00361707, 
	0.00544123, 0.007276472, 0.0091233589999999993, 0.010982509999999999, 
	0.012854600000000001, 0.014740390000000001, 0.016640749999999999, 
	0.018556610000000001, 0.020489090000000001, 0.02243941, 0.02440902, 
	0.02639961, 0.028413170000000001, 0.030452070000000001, 
	0.032519239999999998, 0.034618299999999998, 0.036753880000000003, 
	0.038932080000000001, 0.04116123, 0.043453350000000002, 
	0.045826970000000002, 0.048313790000000002, 0.050977509999999997, 
	0.0016751820000000001, 0.0033592890000000001, 0.0050527180000000003, 
	0.0067558970000000003, 0.0084692980000000001, 0.01019343, 
	0.011928869999999999, 0.013676249999999999, 0.01543625, 0.01720967, 
	0.018997400000000001, 0.02080042, 0.022619899999999998, 0.02445715, 
	0.026313739999999999, 0.028191500000000001, 0.03009264, 
	0.032019829999999999, 0.03397646, 0.035966779999999997, 
	0.037996460000000003, 0.040073230000000001, 0.042208219999999998, 
	0.044418680000000002, 0.046734089999999999, 0.049213699999999999, 
	0.052018380000000003, 0.0015640210000000001, 0.0031359880000000001, 
	0.0047162389999999997, 0.0063051380000000001, 0.0079030839999999995, 
	0.0095105120000000005, 0.0111279, 0.01275577, 0.01439471, 0.01604537, 
	0.017708459999999999, 0.019384820000000001, 0.021075380000000001, 
	0.02278119, 0.024503500000000001, 0.02624375, 0.02800364, 
	0.029785220000000001, 0.031591010000000003, 0.033424130000000003, 
	0.035288569999999998, 0.037189609999999998, 0.039134469999999998, 
	0.041133589999999998, 0.043203100000000001, 0.045370710000000002, 
	0.047692119999999998, 0.05031849, 0.054192560000000001, 0.03228495, 
	0.012041970000000001, 0.024250210000000001, 0.036651209999999997, 
	0.0075907309999999999, 0.01527065, 0.023048559999999999, 
	0.030934730000000001, 0.038941330000000003, 0.0055816909999999997, 
	0.011221099999999999, 0.016922969999999999, 0.022692790000000001, 
	0.028536889999999999, 0.034462729999999997, 0.040479220000000003, 
	0.0044269009999999996, 0.0088949100000000007, 0.01340704, 
	0.017966719999999999, 0.02257787, 0.027245040000000002, 
	0.031973540000000002, 0.036769719999999999, 0.04164118, 
	0.0036737530000000001, 0.0073785739999999997, 0.011116539999999999, 
	0.014889990000000001, 0.018701590000000001, 0.022554370000000001, 
	0.026451869999999999, 0.030398189999999999, 0.034398199999999997, 
	0.038457789999999999, 0.042584120000000003, 0.003142461, 
	0.0063093719999999997, 0.0095022470000000001, 0.01272278, 0.01597287, 
	0.0192547, 0.022570730000000001, 0.025923829999999998, 
	0.029317340000000001, 0.032755230000000003, 0.036242249999999997, 
	0.039784189999999997, 0.043388309999999999, 0.0027469909999999998, 
	0.0055138039999999998, 0.0083015829999999995, 0.011111599999999999, 
	0.013945290000000001, 0.016804260000000001, 0.019690320000000001, 
	0.02260556, 0.025552399999999999, 0.028533639999999999, 
	0.031552620000000003, 0.034613320000000003, 0.037720610000000002, 
	0.04088058, 0.044100970000000003, 0.0024408619999999998, 
	0.0048981629999999996, 0.0073727949999999997, 0.0098657469999999994, 
	0.012378119999999999, 0.01491114, 0.017466200000000001, 
	0.020044869999999999, 0.022648950000000001, 0.025280520000000001, 
	0.02794201, 0.030636279999999998, 0.033366779999999999, 
	0.036137700000000002, 0.038954290000000003, 0.041823199999999998, 
	0.044753250000000001, 0.002196707, 0.0044072929999999996, 
	0.0066324729999999998, 0.0088730300000000005, 0.01112984, 0.01340386, 
	0.015696169999999999, 0.018008, 0.020340730000000001, 
	0.022695940000000001, 0.025075469999999999, 0.027481430000000001, 
	0.029916370000000001, 0.032383309999999998, 0.034885930000000002, 
	0.03742885, 0.04001793, 0.04266089, 0.045368329999999998, 
	0.0019973370000000001, 0.0040065680000000003, 0.006028271, 
	0.0080630839999999999, 0.010111709999999999, 0.012174910000000001, 
	0.01425357, 0.016348629999999999, 0.018461200000000001, 0.0205925, 
	0.022743949999999999, 0.024917180000000001, 0.02711411, 0.02933697, 
	0.031588489999999997, 0.03387196, 0.03619149, 0.038552330000000003, 
	0.04096139, 0.043428130000000002, 0.045966199999999999, 0.001831406, 
	0.0036731279999999999, 0.005525645, 0.0073894800000000004, 
	0.0092652069999999993, 0.01115346, 0.013054929999999999, 0.01497041, 
	0.016900760000000001, 0.018846970000000001, 0.020810149999999999, 
	0.02279159, 0.024792749999999999, 0.02681536, 0.028861459999999999, 
	0.030933510000000001, 0.03303449, 0.035168119999999997, 
	0.037339160000000003, 0.039553869999999998, 0.041820830000000003, 
	0.044152410000000003, 0.046567749999999998, 0.0016911129999999999, 
	0.0033912669999999999, 0.0051008620000000003, 0.0068203350000000003, 
	0.0085501629999999995, 0.010290870000000001, 0.01204303, 0.01380728, 
	0.01558433, 0.017374980000000002, 0.019180119999999998, 
	0.021000769999999998, 0.022838109999999998, 0.024693469999999999, 
	0.026568439999999999, 0.02846487, 0.030385019999999999, 
	0.032331600000000002, 0.034308039999999998, 0.036318690000000001, 
	0.03836929, 0.040467709999999997, 0.042625290000000003, 
	0.044859610000000001, 0.047200789999999999, 0.0015709159999999999, 
	0.0031498260000000001, 0.004737069, 0.0063330119999999998, 
	0.0079380579999999996, 0.0095526420000000001, 0.01117725, 0.0128124, 
	0.01445869, 0.016116769999999999, 0.01778737, 0.01947132, 
	0.021169549999999999, 0.02288314, 0.024613329999999999, 
	0.026361570000000001, 0.028129589999999999, 0.029919439999999999, 
	0.031733659999999997, 0.033575399999999998, 0.035448680000000003, 
	0.037358809999999999, 0.039313069999999999, 0.041321999999999998, 
	0.043401870000000002, 0.04558065, 0.047914770000000002, 
	0.0014667689999999999, 0.0029406599999999999, 0.0044219630000000001, 
	0.0059109920000000003, 0.0074080880000000002, 0.0089136200000000006, 
	0.01042799, 0.011951659999999999, 0.01348509, 0.01502885, 
	0.016583540000000001, 0.018149820000000001, 0.01972848, 
	0.021320370000000002, 0.022926499999999999, 0.024548009999999999, 
	0.026186259999999999, 0.027842840000000001, 0.02951968, 0.03121912, 
	0.032944099999999997, 0.034698359999999998, 0.036486869999999998, 
	0.038316410000000002, 0.040196830000000003, 0.042143359999999998, 
	0.044182199999999998, 0.046366209999999998, 0.048839649999999998, 
	0.001375645, 0.002757678, 0.0041463510000000004, 0.0055419320000000003, 
	0.0069447140000000003, 0.0083550120000000002, 0.0097731729999999996, 
	0.011199570000000001, 0.012634630000000001, 0.014078790000000001, 
	0.015532570000000001, 0.016996529999999999, 0.0184713, 
	0.019957590000000001, 0.02145623, 0.02296813, 0.024494370000000001, 
	0.026036210000000001, 0.027595160000000001, 0.029173000000000001, 
	0.030771929999999999, 0.03239471, 0.034044850000000001, 0.03572699, 
	0.037447540000000001, 0.039215739999999999, 0.041045970000000001, 
	0.042962930000000003, 0.04501666, 0.047343490000000002, 
	0.050798910000000003, 0.030328290000000001, 0.011317519999999999, 
	0.022782139999999999, 0.034415790000000002, 0.0071363640000000001, 
	0.014351849999999999, 0.021653800000000001, 0.029050690000000001, 
	0.036552479999999998, 0.0052488739999999997, 0.010549070000000001, 
	0.01590457, 0.021319930000000001, 0.02680037, 0.032351999999999999, 
	0.037981969999999997, 0.004163768, 0.0083641649999999998, 0.01260373, 
	0.016885319999999999, 0.021212209999999999, 0.025588130000000001, 
	0.030017410000000001, 0.03450516, 0.039057429999999997, 
	0.0034559619999999999, 0.0069396550000000003, 0.01045284, 0.01399748, 
	0.017575790000000001, 0.02119031, 0.024843919999999999, 
	0.028539970000000001, 0.032282379999999999, 0.03607581, 
	0.039925849999999999, 0.0029565870000000001, 0.0059350319999999998, 
	0.008936622, 0.011962789999999999, 0.01501513, 0.018095449999999999, 
	0.0212058, 0.02434853, 0.02752636, 0.030742470000000001, 
	0.034000620000000002, 0.037305329999999998, 0.040662139999999999, 
	0.002584827, 0.0051874010000000003, 0.0078086969999999999, 0.0104498, 
	0.013111899999999999, 0.015796359999999999, 0.018504690000000001, 
	0.02123862, 0.024000110000000002, 0.026791450000000001, 
	0.029615320000000001, 0.03247485, 0.035373849999999998, 
	0.038316959999999997, 0.041309940000000003, 0.0022970199999999999, 
	0.0046087760000000002, 0.006936032, 0.0092796300000000005, 0.0116405, 
	0.01401968, 0.016418329999999998, 0.018837759999999999, 
	0.021279449999999998, 0.02374511, 0.02623669, 0.028756509999999999, 
	0.031307269999999998, 0.033892230000000002, 0.036515390000000002, 
	0.039181710000000002, 0.04189756, 0.002067452, 0.0041473609999999996, 
	0.0062403399999999996, 0.0083470579999999992, 0.01046825, 0.01260475, 
	0.01475745, 0.016927370000000001, 0.019115670000000001, 0.02132365, 
	0.023552799999999999, 0.025804859999999999, 0.02808182, 
	0.030386099999999999, 0.032720539999999999, 0.035088649999999999, 
	0.037494800000000002, 0.039944550000000002, 0.04244527, 
	0.0018799750000000001, 0.0037706369999999999, 0.0056724840000000002, 
	0.0075860600000000004, 0.0095119620000000005, 0.01145085, 
	0.013403450000000001, 0.01537058, 0.01735314, 0.019352149999999999, 
	0.021368789999999999, 0.023404379999999999, 0.025460469999999999, 
	0.027538839999999998, 0.029641649999999999, 0.031771430000000003, 
	0.033931309999999999, 0.036125190000000001, 0.038358049999999998, 
	0.040636449999999998, 0.042969399999999998, 0.0017239289999999999, 
	0.003457136, 0.0052000340000000001, 0.0069530720000000002, 
	0.0087167419999999995, 0.01049158, 0.01227818, 0.01407721, 
	0.015889380000000002, 0.01771553, 0.01955658, 0.02141357, 0.02328771, 
	0.02518039, 0.027093240000000001, 0.029028180000000001, 
	0.030987529999999999, 0.032974099999999999, 0.034991420000000002, 
	0.037043989999999999, 0.039137770000000002, 0.041280879999999999, 
	0.043485120000000002, 0.0015919809999999999, 0.003192102, 
	0.0048007070000000004, 0.0064181730000000001, 0.0080449079999999999, 
	0.00968136, 0.011328019999999999, 0.012985429999999999, 
	0.014654179999999999, 0.016334950000000001, 0.018028470000000001, 
	0.019735599999999999, 0.02145729, 0.023194639999999999, 
	0.024948919999999999, 0.02672161, 0.02851447, 0.03032961, 
	0.032169610000000001, 0.034037699999999997, 0.035937990000000003, 
	0.037875930000000002, 0.039858980000000002, 0.041897919999999998, 
	0.044009510000000002, 0.001478926, 0.002965054, 0.0044586779999999998, 
	0.0059601159999999997, 0.0074697119999999999, 0.0089878419999999994, 
	0.010514920000000001, 0.01205138, 0.013597740000000001, 
	0.015154539999999999, 0.016722399999999998, 0.018301990000000001, 
	0.019894100000000001, 0.021499609999999999, 0.023119520000000001, 
	0.024755010000000001, 0.026407440000000001, 0.028078430000000001, 
	0.029769919999999998, 0.031484310000000001, 0.03322456, 
	0.034994480000000001, 0.03679909, 0.0386453, 0.040543089999999997, 
	0.042507959999999997, 0.044566590000000003, 0.001380959, 
	0.0027683400000000002, 0.0041623950000000002, 0.0055633949999999996, 
	0.006971634, 0.0083874299999999995, 0.0098111299999999995, 
	0.011243110000000001, 0.0126838, 0.014133639999999999, 0.01559315, 
	0.017062899999999999, 0.018543520000000001, 0.020035730000000002, 
	0.021540340000000002, 0.0230583, 0.02459068, 0.02613876, 
	0.027704030000000001, 0.029288310000000001, 0.030893799999999999, 
	0.032523280000000002, 0.034180290000000002, 0.035869499999999999, 
	0.037597360000000003, 0.039373169999999999, 0.04121143, 0.04313707, 
	0.045200650000000002, 0.001295236, 0.0025962379999999998, 0.003903222, 
	0.0052164220000000001, 0.0065360909999999999, 0.0078625009999999992, 
	0.0091959499999999996, 0.010536759999999999, 0.01188528, 
	0.013241899999999999, 0.01460705, 0.015981209999999999, 
	0.017364890000000001, 0.0187587, 0.020163299999999999, 0.02157945, 
	0.023008029999999999, 0.024450050000000001, 0.02590669, 0.02737935, 
	0.028869740000000001, 0.03037991, 0.031912459999999997, 
	0.033470710000000001, 0.03505904, 0.036683500000000001, 
	0.038352850000000001, 0.04008072, 0.041890610000000002, 
	0.043830170000000002, 0.046030080000000001, 0.0012195890000000001, 
	0.002444384, 0.0036745749999999998, 0.0049103640000000004, 
	0.0061519690000000002, 0.0073996269999999998, 0.0086535919999999999, 
	0.0099141409999999996, 0.01118158, 0.01245623, 0.013738459999999999, 
	0.015028669999999999, 0.016327299999999999, 0.017634850000000001, 
	0.018951869999999999, 0.020278999999999998, 0.021616929999999999, 
	0.022966500000000001, 0.02432865, 0.02570449, 0.027095350000000001, 
	0.02850281, 0.029928819999999998, 0.031375819999999999, 
	0.032846939999999998, 0.034346309999999998, 0.035879649999999999, 
	0.037455250000000002, 0.039086009999999997, 0.040794230000000001, 
	0.042625200000000002, 0.044703109999999997, 0.047811029999999997, 
	0.028595240000000001, 0.01067531, 0.02148168, 0.032437479999999998, 
	0.006733345, 0.01353736, 0.020418229999999999, 0.027383049999999999, 
	0.034440039999999998, 0.0049535430000000004, 0.0099530199999999999, 
	0.015001810000000001, 0.02010373, 0.025263150000000002, 
	0.030485100000000001, 0.03577545, 0.0039301960000000004, 
	0.0078932370000000009, 0.011891280000000001, 0.01592675, 
	0.020002369999999998, 0.02412127, 0.028287030000000001, 
	0.032503799999999999, 0.03677648, 0.003262586, 0.0065500790000000003, 
	0.0098639769999999995, 0.013205949999999999, 0.01657788, 
	0.019981869999999999, 0.02342033, 0.026896030000000001, 
	0.030412160000000001, 0.033972469999999998, 0.037581410000000003, 
	0.0027915129999999998, 0.005602686, 0.0084346209999999998, 0.01128854, 
	0.014165789999999999, 0.0170679, 0.019996590000000002, 
	0.022953810000000002, 0.025941780000000001, 0.028963119999999998, 
	0.03202083, 0.035118530000000002, 0.038260530000000001, 
	0.0024407840000000001, 0.0048975499999999996, 0.0073711380000000002, 
	0.0098624720000000006, 0.012372579999999999, 0.01490259, 0.01745379, 
	0.020027619999999999, 0.022625719999999998, 0.025249959999999998, 
	0.0279025, 0.030585899999999999, 0.033303159999999998, 
	0.036057899999999997, 0.03885454, 0.0021692299999999999, 
	0.0043517470000000004, 0.0065482099999999996, 0.0087593399999999991, 
	0.01098593, 0.01322887, 0.01548914, 0.017767829999999998, 
	0.020066190000000001, 0.022385619999999998, 0.02472775, 
	0.027094420000000001, 0.029487840000000001, 0.031910580000000001, 
	0.034365739999999999, 0.036857139999999997, 0.039389519999999997, 
	0.0019526050000000001, 0.0039164559999999996, 0.0058920800000000001, 
	0.0078800550000000004, 0.0098810140000000005, 0.011895660000000001, 
	0.01392475, 0.015969170000000001, 0.018029860000000002, 
	0.020107920000000001, 0.02220459, 0.024321269999999999, 
	0.026459610000000001, 0.028621529999999999, 0.030809280000000001, 
	0.033025600000000002, 0.035273810000000003, 0.037558080000000001, 
	0.039883719999999998, 0.001775684, 0.0035610239999999999, 
	0.0053564509999999999, 0.0071624360000000003, 0.0089794929999999998, 
	0.010808190000000001, 0.01264913, 0.01450303, 0.016370630000000001, 
	0.018252810000000001, 0.020150520000000002, 0.02206487, 
	0.023997129999999998, 0.025948740000000001, 0.027921419999999999, 
	0.02991719, 0.031938469999999997, 0.033988230000000001, 
	0.036070190000000002, 0.03818908, 0.040351169999999999, 
	0.0016284100000000001, 0.003265212, 0.0049107639999999998, 
	0.0065654540000000001, 0.0082297059999999998, 0.0099039829999999999, 
	0.01158879, 0.01328469, 0.01499231, 0.016712330000000001, 0.01844552, 
	0.020192769999999999, 0.021955059999999998, 0.023733540000000001, 
	0.025529509999999998, 0.027344520000000001, 0.02918039, 
	0.031039310000000001, 0.032923969999999997, 0.034837720000000003, 
	0.036784839999999999, 0.038770989999999998, 0.040803949999999999, 
	0.0015038720000000001, 0.003015111, 0.0045340179999999999, 0.00606092, 
	0.0075961700000000002, 0.0091401520000000003, 0.010693289999999999, 
	0.012256039999999999, 0.01382892, 0.015412489999999999, 
	0.017007379999999999, 0.018614289999999999, 0.020234019999999998, 
	0.021867480000000002, 0.0235157, 0.025179880000000002, 0.02686142, 
	0.028562000000000001, 0.030283609999999999, 0.0320287, 
	0.033800330000000003, 0.035602420000000003, 0.037440139999999997, 
	0.039320609999999999, 0.041254140000000002, 0.001397157, 
	0.0028008379999999999, 0.0042113000000000003, 0.0056288190000000002, 
	0.0070536929999999998, 0.0084862470000000006, 0.0099268340000000007, 
	0.01137584, 0.01283369, 0.01430085, 0.015777840000000001, 
	0.017265240000000001, 0.01876369, 0.020273929999999999, 0.02179679, 
	0.023333219999999998, 0.024884320000000001, 0.026451390000000002, 
	0.028035959999999999, 0.029639869999999999, 0.031265380000000002, 
	0.032915310000000003, 0.034593270000000002, 0.036304049999999997, 
	0.038054209999999998, 0.039853279999999998, 0.041716080000000003, 
	0.001304677, 0.0026151770000000002, 0.0039317190000000002, 
	0.0052545389999999999, 0.0065838930000000004, 0.0079200550000000005, 
	0.009263327, 0.01061403, 0.01197253, 0.013339220000000001, 0.01471452, 
	0.016098910000000001, 0.017492939999999998, 0.018897190000000001, 
	0.02031235, 0.021739189999999999, 0.023178589999999999, 
	0.024631569999999998, 0.02609933, 0.02758329, 0.02908517, 0.03060705, 
	0.032151560000000003, 0.03372207, 0.035323, 0.0369605, 
	0.038643440000000001, 0.04038564, 0.042210989999999997, 0.001223752, 
	0.0024527339999999998, 0.0036871360000000001, 0.004927163, 
	0.0061730329999999996, 0.0074249850000000003, 0.0086832739999999995, 
	0.0099481780000000002, 0.011220000000000001, 0.012499079999999999, 
	0.013785769999999999, 0.01508047, 0.016383640000000001, 
	0.017695780000000001, 0.019017429999999998, 0.020349229999999999, 
	0.0216919, 0.023046259999999999, 0.024413259999999999, 
	0.025794029999999999, 0.027189890000000001, 0.02860244, 
	0.030033629999999999, 0.031485920000000001, 0.032962459999999999, 
	0.034467409999999997, 0.03600652, 0.037588120000000003, 
	0.039225210000000003, 0.040940259999999999, 0.042778999999999998, 
	0.001152333, 0.002309392, 0.0034713439999999999, 0.0046383639999999999, 
	0.0058106449999999997, 0.0069883899999999997, 0.0081718209999999993, 
	0.0093611779999999995, 0.01055672, 0.01175873, 0.01296752, 0.01418344, 
	0.01540684, 0.016638170000000001, 0.017877870000000001, 
	0.019126480000000001, 0.020384570000000001, 0.02165284, 
	0.022932040000000001, 0.024223069999999999, 0.025526989999999999, 
	0.026845029999999999, 0.028178700000000001, 0.029529840000000002, 
	0.030900770000000001, 0.032294429999999999, 0.033714760000000003, 
	0.035167190000000001, 0.036659579999999997, 0.03820424, 
	0.039822450000000002, 0.041557549999999999, 0.043528959999999998, 
	0.001088833, 0.0021819600000000001, 0.0032795239999999998, 
	0.0043816829999999999, 0.0054886020000000004, 0.0066004599999999998, 
	0.0077174490000000004, 0.0088397770000000001, 0.0099676690000000002, 
	0.011101369999999999, 0.012241139999999999, 0.01338728, 0.01454011, 
	0.015699979999999999, 0.016867279999999998, 0.01804244, 0.01922598, 
	0.02041842, 0.021620420000000001, 0.022832700000000001, 0.0240561, 
	0.025291609999999999, 0.02654041, 0.027803919999999999, 
	0.029083870000000001, 0.030382449999999998, 0.031702460000000002, 
	0.033047630000000001, 0.034423099999999998, 0.035836350000000003, 
	0.037299079999999998, 0.038831579999999997, 0.040475240000000003, 
	0.042344039999999999, 0.045160249999999999, 0.027049549999999999, 
	0.010102069999999999, 0.02032167, 0.03067431, 0.0063734320000000001, 
	0.01281037, 0.019316070000000001, 0.025896519999999999, 
	0.032558610000000002, 0.0046896990000000003, 0.0094207530000000005, 
	0.01419605, 0.019018819999999999, 0.023892759999999999, 
	0.028822070000000002, 0.033811599999999997, 0.0037214650000000002, 
	0.0074725470000000004, 0.011255100000000001, 0.01507118, 
	0.018923120000000002, 0.022813529999999999, 0.026745410000000001, 
	0.03072219, 0.034747889999999997, 0.0030897329999999999, 
	0.0062019589999999999, 0.0093379699999999993, 0.01249919, 0.01568723, 
	0.018903860000000001, 0.02215112, 0.0254313, 0.02874705, 
	0.032101440000000002, 0.035498059999999998, 0.0026439279999999998, 
	0.0053056350000000004, 0.0079860720000000003, 0.010686289999999999, 
	0.01340744, 0.01615082, 0.01891789, 0.021710279999999998, 
	0.024529849999999999, 0.027378739999999999, 0.03025943, 
	0.033174820000000001, 0.036128359999999998, 0.002311979, 
	0.0046384290000000003, 0.0069800749999999996, 0.0093377159999999994, 
	0.011712230000000001, 0.01410459, 0.01651588, 0.01894732, 
	0.021400280000000001, 0.023876330000000001, 0.02637724, 0.0289051, 
	0.031462329999999997, 0.0340518, 0.03667699, 0.0020549420000000001, 
	0.0041219270000000001, 0.0062015270000000001, 0.0082943670000000004, 
	0.01040113, 0.01252258, 0.01465954, 0.016812959999999998, 0.01898387, 
	0.021173460000000002, 0.023383060000000001, 0.02561422, 0.02786872, 
	0.030148629999999999, 0.032456430000000001, 0.034795079999999999, 
	0.037168229999999997, 0.0018498799999999999, 0.0037099630000000001, 
	0.0055807089999999997, 0.0074626179999999999, 0.0093562369999999999, 
	0.01126217, 0.01318107, 0.015113680000000001, 0.017060820000000001, 
	0.019023390000000001, 0.021002440000000001, 0.022999140000000001, 
	0.025014829999999998, 0.027051080000000002, 0.02910971, 
	0.031192879999999999, 0.033303199999999998, 0.035443839999999997, 
	0.037618789999999999, 0.0016823890000000001, 0.0033735470000000002, 
	0.0050738509999999999, 0.0067837089999999997, 0.0085035660000000006, 
	0.010233910000000001, 0.01197527, 0.013728249999999999, 0.01549348, 
	0.017271700000000001, 0.019063730000000001, 0.02087048, 
	0.022693000000000001, 0.024532479999999999, 0.02639033, 
	0.028268149999999999, 0.030167880000000001, 0.03209182, 
	0.034042820000000001, 0.036024420000000001, 0.038041150000000003, 
	0.0015429549999999999, 0.0030935379999999998, 0.0046520600000000004, 
	0.0062188629999999998, 0.0077943120000000003, 0.0093788090000000001, 
	0.01097279, 0.012576739999999999, 0.014191189999999999, 
	0.015816719999999999, 0.017453980000000001, 0.019103729999999999, 
	0.02076677, 0.022444059999999998, 0.024136669999999999, 
	0.025845859999999998, 0.027573090000000001, 0.02932009, 
	0.031088959999999999, 0.032882250000000002, 0.034703150000000002, 
	0.036555770000000001, 0.038445510000000002, 0.001425038, 0.002856777, 
	0.0042954819999999998, 0.0057414370000000003, 0.0071949500000000003, 
	0.0086563539999999998, 0.010126019999999999, 0.01160433, 
	0.013091739999999999, 0.014588719999999999, 0.016095809999999999, 
	0.0176136, 0.01914277, 0.020684060000000001, 0.022238339999999999, 
	0.023806589999999999, 0.02538994, 0.026989740000000002, 
	0.028607560000000001, 0.030245310000000001, 0.031905320000000001, 
	0.033590519999999999, 0.035304620000000002, 0.037052599999999998, 
	0.038841250000000001, 0.0013239899999999999, 0.0026539189999999998, 
	0.0039900120000000002, 0.0053325109999999998, 0.0066816769999999996, 
	0.0080377920000000002, 0.0094011619999999994, 0.01077212, 0.01215103, 
	0.0135383, 0.014934370000000001, 0.016339719999999999, 
	0.017754909999999999, 0.019180539999999999, 0.020617320000000001, 
	0.022066019999999999, 0.023527559999999999, 0.025002980000000001, 
	0.0264935, 0.028000589999999999, 0.029525989999999998, 0.03107186, 
	0.032640870000000002, 0.03423648, 0.035863249999999999, 
	0.037527459999999999, 0.039238250000000002, 0.0012364159999999999, 
	0.0024781360000000001, 0.0037253529999999998, 0.0049782740000000004, 
	0.0062371220000000003, 0.0075021389999999997, 0.0087735829999999997, 
	0.01005174, 0.01133691, 0.01262945, 0.0139297, 0.015238099999999999, 
	0.01655508, 0.01788116, 0.019216899999999999, 0.020562939999999998, 
	0.02192001, 0.023288960000000001, 0.02467074, 0.026066490000000001, 
	0.02747757, 0.028905610000000002, 0.030352580000000001, 0.03182099, 
	0.033314049999999998, 0.034835980000000002, 0.036392649999999999, 
	0.037992539999999998, 0.039648940000000001, 0.0011597790000000001, 
	0.0023243249999999999, 0.0034938059999999999, 0.0046684020000000003, 
	0.0058483040000000003, 0.0070337200000000002, 0.0082248719999999994, 
	0.0094220039999999994, 0.01062538, 0.01183528, 0.013052019999999999, 
	0.014275950000000001, 0.015507450000000001, 0.01674693, 0.01799487, 
	0.019251790000000001, 0.0205183, 0.02179507, 0.02308288, 
	0.024382629999999999, 0.0256954, 0.027022419999999998, 
	0.028365230000000002, 0.029725680000000001, 0.031106109999999999, 
	0.03250952, 0.033939860000000002, 0.035402629999999997, 
	0.036905809999999997, 0.038461830000000002, 0.040092299999999997, 
	0.001092141, 0.002188593, 0.0032895009999999998, 0.0043950229999999996, 
	0.0055053239999999998, 0.0066205860000000004, 0.0077409999999999996, 
	0.0088667759999999998, 0.0099981400000000008, 0.011135340000000001, 
	0.01227863, 0.013428320000000001, 0.014584730000000001, 0.0157482, 
	0.016919139999999999, 0.018097990000000001, 0.01928523, 
	0.020481429999999998, 0.021687229999999998, 0.022903340000000001, 
	0.024130639999999998, 0.025370090000000001, 0.026622900000000001, 
	0.027890479999999999, 0.029174579999999999, 0.03047739, 
	0.031801740000000002, 0.033151369999999999, 0.034531449999999998, 
	0.035949500000000002, 0.037417289999999999, 0.038955249999999997, 
	0.040605099999999998, 0.0010319999999999999, 0.0020679169999999998, 
	0.0031078809999999998, 0.0041520280000000003, 0.0052005050000000002, 
	0.0062534679999999999, 0.0073110850000000002, 0.0083735389999999993, 
	0.0094410239999999992, 0.010513750000000001, 0.01159196, 0.01267588, 
	0.01376581, 0.01486204, 0.015964909999999999, 0.017074780000000001, 
	0.018192079999999999, 0.019317250000000001, 0.020450840000000001, 
	0.021593439999999998, 0.02274574, 0.023908530000000001, 
	0.025082759999999999, 0.026269529999999999, 0.0274702, 
	0.028686409999999999, 0.029920240000000001, 0.031174360000000002, 
	0.032452300000000003, 0.033758980000000001, 0.035101540000000001, 
	0.036491160000000002, 0.037947269999999998, 0.039509629999999997, 
	0.041288199999999997, 0.00097816900000000009, 0.0019599159999999999, 
	0.0029453529999999999, 0.0039346030000000001, 0.0049277929999999998, 
	0.005925062, 0.0069265580000000002, 0.0079324370000000005, 
	0.0089428719999999993, 0.0099580469999999994, 0.010978160000000001, 
	0.012003430000000001, 0.0130341, 0.01407041, 0.01511267, 
	0.016161169999999999, 0.01721628, 0.018278389999999999, 
	0.019347920000000001, 0.020425390000000002, 0.02151134, 0.02260645, 
	0.023711449999999999, 0.02482724, 0.02595488, 0.027095640000000001, 
	0.028251080000000001, 0.02942318, 0.030614479999999999, 
	0.031828330000000002, 0.033069420000000002, 0.034344550000000001, 
	0.035664420000000002, 0.037047620000000003, 0.038532240000000002, 
	0.040223689999999999, 0.042792589999999998, 0.025662399999999998, 
	0.0095872749999999993, 0.019280519999999999, 0.029092989999999999, 
	0.0060500570000000002, 0.01215749, 0.018326820000000001, 
	0.024563120000000001, 0.030872230000000001, 0.004452559, 
	0.0089425459999999991, 0.01347244, 0.01804503, 0.022663429999999998, 
	0.0273312, 0.032052419999999998, 0.0035338069999999999, 
	0.0070944600000000003, 0.01068356, 0.014302870000000001, 
	0.017954390000000001, 0.021640340000000001, 0.025363239999999999, 
	0.029125979999999999, 0.032931870000000002, 0.0029342970000000002, 
	0.0058890089999999997, 0.0088652550000000007, 0.01186427, 0.01488742, 
	0.017936239999999999, 0.02101244, 0.024117969999999999, 0.02725503, 
	0.030426160000000001, 0.033634320000000002, 0.002511189, 
	0.0050385339999999999, 0.0075828629999999996, 0.010145080000000001, 
	0.01272619, 0.0153273, 0.017949639999999999, 0.020594609999999999, 
	0.02326377, 0.025958910000000002, 0.028682079999999999, 
	0.031435659999999997, 0.034222429999999998, 0.0021961120000000001, 
	0.004405389, 0.0066284630000000002, 0.0088660270000000003, 0.01111884, 
	0.01338774, 0.015673659999999999, 0.01797764, 0.020300820000000001, 
	0.022644540000000001, 0.025010279999999999, 0.02739975, 0.02981495, 
	0.032258189999999999, 0.034732239999999998, 0.001952119, 
	0.0039152060000000001, 0.00588976, 0.007876325, 0.0098754949999999998, 
	0.01188792, 0.013914330000000001, 0.015955509999999999, 
	0.018012360000000002, 0.02008588, 0.022177180000000001, 0.02428756, 
	0.026418480000000001, 0.028571639999999999, 0.030749039999999998, 
	0.032953040000000003, 0.035186500000000002, 0.00175745, 0.003524199, 
	0.0053006520000000003, 0.0070872440000000004, 0.0088844509999999998, 
	0.010692800000000001, 0.012512850000000001, 0.01434524, 
	0.016190659999999999, 0.018049909999999999, 0.019923840000000002, 
	0.02181344, 0.023719850000000001, 0.02564433, 0.027588390000000001, 
	0.029553759999999998, 0.031542519999999998, 0.033557160000000003, 
	0.035600729999999997, 0.001598435, 0.0032048699999999999, 
	0.0048196350000000001, 0.0064430879999999996, 0.0080756179999999997, 
	0.0097176469999999994, 0.01136964, 0.0130321, 0.014705589999999999, 
	0.016390729999999999, 0.01808821, 0.01979881, 0.02152341, 
	0.023262999999999999, 0.025018729999999999, 0.02679192, 
	0.028584120000000001, 0.030397170000000001, 0.032233289999999998, 
	0.034095189999999997, 0.035986259999999999, 0.0014660490000000001, 
	0.0029390610000000002, 0.0044193130000000002, 0.0059071009999999997, 
	0.0074027470000000003, 0.0089066000000000006, 0.010419039999999999, 
	0.01194048, 0.01347139, 0.015012259999999999, 0.016563649999999999, 
	0.01812619, 0.019700570000000001, 0.021287589999999999, 0.02288813, 
	0.024503239999999999, 0.0261341, 0.027782109999999999, 
	0.029448930000000002, 0.031136560000000001, 0.032847439999999999, 
	0.034584629999999998, 0.03635207, 0.001354084, 0.0027142910000000002, 
	0.0040808550000000004, 0.0054540229999999997, 0.0068340679999999996, 
	0.0082212799999999992, 0.0096159769999999995, 0.011018500000000001, 
	0.012429239999999999, 0.013848600000000001, 0.01527704, 
	0.016715069999999999, 0.018163249999999999, 0.019622230000000001, 
	0.021092710000000001, 0.022575520000000002, 0.024071599999999999, 
	0.02558202, 0.02710806, 0.02865123, 0.030213360000000002, 
	0.031796659999999997, 0.03340394, 0.035038760000000002, 
	0.036705889999999998, 0.001258131, 0.0025216940000000001, 
	0.0037908849999999999, 0.005065918, 0.0063470219999999999, 
	0.0076344439999999998, 0.0089284499999999992, 0.01022933, 0.01153741, 
	0.01285302, 0.01417656, 0.01550843, 0.016849099999999999, 
	0.018199110000000001, 0.019559010000000002, 0.020929489999999999, 
	0.022311279999999999, 0.023705250000000001, 0.02511238, 
	0.026533870000000001, 0.027971079999999999, 0.029425699999999999, 
	0.03089977, 0.032395859999999999, 0.033917280000000001, 
	0.035468390000000002, 0.037055240000000003, 0.0011749690000000001, 
	0.0023547910000000002, 0.003539637, 0.0047296880000000001, 
	0.0059251429999999999, 0.00712621, 0.0083331189999999999, 
	0.0095461160000000003, 0.010765469999999999, 0.011991470000000001, 
	0.013224440000000001, 0.01446473, 0.015712730000000001, 
	0.016968859999999999, 0.018233610000000001, 0.01950752, 
	0.020791190000000001, 0.022085319999999999, 0.023390709999999999, 
	0.024708270000000001, 0.026039099999999999, 0.027384470000000001, 
	0.028745940000000001, 0.0301254, 0.031525249999999998, 
	0.032948539999999998, 0.034399350000000002, 0.035883270000000002, 
	0.037408480000000001, 0.0011021889999999999, 0.0022087420000000001, 
	0.003319808, 0.0044355460000000003, 0.005556124, 0.0066817250000000003, 
	0.0078125450000000006, 0.0089487950000000007, 0.010090699999999999, 
	0.01123852, 0.012392520000000001, 0.013552989999999999, 
	0.014720270000000001, 0.015894709999999999, 0.017076709999999998, 
	0.018266729999999998, 0.01946525, 0.02067285, 0.021890179999999999, 
	0.023117970000000002, 0.02435708, 0.025608530000000001, 0.02687351, 
	0.02815347, 0.029450179999999999, 0.030765879999999999, 
	0.032103420000000001, 0.033466620000000002, 0.034860710000000003, 
	0.036293359999999997, 0.037776549999999999, 0.0010379510000000001, 
	0.0020798520000000001, 0.00312583, 0.0041760249999999999, 
	0.0052305839999999999, 0.0062896649999999998, 0.0073534380000000003, 
	0.0084220849999999993, 0.0094958049999999995, 0.01057481, 
	0.011659340000000001, 0.01274963, 0.013845980000000001, 
	0.014948680000000001, 0.016058070000000001, 0.017174519999999999, 
	0.018298459999999999, 0.019430349999999999, 0.020570720000000001, 
	0.02172017, 0.022879409999999999, 0.024049230000000001, 
	0.025230579999999999, 0.026424599999999999, 0.02763262, 
	0.028856329999999999, 0.030097809999999999, 0.03135976, 
	0.032645760000000003, 0.03396076, 0.03531198, 0.036710729999999997, 
	0.038176700000000001, 0.00098083099999999993, 0.0019652530000000001, 
	0.0029533799999999998, 0.0039453320000000002, 0.0049412409999999999, 
	0.0059412429999999997, 0.0069454879999999997, 0.0079541330000000004, 
	0.0089673510000000001, 0.0099853270000000004, 0.011008260000000001, 
	0.012036369999999999, 0.013069900000000001, 0.014109099999999999, 
	0.015154259999999999, 0.016205689999999998, 0.01726376, 
	0.018328850000000001, 0.019401390000000001, 0.020481900000000001, 
	0.02157094, 0.022669160000000001, 0.023777320000000001, 
	0.024896310000000001, 0.026027189999999999, 0.027171250000000001, 
	0.028330060000000001, 0.029505590000000002, 0.030700399999999999, 
	0.031917859999999999, 0.03316268, 0.034441699999999999, 
	0.035765659999999998, 0.037153270000000002, 0.038642900000000001, 
	0.00092970219999999998, 0.001862685, 0.0027990490000000001, 
	0.0037389020000000001, 0.0046823580000000002, 0.0056295379999999999, 
	0.0065805730000000002, 0.0075356019999999998, 0.0084947749999999995, 
	0.0094582539999999993, 0.01042621, 0.01139884, 0.01237634, 0.01335894, 
	0.014346879999999999, 0.01534044, 0.016339909999999999, 
	0.017345619999999999, 0.01835794, 0.0193773, 0.020404149999999999, 
	0.021439050000000001, 0.022482599999999998, 0.023535520000000001, 
	0.024598660000000001, 0.025673020000000001, 0.02675982, 
	0.027860550000000001, 0.028977079999999999, 0.030111840000000001, 
	0.031268039999999997, 0.032450149999999997, 0.03366471, 
	0.034921960000000002, 0.036239779999999999, 0.03765487, 
	0.039269199999999997, 0.00088366580000000001, 0.0017703409999999999, 
	0.0026601160000000001, 0.003553086, 0.0044493520000000002, 
	0.0053490209999999998, 0.0062522089999999999, 0.0071590380000000004, 
	0.0080696399999999995, 0.0089841590000000002, 0.0099027439999999998, 
	0.01082556, 0.011752790000000001, 0.012684620000000001, 0.01362127, 
	0.01456297, 0.01550998, 0.016462569999999999, 0.01742107, 
	0.018385820000000001, 0.01935721, 0.020335700000000002, 0.02132179, 
	0.022316059999999999, 0.02331921, 0.024332039999999999, 
	0.025355490000000001, 0.026390719999999999, 0.027439160000000001, 
	0.028502590000000001, 0.02958332, 0.03068442, 0.03181018, 
	0.032966820000000001, 0.034164199999999999, 0.035419470000000002, 
	0.036767920000000003, 0.038307649999999999, 0.040664989999999998, 
	0.024410569999999999, 0.0091224080000000003, 0.01834086, 0.02766675, 
	0.0057579240000000002, 0.01156795, 0.017433959999999998, 0.02336034, 
	0.029352050000000001, 0.0042382610000000001, 0.0085105579999999997, 
	0.01281904, 0.017166109999999998, 0.021554449999999999, 
	0.025987079999999999, 0.030467459999999998, 0.0033641819999999998, 
	0.0067528099999999997, 0.010167280000000001, 0.013609120000000001, 
	0.017080040000000001, 0.020581950000000002, 0.024117, 0.02768762, 
	0.031296610000000002, 0.0027937679999999999, 0.0056061499999999998, 
	0.0084381200000000003, 0.01129075, 0.014165229999999999, 
	0.017062879999999999, 0.01998515, 0.022933700000000001, 0.0259104, 
	0.028917379999999999, 0.031957079999999999, 0.0023911599999999998, 
	0.0047970670000000003, 0.0072184440000000001, 0.0096560799999999992, 
	0.012110849999999999, 0.0145837, 0.017075699999999999, 
	0.019588040000000001, 0.022122050000000001, 0.024679240000000002, 
	0.027261319999999999, 0.029870259999999999, 0.032508349999999998, 
	0.0020913239999999999, 0.004194677, 0.0063106129999999996, 
	0.0084397380000000004, 0.01058271, 0.01274026, 0.0149132, 0.0171024, 
	0.019308860000000001, 0.021533690000000001, 0.023778170000000001, 
	0.026043699999999999, 0.028331950000000002, 0.03064482, 
	0.032984550000000001, 0.001859117, 0.0037282639999999998, 
	0.0056078810000000003, 0.0074984429999999996, 0.0094004710000000005, 
	0.01131453, 0.01324125, 0.01518131, 0.017135480000000002, 
	0.019104610000000001, 0.02108966, 0.0230917, 0.025111959999999999, 
	0.027151850000000002, 0.029212999999999999, 0.03129734, 0.03340713, 
	0.0016738370000000001, 0.0033561870000000001, 0.0050474040000000001, 
	0.0067478720000000002, 0.0084580090000000007, 0.01017827, 0.01190914, 
	0.013651190000000001, 0.01540499, 0.017171229999999999, 
	0.018950649999999999, 0.02074409, 0.02255248, 0.0243769, 
	0.026218579999999998, 0.028078949999999998, 0.029959679999999999, 
	0.031862769999999999, 0.033790599999999997, 0.001522483, 
	0.0030522940000000001, 0.0045897250000000002, 0.0061350909999999996, 
	0.0076887329999999997, 0.0092510209999999999, 0.01082236, 0.01240318, 
	0.01399398, 0.01559529, 0.017207710000000001, 0.018831879999999999, 
	0.02046856, 0.022118579999999999, 0.023782890000000001, 
	0.025462599999999998, 0.027158959999999999, 0.028873469999999998, 
	0.030607889999999999, 0.032364339999999998, 0.034145439999999999, 
	0.0013964660000000001, 0.002799316, 0.0042087940000000001, 0.005625161, 
	0.0070487019999999996, 0.0084797199999999996, 0.0099185499999999999, 
	0.01136555, 0.01282113, 0.01428571, 0.015759769999999999, 0.01724386, 
	0.01873855, 0.02024453, 0.02176254, 0.02329345, 0.024838229999999999, 
	0.026398029999999999, 0.027974180000000001, 0.029568279999999999, 
	0.03118224, 0.032818399999999998, 0.034479719999999998, 0.001289882, 
	0.0025853819999999998, 0.0038867060000000002, 0.0051940729999999996, 
	0.006507723, 0.0078279109999999999, 0.0091549170000000003, 0.01048904, 
	0.01183061, 0.013179990000000001, 0.01453757, 0.015903790000000001, 
	0.017279139999999998, 0.018664139999999999, 0.020059420000000001, 
	0.021465649999999999, 0.02288362, 0.024314220000000001, 
	0.025758489999999998, 0.027217640000000001, 0.028693119999999999, 
	0.03018668, 0.03170046, 0.033237120000000002, 0.034800129999999999, 
	0.001198536, 0.0024020579999999999, 0.0036107410000000002, 
	0.0048247740000000004, 0.0060443579999999997, 0.0072697120000000002, 
	0.0085010699999999995, 0.0097386880000000006, 0.010982840000000001, 
	0.012233829999999999, 0.013491980000000001, 0.014757670000000001, 
	0.016031279999999998, 0.01731326, 0.01860411, 0.019904379999999999, 
	0.021214710000000001, 0.022535800000000002, 0.023868480000000001, 
	0.025213699999999999, 0.026572579999999998, 0.027946439999999999, 
	0.029336899999999999, 0.030745910000000001, 0.03217594, 
	0.033630159999999999, 0.035112780000000003, 0.001119362, 
	0.0022431819999999998, 0.003371612, 0.0045048120000000004, 
	0.0056429569999999997, 0.0067862340000000004, 0.0079348419999999992, 
	0.0090889979999999992, 0.01024894, 0.01141491, 0.01258721, 0.01376612, 
	0.01495199, 0.016145179999999999, 0.0173461, 0.018555209999999999, 
	0.01977303, 0.021000129999999999, 0.022237179999999999, 
	0.023484930000000001, 0.024744269999999999, 0.026016230000000001, 
	0.02730204, 0.028603179999999999, 0.029921489999999999, 
	0.031259229999999999, 0.03261936, 0.034005769999999998, 
	0.035423879999999998, 0.001050069, 0.002104149, 0.003162373, 
	0.0042248809999999998, 0.0052918230000000002, 0.0063633609999999997, 
	0.0074396660000000002, 0.0085209250000000004, 0.0096073400000000007, 
	0.010699129999999999, 0.01179652, 0.01289979, 0.014009199999999999, 
	0.015125069999999999, 0.016247749999999998, 0.017377610000000002, 
	0.01851508, 0.019660629999999998, 0.02081481, 0.02197824, 0.02315161, 
	0.02433575, 0.025531620000000001, 0.026740380000000001, 
	0.027963399999999999, 0.02920238, 0.030459460000000001, 
	0.031737380000000003, 0.033039789999999999, 0.034371760000000001, 
	0.035740649999999999, 0.00098890669999999992, 0.0019814450000000001, 
	0.0029777290000000001, 0.0039778829999999998, 0.0049820369999999999, 
	0.0059903320000000001, 0.0070029180000000003, 0.0080199550000000005, 
	0.0090416170000000001, 0.01006809, 0.01109958, 0.012136310000000001, 
	0.013178520000000001, 0.01422646, 0.015280439999999999, 
	0.016340770000000001, 0.017407800000000001, 0.018481939999999999, 
	0.019563629999999999, 0.020653379999999999, 0.021751759999999998, 
	0.02285943, 0.023977169999999999, 0.025105869999999999, 0.02624661, 
	0.027400689999999998, 0.0285697, 0.029755650000000002, 0.03096113, 
	0.032189559999999999, 0.033445700000000002, 0.034736509999999998, 
	0.03607291, 0.00093451820000000003, 0.0018723399999999999, 
	0.0028135679999999998, 0.003758309, 0.0047066779999999997, 
	0.0056587989999999999, 0.0066148020000000004, 0.0075748279999999996, 
	0.0085390269999999994, 0.0095075639999999996, 0.01048061, 
	0.011458360000000001, 0.01244103, 0.013428819999999999, 
	0.014422000000000001, 0.01542084, 0.01642563, 0.017436710000000001, 
	0.018454459999999999, 0.01947929, 0.020511669999999999, 
	0.021552160000000001, 0.022601360000000001, 0.02366002, 
	0.024728960000000001, 0.025809220000000001, 0.026902010000000001, 
	0.02800884, 0.029131609999999999, 0.030272739999999999, 
	0.031435490000000003, 0.032624380000000001, 0.033845979999999998, 
	0.03511065, 0.036436469999999999, 0.00088583270000000005, 0.001774685, 
	0.0026666480000000002, 0.0035618149999999999, 0.0044602899999999996, 
	0.0053621800000000002, 0.0062676010000000002, 0.0071766750000000004, 
	0.0080895359999999996, 0.0090063250000000008, 0.0099271959999999992, 
	0.01085231, 0.01178186, 0.01271602, 0.01365502, 0.01459909, 0.01554848, 
	0.016503480000000001, 0.017464400000000001, 0.018431590000000001, 
	0.019405459999999999, 0.020386439999999999, 0.02137505, 
	0.022371889999999998, 0.023377620000000002, 0.024393069999999999, 
	0.02541918, 0.026457109999999999, 0.027508310000000001, 
	0.028574550000000001, 0.029658150000000001, 0.030762210000000002, 
	0.031891019999999999, 0.033050839999999998, 0.03425156, 
	0.035510430000000003, 0.036862979999999997, 0.00084199459999999998, 
	0.0016867609999999999, 0.0025343789999999998, 0.003384934, 
	0.0042385160000000003, 0.0050952219999999999, 0.005955152, 
	0.0068184170000000002, 0.0076851319999999999, 0.0085554229999999995, 
	0.0094294229999999993, 0.01030728, 0.01118914, 0.01207519, 
	0.012965600000000001, 0.013860580000000001, 0.01476034, 
	0.015665129999999999, 0.016575220000000002, 0.017490909999999998, 
	0.01841253, 0.019340449999999999, 0.020275100000000001, 0.02121696, 
	0.022166600000000002, 0.023124659999999998, 0.024091910000000001, 
	0.025069259999999999, 0.026057810000000001, 0.02705892, 
	0.028074289999999998, 0.029106150000000001, 0.030157440000000001, 
	0.03123225, 0.032336589999999998, 0.033479929999999998, 
	0.034678809999999997, 0.03596734, 0.037440649999999999, 
	0.00080231170000000002, 0.001607177, 0.002414668, 0.00322486, 
	0.0040378339999999997, 0.004853675, 0.0056724740000000003, 
	0.0064943290000000001, 0.007319341, 0.0081476220000000002, 
	0.0089792899999999991, 0.009814471, 0.010653299999999999, 0.01149594, 
	0.012342530000000001, 0.01319326, 0.01404831, 0.0149079, 0.01577226, 
	0.016641639999999999, 0.017516319999999998, 0.018396619999999999, 
	0.01928291, 0.02017557, 0.02107508, 0.02198197, 0.02289685, 0.02382045, 
	0.024753649999999999, 0.02569749, 0.026653280000000001, 0.02762264, 
	0.0286077, 0.029611269999999999, 0.030637290000000001, 
	0.031691530000000002, 0.032783079999999999, 0.033927899999999997, 
	0.035158880000000003, 0.036567820000000001, 0.038742720000000001, 
	0.023275199999999999, 0.0087005420000000003, 0.01748854, 
	0.026373850000000001, 0.0054927129999999998, 0.01103294, 0.01662406, 
	0.022269870000000001, 0.027974639999999999, 0.0040436559999999996, 
	0.0081183959999999999, 0.0122261, 0.016368850000000001, 
	0.020548960000000002, 0.024769030000000001, 0.029032019999999999, 
	0.0032101090000000001, 0.0064425719999999997, 0.0096986090000000004, 
	0.012979559999999999, 0.0162869, 0.019622279999999999, 
	0.022987549999999999, 0.02638478, 0.029816329999999999, 
	0.0026660989999999999, 0.0053492380000000001, 0.0080502750000000008, 
	0.010770149999999999, 0.01350988, 0.016270630000000001, 
	0.019053649999999998, 0.021860350000000001, 0.024692329999999998, 
	0.0275514, 0.030439600000000001, 0.0022820969999999999, 
	0.0045777079999999998, 0.006887471, 0.0092120770000000008, 0.01155228, 
	0.01390893, 0.016282930000000001, 0.018675310000000001, 
	0.021087209999999999, 0.02351992, 0.025974879999999999, 
	0.028453740000000002, 0.03095842, 0.0019960970000000001, 
	0.0040032280000000002, 0.0060218809999999998, 0.0080525900000000001, 
	0.010095929999999999, 0.01215255, 0.01422313, 0.01630844, 
	0.018409350000000001, 0.020526800000000001, 0.022661859999999999, 
	0.024815750000000001, 0.026989840000000001, 0.029185719999999998, 
	0.031405219999999998, 0.001774589, 0.003558388, 0.0053517829999999997, 
	0.0071551949999999996, 0.0089690800000000008, 0.01079394, 
	0.012630300000000001, 0.01447878, 0.01634004, 0.018214790000000002, 
	0.020103869999999999, 0.022008179999999999, 0.023928769999999999, 
	0.025866799999999999, 0.027823649999999998, 0.029800879999999998, 
	0.031800330000000002, 0.001597836, 0.003203493, 0.004817287, 
	0.0064395559999999999, 0.0080706660000000006, 0.0097110170000000006, 
	0.011361039999999999, 0.01302122, 0.01469207, 0.016374159999999999, 
	0.018068150000000002, 0.019774739999999999, 0.02149473, 
	0.023229030000000001, 0.02497866, 0.026744819999999999, 
	0.028528870000000001, 0.030332430000000001, 0.032157409999999997, 
	0.001453438, 0.0029136140000000001, 0.0043807890000000004, 
	0.0058552389999999999, 0.0073372669999999997, 0.0088271970000000002, 
	0.01032538, 0.011832209999999999, 0.0133481, 0.014873519999999999, 
	0.016408969999999998, 0.01795503, 0.019512330000000001, 
	0.021081579999999999, 0.022663579999999999, 0.024259240000000001, 
	0.025869630000000001, 0.027495950000000002, 0.02913963, 
	0.030802380000000001, 0.032486229999999998, 0.001333206, 
	0.0026722870000000002, 0.0040174590000000001, 0.0053689549999999999, 
	0.0067270230000000004, 0.0080919359999999992, 0.0094639839999999999, 
	0.010843490000000001, 0.01223079, 0.013626269999999999, 0.01503034, 
	0.016443470000000002, 0.017866159999999999, 0.01929898, 0.02074258, 
	0.022197669999999999, 0.02366507, 0.02514574, 0.026640759999999999, 
	0.02815142, 0.029679250000000001, 0.031226090000000001, 
	0.032794190000000001, 0.0012315099999999999, 0.002468193, 
	0.0037102319999999999, 0.0049578230000000001, 0.0062111759999999997, 
	0.0074705199999999996, 0.008736097, 0.01000817, 0.01128704, 
	0.012573000000000001, 0.013866420000000001, 0.01516765, 0.01647713, 
	0.017795310000000002, 0.019122699999999999, 0.0204599, 0.02180756, 
	0.02316642, 0.024537340000000001, 0.025921320000000001, 0.02731952, 
	0.028733330000000001, 0.030164440000000001, 0.03161489, 
	0.033087270000000002, 0.001144349, 0.0022932909999999998, 
	0.0034469840000000002, 0.0046055940000000002, 0.0057693010000000001, 
	0.0069382979999999999, 0.0081127920000000006, 0.0092930080000000002, 
	0.010479189999999999, 0.011671590000000001, 0.01287052, 0.01407627, 
	0.015289199999999999, 0.016509679999999999, 0.017738150000000001, 
	0.01897507, 0.02022098, 0.021476479999999999, 0.022742249999999999, 
	0.02401907, 0.025307880000000001, 0.02660972, 0.027925889999999998, 
	0.02925792, 0.03060769, 0.031977579999999999, 0.033370650000000002, 
	0.0010687979999999999, 0.0021417060000000002, 0.0032188590000000001, 
	0.0043004000000000002, 0.0053864849999999999, 0.0064772789999999998, 
	0.0075729589999999998, 0.0086737159999999997, 0.009779757, 0.01089131, 
	0.012008599999999999, 0.01313192, 0.01426154, 0.01539778, 
	0.016541009999999998, 0.017691599999999998, 0.01884999, 0.02001669, 
	0.021192229999999999, 0.02237726, 0.0235725, 0.0247788, 
	0.025997139999999998, 0.027228720000000001, 0.028474940000000001, 
	0.029737570000000001, 0.031018790000000001, 0.03232144, 
	0.033649289999999998, 0.0010026729999999999, 0.0020090469999999999, 
	0.003019238, 0.0040333729999999998, 0.0050515849999999999, 
	0.0060740179999999996, 0.0071008240000000004, 0.0081321680000000004, 
	0.0091682269999999993, 0.01020919, 0.01125527, 0.01230669, 
	0.013363699999999999, 0.01442656, 0.01549557, 0.016571059999999999, 
	0.0176534, 0.018742979999999999, 0.019840259999999998, 
	0.020945769999999999, 0.022060079999999999, 0.02318388, 
	0.024317950000000001, 0.025463220000000002, 0.02662078, 
	0.027791960000000001, 0.02897839, 0.030182130000000001, 
	0.031405820000000001, 0.032652970000000003, 0.033928460000000001, 
	0.00094430499999999999, 0.0018919609999999999, 0.0028430719999999999, 
	0.0037977459999999998, 0.0047561019999999999, 0.0057182630000000003, 
	0.0066843629999999996, 0.0076545440000000001, 0.0086289599999999998, 
	0.0096077780000000008, 0.01059117, 0.01157934, 0.01257249, 
	0.013570860000000001, 0.01457468, 0.015584249999999999, 
	0.016599860000000001, 0.01762186, 0.01865062, 0.019686579999999999, 
	0.020730200000000001, 0.021782059999999999, 0.02284276, 
	0.023913070000000002, 0.024993830000000002, 0.026086069999999999, 
	0.027191050000000001, 0.0283103, 0.02944573, 0.03059984, 
	0.031775930000000001, 0.03297858, 0.034214519999999998, 
	0.00089239899999999999, 0.0017878480000000001, 0.0026864390000000001, 
	0.0035882679999999999, 0.0044934379999999998, 0.0054020580000000004, 
	0.0063142449999999996, 0.0072301240000000001, 0.0081498279999999996, 
	0.0090735009999999994, 0.010001299999999999, 0.010933389999999999, 
	0.011869950000000001, 0.01281118, 0.0137573, 0.014708529999999999, 
	0.015665149999999999, 0.01662744, 0.017595710000000001, 
	0.018570320000000001, 0.019551679999999998, 0.02054023, 
	0.021536489999999998, 0.02254107, 0.023554640000000002, 
	0.024578030000000001, 0.02561221, 0.026658350000000001, 
	0.027717889999999999, 0.028792649999999999, 0.029884979999999998, 
	0.030998000000000001, 0.032136060000000001, 0.033305519999999998, 
	0.034516390000000001, 0.00084593400000000001, 0.001694657, 
	0.0025462509999999998, 0.0034007999999999998, 0.0042583969999999997, 
	0.0051191359999999998, 0.0059831210000000001, 0.0068504630000000002, 
	0.0077212770000000003, 0.0085956899999999996, 0.0094738380000000001, 
	0.01035587, 0.011241930000000001, 0.012132199999999999, 
	0.013026869999999999, 0.01392613, 0.01483021, 0.015739360000000001, 
	0.01665384, 0.017573950000000001, 0.018500030000000001, 
	0.019432459999999999, 0.020371670000000001, 0.021318139999999999, 
	0.022272429999999999, 0.023235209999999999, 0.024207240000000001, 
	0.02518944, 0.026182919999999998, 0.027189049999999999, 
	0.028209560000000002, 0.029246660000000001, 0.03030333, 
	0.031383710000000002, 0.032493830000000001, 0.033643270000000003, 
	0.034848709999999998, 0.0008040937, 0.0016107490000000001, 
	0.0024200369999999999, 0.0032320349999999999, 0.0040468240000000001, 
	0.0048644880000000001, 0.0056851200000000001, 0.0065088159999999997, 
	0.0073356799999999998, 0.0081658229999999991, 0.0089993629999999998, 
	0.0098364279999999995, 0.01067716, 0.011521699999999999, 0.01237021, 
	0.013222869999999999, 0.01407987, 0.01494142, 0.015807749999999999, 
	0.016679119999999999, 0.017555810000000002, 0.018438139999999999, 
	0.019326469999999998, 0.020221200000000002, 0.021122800000000001, 
	0.022031800000000001, 0.022948820000000002, 0.023874599999999999, 
	0.024809990000000001, 0.025756069999999999, 0.026714140000000001, 
	0.02768582, 0.028673259999999999, 0.029679279999999999, 0.03070782, 
	0.031764680000000003, 0.032858989999999998, 0.03400678, 
	0.035241139999999997, 0.00076621790000000001, 0.0015347970000000001, 
	0.0023058010000000001, 0.0030792979999999998, 0.0038553609999999999, 
	0.0046340670000000004, 0.0054154959999999997, 0.0061997340000000001, 
	0.0069868739999999997, 0.0077770130000000002, 0.0085702569999999995, 
	0.0093667179999999996, 0.01016652, 0.01096978, 0.01177666, 
	0.012587299999999999, 0.01340187, 0.01422055, 0.015043539999999999, 
	0.015871059999999999, 0.016703349999999999, 0.017540690000000001, 
	0.01838337, 0.019231729999999999, 0.02008617, 0.02094712, 
	0.021815089999999999, 0.02269067, 0.023574560000000001, 
	0.024467590000000001, 0.025370770000000001, 0.026285340000000001, 
	0.027212879999999998, 0.028155400000000001, 0.02911563, 0.03009734, 
	0.031106100000000001, 0.032150690000000003, 0.033246530000000003, 
	0.034425509999999999, 0.035776839999999997, 0.00073176670000000004, 
	0.0014657170000000001, 0.0022019079999999998, 0.0029404019999999999, 
	0.0036812640000000001, 0.0044245619999999999, 0.0051703690000000002, 
	0.0059187609999999998, 0.0066698199999999999, 0.0074236349999999996, 
	0.0081802980000000008, 0.0089399089999999994, 0.0097025740000000003, 
	0.010468409999999999, 0.011237540000000001, 0.012010099999999999, 
	0.012786230000000001, 0.013566089999999999, 0.014349860000000001, 
	0.01513772, 0.015929889999999999, 0.01672659, 0.017528080000000001, 
	0.018334659999999999, 0.019146639999999999, 0.019964389999999999, 
	0.020788339999999999, 0.021618970000000001, 0.02245685, 
	0.023302630000000001, 0.024157120000000001, 0.025021290000000002, 
	0.025896309999999999, 0.026783709999999999, 0.027685419999999999, 
	0.028604049999999999, 0.02954325, 0.03050837, 0.031507880000000002, 
	0.032556670000000003, 0.033685600000000003, 0.03498101, 
	0.036997420000000003, 0.022240739999999998, 0.0083159749999999998, 
	0.01671191, 0.025196409999999999, 0.0052508640000000001, 
	0.010545240000000001, 0.01588608, 0.021276690000000001, 0.02672078, 
	0.0038661450000000001, 0.0077607930000000002, 0.011685589999999999, 
	0.015642360000000001, 0.019633109999999999, 0.023660110000000002, 
	0.02772587, 0.0030695399999999999, 0.0061596020000000001, 
	0.0092712560000000003, 0.012405680000000001, 0.01556416, 0.01874814, 
	0.02195921, 0.02519915, 0.028469970000000001, 0.002549599, 
	0.0051148579999999999, 0.0076965319999999999, 0.010295449999999999, 
	0.0129125, 0.0155487, 0.01820513, 0.02088303, 0.023583750000000001, 
	0.026308829999999998, 0.029060030000000001, 0.002182561, 
	0.0043775530000000002, 0.0065855389999999996, 0.0088071290000000003, 
	0.011042990000000001, 0.013293849999999999, 0.01556052, 
	0.017843879999999999, 0.020144909999999999, 0.022464720000000001, 
	0.024804550000000002, 0.027165789999999999, 0.02955004, 0.001909177, 
	0.0038285120000000001, 0.0057584380000000003, 0.007699427, 
	0.0096519880000000002, 0.011616680000000001, 0.01359411, 0.01558495, 
	0.017589939999999998, 0.0196099, 0.02164576, 0.023698529999999999, 
	0.02576939, 0.027859680000000001, 0.029970900000000002, 
	0.0016974270000000001, 0.003403339, 0.005118081, 0.0068420240000000004, 
	0.0085755710000000006, 0.010319160000000001, 0.012073270000000001, 
	0.013838420000000001, 0.015615179999999999, 0.017404200000000002, 
	0.019206170000000002, 0.021021870000000002, 0.0228522, 0.02469814, 
	0.02656085, 0.028441609999999999, 0.030341949999999999, 0.00152845, 
	0.0030641119999999999, 0.004607267, 0.0061582140000000004, 
	0.0077172780000000002, 0.0092848119999999999, 0.0108612, 
	0.012446850000000001, 0.014042229999999999, 0.015647830000000001, 
	0.017264209999999999, 0.018891990000000001, 0.020531839999999999, 
	0.022184539999999999, 0.023850960000000001, 0.02553209, 
	0.027229079999999999, 0.02894323, 0.030676120000000001, 
	0.0013903979999999999, 0.0027870130000000001, 0.0041900779999999999, 
	0.0055998389999999997, 0.007016563, 0.0084405379999999992, 
	0.0098720760000000005, 0.01131152, 0.01275923, 0.01421561, 0.01568112, 
	0.017156230000000001, 0.01864151, 0.020137539999999999, 
	0.021645020000000001, 0.02316472, 0.024697520000000001, 
	0.026244420000000001, 0.027806600000000001, 0.02938545, 
	0.030982579999999999, 0.0012754439999999999, 0.0025563109999999999, 
	0.0038427969999999998, 0.0051351060000000004, 0.0064334630000000004, 
	0.0077381050000000003, 0.0090492920000000004, 0.010367299999999999, 
	0.01169244, 0.01302504, 0.01436546, 0.01571411, 0.017071409999999999, 
	0.018437869999999999, 0.019814020000000002, 0.021200489999999999, 
	0.02259796, 0.024007219999999999, 0.025429190000000001, 
	0.026864909999999999, 0.02831562, 0.029782800000000002, 
	0.031268219999999999, 0.0011782069999999999, 0.0023611930000000001, 
	0.003549122, 0.0047421679999999997, 0.0059405200000000003, 
	0.0071443779999999998, 0.0083539600000000006, 0.0095695009999999994, 
	0.01079125, 0.012019490000000001, 0.013254520000000001, 0.01449667, 
	0.01574629, 0.017003790000000001, 0.01826962, 0.019544260000000001, 
	0.020828280000000001, 0.022122309999999999, 0.023427050000000001, 
	0.024743350000000001, 0.026072140000000001, 0.027414569999999999, 
	0.028771959999999999, 0.030145930000000001, 0.031538459999999997, 
	0.0010948640000000001, 0.0021939730000000001, 0.0032974699999999998, 
	0.0044055029999999998, 0.0055182319999999997, 0.0066358290000000002, 
	0.0077584769999999997, 0.0088863770000000009, 0.010019739999999999, 
	0.0111588, 0.01230381, 0.01345504, 0.0146128, 0.015777409999999999, 
	0.016949249999999999, 0.018128709999999999, 0.019316259999999998, 
	0.0205124, 0.021717710000000001, 0.022932839999999999, 
	0.024158559999999999, 0.025395729999999998, 0.0266454, 
	0.027908780000000001, 0.029187359999999999, 0.030482970000000002, 
	0.031797880000000001, 0.0010226199999999999, 0.0020490399999999998, 
	0.0030793819999999999, 0.0041137769999999999, 0.0051523599999999999, 
	0.0061952800000000001, 0.007242694, 0.0082947720000000006, 
	0.0093516970000000008, 0.01041367, 0.011480890000000001, 0.01255361, 
	0.01363207, 0.01471655, 0.015807359999999999, 0.016904829999999999, 
	0.01800935, 0.019121320000000001, 0.020241209999999999, 
	0.021369570000000001, 0.022506999999999999, 0.023654189999999999, 
	0.024811960000000001, 0.025981259999999999, 0.027163219999999998, 
	0.028359220000000001, 0.02957094, 0.030800500000000001, 
	0.032050629999999997, 0.00095938550000000005, 0.001922195, 
	0.0028885349999999998, 0.0038585170000000001, 0.004832261, 
	0.0058098949999999998, 0.0067915550000000003, 0.0077773879999999997, 
	0.0087675500000000007, 0.0097622109999999998, 0.01076155, 0.01176578, 
	0.012775099999999999, 0.01378975, 0.01480998, 0.015836090000000001, 
	0.01686839, 0.017907220000000001, 0.01895297, 0.020006079999999999, 
	0.021067039999999999, 0.02213642, 0.023214869999999999, 
	0.024303140000000001, 0.02540212, 0.026512859999999999, 
	0.027636649999999999, 0.02877505, 0.029930040000000002, 0.03110417, 
	0.032300839999999997, 0.00090356729999999997, 0.0018102369999999999, 
	0.0027201019999999998, 0.0036332619999999999, 0.0045498190000000001, 
	0.0054698869999999997, 0.0063935830000000004, 0.0073210360000000004, 
	0.0082523809999999996, 0.0091877650000000005, 0.01012735, 
	0.011071289999999999, 0.012019790000000001, 0.01297304, 
	0.013931270000000001, 0.01489471, 0.015863619999999998, 
	0.016838309999999999, 0.017819089999999999, 0.018806320000000001, 
	0.019800419999999999, 0.020801859999999998, 0.02181114, 
	0.022828890000000001, 0.023855810000000002, 0.024892729999999998, 
	0.025940640000000001, 0.027000739999999999, 0.028074490000000001, 
	0.029163769999999999, 0.030270950000000001, 0.031399240000000002, 
	0.032553070000000003, 0.00085392699999999998, 0.00171068, 0.00257034, 
	0.003432994, 0.0042987340000000002, 0.0051676589999999998, 
	0.0060398730000000003, 0.0069154869999999997, 0.007794619, 
	0.0086773979999999994, 0.0095639609999999993, 0.01045446, 
	0.011349039999999999, 0.012247890000000001, 0.01315119, 
	0.014059159999999999, 0.014971999999999999, 0.015889980000000001, 
	0.016813359999999999, 0.017742460000000002, 0.018677599999999999, 
	0.019619190000000002, 0.020567640000000002, 0.021523460000000001, 
	0.022487210000000001, 0.023459569999999999, 0.024441299999999999, 
	0.025433359999999999, 0.026436850000000001, 0.027453180000000001, 
	0.02848409, 0.02953184, 0.03059945, 0.031691129999999998, 
	0.032813019999999998, 0.00080948870000000005, 0.001621562, 0.002436293, 
	0.0032537590000000002, 0.0040740409999999996, 0.0048972260000000002, 
	0.0057234060000000003, 0.0065526789999999996, 0.0073851489999999997, 
	0.0082209290000000001, 0.0090601380000000006, 0.009902905, 
	0.010749369999999999, 0.011599679999999999, 0.01245401, 0.01331252, 
	0.014175409999999999, 0.0150429, 0.015915209999999999, 
	0.016792609999999999, 0.017675389999999999, 0.018563860000000001, 
	0.019458380000000001, 0.020359370000000002, 0.021267299999999999, 
	0.0221827, 0.0231062, 0.024038549999999999, 0.02498061, 0.02593347, 
	0.026898430000000001, 0.02787715, 0.028871790000000001, 
	0.029885200000000001, 0.030921379999999998, 0.031986189999999998, 
	0.033088869999999999, 0.00076947199999999999, 0.0015413180000000001, 
	0.0023156040000000002, 0.0030923980000000001, 0.0038717729999999998, 
	0.0046538059999999999, 0.0054385780000000003, 0.0062261759999999999, 
	0.0070166930000000001, 0.0078102270000000003, 0.0086068840000000004, 
	0.0094067769999999998, 0.01021003, 0.01101677, 0.01182714, 
	0.012641299999999999, 0.01345941, 0.01428166, 0.01510824, 0.01593938, 
	0.01677532, 0.017616340000000001, 0.01846273, 0.019314850000000001, 
	0.020173070000000001, 0.02103785, 0.021909689999999999, 
	0.022789190000000001, 0.02367706, 0.024574120000000001, 0.02548139, 
	0.026400130000000001, 0.027331919999999999, 0.028278790000000002, 
	0.02924349, 0.030229820000000001, 0.031243380000000001, 0.03229303, 
	0.033394310000000003, 0.00073324580000000005, 0.0014686809999999999, 
	0.0022063640000000002, 0.0029463559999999998, 0.0036887220000000002, 
	0.0044335310000000001, 0.0051808560000000002, 0.0059307739999999998, 
	0.006683367, 0.007438722, 0.0081969339999999995, 0.0089581020000000008, 
	0.0097223329999999997, 0.010489739999999999, 0.01126046, 
	0.012034609999999999, 0.01281234, 0.01359382, 0.01437922, 0.01516872, 
	0.015962540000000001, 0.016760899999999999, 0.017564079999999999, 
	0.018372340000000001, 0.01918603, 0.020005519999999999, 
	0.020831209999999999, 0.021663600000000002, 0.022503260000000001, 
	0.023350860000000001, 0.02420719, 0.02507322, 0.02595014, 
	0.026839479999999999, 0.027743170000000001, 0.028663839999999999, 
	0.029605139999999999, 0.030572439999999999, 0.031574249999999998, 
	0.032625519999999998, 0.033757269999999999, 0.00070029399999999996, 
	0.0014026139999999999, 0.0021070120000000001, 0.0028135429999999999, 
	0.003522266, 0.0042332419999999999, 0.0049465380000000003, 
	0.0056622199999999999, 0.0063803649999999998, 0.0071010480000000004, 
	0.0078243540000000004, 0.0085503699999999998, 0.0092791929999999998, 
	0.01001092, 0.010745670000000001, 0.01148356, 0.01222471, 0.01296926, 
	0.01371737, 0.01446919, 0.015224919999999999, 0.015984740000000001, 
	0.016748889999999999, 0.017517600000000001, 0.018291160000000001, 
	0.019069869999999999, 0.01985408, 0.02064421, 0.0214407, 
	0.022244110000000001, 0.023055079999999999, 0.023874360000000001, 
	0.02470288, 0.0255418, 0.026392550000000001, 0.027257010000000002, 
	0.02813769, 0.029038109999999999, 0.029963449999999999, 0.03092189, 
	0.03192789, 0.033011390000000002, 0.034256509999999997, 
	0.00067019040000000001, 0.001342261, 0.0020162579999999999, 
	0.0026922339999999999, 0.0033702390000000001, 0.0040503300000000004, 
	0.0047325650000000002, 0.0054170060000000003, 0.0061037189999999996, 
	0.006792775, 0.007484246, 0.0081782130000000001, 0.0088747600000000006, 
	0.0095739780000000003, 0.010275960000000001, 0.010980820000000001, 
	0.01168866, 0.01239961, 0.0131138, 0.013831380000000001, 0.01455249, 
	0.01527732, 0.016006050000000001, 0.016738900000000001, 
	0.017476100000000001, 0.018217919999999999, 0.018964640000000001, 
	0.019716620000000001, 0.02047423, 0.02123792, 0.022008199999999999, 
	0.022785699999999999, 0.023571129999999999, 0.024365399999999999, 
	0.025169609999999999, 0.025985129999999999, 0.026813790000000001, 
	0.027657999999999999, 0.028521149999999999, 0.02940823, 
	0.030327179999999999, 0.031291989999999999, 0.03233171, 
	0.033527939999999999, 0.035405720000000002, 0.02129433, 
	0.0079639689999999996, 0.016001330000000001, 0.02411963, 
	0.0050294199999999997, 0.01009883, 0.01521084, 0.02036833, 0.02557454, 
	0.003703572, 0.0074333719999999997, 0.01119086, 0.014977620000000001, 
	0.01879544, 0.02264627, 0.026532300000000002, 0.0029407740000000002, 
	0.0059004529999999999, 0.008879985, 0.011880409999999999, 0.01490285, 
	0.017948579999999999, 0.021018970000000001, 0.024115569999999999, 
	0.02724012, 0.0024428639999999999, 0.0049001679999999999, 
	0.0073725819999999999, 0.0098608359999999996, 0.01236572, 
	0.014888119999999999, 0.017428989999999998, 0.019989389999999999, 
	0.0225705, 0.02517366, 0.02780034, 0.0020913540000000001, 
	0.0041941820000000003, 0.0063089829999999998, 0.0084362989999999995, 
	0.01057672, 0.01273088, 0.0148995, 0.017083339999999999, 0.01928326, 
	0.021500209999999999, 0.023735260000000001, 0.025989600000000002, 
	0.028264589999999999, 0.001829521, 0.0036684249999999999, 
	0.0055170979999999998, 0.0073759580000000002, 0.0092454579999999998, 
	0.01112609, 0.01301838, 0.014922940000000001, 0.01684039, 0.01877146, 
	0.020716930000000001, 0.022677699999999999, 0.02465475, 
	0.026649229999999999, 0.028662400000000001, 0.0016267059999999999, 
	0.0032612560000000001, 0.0049039569999999996, 0.0065551400000000001, 
	0.0082151619999999998, 0.0098844099999999997, 0.01156331, 0.01325231, 
	0.01495192, 0.016662699999999999, 0.018385240000000001, 
	0.020120240000000001, 0.021868450000000001, 0.023630709999999999, 
	0.025408, 0.027201409999999999, 0.029012199999999998, 
	0.0014648510000000001, 0.0029363729999999999, 0.0044148169999999997, 
	0.0059004519999999996, 0.007393564, 0.0088944680000000009, 0.0104035, 
	0.011921030000000001, 0.01344745, 0.01498321, 0.016528790000000002, 
	0.01808471, 0.019651579999999998, 0.02123005, 0.022820859999999998, 
	0.02442486, 0.026043, 0.027676369999999999, 0.029326270000000002, 
	0.0013326099999999999, 0.0026709749999999999, 0.0040153029999999996, 
	0.0053658150000000003, 0.0067227479999999997, 0.0080863580000000001, 
	0.0094569219999999996, 0.010834740000000001, 0.012220129999999999, 
	0.013613460000000001, 0.01501511, 0.016425510000000001, 
	0.017845130000000001, 0.019274489999999998, 0.02071419, 0.02216487, 
	0.023627280000000001, 0.025102280000000001, 0.026590820000000001, 
	0.028094049999999999, 0.029613299999999999, 0.0012224899999999999, 
	0.002450004, 0.003682715, 0.0049208089999999999, 0.0061644830000000001, 
	0.0074139519999999997, 0.0086694440000000001, 0.0099312080000000004, 
	0.011199509999999999, 0.01247465, 0.013756930000000001, 0.01504672, 
	0.016344379999999999, 0.017650349999999999, 0.018965099999999999, 
	0.020289149999999999, 0.021623090000000001, 0.02296759, 0.02432341, 
	0.02569142, 0.02707265, 0.028468279999999999, 0.02987973, 
	0.0011293379999999999, 0.0022631050000000001, 0.0034014480000000001, 
	0.0045445240000000003, 0.0056924999999999996, 0.0068455570000000004, 
	0.0080038869999999995, 0.0091676989999999996, 0.010337219999999999, 
	0.011512680000000001, 0.01269436, 0.01388255, 0.01507755, 
	0.016279720000000001, 0.017489439999999998, 0.018707129999999999, 
	0.019933280000000001, 0.021168409999999999, 0.022413140000000002, 
	0.023668160000000001, 0.024934250000000002, 0.026212349999999999, 
	0.027503530000000002, 0.028809089999999999, 0.030130580000000001, 
	0.001049492, 0.0021029220000000001, 0.0031604160000000001, 
	0.0042221070000000001, 0.0052881389999999999, 0.0063586670000000001, 
	0.0074338520000000003, 0.0085138739999999994, 0.0095989200000000004, 
	0.010689199999999999, 0.011784930000000001, 0.01288635, 
	0.013993729999999999, 0.01510737, 0.016227559999999999, 
	0.017354680000000001, 0.018489100000000001, 0.019631260000000001, 
	0.02078166, 0.021940850000000001, 0.02310945, 0.024288210000000001, 
	0.025477960000000001, 0.026679689999999999, 0.027894599999999999, 
	0.0291241, 0.03036997, 0.00098027750000000006, 0.0019640809999999999, 
	0.00295152, 0.0039427109999999998, 0.004937777, 0.0059368499999999996, 
	0.0069400709999999999, 0.0079475919999999999, 0.0089595739999999997, 
	0.009976192, 0.010997639999999999, 0.012024109999999999, 
	0.013055840000000001, 0.014093069999999999, 0.01513605, 
	0.016185100000000001, 0.017240519999999999, 0.018302680000000002, 
	0.019371989999999999, 0.020448879999999999, 0.02153389, 
	0.022627580000000001, 0.023730629999999999, 0.024843830000000001, 
	0.025968080000000001, 0.0271045, 0.028254379999999999, 0.02941937, 
	0.03060152, 0.00091969250000000001, 0.001842563, 0.0027687079999999999, 
	0.0036982270000000001, 0.0046312289999999997, 0.005567827, 
	0.0065081440000000004, 0.0074523109999999997, 0.0084004679999999995, 
	0.0093527639999999995, 0.01030936, 0.01127044, 0.012236179999999999, 
	0.013206799999999999, 0.014182510000000001, 0.015163569999999999, 
	0.016150250000000001, 0.017142850000000001, 0.0181417, 0.01914718, 
	0.020159699999999999, 0.021179739999999999, 0.022207850000000001, 
	0.02324464, 0.024290849999999999, 0.025347330000000001, 
	0.026415089999999999, 0.027495370000000002, 0.028589690000000001, 
	0.029699949999999999, 0.030828629999999999, 0.00086621080000000002, 
	0.0017353030000000001, 0.00260736, 0.0034824700000000001, 
	0.0043607280000000003, 0.0052422340000000001, 0.0061270939999999996, 
	0.0070154220000000003, 0.0079073400000000005, 0.0088029779999999995, 
	0.0097024769999999993, 0.010605989999999999, 0.01151367, 0.01242571, 
	0.01334229, 0.014263619999999999, 0.015189940000000001, 0.0161215, 
	0.017058569999999999, 0.01800148, 0.01895057, 0.019906219999999999, 
	0.020868899999999999, 0.021839089999999999, 0.02281739, 
	0.023804479999999999, 0.024801150000000001, 0.025808359999999999, 
	0.026827259999999999, 0.02785928, 0.0289062, 0.02997035, 
	0.031054809999999999, 0.00081864679999999997, 0.0016399190000000001, 
	0.0024638889999999999, 0.0032906369999999999, 0.0041202449999999998, 
	0.0049528020000000001, 0.0057884, 0.0066271400000000001, 
	0.0074691280000000002, 0.0083144780000000001, 0.0091633119999999998, 
	0.01001576, 0.01087197, 0.011732080000000001, 0.01259627, 
	0.013464719999999999, 0.014337620000000001, 0.01521518, 0.01609766, 
	0.016985299999999998, 0.017878399999999999, 0.0187773, 
	0.019682350000000001, 0.02059397, 0.021512650000000001, 
	0.022438920000000001, 0.023373430000000001, 0.024316939999999999, 
	0.025270330000000001, 0.026234690000000001, 0.02721138, 
	0.028202060000000001, 0.029208939999999999, 0.03023493, 
	0.031284090000000001, 0.00077606569999999996, 0.001554534, 
	0.0023354700000000001, 0.0031189439999999998, 0.003905029, 
	0.0046938040000000002, 0.0054853499999999999, 0.0062797560000000001, 
	0.0070771159999999996, 0.0078775300000000006, 0.0086811030000000008, 
	0.0094879530000000004, 0.0102982, 0.01111198, 0.011929439999999999, 
	0.01275072, 0.013576009999999999, 0.01440548, 0.01523935, 
	0.016077830000000001, 0.016921169999999999, 0.017769650000000001, 
	0.018623569999999999, 0.019483279999999999, 0.02034919, 
	0.021221719999999999, 0.022101409999999998, 0.02298886, 
	0.023884780000000001, 0.024790019999999999, 0.025705599999999999, 
	0.02663279, 0.027573199999999999, 0.028528899999999999, 
	0.029502670000000002, 0.030498359999999999, 0.03152166, 
	0.00073772029999999997, 0.001477648, 0.002219843, 0.002964366, 
	0.0037112830000000001, 0.0044606639999999996, 0.005212581, 
	0.0059671139999999999, 0.0067243440000000002, 0.0074843610000000001, 
	0.0082472589999999998, 0.0090131380000000004, 0.0097821060000000005, 
	0.010554279999999999, 0.011329789999999999, 0.01210876, 
	0.012891349999999999, 0.013677720000000001, 0.01446803, 0.01526249, 
	0.016061309999999999, 0.016864710000000002, 0.017672960000000001, 
	0.018486349999999999, 0.01930521, 0.020129919999999999, 
	0.020960889999999999, 0.021798629999999999, 0.022643690000000001, 
	0.02349677, 0.024358660000000001, 0.025230329999999999, 
	0.026113009999999999, 0.0270082, 0.027917899999999999, 
	0.028844729999999999, 0.029792389999999998, 0.030766310000000002, 
	0.031775079999999997, 0.00070300600000000005, 0.0014080480000000001, 
	0.0021151799999999999, 0.0028244559999999999, 0.0035359359999999999, 
	0.0042496820000000003, 0.0049657579999999998, 0.0056842350000000002, 
	0.0064051869999999997, 0.0071286919999999998, 0.0078548330000000003, 
	0.0085836999999999997, 0.0093153880000000008, 0.01005, 
	0.010787649999999999, 0.011528450000000001, 0.01227253, 0.01302003, 
	0.01377111, 0.014525929999999999, 0.01528467, 0.016047530000000001, 
	0.016814740000000002, 0.017586540000000001, 0.018363210000000001, 
	0.01914507, 0.019932459999999999, 0.020725790000000001, 
	0.021525530000000001, 0.02233222, 0.02314652, 0.02396918, 
	0.024801130000000001, 0.025643530000000001, 0.026497840000000002, 
	0.02736595, 0.02825037, 0.029154659999999999, 0.030084, 0.03104668, 
	0.032057219999999997, 0.00067142860000000005, 0.0013447419999999999, 
	0.002019987, 0.0026972150000000002, 0.0033764789999999999, 
	0.0040578330000000003, 0.004741337, 0.0054270519999999999, 
	0.0061150459999999998, 0.0068053879999999999, 0.0074981520000000001, 
	0.0081934179999999992, 0.0088912709999999992, 0.009591802, 0.01029511, 
	0.01100129, 0.011710470000000001, 0.01242276, 0.01313831, 0.01385724, 
	0.014579719999999999, 0.015305930000000001, 0.016036060000000001, 
	0.01677031, 0.017508920000000001, 0.01825216, 0.019000329999999999, 
	0.019753759999999999, 0.020512829999999999, 0.02127801, 
	0.022049800000000001, 0.02282882, 0.023615799999999999, 
	0.024411639999999998, 0.025217440000000001, 0.02603459, 0.02686492, 
	0.02771084, 0.02857575, 0.029464669999999998, 0.030385550000000001, 
	0.031352440000000002, 0.032394529999999998, 0.00064257970000000002, 
	0.0012869089999999999, 0.001933031, 0.0025809919999999998, 
	0.0032308380000000002, 0.0038826199999999998, 0.0045363909999999999, 
	0.0051922069999999999, 0.0058501279999999996, 0.0065102149999999998, 
	0.0071725360000000002, 0.0078371619999999999, 0.0085041679999999994, 
	0.0091736349999999994, 0.0098456499999999992, 0.0105203, 0.0111977, 
	0.01187794, 0.01256115, 0.013247449999999999, 0.01393698, 0.01462988, 
	0.015326340000000001, 0.016026519999999999, 0.01673063, 0.0174389, 
	0.01815158, 0.018868940000000001, 0.019591330000000001, 0.0203191, 
	0.021052680000000001, 0.021792570000000001, 0.02253937, 
	0.023293769999999998, 0.024056629999999999, 0.024829009999999999, 
	0.02561225, 0.0264081, 0.027218889999999999, 0.028047909999999999, 
	0.02889999, 0.02978283, 0.030710020000000001, 0.031709830000000001, 
	0.032861899999999999, 0.00061611900000000004, 0.001233867, 0.001853284, 
	0.0024744089999999999, 0.0030972880000000001, 0.0037219639999999999, 
	0.0043484860000000004, 0.0049769050000000002, 0.0056072730000000003, 
	0.0062396480000000004, 0.0068740880000000004, 0.0075106590000000003, 
	0.0081494280000000002, 0.0087904660000000003, 0.0094338500000000006, 
	0.010079670000000001, 0.010728, 0.011378940000000001, 
	0.012032609999999999, 0.0126891, 0.013348540000000001, 
	0.014011060000000001, 0.01467681, 0.015345940000000001, 
	0.016018629999999999, 0.016695069999999999, 0.017375479999999999, 
	0.018060099999999999, 0.018749200000000001, 0.01944309, 
	0.020142130000000001, 0.020846730000000001, 0.021557369999999999, 
	0.022274599999999999, 0.022999120000000001, 0.023731740000000001, 
	0.024473490000000001, 0.025225649999999999, 0.02598992, 0.02676854, 
	0.027564700000000001, 0.02838307, 0.029231119999999999, 
	0.030122050000000001, 0.031083340000000001, 0.032192419999999999, 
	0.033948220000000001, 0.020425169999999999, 0.0076405550000000003, 
	0.01534871, 0.02313113, 0.0048259030000000003, 0.0096886880000000009, 
	0.01459066, 0.019534369999999999, 0.024522639999999998, 0.003554125, 
	0.007132467, 0.010736320000000001, 0.014367090000000001, 0.01802633, 
	0.02171578, 0.025437330000000001, 0.0028223839999999998, 
	0.0056622390000000003, 0.0085204100000000008, 0.01139781, 
	0.014295459999999999, 0.017214440000000001, 0.020155969999999999, 
	0.023121409999999998, 0.02611225, 0.0023447139999999999, 
	0.0047027859999999996, 0.0070748119999999998, 0.0094614420000000005, 
	0.01186338, 0.01428139, 0.016716330000000001, 0.019169120000000001, 
	0.021640800000000002, 0.024132500000000001, 0.026645519999999999, 
	0.0020074730000000001, 0.0040255689999999997, 0.0060547329999999996, 
	0.0080954479999999999, 0.010148239999999999, 0.012213669999999999, 
	0.01429236, 0.016385, 0.01849232, 0.020615169999999999, 
	0.022754460000000001, 0.024911220000000001, 0.027086610000000001, 
	0.001756255, 0.0035212030000000001, 0.00529519, 0.0070785889999999997, 
	0.0088718019999999998, 0.010675270000000001, 0.012489449999999999, 
	0.01431488, 0.016152119999999999, 0.01800179, 0.019864590000000001, 
	0.02174127, 0.023632710000000001, 0.025539849999999999, 
	0.027463789999999998, 0.0015616510000000001, 0.003130575, 
	0.0047070469999999998, 0.0062913630000000003, 0.0078838420000000003, 
	0.0094848269999999995, 0.011094690000000001, 0.012713840000000001, 
	0.01434272, 0.015981809999999999, 0.017631649999999999, 0.01929283, 
	0.02096599, 0.022651879999999999, 0.024351310000000001, 0.02606522, 
	0.027794659999999999, 0.0014063420000000001, 0.0028188739999999999, 
	0.0042378199999999998, 0.0056634210000000001, 0.0070959350000000003, 
	0.0085356389999999994, 0.0099828339999999995, 0.011437849999999999, 
	0.012901030000000001, 0.01437276, 0.01585348, 0.01734364, 
	0.018843749999999999, 0.020354400000000002, 0.02187621, 
	0.023409900000000001, 0.024956280000000001, 0.02651628, 
	0.028090960000000002, 0.0012794429999999999, 0.0025642299999999998, 
	0.0038545459999999999, 0.00515059, 0.006452574, 0.0077607270000000003, 
	0.0090752950000000006, 0.010396539999999999, 0.011724760000000001, 
	0.013060260000000001, 0.01440338, 0.015754509999999999, 
	0.017114040000000001, 0.018482430000000001, 0.019860200000000001, 
	0.0212479, 0.02264617, 0.024055719999999999, 0.025477380000000001, 
	0.02691209, 0.028360940000000001, 0.001173767, 0.0023522009999999999, 
	0.0035354589999999999, 0.0047237049999999999, 0.0059171179999999999, 
	0.0071158899999999997, 0.0083202239999999993, 0.00953034, 
	0.010746479999999999, 0.011968899999999999, 0.01319788, 
	0.014433720000000001, 0.01567677, 0.01692739, 0.018185989999999999, 
	0.019453020000000001, 0.020728989999999999, 0.022014470000000001, 
	0.0233101, 0.024616619999999999, 0.025934869999999999, 
	0.027265830000000001, 0.02861066, 0.001084371, 0.0021728580000000002, 
	0.003265595, 0.004362721, 0.0054643879999999997, 0.006570757, 
	0.0076819999999999996, 0.0087983030000000004, 0.0099198649999999999, 
	0.0110469, 0.01217965, 0.01331836, 0.01446331, 0.01561481, 0.01677319, 
	0.017938820000000001, 0.0191121, 0.020293510000000001, 
	0.021483550000000001, 0.022682810000000001, 0.02389196, 0.02511176, 
	0.026343100000000001, 0.02758704, 0.02884482, 0.0010077420000000001, 
	0.002019145, 0.0030343229999999998, 0.0040533970000000002, 
	0.0050764970000000001, 0.0061037599999999997, 0.0071353320000000003, 
	0.0081713719999999997, 0.0092120480000000005, 0.010257540000000001, 
	0.01130806, 0.012363799999999999, 0.013425009999999999, 0.01449193, 
	0.01556485, 0.016644059999999999, 0.01772992, 0.018822789999999999, 
	0.019923090000000001, 0.021031299999999999, 0.02214795, 0.02327365, 
	0.024409110000000001, 0.025555129999999999, 0.026712679999999999, 
	0.02788291, 0.02906719, 0.00094131209999999996, 0.001885905, 
	0.0028338769999999998, 0.0037853330000000001, 0.0047403849999999997, 
	0.00569915, 0.0066617559999999996, 0.0076283380000000001, 
	0.0085990400000000005, 0.0095740200000000008, 0.010553440000000001, 
	0.011537489999999999, 0.01252637, 0.013520280000000001, 0.01451946, 
	0.01552416, 0.01653468, 0.017551319999999999, 0.018574420000000001, 
	0.019604369999999999, 0.020641619999999999, 0.02168664, 
	0.022740010000000001, 0.02380237, 0.024874480000000001, 0.02595722, 
	0.027051660000000002, 0.02815906, 0.029281000000000001, 
	0.00088316329999999995, 0.001769285, 0.002658451, 0.0035507529999999998,
	0.0044462879999999996, 0.0053451590000000004, 0.0062474749999999997, 
	0.0071533539999999998, 0.0080629210000000007, 0.0089763099999999995, 
	0.0098936660000000006, 0.010815140000000001, 0.01174091, 
	0.012671150000000001, 0.01360607, 0.014545870000000001, 
	0.015490790000000001, 0.0164411, 0.01739709, 0.018359070000000002, 
	0.01932741, 0.020302509999999999, 0.021284830000000001, 0.02227488, 
	0.02327328, 0.024280719999999999, 0.025298029999999999, 
	0.026326200000000001, 0.027366399999999999, 0.028420109999999998, 
	0.02948918, 0.00083183040000000001, 0.0016663439999999999, 
	0.0025036149999999998, 0.003343726, 0.0041867609999999998, 
	0.0050328090000000001, 0.0058819679999999996, 0.0067343389999999998, 
	0.0075900300000000002, 0.0084491600000000007, 0.0093118520000000007, 
	0.01017824, 0.011048469999999999, 0.0119227, 0.012801099999999999, 
	0.013683860000000001, 0.01457117, 0.01546325, 0.016360360000000001, 
	0.01726275, 0.018170740000000001, 0.019084650000000002, 
	0.020004859999999999, 0.0209318, 0.021865969999999998, 
	0.022807910000000001, 0.023758290000000001, 0.024717880000000001, 
	0.02568759, 0.026668549999999999, 0.02766213, 0.028670060000000001, 
	0.02969459, 0.00078617590000000005, 0.001574797, 0.0023659309999999999, 
	0.0031596469999999998, 0.003956022, 0.0047551349999999997, 
	0.0055570699999999999, 0.0063619169999999999, 0.0071697699999999998, 
	0.0079807339999999997, 0.0087949150000000004, 0.0096124330000000001, 
	0.010433410000000001, 0.011257990000000001, 0.012086299999999999, 
	0.012918529999999999, 0.013754819999999999, 0.01459539, 0.01544042, 
	0.016290160000000001, 0.017144840000000001, 0.01800477, 0.01887024, 
	0.019741620000000001, 0.0206193, 0.02150374, 0.022395479999999999, 
	0.023295119999999999, 0.0242034, 0.02512118, 0.026049510000000001, 
	0.026989679999999999, 0.027943340000000001, 0.0289126, 
	0.029900280000000001, 0.000745303, 0.001492845, 0.0022426849999999999, 
	0.0029948869999999999, 0.003749517, 0.0045066459999999996, 
	0.0052663479999999997, 0.0060287020000000004, 0.0067937930000000002, 
	0.0075617100000000001, 0.0083325489999999999, 0.0091064130000000007, 
	0.0098834109999999999, 0.01066366, 0.011447300000000001, 
	0.012234449999999999, 0.01302526, 0.013819909999999999, 
	0.014618569999999999, 0.01542143, 0.016228719999999999, 
	0.017040659999999999, 0.017857520000000002, 0.018679600000000001, 
	0.01950723, 0.020340790000000001, 0.02118072, 0.02202751, 
	0.022881740000000001, 0.023744109999999999, 0.024615419999999999, 
	0.025496680000000001, 0.02638911, 0.027294249999999999, 
	0.028214119999999999, 0.029151409999999999, 0.030109859999999999, 
	0.0007084948, 0.001419048, 0.002131712, 0.0028465449999999998, 
	0.0035636050000000001, 0.0042829540000000003, 0.0050046609999999997, 
	0.0057287939999999997, 0.006455428, 0.0071846430000000001, 0.007916523, 
	0.0086511599999999998, 0.0093886479999999994, 0.01012909, 0.01087261, 
	0.011619310000000001, 0.01236933, 0.01312281, 0.013879900000000001, 
	0.014640780000000001, 0.01540562, 0.016174629999999999, 
	0.016948029999999999, 0.01772609, 0.018509060000000001, 0.01929728, 
	0.020091100000000001, 0.020890929999999999, 0.02169724, 0.02251059, 
	0.023331620000000001, 0.024161120000000001, 0.025000020000000001, 
	0.025849489999999999, 0.026711019999999999, 0.0275865, 0.0284785, 
	0.029390599999999999, 0.030328089999999999, 0.00067517130000000001, 
	0.001352242, 0.0020312590000000001, 0.0027122740000000002, 
	0.0033953410000000001, 0.0040805140000000004, 0.0047678529999999998, 
	0.005457422, 0.0061492860000000003, 0.006843516, 0.0075401879999999998, 
	0.008239382, 0.0089411820000000006, 0.0096456809999999997, 
	0.010352979999999999, 0.011063180000000001, 0.011776389999999999, 
	0.01249275, 0.013212369999999999, 0.01393542, 0.014662049999999999, 
	0.01539243, 0.01612676, 0.016865249999999998, 0.017608140000000001, 
	0.018355690000000001, 0.01910821, 0.01986603, 0.02062955, 
	0.021399209999999998, 0.022175549999999999, 0.022959170000000001, 
	0.023750830000000001, 0.024551420000000001, 0.025362050000000001, 
	0.02618413, 0.02701949, 0.027870579999999999, 0.028740829999999998, 
	0.029635310000000002, 0.030562039999999999, 0.00064485810000000003, 
	0.001291475, 0.0019398919999999999, 0.002590158, 0.0032423180000000001, 
	0.003896423, 0.0045525280000000001, 0.0052106870000000003, 
	0.0058709610000000001, 0.0065334130000000001, 0.0071981099999999998, 
	0.0078651220000000004, 0.0085345270000000001, 0.0092064050000000008, 
	0.0098808430000000003, 0.01055794, 0.011237779999999999, 
	0.011920490000000001, 0.01260618, 0.01329497, 0.013987009999999999, 
	0.01468245, 0.01538145, 0.0160842, 0.016790900000000001, 
	0.017501780000000002, 0.01821708, 0.01893711, 0.01966217, 
	0.020392649999999998, 0.021128979999999999, 0.021871640000000001, 
	0.022621249999999999, 0.0233785, 0.024144249999999999, 0.02491958, 
	0.025705829999999999, 0.026504750000000001, 0.027318700000000001, 
	0.028150970000000001, 0.02900643, 0.029892829999999999, 
	0.030823860000000002, 0.00061716349999999995, 0.0012359599999999999, 
	0.001856428, 0.00247861, 0.003102549, 0.00372829, 0.0043558800000000003,
	0.0049853720000000001, 0.005616818, 0.0062502759999999999, 
	0.0068858039999999997, 0.0075234669999999998, 0.0081633339999999995, 
	0.0088054750000000001, 0.0094499690000000008, 0.010096900000000001, 
	0.01074635, 0.011398419999999999, 0.01205322, 0.012710849999999999, 
	0.01337144, 0.01403512, 0.01470203, 0.01537233, 0.0160462, 
	0.016723829999999999, 0.017405440000000001, 0.018091260000000001, 
	0.018781590000000001, 0.019476710000000001, 0.020177, 0.02088286, 
	0.021594769999999999, 0.02231329, 0.02303912, 0.02377307, 0.02451617, 
	0.025269719999999999, 0.026035389999999999, 0.026815459999999999, 
	0.02761311, 0.02843304, 0.02928273, 0.03017541, 0.03113871, 0.000591761,
	0.001185043, 0.0017798810000000001, 0.0023763130000000001, 
	0.0029743780000000002, 0.0035741179999999998, 0.0041755749999999999, 
	0.0047787970000000004, 0.00538383, 0.005990726, 0.0065995389999999998, 
	0.0072103260000000004, 0.0078231489999999997, 0.0084380719999999996, 
	0.0090551629999999998, 0.0096744980000000001, 0.01029616, 0.01092022, 
	0.01154678, 0.01217594, 0.012807799999999999, 0.01344249, 0.01408011, 
	0.014720830000000001, 0.01536478, 0.016012129999999999, 0.01666308, 
	0.017317820000000001, 0.017976590000000001, 0.018639650000000001, 
	0.019307310000000001, 0.01997989, 0.0206578, 0.021341499999999999, 
	0.022031530000000001, 0.022728539999999998, 0.023433329999999999, 
	0.024146890000000001, 0.024870469999999999, 0.02560569, 
	0.026354740000000001, 0.027120700000000001, 0.027908120000000002, 
	0.028724240000000002, 0.029581920000000001, 0.030507969999999999, 
	0.031578059999999998, 0.00056837649999999995, 0.0011381729999999999, 
	0.0017094219999999999, 0.0022821579999999998, 0.0028564160000000001, 
	0.0034322340000000002, 0.0040096519999999998, 0.0045887100000000002, 
	0.0051694530000000001, 0.0057519270000000004, 0.0063361809999999998, 
	0.0069222659999999998, 0.0075102370000000003, 0.0081001530000000006, 
	0.0086920750000000005, 0.0092860689999999992, 0.0098822059999999993, 
	0.01048056, 0.011081219999999999, 0.01168426, 0.01228979, 0.0128979, 
	0.01350871, 0.014122330000000001, 0.014738899999999999, 0.01535857, 
	0.015981490000000001, 0.01660785, 0.017237840000000001, 
	0.017871689999999999, 0.018509649999999999, 0.019151999999999999, 
	0.019799069999999998, 0.020451250000000001, 0.021108970000000001, 
	0.02177277, 0.022443270000000001, 0.02312123, 0.023807620000000002, 
	0.024503629999999998, 0.02521085, 0.025931389999999999, 
	0.026668230000000001, 0.027425789999999999, 0.028211110000000001, 
	0.029036699999999999, 0.029928679999999999, 0.030960769999999999, 
	0.032608619999999998, 0.01962419, 0.0073423860000000002, 0.01474725, 
	0.022220469999999999, 0.0046382200000000002, 0.0093105630000000009, 
	0.01401908, 0.018766020000000001, 0.023553890000000001, 
	0.0034162770000000001, 0.0068549800000000001, 0.01031726, 0.01380438, 
	0.01731771, 0.02085876, 0.02442921, 0.0027131619999999999, 
	0.0054425209999999996, 0.0081888289999999999, 0.0109529, 0.01373564, 
	0.016538000000000001, 0.019361070000000001, 0.02220602, 0.02507417, 
	0.0022541530000000001, 0.0045206980000000001, 0.0068001709999999998, 
	0.009093149, 0.011400260000000001, 0.01372219, 0.01605968, 
	0.018413550000000001, 0.0207847, 0.023174139999999999, 
	0.025582980000000002, 0.0019300680000000001, 0.0038699989999999998, 
	0.0058201920000000001, 0.0077810800000000001, 0.0097531279999999998, 
	0.01173684, 0.01373277, 0.015741519999999998, 0.01776374, 
	0.019800160000000001, 0.021851579999999999, 0.023918910000000002, 
	0.026003120000000001, 0.001688637, 0.0033853519999999999, 
	0.0050904549999999998, 0.0068042800000000002, 0.0085271870000000003, 
	0.010259559999999999, 0.01200183, 0.01375445, 0.015517919999999999, 
	0.017292789999999999, 0.019079659999999998, 0.020879200000000001, 
	0.022692150000000001, 0.024519349999999999, 0.026361720000000002, 
	0.0015016070000000001, 0.0030099760000000001, 0.004525355, 0.006048009, 
	0.0075782239999999997, 0.0091163070000000006, 0.01066259, 0.01221743, 
	0.01378123, 0.015354410000000001, 0.01693743, 0.01853082, 
	0.020135139999999999, 0.021751030000000001, 0.023379190000000001, 
	0.02502043, 0.02667564, 0.0013523350000000001, 0.0027104289999999999, 
	0.0040744839999999997, 0.0054447159999999996, 0.0068213570000000001, 
	0.0082046549999999999, 0.0095948779999999994, 0.01099232, 0.01239728, 
	0.01381012, 0.0152312, 0.016660930000000001, 0.018099759999999999, 
	0.019548179999999998, 0.021006759999999999, 0.022476099999999999, 
	0.023956890000000002, 0.025449929999999999, 0.026956109999999998, 
	0.0012303640000000001, 0.0024657020000000002, 0.0037061820000000001, 
	0.0049519830000000001, 0.0062032959999999996, 0.0074603239999999999, 
	0.0087232899999999999, 0.0099924300000000001, 0.011268, 0.01255028, 
	0.013839560000000001, 0.015136190000000001, 0.01644052, 
	0.017752939999999998, 0.019073900000000001, 0.020403890000000001, 
	0.021743450000000001, 0.02309319, 0.024453809999999999, 
	0.025826109999999999, 0.027210979999999999, 0.001128787, 0.002261922, 
	0.003399544, 0.004541804, 0.0056888609999999999, 0.0068408879999999998, 
	0.0079980669999999993, 0.009160596, 0.01032869, 0.01150257, 
	0.012682489999999999, 0.013868729999999999, 0.01506157, 
	0.016261339999999999, 0.017468399999999999, 0.018683140000000001, 
	0.019906, 0.02113746, 0.022378080000000002, 0.02362848, 
	0.024889370000000001, 0.026161569999999999, 0.02744603, 0.001042856, 
	0.0020895480000000001, 0.003140196, 0.0041949270000000002, 
	0.0052538769999999997, 0.0063171909999999998, 0.0073850239999999996, 
	0.0084575420000000002, 0.0095349240000000002, 0.010617359999999999, 
	0.01170506, 0.012798250000000001, 0.01389718, 0.015002100000000001, 
	0.016113329999999999, 0.017231159999999999, 0.018355980000000001, 
	0.019488160000000001, 0.020628150000000001, 0.021776460000000001, 
	0.02293365, 0.02410035, 0.025277319999999999, 0.026465410000000002, 
	0.027665639999999998, 0.00096919360000000002, 0.0019418009999999999, 
	0.002917925, 0.0038976750000000002, 0.004881168, 0.0058685270000000001, 
	0.0068598859999999999, 0.007855384, 0.0088551740000000004, 
	0.0098594200000000007, 0.010868289999999999, 0.01188199, 
	0.012900709999999999, 0.01392468, 0.014954149999999999, 
	0.015989380000000001, 0.01703066, 0.01807833, 0.01913275, 0.02019431, 
	0.021263480000000001, 0.022340780000000001, 0.023426780000000001, 
	0.024522180000000001, 0.025627759999999999, 0.026744449999999999, 
	0.027873350000000002, 0.0009053342, 0.0018137279999999999, 
	0.0027252719999999999, 0.0036400600000000001, 0.0045581930000000003, 
	0.0054797789999999997, 0.0064049299999999997, 0.0073337680000000001, 
	0.0082664239999999996, 0.0092030370000000007, 0.01014376, 0.01108875, 
	0.012038180000000001, 0.01299224, 0.013951150000000001, 
	0.014915110000000001, 0.015884390000000002, 0.016859249999999999, 
	0.01783999, 0.018826949999999999, 0.01982049, 0.020821050000000001, 
	0.021829089999999999, 0.02284516, 0.023869890000000001, 
	0.024903999999999999, 0.025948349999999998, 0.027003969999999999, 
	0.028072090000000001, 0.00084943319999999998, 0.001701627, 
	0.0025566600000000001, 0.0034146139999999998, 0.0042755780000000004, 
	0.0051396439999999996, 0.0060069119999999997, 0.0068774860000000004, 
	0.0077514799999999998, 0.0086290140000000008, 0.0095102169999999996, 
	0.01039523, 0.011284189999999999, 0.01217728, 0.01307466, 
	0.013976529999999999, 0.01488309, 0.015794570000000001, 
	0.016711230000000001, 0.017633340000000001, 0.018561210000000002, 
	0.019495189999999999, 0.02043567, 0.02138309, 0.02233796, 
	0.023300850000000001, 0.024272439999999999, 0.025253540000000001, 
	0.026245089999999999, 0.027248250000000002, 0.028264439999999998, 
	0.00080008300000000004, 0.001602671, 0.0024078319999999999, 
	0.0032156390000000002, 0.0040261699999999999, 0.004839505, 
	0.0056557320000000001, 0.0064749430000000004, 0.007297235, 
	0.0081227130000000002, 0.0089514899999999994, 0.0097836850000000003, 
	0.010619429999999999, 0.01145886, 0.01230213, 0.0131494, 0.01400085, 
	0.014856670000000001, 0.015717080000000001, 0.016582300000000001, 
	0.017452619999999999, 0.018328290000000001, 0.019209670000000002, 
	0.0200971, 0.020990999999999999, 0.021891830000000001, 0.02280016, 
	0.023716600000000001, 0.02464191, 0.025576970000000001, 
	0.026522859999999999, 0.027480919999999999, 0.028452829999999998, 
	0.00075619079999999996, 0.0015146649999999999, 0.0022754839999999999, 
	0.0030387130000000002, 0.0038044179999999999, 0.0045726730000000002, 
	0.0053435519999999997, 0.0061171389999999997, 0.006893517, 
	0.0076727799999999997, 0.0084550249999999997, 0.0092403569999999994, 
	0.01002889, 0.010820740000000001, 0.011616039999999999, 
	0.012414939999999999, 0.01321757, 0.014024119999999999, 
	0.014834770000000001, 0.015649699999999999, 0.016469149999999998, 
	0.017293349999999999, 0.018122579999999999, 0.018957149999999999, 
	0.01979738, 0.020643669999999999, 0.021496459999999998, 
	0.022356270000000001, 0.02322368, 0.0240994, 0.024984269999999999, 
	0.025879300000000001, 0.026785750000000001, 0.027705199999999999, 
	0.028639709999999999, 0.00071689439999999996, 0.0014358800000000001, 
	0.0021570119999999998, 0.002880348, 0.003605947, 0.0043338739999999997, 
	0.005064196, 0.0057969839999999998, 0.0065323159999999998, 0.007270271, 
	0.0080109359999999998, 0.0087544019999999997, 0.0095007700000000004, 
	0.01025014, 0.011002629999999999, 0.011758370000000001, 
	0.012517479999999999, 0.0132801, 0.01404641, 0.014816559999999999, 
	0.015590740000000001, 0.016369160000000001, 0.01715206, 0.01793968, 
	0.018732309999999999, 0.019530269999999999, 0.02033393, 0.02114371, 
	0.021960090000000002, 0.022783620000000001, 0.023614980000000001, 
	0.02445495, 0.025304489999999999, 0.026164799999999998, 0.02703738, 
	0.027924170000000002, 0.028827780000000001, 0.00068150489999999997, 
	0.001364933, 0.002050334, 0.0027377579999999999, 0.0034272600000000001, 
	0.0041188960000000004, 0.0048127270000000002, 0.0055088150000000002, 
	0.0062072300000000002, 0.0069080419999999997, 0.0076113270000000002, 
	0.0083171670000000003, 0.0090256490000000002, 0.0097368650000000008, 
	0.010450910000000001, 0.01116791, 0.01188795, 0.01261118, 
	0.013337730000000001, 0.01406775, 0.014801389999999999, 0.01553883, 
	0.016280280000000001, 0.01702594, 0.017776070000000001, 
	0.018530919999999999, 0.0192908, 0.020056060000000001, 
	0.020827100000000001, 0.021604370000000001, 0.022388399999999999, 
	0.023179829999999998, 0.02397939, 0.024788020000000001, 
	0.025606830000000001, 0.026437260000000001, 0.027281159999999999, 
	0.028141010000000001, 0.029020310000000001, 0.000649465, 
	0.0013007050000000001, 0.0019537650000000001, 0.0026086899999999999, 
	0.0032655290000000001, 0.0039243330000000003, 0.0045851549999999996, 
	0.0052480529999999999, 0.0059130859999999997, 0.0065803190000000003, 
	0.0072498190000000002, 0.0079216579999999998, 0.0085959130000000002, 
	0.0092726670000000001, 0.0099520070000000006, 0.010634029999999999, 
	0.01131883, 0.01200652, 0.01269723, 0.01339107, 0.01408819, 0.01478875, 
	0.0154929, 0.016200840000000001, 0.016912770000000001, 
	0.017628919999999999, 0.018349549999999999, 0.01907495, 
	0.019805440000000001, 0.020541400000000001, 0.02128327, 
	0.022031539999999999, 0.022786830000000001, 0.023549850000000001, 
	0.02432146, 0.02510275, 0.025895069999999999, 0.026700209999999999, 
	0.02752054, 0.0283594, 0.02922172, 0.00062031870000000004, 
	0.0012422819999999999, 0.0018659289999999999, 0.002491301, 
	0.0031184419999999999, 0.0037473990000000002, 0.0043782179999999997, 
	0.0050109519999999999, 0.0056456550000000003, 0.0062823829999999999, 
	0.0069211960000000001, 0.0075621600000000001, 0.0082053430000000004, 
	0.0088508170000000004, 0.0094986610000000003, 0.01014896, 0.0108018, 
	0.01145728, 0.0121155, 0.012776569999999999, 0.01344063, 0.0141078, 
	0.01477822, 0.01545206, 0.01612949, 0.016810720000000001, 0.01749595, 
	0.018185429999999999, 0.018879440000000001, 0.019578290000000002, 
	0.020282339999999999, 0.020992, 0.02170776, 0.022430189999999999, 
	0.023159969999999998, 0.023897939999999999, 0.024645130000000001, 
	0.025402839999999999, 0.02617278, 0.026957229999999999, 0.0277594, 
	0.028584020000000002, 0.02943865, 0.00059368949999999995, 
	0.0011889069999999999, 0.001785687, 0.0023840689999999999, 
	0.0029840909999999999, 0.0035857950000000001, 0.0041892240000000001, 
	0.0047944249999999997, 0.0054014470000000002, 0.0060103400000000003, 
	0.0066211580000000003, 0.0072339600000000002, 0.0078488069999999993, 
	0.0084657629999999994, 0.0090848979999999992, 0.0097062869999999992, 
	0.010330010000000001, 0.01095615, 0.011584799999999999, 
	0.012216060000000001, 0.01285003, 0.01348684, 0.01412661, 0.01476947, 
	0.01541559, 0.01606513, 0.016718279999999999, 0.01737524, 0.01803625, 
	0.018701570000000001, 0.019371510000000002, 0.020046390000000001, 
	0.020726629999999999, 0.021412690000000002, 0.022105110000000001, 
	0.022804540000000002, 0.023511799999999999, 0.02422786, 
	0.024953989999999999, 0.025691820000000001, 0.02644355, 0.02721227, 
	0.028002559999999999, 0.02882171, 0.029682650000000001, 0.0005692637, 
	0.0011399509999999999, 0.001712093, 0.0022857260000000001, 
	0.0028608840000000002, 0.0034376049999999998, 0.0040159289999999997, 
	0.0045958980000000002, 0.0051775550000000004, 0.0057609469999999998, 
	0.006346122, 0.0069331330000000002, 0.0075220340000000004, 
	0.0081128829999999996, 0.0087057439999999996, 0.0093006809999999999, 
	0.0098977660000000005, 0.010497080000000001, 0.01109869, 0.0117027, 
	0.012309189999999999, 0.012918280000000001, 0.01353006, 0.01414467, 
	0.014762239999999999, 0.01538291, 0.016006840000000001, 0.01663421, 
	0.017265229999999999, 0.01790011, 0.018539110000000001, 0.01918251, 
	0.019830649999999998, 0.020483899999999999, 0.021142709999999999, 
	0.0218076, 0.022479220000000001, 0.02315832, 0.02384586, 0.02454305, 
	0.025251470000000002, 0.025973240000000002, 0.02671136, 0.02747024, 
	0.028256949999999999, 0.029084039999999999, 0.029977730000000001, 
	0.00054677779999999997, 0.0010948850000000001, 0.0016443510000000001, 
	0.0021952069999999998, 0.0027474859999999999, 0.0033012219999999999, 
	0.0038564509999999999, 0.0044132099999999999, 0.0049715410000000003, 
	0.0055314830000000002, 0.0060930819999999997, 0.0066563849999999999, 
	0.00722144, 0.0077883010000000001, 0.0083570229999999999, 
	0.0089276660000000008, 0.0095002929999999999, 0.010074970000000001, 
	0.01065177, 0.011230779999999999, 0.011812069999999999, 
	0.012395740000000001, 0.012981889999999999, 0.01357061, 
	0.014162040000000001, 0.01475629, 0.015353510000000001, 
	0.015953849999999999, 0.016557479999999999, 0.01716459, 
	0.017775409999999998, 0.018390159999999999, 0.019009129999999999, 
	0.01963264, 0.020261040000000001, 0.02089477, 0.021534339999999999, 
	0.022180350000000001, 0.022833550000000001, 0.023494850000000001, 
	0.024165430000000002, 0.02484681, 0.025541049999999999, 0.02625104, 
	0.026981089999999999, 0.02773805, 0.02853412, 0.02939483, 
	0.030392329999999999, 0.00052600870000000003, 0.0010532619999999999, 
	0.0015817870000000001, 0.0021116120000000001, 0.0026427680000000002, 
	0.003175284, 0.0037091950000000002, 0.0042445349999999998, 
	0.0047813389999999999, 0.0053196459999999999, 0.0058594950000000002, 
	0.00640093, 0.0069439949999999997, 0.007488738, 0.0080352080000000003, 
	0.0085834599999999994, 0.0091335500000000007, 0.0096855399999999994, 
	0.01023949, 0.01079548, 0.01135358, 0.01191386, 0.01247642, 0.01304135, 
	0.013608759999999999, 0.01417875, 0.014751449999999999, 0.01532698, 
	0.015905510000000001, 0.0164872, 0.017072219999999999, 
	0.017660800000000001, 0.018253149999999999, 0.01884955, 
	0.019450289999999999, 0.020055750000000001, 0.020666319999999998, 
	0.021282490000000001, 0.021904860000000002, 0.022534149999999999, 
	0.023171230000000001, 0.02381726, 0.024473689999999999, 
	0.025142540000000001, 0.02582661, 0.026530089999999999, 0.02725965, 
	0.02802719, 0.02885762, 0.029821360000000002, 0.031373180000000001, 
	0.018883649999999998, 0.0070666169999999999, 0.01419114, 
	0.021378810000000002, 0.0044645919999999999, 0.0089608459999999997, 
	0.01349059, 0.01805584, 0.022658790000000002, 0.0032887260000000001, 
	0.0065982810000000001, 0.0099296969999999995, 0.01328409, 
	0.016662690000000001, 0.020066839999999999, 0.02349801, 
	0.0026120840000000002, 0.0052392230000000003, 0.0078820939999999992, 
	0.010541429999999999, 0.01321802, 0.01591273, 0.018626509999999999, 
	0.021360400000000002, 0.024115560000000001, 0.0021703320000000001, 
	0.0043521929999999999, 0.0065460630000000004, 0.0087524600000000001, 
	0.010971949999999999, 0.013205130000000001, 0.01545267, 0.0177153, 
	0.019993799999999999, 0.022289059999999999, 0.024602059999999999, 
	0.0018584160000000001, 0.0037260140000000001, 0.0056031539999999999, 
	0.0074902229999999998, 0.0093876399999999992, 0.01129585, 
	0.013215360000000001, 0.015146679999999999, 0.01709041, 0.01904718, 
	0.021017689999999999, 0.023002729999999999, 0.025003170000000002, 
	0.0016260389999999999, 0.0032596040000000001, 0.0049009739999999998, 
	0.0065504489999999999, 0.0082083520000000004, 0.0098750309999999994, 
	0.01155086, 0.01323625, 0.014931649999999999, 0.016637530000000001, 
	0.018354430000000001, 0.020082940000000001, 0.021823700000000001, 
	0.02357743, 0.02534494, 0.0014460160000000001, 0.0028983350000000001, 
	0.0043571809999999999, 0.0058227929999999997, 0.0072954279999999996, 
	0.0087753620000000001, 0.01026289, 0.011758340000000001, 
	0.013262049999999999, 0.01477441, 0.016295819999999999, 
	0.017826749999999999, 0.01936769, 0.020919190000000001, 
	0.022481870000000001, 0.02405641, 0.025643590000000001, 
	0.0013023290000000001, 0.0026100300000000002, 0.0039232850000000003, 
	0.0052422889999999998, 0.0065672509999999996, 0.0078983939999999996, 
	0.0092359580000000007, 0.0105802, 0.01193141, 0.01328988, 
	0.014655939999999999, 0.016029950000000001, 0.017412319999999998, 
	0.018803460000000001, 0.020203869999999999, 0.021614080000000001, 
	0.023034679999999998, 0.024466350000000001, 0.025909850000000002, 
	0.001184917, 0.0023744769999999998, 0.0035688310000000002, 
	0.0047681399999999997, 0.0059725769999999997, 0.0071823260000000002, 
	0.0083975850000000008, 0.0096185669999999997, 0.010845499999999999, 
	0.01207863, 0.01331823, 0.014564590000000001, 0.015818019999999999, 
	0.017078880000000001, 0.018347550000000001, 0.01962446, 
	0.020910080000000001, 0.022204930000000001, 0.02350961, 
	0.024824800000000001, 0.026151259999999999, 0.001087134, 
	0.0021783280000000002, 0.0032737069999999998, 0.004373409, 
	0.0054775780000000003, 0.0065863680000000004, 0.0076999440000000002, 
	0.0088184839999999997, 0.009942177, 0.01107123, 0.012205860000000001, 
	0.01334631, 0.01449285, 0.01564575, 0.01680533, 0.017971930000000001, 
	0.01914594, 0.02032778, 0.021517919999999999, 0.02271689, 0.0239253, 
	0.025143840000000001, 0.026373290000000001, 0.0010044089999999999, 
	0.0020124019999999999, 0.003024086, 0.0040395789999999997, 
	0.0050590030000000003, 0.0060824870000000001, 0.007110173, 
	0.0081422100000000004, 0.0091787569999999992, 0.01021999, 
	0.011266079999999999, 0.01231725, 0.013373700000000001, 
	0.014435679999999999, 0.01550344, 0.01657726, 0.017657450000000002, 
	0.01874437, 0.019838390000000001, 0.020939940000000001, 
	0.022049510000000001, 0.02316764, 0.024294949999999999, 0.02543217, 
	0.02658013, 0.00093349280000000001, 0.0018701760000000001, 
	0.0028101430000000002, 0.003753494, 0.0047003339999999996, 
	0.0056507750000000002, 0.0066049359999999996, 0.0075629440000000003, 
	0.0085249369999999998, 0.0094910600000000008, 0.01046147, 0.01143634, 
	0.012415839999999999, 0.013400179999999999, 0.014389580000000001, 
	0.01538427, 0.016384510000000001, 0.017390579999999999, 0.0184028, 
	0.019421509999999999, 0.020447119999999999, 0.021480059999999999, 
	0.022520829999999999, 0.023570000000000001, 0.024628230000000001, 
	0.025696279999999998, 0.02677506, 0.00087201200000000003, 
	0.0017468850000000001, 0.0026247010000000001, 0.003505546, 
	0.0043895100000000001, 0.0052766920000000004, 0.0061671929999999996, 
	0.0070611240000000002, 0.0079586009999999992, 0.0088597499999999996, 
	0.0097647059999999997, 0.01067361, 0.011586630000000001, 0.01250391, 
	0.013425660000000001, 0.01435206, 0.015283339999999999, 0.01621972, 
	0.01716148, 0.018108900000000001, 0.019062309999999999, 
	0.020022069999999999, 0.02098858, 0.021962300000000001, 
	0.022943760000000001, 0.023933570000000001, 0.024932429999999998, 
	0.025941180000000001, 0.0269608, 0.0008181916, 0.0016389659999999999, 
	0.0024623929999999998, 0.003288549, 0.0041175140000000001, 
	0.0049493719999999996, 0.0057842120000000004, 0.0066221300000000004, 
	0.0074632270000000002, 0.0083076109999999995, 0.0091553999999999993, 
	0.01000672, 0.01086169, 0.01172048, 0.012583220000000001, 0.0134501, 
	0.01432128, 0.01519699, 0.01607743, 0.016962850000000002, 
	0.017853520000000001, 0.018749740000000001, 0.01965184, 
	0.020560189999999999, 0.02147524, 0.022397449999999999, 0.02332741, 
	0.024265760000000001, 0.025213269999999999, 0.026170880000000001, 
	0.027139690000000001, 0.00077067689999999996, 0.0015436969999999999, 
	0.0023191240000000001, 0.0030970239999999999, 0.0038774669999999999, 
	0.0046605259999999999, 0.0054462809999999999, 0.006234814, 
	0.0070262149999999997, 0.0078205770000000004, 0.0086180010000000001, 
	0.0094185959999999996, 0.010222480000000001, 0.01102977, 0.0118406, 
	0.012655130000000001, 0.013473499999999999, 0.01429589, 
	0.015122490000000001, 0.015953499999999999, 0.016789149999999999, 
	0.017629679999999998, 0.018475390000000001, 0.019326570000000001, 
	0.02018358, 0.021046829999999999, 0.02191676, 0.022793899999999999, 
	0.023678870000000001, 0.024572380000000001, 0.025475310000000001, 
	0.026388700000000001, 0.027313839999999999, 0.0007284158, 
	0.0014589690000000001, 0.0021917159999999998, 0.0029267160000000002, 
	0.0036640290000000001, 0.0044037219999999997, 0.0051458629999999997, 
	0.0058905260000000001, 0.0066377900000000002, 0.0073877359999999998, 
	0.0081404519999999994, 0.0088960340000000006, 0.0096545820000000001, 
	0.0104162, 0.01118102, 0.01194915, 0.01272073, 0.01349591, 0.01427485, 
	0.01505772, 0.015844730000000001, 0.016636069999999999, 
	0.017431990000000001, 0.018232749999999999, 0.019038630000000001, 
	0.019849970000000002, 0.020667149999999999, 0.02149059, 
	0.022320779999999998, 0.0231583, 0.024003839999999999, 
	0.024858189999999999, 0.02572236, 0.026597550000000001, 
	0.027485309999999999, 0.00069057880000000002, 0.001383116, 
	0.0020776620000000001, 0.0027742690000000002, 0.0034729909999999999, 
	0.0041738870000000003, 0.0048770180000000003, 0.0055824489999999997, 
	0.0062902499999999998, 0.0070004919999999997, 0.0077132540000000001, 
	0.0084286180000000006, 0.0091466729999999993, 0.0098675150000000003, 
	0.01059124, 0.01131797, 0.012047810000000001, 0.01278089, 
	0.013517360000000001, 0.01425735, 0.01500105, 0.015748620000000001, 
	0.016500270000000001, 0.017256219999999999, 0.018016709999999998, 
	0.01878202, 0.019552469999999999, 0.0203284, 0.021110219999999999, 
	0.02189839, 0.022693459999999999, 0.023496070000000001, 
	0.024306990000000001, 0.025127139999999999, 0.025957689999999999, 
	0.026800089999999999, 0.027656239999999999, 0.00065650280000000005, 
	0.0013148070000000001, 0.0019749590000000001, 0.0026370030000000002, 
	0.0033009900000000002, 0.0039669709999999997, 0.0046350000000000002, 
	0.0053051369999999997, 0.0059774420000000003, 0.00665198, 0.007328818, 
	0.008008032, 0.0086896999999999999, 0.0093739029999999994, 0.01006073, 
	0.010750279999999999, 0.01144266, 0.01213797, 0.01283634, 0.0135379, 
	0.01424278, 0.01495116, 0.015663179999999999, 0.016379060000000001, 
	0.017098990000000001, 0.017823200000000001, 0.018551970000000001, 
	0.019285569999999998, 0.020024360000000001, 0.020768700000000001, 
	0.02151904, 0.02227589, 0.02303987, 0.023811700000000002, 
	0.024592269999999999, 0.02538267, 0.026184300000000001, 
	0.026998950000000001, 0.027829039999999999, 0.00062565120000000003, 
	0.0012529660000000001, 0.0018819850000000001, 0.0025127499999999998, 
	0.0031453039999999998, 0.0037796959999999999, 0.0044159719999999998, 
	0.0050541869999999999, 0.0056943929999999999, 0.0063366480000000003, 
	0.0069810150000000001, 0.0076275580000000004, 0.0082763469999999999, 
	0.0089274550000000008, 0.0095809610000000007, 0.01023695, 
	0.010895510000000001, 0.011556749999999999, 0.012220760000000001, 
	0.01288766, 0.01355758, 0.014230639999999999, 0.014907, 
	0.015586829999999999, 0.01627029, 0.016957590000000002, 
	0.017648939999999998, 0.018344599999999999, 0.019044849999999999, 
	0.019749989999999999, 0.0204604, 0.021176500000000001, 
	0.021898770000000001, 0.0226278, 0.023364269999999999, 
	0.024109040000000002, 0.024863139999999999, 0.02562791, 
	0.026405060000000001, 0.027196919999999999, 0.028006730000000001, 
	0.00059758529999999997, 0.0011967119999999999, 0.001797416, 0.002399736,
	0.0030037110000000001, 0.0036093829999999999, 0.0042167970000000004, 
	0.0048259979999999997, 0.0054370360000000001, 0.0060499630000000002, 
	0.0066648339999999997, 0.0072817059999999998, 0.0079006409999999999, 
	0.0085217049999999992, 0.0091449700000000005, 0.0097705069999999995, 
	0.0103984, 0.01102873, 0.011661599999999999, 0.0122971, 0.01293534, 
	0.01357644, 0.01422053, 0.014867750000000001, 0.015518250000000001, 
	0.016172209999999999, 0.016829799999999999, 0.01749125, 
	0.018156780000000001, 0.01882667, 0.019501210000000001, 
	0.020180759999999999, 0.020865709999999999, 0.021556530000000001, 
	0.022253780000000001, 0.02295811, 0.023670340000000002, 0.02439146, 
	0.025122749999999999, 0.025865860000000001, 0.026623000000000001, 
	0.027397310000000001, 0.028193409999999999, 0.00057194259999999997, 
	0.001145318, 0.0017201580000000001, 0.0022964970000000002, 0.002874372, 
	0.0034538210000000001, 0.0040348830000000004, 0.0046176009999999998, 
	0.0052020169999999998, 0.0057881800000000004, 0.0063761379999999999, 
	0.0069659429999999996, 0.0075576519999999998, 0.0081513209999999996, 
	0.0087470150000000003, 0.0093448000000000003, 0.0099447470000000003, 
	0.010546929999999999, 0.01115144, 0.011758350000000001, 0.01236777, 
	0.0129798, 0.01359455, 0.01421214, 0.014832700000000001, 0.01545639, 
	0.01608337, 0.016713809999999999, 0.017347910000000001, 
	0.017985910000000001, 0.018628059999999998, 0.019274639999999999, 
	0.019925979999999999, 0.02058248, 0.021244570000000001, 0.0219128, 
	0.022587779999999998, 0.023270309999999999, 0.023961329999999999, 
	0.024662079999999999, 0.025374130000000002, 0.026099629999999999, 
	0.026841589999999999, 0.027604469999999999, 0.02839539, 
	0.00054842119999999996, 0.0010981770000000001, 0.001649298, 
	0.0022018139999999999, 0.002755759, 0.0033111669999999998, 
	0.0038680749999999999, 0.0044265190000000003, 0.0049865409999999997, 
	0.0055481810000000001, 0.0061114860000000002, 0.0066765000000000001, 
	0.0072432759999999999, 0.007811864, 0.0083823209999999999, 
	0.0089547080000000005, 0.0095290860000000008, 0.01010553, 0.0106841, 
	0.01126488, 0.011847959999999999, 0.012433430000000001, 
	0.013021390000000001, 0.013611939999999999, 0.014205189999999999, 
	0.01480129, 0.01540036, 0.016002570000000001, 0.016608089999999999, 
	0.017217110000000001, 0.01782984, 0.018446529999999999, 0.01906745, 
	0.019692930000000001, 0.020323330000000001, 0.020959080000000001, 
	0.021600689999999999, 0.022248770000000001, 0.022904069999999999, 
	0.023567520000000002, 0.024240279999999999, 0.024923890000000001, 
	0.025620420000000001, 0.02633278, 0.027065280000000001, 0.02782482, 
	0.02862367, 0.00052676730000000003, 0.001054782, 0.0015840699999999999, 
	0.0021146619999999998, 0.0026465859999999998, 0.003179875, 0.00371456, 
	0.0042506760000000001, 0.0047882610000000003, 0.0053273510000000001, 
	0.0058679869999999999, 0.0064102109999999999, 0.0069540690000000002, 
	0.0074996079999999996, 0.0080468780000000004, 0.0085959339999999995, 
	0.0091468299999999999, 0.0096996310000000002, 0.0102544, 0.01081121, 
	0.011370130000000001, 0.011931239999999999, 0.01249463, 0.0130604, 
	0.013628650000000001, 0.01419949, 0.014773039999999999, 
	0.015349440000000001, 0.015928830000000001, 0.016511390000000001, 
	0.017097290000000001, 0.017686750000000001, 0.018280000000000001, 
	0.0188773, 0.01947896, 0.02008534, 0.020696840000000001, 0.02131396, 
	0.021937290000000002, 0.022567549999999999, 0.02320562, 
	0.023852660000000001, 0.02451012, 0.025180029999999999, 0.02586519, 
	0.026569800000000001, 0.027300560000000001, 0.02806939, 
	0.028901280000000001, 0.00050676629999999996, 0.001014701, 
	0.0015238280000000001, 0.0020341740000000001, 0.0025457660000000001, 
	0.0030586340000000002, 0.003572806, 0.0040883150000000004, 
	0.0046051929999999996, 0.0051234749999999997, 0.0056431980000000003, 
	0.0061643990000000001, 0.0066871209999999999, 0.0072114049999999997, 
	0.0077372980000000001, 0.0082648470000000005, 0.0087941040000000005, 
	0.0093251240000000006, 0.0098579659999999993, 0.01039269, 
	0.010929370000000001, 0.01146806, 0.01200886, 0.01255184, 0.0130971, 
	0.013644730000000001, 0.01419484, 0.01474755, 0.015302980000000001, 
	0.01586129, 0.016422630000000001, 0.016987180000000001, 
	0.017555129999999999, 0.018126719999999999, 0.018702199999999999, 
	0.019281860000000001, 0.019866040000000001, 0.020455149999999998, 
	0.021049660000000001, 0.021650139999999998, 0.022257280000000001, 
	0.02287194, 0.023495229999999999, 0.024128589999999998, 
	0.024773940000000001, 0.025434040000000002, 0.026112960000000001, 
	0.026817210000000001, 0.027558429999999998, 0.028360969999999999, 
	0.02929389, 0.0004882353, 0.0009775668999999999, 0.001468018, 
	0.0019596119999999999, 0.0024523739999999998, 0.00294633, 
	0.0034415090000000001, 0.0039379380000000002, 0.004435647, 0.004934669, 
	0.0054350370000000002, 0.005936785, 0.0064399510000000002, 
	0.0069445740000000002, 0.0074506950000000002, 0.0079583569999999992, 
	0.0084676079999999997, 0.0089784960000000007, 0.0094910740000000004, 
	0.010005399999999999, 0.010521529999999999, 0.011039530000000001, 
	0.011559470000000001, 0.012081420000000001, 0.012605470000000001, 
	0.01313171, 0.013660210000000001, 0.0141911, 0.01472448, 0.01526048, 
	0.015799239999999999, 0.01634091, 0.01688566, 0.01743368, 
	0.017985190000000002, 0.01854045, 0.019099720000000001, 0.01966335, 
	0.02023171, 0.020805279999999999, 0.021384589999999998, 
	0.021970320000000002, 0.02256331, 0.023164629999999999, 
	0.023775669999999999, 0.024398320000000001, 0.02503524, 
	0.025690399999999999, 0.02637018, 0.027085919999999999, 
	0.027861449999999999, 0.02876424, 0.03023021, 0.01819697, 
	0.0068108140000000001, 0.01367545, 0.020598600000000002, 
	0.0043034969999999999, 0.0086364509999999999, 0.01300051, 
	0.017397449999999998, 0.02182926, 0.0031703600000000001, 
	0.0063601170000000002, 0.0095701970000000008, 0.0128016, 
	0.016055429999999999, 0.019332869999999999, 0.022635240000000001, 
	0.00251827, 0.0050505719999999997, 0.0075975130000000002, 0.01015975, 
	0.012737989999999999, 0.015333019999999999, 0.017945659999999999, 
	0.020576859999999999, 0.023227609999999999, 0.002092525, 0.004195804, 
	0.006310268, 0.0084363839999999999, 0.01057465, 0.01272563, 
	0.014889889999999999, 0.017068079999999999, 0.019260920000000001, 
	0.021469169999999999, 0.02369369, 0.0017918980000000001, 0.003592366, 
	0.0054017279999999997, 0.0072203349999999996, 0.0090485600000000006, 
	0.01088681, 0.01273552, 0.014595169999999999, 0.016466270000000002, 
	0.018349399999999998, 0.020245160000000002, 0.02215425, 
	0.024077419999999999, 0.001567922, 0.0031428710000000002, 
	0.0047251009999999998, 0.0063148839999999998, 0.0079125089999999999, 
	0.0095182889999999992, 0.01113256, 0.01275569, 0.014388069999999999, 
	0.016030139999999998, 0.017682349999999999, 0.01934524, 
	0.021019360000000001, 0.022705340000000001, 0.024403899999999999, 
	0.001394398, 0.0027946870000000001, 0.0042010679999999996, 
	0.0056137579999999999, 0.0070329889999999999, 0.008459009, 
	0.0098920850000000001, 0.011332500000000001, 0.01278058, 0.01423664, 
	0.015701070000000001, 0.017174249999999999, 0.018656639999999999, 
	0.02014871, 0.021651, 0.023164110000000002, 0.024688700000000001, 
	0.0012558949999999999, 0.0025168109999999999, 0.0037829159999999999, 
	0.0050543860000000001, 0.0063314080000000002, 0.0076141849999999999, 
	0.0089029320000000006, 0.010197879999999999, 0.011499290000000001, 
	0.01280741, 0.014122559999999999, 0.01544504, 0.016775209999999999, 
	0.01811345, 0.019460169999999999, 0.020815859999999999, 
	0.022181019999999999, 0.023556230000000001, 0.02494215, 0.001142714, 
	0.0022897709999999999, 0.0034413080000000001, 0.004597472, 
	0.0057584189999999999, 0.0069243150000000003, 0.0080953380000000005, 
	0.0092716799999999992, 0.010453550000000001, 0.011641159999999999, 
	0.012834750000000001, 0.01403459, 0.01524096, 0.016454159999999999, 
	0.017674539999999999, 0.018902459999999999, 0.020138340000000001, 
	0.02138263, 0.022635849999999999, 0.023898579999999999, 0.02517146, 
	0.0010484520000000001, 0.0021007019999999999, 0.0031568669999999998, 
	0.0042170690000000004, 0.0052814409999999996, 0.0063501219999999997, 
	0.0074232600000000001, 0.0085010160000000001, 0.0095835599999999996, 
	0.010671079999999999, 0.01176376, 0.012861829999999999, 0.01396552, 
	0.015075079999999999, 0.016190779999999998, 0.017312930000000001, 
	0.018441860000000001, 0.01957795, 0.020721590000000002, 
	0.021873259999999999, 0.02303345, 0.024202769999999998, 
	0.025381879999999999, 0.000968702, 0.001940759, 0.0029162709999999998, 
	0.003895342, 0.0048780840000000004, 0.0058646150000000001, 
	0.0068550620000000003, 0.0078495600000000002, 0.0088482519999999992, 
	0.0098512930000000005, 0.01085885, 0.011871100000000001, 0.01288824, 
	0.013910479999999999, 0.01493805, 0.01597119, 0.017010190000000001, 
	0.018055330000000001, 0.019106970000000001, 0.02016546, 
	0.021231219999999999, 0.022304729999999998, 0.023386509999999999, 
	0.024477160000000001, 0.02557738, 0.00090033449999999998, 0.001803657, 
	0.0027100549999999998, 0.003619616, 0.0045324379999999997, 
	0.0054486209999999998, 0.0063682740000000002, 0.0072915130000000003, 
	0.0082184589999999991, 0.0091492450000000003, 0.010084009999999999, 
	0.01102291, 0.01196611, 0.01291377, 0.013866099999999999, 
	0.014823309999999999, 0.01578562, 0.016753270000000001, 
	0.017726559999999999, 0.018705780000000002, 0.019691259999999999, 
	0.020683400000000001, 0.02168262, 0.02268939, 0.023704289999999999, 
	0.024727929999999999, 0.02576107, 0.00084106160000000003, 0.001684804, 
	0.0025313029999999999, 0.0033806349999999999, 0.0042328849999999996, 
	0.0050881399999999997, 0.0059464929999999997, 0.0068080429999999997, 
	0.007672898, 0.008541168, 0.0094129769999999995, 0.010288449999999999, 
	0.011167730000000001, 0.012050969999999999, 0.01293833, 0.01382999, 
	0.01472613, 0.01562697, 0.016532740000000001, 0.01744368, 
	0.018360100000000001, 0.019282279999999999, 0.02021059, 
	0.021145420000000002, 0.022087200000000001, 0.02303647, 
	0.023993790000000001, 0.02495986, 0.025935489999999999, 
	0.00078917250000000005, 0.0015807659999999999, 0.002374845, 
	0.0031714790000000001, 0.0039707400000000004, 0.0047727050000000003, 
	0.0055774550000000003, 0.0063850770000000003, 0.0071956620000000002, 
	0.0080093089999999992, 0.0088261209999999993, 0.0096462100000000005, 
	0.0104697, 0.01129671, 0.01212739, 0.01296189, 0.013800359999999999, 
	0.014643, 0.01548998, 0.01634153, 0.017197879999999999, 
	0.018059289999999999, 0.018926040000000002, 0.019798469999999999, 
	0.020676940000000001, 0.021561859999999999, 0.022453710000000002, 
	0.023353019999999999, 0.024260449999999999, 0.025176730000000001, 
	0.026102759999999999, 0.00074336149999999995, 0.001488921, 0.002236736, 
	0.0029868669999999998, 0.0037393769999999999, 0.0044943350000000003, 
	0.0052518110000000003, 0.0060118819999999996, 0.0067746259999999997, 
	0.0075401310000000003, 0.0083084860000000003, 0.0090797900000000008, 
	0.0098541449999999999, 0.010631659999999999, 0.011412469999999999, 
	0.01219668, 0.01298445, 0.01377593, 0.014571270000000001, 
	0.015370669999999999, 0.016174319999999999, 0.01698243, 0.01779526, 
	0.018613069999999999, 0.019436160000000001, 0.020264879999999999, 
	0.021099610000000001, 0.021940790000000002, 0.022788929999999999, 
	0.02364463, 0.024508579999999999, 0.02538164, 0.02626481, 
	0.00070261480000000001, 0.001407235, 0.0021139119999999999, 
	0.0028226990000000001, 0.0035336529999999999, 0.0042468330000000002, 
	0.004962302, 0.0056801280000000004, 0.0064003799999999998, 
	0.0071231330000000002, 0.0078484680000000008, 0.0085764699999999992, 
	0.0093072280000000007, 0.010040840000000001, 0.010777409999999999, 
	0.011517060000000001, 0.012259890000000001, 0.01300605, 
	0.013755669999999999, 0.01450892, 0.01526595, 0.016026970000000001, 
	0.01679216, 0.017561759999999999, 0.018336020000000001, 
	0.019115219999999999, 0.019899690000000001, 0.02068979, 
	0.021485919999999999, 0.022288570000000001, 0.023098299999999999, 
	0.023915769999999999, 0.024741760000000002, 0.025577240000000001, 
	0.026423390000000001, 0.00066613269999999997, 0.001334104, 
	0.0020039580000000001, 0.0026757439999999999, 0.0033495119999999998, 
	0.0040253149999999998, 0.0047032080000000004, 0.0053832519999999998, 
	0.0060655070000000004, 0.0067500420000000004, 0.0074369249999999996, 
	0.0081262320000000006, 0.0088180429999999994, 0.0095124430000000006, 
	0.01020952, 0.01090938, 0.01161212, 0.01231786, 0.01302673, 0.01373884, 
	0.014454359999999999, 0.01517343, 0.015896239999999999, 
	0.016622979999999999, 0.017353859999999999, 0.01808912, 
	0.018829019999999998, 0.01957387, 0.02032401, 0.021079819999999999, 
	0.02184177, 0.022610379999999999, 0.023386259999999999, 
	0.024170170000000001, 0.024963010000000001, 0.02576591, 
	0.026580280000000001, 0.000633276, 0.001268244, 0.001904944, 
	0.0025434189999999999, 0.0031837150000000002, 0.003825878, 
	0.0044699589999999999, 0.0051160090000000004, 0.0057640859999999999, 
	0.0064142469999999997, 0.0070665559999999999, 0.0077210769999999998, 
	0.0083778829999999992, 0.0090370480000000006, 0.0096986529999999998, 
	0.01036278, 0.011029529999999999, 0.011698999999999999, 0.01237129, 
	0.013046520000000001, 0.01372482, 0.01440633, 0.015091190000000001, 
	0.01577957, 0.016471650000000001, 0.017167640000000001, 0.01786776, 
	0.01857226, 0.019281429999999999, 0.019995579999999999, 0.0207151, 
	0.021440399999999998, 0.022171989999999999, 0.022910460000000001, 
	0.023656509999999999, 0.02441101, 0.025175019999999999, 
	0.025949880000000002, 0.02673737, 0.00060352789999999995, 
	0.0012086180000000001, 0.0018153080000000001, 0.0024236349999999999, 
	0.0030336400000000002, 0.0036453660000000001, 0.0042588569999999996, 
	0.0048741610000000001, 0.0054913269999999998, 0.0061104080000000003, 
	0.0067314590000000004, 0.0073545399999999997, 0.0079797140000000006, 
	0.0086070460000000001, 0.0092366080000000003, 0.0098684770000000005, 
	0.01050273, 0.01113947, 0.011778769999999999, 0.01242074, 
	0.013065490000000001, 0.01371314, 0.014363829999999999, 0.01501769, 
	0.01567487, 0.016335559999999999, 0.01699995, 0.017668240000000002, 
	0.018340680000000002, 0.019017530000000001, 0.019699109999999999, 
	0.020385770000000001, 0.021077909999999998, 0.021776009999999998, 
	0.02248062, 0.02319243, 0.023912249999999999, 0.024641099999999999, 
	0.02538027, 0.026131439999999999, 0.02689685, 0.0005764651, 0.001154378,
	0.001733772, 0.0023146820000000002, 0.0028971439999999999, 0.003481198, 
	0.004066882, 0.0046542390000000001, 0.0052433150000000001, 
	0.0058341560000000001, 0.0064268119999999996, 0.0070213360000000004, 
	0.0076177850000000002, 0.0082162160000000001, 0.0088166939999999999, 
	0.0094192870000000001, 0.01002407, 0.010631109999999999, 0.0112405, 
	0.01185232, 0.012466680000000001, 0.01308368, 0.013703419999999999, 
	0.01432604, 0.01495167, 0.015580460000000001, 0.016212580000000001, 
	0.016848200000000001, 0.017487519999999999, 0.018130790000000001, 
	0.01877825, 0.01943019, 0.020086960000000001, 0.02074894, 
	0.021416580000000001, 0.02209042, 0.022771099999999999, 
	0.023459420000000002, 0.02415633, 0.024863079999999999, 0.02558127, 
	0.026313070000000001, 0.02706153, 0.0005517384, 0.001104823, 
	0.0016592829999999999, 0.0022151509999999998, 0.0027724590000000001, 
	0.0033312429999999998, 0.0038915379999999999, 0.0044533840000000003, 
	0.00501682, 0.0055818889999999996, 0.0061486350000000004, 
	0.0067171059999999996, 0.0072873529999999999, 0.0078594279999999999, 
	0.0084333889999999995, 0.0090092939999999993, 0.0095872100000000005, 
	0.0101672, 0.01074935, 0.01133372, 0.011920419999999999, 0.01250952, 
	0.013101130000000001, 0.01369535, 0.014292310000000001, 0.01489213, 
	0.01549495, 0.016100940000000001, 0.016710269999999999, 
	0.017323120000000001, 0.017939719999999999, 0.018560320000000002, 
	0.01918518, 0.019814640000000001, 0.02044907, 0.021088900000000001, 
	0.02173464, 0.022386909999999999, 0.023046460000000001, 
	0.023714229999999999, 0.024391400000000001, 0.025079520000000001, 
	0.025780669999999999, 0.026497799999999998, 0.027235260000000001, 
	0.00052905669999999999, 0.001059368, 0.0015909609999999999, 0.002123865,
	0.00265811, 0.0031937269999999999, 0.0037307489999999998, 
	0.0042692110000000002, 0.0048091499999999999, 0.0053506040000000001, 
	0.0058936129999999998, 0.0064382199999999997, 0.0069844699999999996, 
	0.0075324119999999996, 0.0080820960000000004, 0.0086335760000000004, 
	0.009186909, 0.0097421569999999996, 0.01029938, 0.010858659999999999, 
	0.011420069999999999, 0.01198368, 0.012549589999999999, 0.01311788, 
	0.01368867, 0.01426207, 0.014838199999999999, 0.015417190000000001, 
	0.015999200000000002, 0.016584390000000001, 0.017172949999999999, 
	0.017765090000000001, 0.018361039999999999, 0.018961059999999998, 
	0.01956548, 0.020174640000000001, 0.020788959999999999, 
	0.021408940000000001, 0.022035160000000002, 0.02266835, 
	0.023309420000000001, 0.023959500000000002, 0.024620079999999999, 
	0.025293179999999998, 0.02598164, 0.026689669999999999, 0.02742404, 
	0.00050817560000000002, 0.001017523, 0.001528069, 0.002039838, 
	0.0025528579999999999, 0.003067158, 0.0035827680000000001, 
	0.0040997200000000003, 0.0046180459999999998, 0.0051377819999999996, 
	0.0056589630000000004, 0.0061816299999999996, 0.0067058220000000002, 
	0.0072315840000000001, 0.0077589599999999996, 0.0082879990000000008, 
	0.0088187519999999991, 0.0093512760000000004, 0.0098856280000000005, 
	0.01042187, 0.010960070000000001, 0.0115003, 0.01204264, 0.01258718, 
	0.01313399, 0.01368319, 0.01423488, 0.014789180000000001, 
	0.015346220000000001, 0.015906139999999999, 0.0164691, 0.01703528, 
	0.017604890000000002, 0.018178139999999999, 0.018755299999999999, 
	0.019336659999999999, 0.019922559999999999, 0.020513409999999999, 
	0.021109679999999999, 0.021711939999999999, 0.022320889999999999, 
	0.0229374, 0.023562570000000001, 0.024197840000000002, 
	0.024845160000000002, 0.025507289999999998, 0.026188320000000001, 
	0.026894789999999998, 0.0276384, 0.00048888790000000001, 
	0.00097887400000000002, 0.001469981, 0.0019622340000000002, 0.002455657,
	0.0029502769999999998, 0.0034461209999999999, 0.0039432169999999997, 
	0.0044415970000000003, 0.0049412919999999999, 0.0054423340000000001, 
	0.0059447600000000003, 0.0064486070000000003, 0.0069539129999999999, 
	0.0074607199999999997, 0.00796907, 0.0084790130000000005, 0.008990596, 
	0.009503872, 0.010018900000000001, 0.01053573, 0.01105444, 0.01157509, 
	0.012097770000000001, 0.01262253, 0.01314949, 0.01367873, 0.01421035, 
	0.014744470000000001, 0.01528121, 0.01582072, 0.016363140000000002, 
	0.016908650000000001, 0.017457440000000001, 0.01800972, 
	0.018565749999999999, 0.019125820000000002, 0.019690240000000001, 
	0.020259409999999999, 0.020833790000000001, 0.021413930000000001, 
	0.022000499999999999, 0.022594349999999999, 0.023196540000000002, 
	0.023808470000000002, 0.02443203, 0.025069890000000001, 0.02572603, 
	0.026406840000000001, 0.027123689999999999, 0.027900479999999998, 
	0.00047101750000000001, 0.000943066, 0.0014161670000000001, 
	0.0018903419999999999, 0.0023656139999999998, 0.002842008, 
	0.0033195490000000002, 0.0037982620000000002, 0.0042781759999999999, 
	0.0047593189999999997, 0.0052417219999999999, 0.005725417, 
	0.0062104380000000004, 0.00669682, 0.0071846000000000002, 
	0.0076738190000000001, 0.0081645180000000008, 0.0086567420000000003, 
	0.0091505400000000004, 0.0096459600000000003, 0.010143060000000001, 
	0.010641889999999999, 0.01114252, 0.011645010000000001, 
	0.012149439999999999, 0.01265588, 0.01316441, 0.013675140000000001, 
	0.01418815, 0.014703559999999999, 0.015221490000000001, 0.01574207, 
	0.016265450000000001, 0.016791799999999999, 0.01732129, 
	0.017854140000000001, 0.0183906, 0.018930929999999999, 
	0.019475449999999998, 0.020024549999999999, 0.02057865, 0.02113831, 
	0.02170416, 0.02227703, 0.022857949999999998, 0.023448279999999998, 
	0.024049859999999999, 0.024665289999999999, 0.025298439999999998, 
	0.025955539999999999, 0.0266477, 0.027398269999999999, 0.02827348, 
	0.00045441310000000001, 0.0009097962, 0.001366169, 
	0.0018235510000000001, 0.0022819649999999999, 0.0027414319999999998, 
	0.0032019750000000001, 0.003663618, 0.0041263869999999996, 
	0.0045903089999999999, 0.0050554110000000001, 0.0055217210000000003, 
	0.0059892720000000003, 0.006458096, 0.006928226, 0.0073996979999999997, 
	0.0078725519999999997, 0.0083468269999999994, 0.0088225660000000004, 
	0.0092998149999999995, 0.0097786230000000002, 0.010259040000000001, 
	0.01074113, 0.011224939999999999, 0.01171054, 0.012197990000000001, 
	0.01268739, 0.013178799999999999, 0.01367231, 0.01416802, 0.01466603, 
	0.01516647, 0.015669450000000001, 0.016175129999999999, 
	0.016683659999999999, 0.017195220000000001, 0.01771002, 
	0.018228279999999999, 0.018750280000000001, 0.019276310000000001, 
	0.01980676, 0.020342030000000001, 0.020882660000000001, 
	0.021429279999999998, 0.021982669999999999, 0.022543850000000001, 
	0.023114139999999998, 0.023695330000000001, 0.024289950000000001, 
	0.02490179, 0.025536940000000001, 0.02620625, 0.026932609999999999, 
	0.027780829999999999, 0.029169690000000002, 0.017558480000000001, 
	0.006572886, 0.01319592, 0.019873330000000002, 0.0041536250000000002, 
	0.0083347249999999994, 0.01254478, 0.016785399999999999, 
	0.021058339999999998, 0.0030602210000000001, 0.0061385500000000004, 
	0.0092358200000000005, 0.01235294, 0.01549088, 0.018650710000000001, 
	0.02183361, 0.0024309650000000002, 0.0048750379999999999, 
	0.0073327690000000003, 0.0098047499999999992, 0.01229162, 
	0.014794069999999999, 0.017312850000000001, 0.019848790000000002, 
	0.022402789999999999, 0.0020201080000000001, 0.0040502689999999996, 
	0.0060908739999999996, 0.0081423439999999993, 0.01020513, 
	0.012279730000000001, 0.01436666, 0.01646651, 0.018579890000000002, 
	0.0207075, 0.02285009, 0.001729981, 0.0034679789999999999, 
	0.0052142890000000004, 0.0069692249999999999, 0.0087331270000000003, 
	0.010506359999999999, 0.012289309999999999, 0.01408242, 
	0.015886129999999998, 0.017700960000000002, 0.019527449999999998, 
	0.02136621, 0.0232179, 0.001513819, 0.0030342170000000001, 
	0.0045614219999999999, 0.00609568, 0.0076372549999999999, 0.009186428, 
	0.0107435, 0.01230881, 0.01388269, 0.01546554, 0.017057780000000002, 
	0.018659849999999999, 0.020272269999999998, 0.021895580000000001, 
	0.0235304, 0.0013463430000000001, 0.0026982030000000001, 
	0.0040557630000000004, 0.0054192199999999998, 0.006788784, 
	0.0081646779999999999, 0.0095471429999999993, 0.01093644, 
	0.012332839999999999, 0.013736659999999999, 0.01514821, 0.01656786, 
	0.01799599, 0.01943303, 0.020879459999999999, 0.02233578, 
	0.023802589999999998, 0.001212662, 0.0024300300000000001, 
	0.0036522550000000001, 0.004879497, 0.0061119269999999996, 
	0.0073497270000000003, 0.0085930929999999996, 0.0098422340000000001, 
	0.01109737, 0.01235876, 0.013626650000000001, 0.014901319999999999, 
	0.016183099999999999, 0.01747232, 0.018769339999999999, 0.02007459, 
	0.021388500000000001, 0.02271159, 0.02404442, 0.0011034180000000001, 
	0.0022109080000000001, 0.0033225939999999999, 0.00443861, 
	0.0055590980000000002, 0.0066842079999999996, 0.0078141019999999999, 
	0.0089489510000000001, 0.010088939999999999, 0.011234269999999999, 
	0.012385159999999999, 0.013541829999999999, 0.01470454, 
	0.015873559999999998, 0.017049189999999999, 0.01823176, 
	0.019421629999999999, 0.020619189999999999, 0.021824909999999999, 
	0.023039259999999999, 0.024262820000000001, 0.001012432, 
	0.0020284259999999998, 0.0030480889999999999, 0.0040715339999999999, 
	0.0050988780000000003, 0.0061302489999999999, 0.0071657830000000002, 
	0.0082056219999999992, 0.0092499220000000007, 0.01029885, 
	0.011352579999999999, 0.0124113, 0.01347523, 0.01454459, 
	0.015619620000000001, 0.016700590000000001, 0.017787790000000001, 
	0.01888155, 0.01998223, 0.02109022, 0.02220596, 0.023329969999999998, 
	0.024462810000000001, 0.00093545130000000001, 0.0018740510000000001, 
	0.0028158889999999998, 0.0037610629999999998, 0.0047096719999999998, 
	0.0056618249999999997, 0.0066176359999999997, 0.0075772280000000001, 
	0.0085407309999999993, 0.0095082840000000005, 0.010480039999999999, 
	0.01145615, 0.0124368, 0.013422170000000001, 0.01441246, 0.0154079, 
	0.01640873, 0.01741521, 0.018427639999999999, 0.019446339999999999, 
	0.020471670000000001, 0.021504039999999999, 0.02254389, 0.02359174, 
	0.024648179999999999, 0.00086945580000000005, 0.001741717, 
	0.0026168620000000002, 0.0034949730000000002, 0.0043761370000000004, 
	0.0052604469999999997, 0.0061480010000000002, 0.007038903, 
	0.0079332650000000001, 0.0088312059999999994, 0.0097328529999999996, 
	0.01063834, 0.01154782, 0.012461440000000001, 0.01337939, 0.01430183, 
	0.01522899, 0.016161060000000001, 0.017098309999999999, 
	0.018041000000000001, 0.018989410000000002, 0.019943889999999999, 
	0.020904800000000001, 0.021872539999999999, 0.022847599999999999, 
	0.023830520000000001, 0.024821900000000001, 0.0008122378, 
	0.0016269940000000001, 0.0024443350000000002, 0.0032643350000000002, 
	0.0040870669999999998, 0.004912614, 0.0057410580000000003, 
	0.0065724920000000001, 0.0074070100000000003, 0.0082447149999999997, 
	0.0090857160000000006, 0.0099301300000000006, 0.010778080000000001, 
	0.01162971, 0.01248515, 0.01334457, 0.014208129999999999, 
	0.015076030000000001, 0.015948469999999999, 0.016825659999999999, 
	0.017707850000000001, 0.018595319999999999, 0.019488370000000001, 
	0.02038734, 0.021292599999999998, 0.022204600000000001, 0.02312382, 
	0.024050849999999999, 0.024986339999999999, 0.00076214619999999996, 
	0.0015265669999999999, 0.0022933210000000001, 0.0030624720000000001, 
	0.003834086, 0.0046082329999999998, 0.0053849869999999999, 
	0.0061644259999999998, 0.0069466349999999996, 0.0077317009999999997, 
	0.0085197190000000003, 0.0093107899999999993, 0.010105019999999999, 
	0.010902530000000001, 0.011703440000000001, 0.012507890000000001, 
	0.01331602, 0.01412799, 0.014943970000000001, 0.015764150000000001, 
	0.016588729999999999, 0.017417950000000001, 0.018252060000000001, 
	0.01909133, 0.019936079999999998, 0.02078667, 0.021643490000000001, 
	0.022506999999999999, 0.023377740000000001, 0.02425633, 
	0.025143490000000001, 0.00071792109999999998, 0.0014379079999999999, 
	0.0021600130000000001, 0.0028842910000000002, 0.0036108020000000002, 
	0.0043396060000000002, 0.0050707690000000001, 0.0058043599999999997, 
	0.0065404499999999997, 0.0072791189999999997, 0.0080204479999999995, 
	0.0087645250000000004, 0.0095114450000000003, 0.010261309999999999, 
	0.01101422, 0.011770299999999999, 0.01252967, 0.013292470000000001, 
	0.01405884, 0.014828940000000001, 0.015602960000000001, 
	0.016381079999999999, 0.01716351, 0.017950480000000001, 
	0.018742269999999998, 0.01953916, 0.020341479999999999, 
	0.021149609999999999, 0.021963980000000001, 0.022785079999999999, 
	0.023613479999999999, 0.02444988, 0.025295080000000001, 
	0.00067858399999999998, 0.001359053, 0.0020414550000000002, 0.002725838,
	0.003412254, 0.0041007580000000004, 0.0047914059999999998, 
	0.0054842609999999998, 0.0061793849999999999, 0.0068768479999999996, 
	0.0075767209999999998, 0.0082790829999999996, 0.0089840130000000008, 
	0.0096916020000000005, 0.01040194, 0.011115130000000001, 0.01183129, 
	0.012550520000000001, 0.01327295, 0.013998729999999999, 0.014728, 
	0.01546092, 0.016197679999999999, 0.016938479999999999, 
	0.017683520000000001, 0.018433069999999999, 0.019187389999999999, 
	0.019946789999999999, 0.020711630000000002, 0.021482299999999999, 
	0.022259279999999999, 0.0230431, 0.023834399999999999, 0.02463396, 
	0.02544269, 0.00064336310000000002, 0.001288455, 0.001935317, 
	0.002583994, 0.0032345299999999998, 0.0038869759999999999, 
	0.0045413820000000001, 0.0051978010000000002, 0.0058562909999999996, 
	0.006516913, 0.0071797299999999996, 0.0078448089999999995, 
	0.0085122240000000005, 0.0091820500000000006, 0.0098543720000000001, 
	0.01052928, 0.011206860000000001, 0.01188722, 0.01257047, 0.01325673, 
	0.013946129999999999, 0.0146388, 0.01533491, 0.016034619999999999, 
	0.016738119999999999, 0.017445619999999998, 0.018157329999999999, 
	0.018873540000000001, 0.019594520000000001, 0.020320609999999999, 
	0.02105218, 0.021789679999999999, 0.022533609999999999, 
	0.023284579999999999, 0.024043330000000002, 0.02481071, 
	0.025587840000000001, 0.00061164170000000003, 0.0012248750000000001, 
	0.001839736, 0.0024562659999999999, 0.0030745049999999999, 
	0.0036944970000000001, 0.0043162879999999997, 0.0049399240000000001, 
	0.0055654579999999997, 0.0061929430000000002, 0.006822435, 
	0.0074539960000000001, 0.0080876880000000009, 0.0087235799999999999, 
	0.0093617449999999994, 0.010002260000000001, 0.01064521, 
	0.011290680000000001, 0.01193877, 0.01258958, 0.01324323, 0.01389983, 
	0.014559519999999999, 0.01522245, 0.01588877, 0.016558659999999999, 
	0.017232319999999999, 0.017909970000000001, 0.018591839999999998, 
	0.019278219999999999, 0.01996941, 0.020665780000000002, 
	0.021367750000000001, 0.022075790000000001, 0.022790479999999998, 
	0.02351251, 0.024242710000000001, 0.024982130000000002, 
	0.025732069999999999, 0.00058292070000000003, 0.0011673110000000001, 
	0.001753206, 0.0023406400000000002, 0.0029296510000000001, 0.003520277, 
	0.0041125600000000003, 0.0047065420000000002, 0.0053022690000000001, 
	0.0058997880000000004, 0.0064991520000000002, 0.0071004129999999999, 
	0.0077036279999999997, 0.0083088569999999994, 0.0089161659999999997, 
	0.0095256230000000004, 0.0101373, 0.01075128, 0.01136764, 
	0.011986480000000001, 0.01260789, 0.013231980000000001, 
	0.013858860000000001, 0.01448867, 0.015121529999999999, 
	0.015757609999999998, 0.016397060000000001, 0.017040070000000001, 
	0.017686859999999999, 0.018337639999999999, 0.01899269, 
	0.019652300000000001, 0.020316810000000001, 0.020986620000000001, 
	0.02166218, 0.022344050000000001, 0.023032879999999999, 
	0.023729460000000001, 0.024434790000000001, 0.02515011, 0.02587708, 
	0.0005567918, 0.0011149459999999999, 0.0016744939999999999, 0.002235468,
	0.0027978999999999999, 0.0033618260000000001, 0.0039272830000000002, 
	0.0044943099999999996, 0.0050629480000000003, 0.0056332400000000003, 
	0.0062052299999999999, 0.0067789679999999998, 0.0073545040000000004, 
	0.0079318919999999994, 0.0085111900000000001, 0.009092457, 
	0.0096757600000000003, 0.01026117, 0.010848760000000001, 0.01143861, 
	0.012030799999999999, 0.01262544, 0.013222609999999999, 0.01382244, 
	0.01442504, 0.01503053, 0.015639070000000001, 0.016250819999999999, 
	0.016865950000000001, 0.017484650000000001, 0.018107149999999999, 
	0.018733699999999999, 0.019364570000000001, 0.020000110000000001, 
	0.02064067, 0.02128671, 0.021938740000000002, 0.0225974, 
	0.023263430000000002, 0.02393779, 0.02462168, 0.025316680000000001, 
	0.026024889999999998, 0.00053291790000000003, 0.001067103, 
	0.0016025830000000001, 0.002139387, 0.0026775449999999999, 
	0.0032170889999999998, 0.0037580529999999999, 0.0043004710000000002, 
	0.004844381, 0.0053898210000000004, 0.0059368329999999999, 
	0.0064854589999999998, 0.0070357450000000004, 0.0075877399999999999, 
	0.0081414950000000003, 0.0086970639999999991, 0.0092545059999999991, 
	0.0098138819999999995, 0.010375260000000001, 0.010938710000000001, 
	0.0115043, 0.01207213, 0.012642280000000001, 0.01321484, 
	0.013789920000000001, 0.014367639999999999, 0.014948110000000001, 
	0.01553148, 0.016117900000000001, 0.016707530000000002, 
	0.017300570000000001, 0.017897219999999998, 0.01849773, 
	0.019102359999999999, 0.01971142, 0.020325280000000001, 
	0.020944359999999999, 0.021569149999999999, 0.022200250000000001, 
	0.02283841, 0.023484519999999998, 0.02413974, 0.024805580000000001, 
	0.025484070000000001, 0.026178099999999999, 0.00051101810000000005, 
	0.001023218, 0.0015366240000000001, 0.0020512629999999998, 
	0.0025671629999999999, 0.0030843530000000002, 0.003602863, 
	0.0041227260000000002, 0.004643973, 0.0051666409999999996, 
	0.0056907659999999999, 0.0062163879999999998, 0.0067435469999999999, 
	0.007272288, 0.0078026559999999998, 0.0083347000000000004, 0.008868473, 
	0.0094040300000000007, 0.0099414289999999999, 0.010480730000000001, 
	0.01102201, 0.01156534, 0.01211079, 0.01265845, 0.01320841, 0.01376078, 
	0.014315649999999999, 0.01487316, 0.01543343, 0.0159966, 
	0.016562839999999999, 0.017132330000000001, 0.017705269999999999, 
	0.01828188, 0.018862429999999999, 0.019447220000000001, 0.02003659, 
	0.02063094, 0.021230760000000001, 0.021836620000000001, 
	0.022449230000000001, 0.023069449999999998, 0.02369841, 
	0.024337560000000001, 0.024988860000000002, 0.025655089999999998, 
	0.026340369999999998, 0.00049085640000000005, 0.00098281699999999998, 
	0.001475905, 0.001970145, 0.0024655620000000001, 0.0029621819999999998, 
	0.0034600329999999999, 0.0039591440000000004, 0.0044595449999999997, 
	0.0049612679999999996, 0.0054643469999999996, 0.0059688170000000004, 
	0.0064747160000000002, 0.0069820819999999997, 0.0074909579999999998, 
	0.0080013870000000004, 0.0085134159999999993, 0.0090270950000000006, 
	0.0095424770000000006, 0.01005962, 0.010578580000000001, 0.01109943, 
	0.011622230000000001, 0.012147059999999999, 0.012674, 0.01320314, 
	0.01373457, 0.014268400000000001, 0.01480475, 0.01534373, 0.0158855, 
	0.016430190000000001, 0.016977989999999998, 0.017529090000000001, 
	0.018083709999999999, 0.018642100000000002, 0.019204539999999999, 
	0.01977137, 0.020342969999999998, 0.02091981, 0.021502449999999999, 
	0.022091550000000001, 0.02268798, 0.023292790000000001, 0.02390741, 
	0.024533719999999998, 0.025174430000000001, 0.02583353, 0.02651744, 
	0.00047223289999999998, 0.00094550050000000001, 0.0014198240000000001, 
	0.0018952260000000001, 0.0023717289999999999, 0.0028493569999999998, 
	0.0033281360000000002, 0.0038080929999999998, 0.0042892540000000002, 
	0.0047716490000000002, 0.0052553080000000002, 0.0057402640000000001, 
	0.00622655, 0.0067142030000000002, 0.0072032590000000001, 
	0.0076937580000000002, 0.008185744, 0.0086792599999999994, 
	0.0091743539999999991, 0.0096710779999999996, 0.01016948, 
	0.010669629999999999, 0.01117158, 0.011675400000000001, 0.01218117, 
	0.012688949999999999, 0.01319884, 0.01371093, 0.01422531, 
	0.014742099999999999, 0.01526141, 0.015783390000000001, 
	0.016308179999999999, 0.016835940000000001, 0.017366860000000001, 
	0.017901159999999999, 0.018439069999999998, 0.01898087, 0.01952688, 
	0.020077480000000002, 0.02063311, 0.021194310000000001, 0.02176173, 
	0.022336189999999999, 0.02291874, 0.023510730000000001, 
	0.024114010000000002, 0.02473119, 0.02536617, 0.02602519, 
	0.026719420000000001, 0.00045497750000000003, 0.0009109268, 0.001367867,
	0.001825819, 0.0022848040000000001, 0.0027448440000000002, 
	0.0032059620000000001, 0.0036681819999999999, 0.0041315309999999999, 
	0.0045960330000000002, 0.0050617170000000003, 0.0055286129999999999, 
	0.0059967509999999998, 0.0064661639999999999, 0.0069368859999999997, 
	0.0074089519999999999, 0.0078824020000000002, 0.0083572760000000003, 
	0.0088336170000000002, 0.0093114700000000005, 0.0097908839999999997, 
	0.01027191, 0.01075461, 0.01123904, 0.01172525, 0.01221334, 0.01270335, 
	0.01319539, 0.01368953, 0.01418588, 0.014684539999999999, 0.01518562, 
	0.015689249999999998, 0.016195589999999999, 0.016704779999999999, 
	0.017217, 0.01773247, 0.018251409999999999, 0.01877409, 0.01930082, 
	0.019831959999999999, 0.020367949999999999, 0.020909290000000001, 
	0.021456639999999999, 0.022010769999999999, 0.022572709999999999, 
	0.023143770000000001, 0.02372575, 0.024321189999999999, 
	0.024933879999999999, 0.025569919999999999, 0.02624019, 
	0.026967640000000001, 0.0004389444, 0.00087880320000000001, 
	0.0013195940000000001, 0.001761337, 0.0022040499999999999, 0.002647754, 
	0.0030924699999999999, 0.0035382209999999998, 0.0039850299999999996, 
	0.0044329210000000003, 0.0048819199999999997, 0.0053320529999999998, 
	0.0057833490000000001, 0.0062358370000000002, 0.006689548, 
	0.0071445160000000001, 0.0076007740000000002, 0.008058361, 
	0.0085173139999999998, 0.0089776760000000004, 0.00943949, 
	0.0099028020000000005, 0.010367660000000001, 0.010834130000000001, 
	0.01130225, 0.011772100000000001, 0.012243739999999999, 0.01271723, 
	0.01319267, 0.013670130000000001, 0.014149709999999999, 0.0146315, 
	0.01511563, 0.01560222, 0.016091399999999999, 0.01658333, 
	0.017078179999999998, 0.017576140000000001, 0.01807746, 
	0.018582370000000001, 0.019091179999999999, 0.01960425, 
	0.020121989999999999, 0.020644909999999999, 0.021173609999999999, 
	0.02170888, 0.022251690000000001, 0.02280333, 0.023365549999999999, 
	0.02394083, 0.02453286, 0.025147610000000001, 0.025795729999999999, 
	0.02649965, 0.027323090000000001, 0.0004240076, 0.00084887730000000005, 
	0.0012746260000000001, 0.00170127, 0.0021288290000000001, 0.002557321, 
	0.0029867650000000002, 0.0034171819999999999, 0.003848593, 
	0.0042810210000000003, 0.0047144889999999997, 0.0051490219999999996, 
	0.0055846450000000001, 0.0060213860000000001, 0.0064592729999999998, 
	0.0068983359999999997, 0.0073386069999999996, 0.0077801190000000003, 
	0.0082229069999999998, 0.0086670099999999993, 0.0091124670000000008, 
	0.0095593199999999996, 0.01000761, 0.0104574, 0.01090873, 
	0.011361649999999999, 0.01181623, 0.01227253, 0.01273062, 0.01319058, 
	0.01365249, 0.014116429999999999, 0.01458251, 0.015050839999999999, 
	0.01552153, 0.01599472, 0.016470559999999999, 0.016949220000000001, 
	0.017430890000000001, 0.017915770000000001, 0.018404139999999999, 
	0.01889627, 0.0193925, 0.019893250000000001, 0.020399, 
	0.020910350000000001, 0.021428050000000001, 0.02195306, 
	0.022486639999999999, 0.023030479999999999, 0.023587009999999999, 
	0.02415985, 0.024754829999999999, 0.025382390000000001, 
	0.026064529999999999, 0.026863700000000001, 0.028183030000000001, 
	0.016963280000000001, 0.0063510210000000001, 0.012748890000000001, 
	0.0191974, 0.0040138420000000001, 0.0080533710000000001, 
	0.012119919999999999, 0.016214949999999999, 0.020340029999999999, 
	0.0029574800000000002, 0.0059319029999999997, 0.0089240239999999992, 
	0.01193466, 0.014964679999999999, 0.018015070000000001, 
	0.021086850000000001, 0.0023495130000000001, 0.0047112990000000004, 
	0.0070858570000000001, 0.0094737220000000004, 0.011875470000000001, 
	0.014291720000000001, 0.016723160000000001, 0.01917052, 
	0.021634589999999999, 0.0019525390000000001, 0.0039144970000000003, 
	0.0058862280000000003, 0.0078681150000000002, 0.0098605670000000006, 
	0.011864029999999999, 0.013878969999999999, 0.015905900000000001, 
	0.0179454, 0.01999807, 0.022064569999999999, 0.0016722040000000001, 
	0.0033519230000000001, 0.0050394259999999996, 0.0067349990000000002, 
	0.0084389479999999999, 0.0101516, 0.01187332, 0.01360448, 0.01534549, 
	0.01709681, 0.018858920000000001, 0.020632370000000001, 
	0.022417739999999999, 0.001463329, 0.0029328290000000001, 
	0.0044087090000000002, 0.0058911909999999996, 0.0073805140000000003, 
	0.008876933, 0.01038072, 0.01189218, 0.013411609999999999, 0.01493937, 
	0.016475839999999999, 0.0180214, 0.01957652, 0.02114168, 0.02271741, 
	0.001301494, 0.002608165, 0.0039201820000000004, 0.0052377220000000002, 
	0.0065609750000000001, 0.0078901470000000001, 0.0092254529999999998, 
	0.010567129999999999, 0.011915419999999999, 0.01327061, 0.01463298, 
	0.016002849999999999, 0.01738056, 0.01876651, 0.02016109, 
	0.021564779999999999, 0.02297807, 0.0011723110000000001, 
	0.0023490400000000002, 0.0035303259999999999, 0.0047163149999999996, 
	0.0059071610000000002, 0.0071030310000000001, 0.0083041009999999995, 
	0.0095105610000000007, 0.01072261, 0.01194048, 0.01316439, 0.0143946, 
	0.015631389999999998, 0.016875060000000001, 0.018125929999999998, 
	0.01938438, 0.020650789999999999, 0.0219256, 0.02320931, 
	0.0010667389999999999, 0.0021373030000000001, 0.0032118060000000002, 
	0.0042903699999999999, 0.0053731229999999996, 0.0064602039999999998, 
	0.0075517570000000001, 0.0086479399999999998, 0.0097489199999999995, 
	0.010854880000000001, 0.011965999999999999, 0.0130825, 0.0142046, 
	0.01533255, 0.01646661, 0.017607069999999999, 0.01875425, 
	0.019908499999999999, 0.021070220000000001, 0.02223982, 
	0.023417799999999999, 0.00097880860000000005, 0.0019609660000000002, 
	0.0029465680000000001, 0.0039357180000000004, 0.0049285249999999996, 
	0.0059251030000000001, 0.0069255769999999996, 0.007930075, 
	0.0089387389999999994, 0.0099517170000000005, 0.01096917, 0.01199127, 
	0.013018200000000001, 0.014050170000000001, 0.015087389999999999, 
	0.01613011, 0.017178570000000001, 0.018233059999999999, 
	0.019293910000000001, 0.02036145, 0.02143608, 0.022518219999999999, 
	0.023608359999999998, 0.00090441160000000003, 0.001811783, 
	0.0027221979999999999, 0.0036357429999999999, 0.0045525119999999999, 
	0.005472602, 0.0063961180000000001, 0.0073231700000000004, 
	0.0082538769999999997, 0.0091883639999999992, 0.01012677, 
	0.011069229999999999, 0.012015909999999999, 0.012966979999999999, 
	0.01392261, 0.01488301, 0.015848379999999999, 0.016818969999999999, 
	0.01779503, 0.018776850000000001, 0.019764730000000001, 
	0.020759039999999999, 0.021760149999999999, 0.02276852, 
	0.023784639999999999, 0.0008406291, 0.001683897, 0.002529875, 
	0.0033786390000000001, 0.004230269, 0.0050848489999999998, 
	0.0059424680000000002, 0.0068032220000000003, 0.0076672110000000002, 
	0.0085345439999999998, 0.0094053350000000008, 0.010279709999999999, 
	0.011157790000000001, 0.01203974, 0.01292569, 0.01381581, 
	0.014710290000000001, 0.015609319999999999, 0.016513119999999999, 
	0.017421909999999999, 0.01833597, 0.01925557, 0.020181029999999999, 
	0.021112720000000001, 0.022051040000000001, 0.022996430000000002, 
	0.023949439999999999, 0.00078532829999999995, 0.0015730259999999999, 
	0.002363155, 0.0031557820000000002, 0.0039509749999999998, 
	0.0047488080000000002, 0.0055493579999999999, 0.0063527080000000003, 
	0.0071589449999999999, 0.0079681609999999996, 0.0087804560000000007, 
	0.0095959340000000004, 0.010414710000000001, 0.011236899999999999, 
	0.012062649999999999, 0.01289208, 0.013725360000000001, 0.01456264, 
	0.01540411, 0.016249969999999999, 0.017100420000000002, 
	0.017955720000000001, 0.018816119999999999, 0.019681919999999999, 
	0.020553439999999999, 0.021431059999999998, 0.022315189999999999, 
	0.023206330000000001, 0.024105020000000001, 0.00073691399999999997, 
	0.0014759689999999999, 0.0022172189999999999, 0.0029607219999999998, 
	0.003706539, 0.0044547340000000001, 0.0052053739999999996, 
	0.0059585310000000004, 0.0067142809999999999, 0.0074727049999999996, 
	0.008233888, 0.0089979210000000007, 0.0097649030000000001, 0.01053494, 
	0.01130814, 0.012084620000000001, 0.012864530000000001, 0.01364799, 
	0.014435150000000001, 0.0152262, 0.01602131, 0.016820669999999999, 
	0.017624520000000001, 0.018433080000000001, 0.019246650000000001, 
	0.020065510000000002, 0.020890019999999999, 0.021720570000000002, 
	0.022557600000000001, 0.023401620000000001, 0.024253250000000001, 
	0.00069416870000000002, 0.0013902820000000001, 0.002088389, 
	0.0027885409999999998, 0.0034907889999999998, 0.0041951920000000004, 
	0.004901809, 0.0056107020000000004, 0.006321938, 0.0070355870000000003, 
	0.0077517250000000001, 0.0084704299999999993, 0.00919179, 
	0.0099158920000000008, 0.010642840000000001, 0.011372729999999999, 
	0.012105670000000001, 0.0128418, 0.01358123, 0.014324119999999999, 
	0.01507062, 0.015820890000000001, 0.01657513, 0.017333540000000001, 
	0.018096339999999999, 0.018863789999999998, 0.01963618, 
	0.020413819999999999, 0.02119708, 0.02198638, 0.022782190000000001, 
	0.02358509, 0.024395730000000001, 0.00065614690000000001, 
	0.0013140700000000001, 0.0019738109999999998, 0.0026354170000000001, 
	0.0032989339999999999, 0.003964413, 0.0046319059999999999, 
	0.0053014680000000002, 0.0059731589999999996, 0.0066470399999999999, 
	0.0073231779999999996, 0.0080016410000000003, 0.0086825059999999996, 
	0.0093658500000000002, 0.01005176, 0.010740319999999999, 0.01143164, 
	0.012125820000000001, 0.01282297, 0.013523210000000001, 0.01422668, 
	0.01493352, 0.015643899999999999, 0.016357980000000001, 
	0.017075949999999999, 0.017798040000000001, 0.018524479999999999, 
	0.01925553, 0.019991499999999999, 0.020732730000000001, 
	0.021479600000000001, 0.022232579999999998, 0.022992180000000001, 
	0.02375903, 0.024533880000000001, 0.00062210300000000004, 0.001245835, 
	0.001871234, 0.0024983399999999999, 0.0031271960000000001, 
	0.0037578469999999999, 0.0043903379999999997, 0.0050247199999999999, 
	0.005661045, 0.0062993670000000002, 0.0069397449999999998, 
	0.0075822399999999996, 0.0082269189999999992, 0.0088738510000000003, 
	0.0095231099999999996, 0.01017478, 0.01082894, 0.01148568, 
	0.012145100000000001, 0.012807320000000001, 0.01347244, 0.01414059, 
	0.014811899999999999, 0.01548653, 0.016164640000000001, 
	0.016846409999999999, 0.017532039999999999, 0.018221749999999998, 
	0.0189158, 0.01961446, 0.020318070000000001, 0.021026980000000001, 
	0.02174162, 0.0224625, 0.023190200000000001, 0.023925430000000001, 
	0.02466904, 0.00059144099999999995, 0.0011843820000000001, 0.001778857, 
	0.0023749019999999999, 0.0029725559999999999, 0.0035718579999999998, 
	0.0041728499999999996, 0.0047755760000000001, 0.0053800829999999999, 
	0.0059864189999999998, 0.0065946370000000004, 0.00720479, 
	0.0078169390000000002, 0.0084311430000000003, 0.0090474700000000002, 
	0.0096659889999999998, 0.010286770000000001, 0.01090991, 
	0.011535480000000001, 0.01216357, 0.01279429, 0.01342775, 0.01406406, 
	0.01470335, 0.01534577, 0.015991470000000001, 0.01664061, 0.0172934, 
	0.017950029999999999, 0.018610749999999999, 0.019275830000000001, 
	0.019945560000000001, 0.020620300000000001, 0.021300449999999999, 
	0.021986490000000001, 0.022678960000000001, 0.023378550000000001, 
	0.024086059999999999, 0.02480251, 0.00056367859999999995, 0.001128743, 
	0.0016952250000000001, 0.0022631560000000001, 0.0028325709999999999, 
	0.0034035060000000002, 0.003975999, 0.0045500879999999999, 
	0.0051258149999999997, 0.0057032250000000001, 0.006282363, 
	0.0068632789999999999, 0.0074460239999999999, 0.0080306539999999999, 
	0.0086172269999999999, 0.0092058039999999997, 0.0097964530000000001, 
	0.010389239999999999, 0.010984249999999999, 0.011581559999999999, 
	0.012181259999999999, 0.01278344, 0.013388209999999999, 0.01399567, 
	0.014605949999999999, 0.01521919, 0.015835519999999999, 0.01645512, 
	0.017078159999999998, 0.017704839999999999, 0.018335379999999998, 
	0.018970049999999999, 0.019609129999999999, 0.020252940000000001, 
	0.020901880000000001, 0.021556390000000002, 0.022217009999999999, 
	0.022884370000000001, 0.02355925, 0.024242610000000001, 
	0.024935680000000002, 0.00053842129999999997, 0.001078128, 0.001619147, 
	0.0021615100000000002, 0.0027052460000000001, 0.0032503879999999999, 
	0.0037969700000000002, 0.0043450279999999999, 0.004894598, 
	0.0054457209999999997, 0.005998438, 0.0065527930000000003, 
	0.0071088319999999998, 0.0076666049999999999, 0.0082261629999999999, 
	0.0087875620000000005, 0.0093508610000000002, 0.0099161230000000006, 
	0.01048341, 0.01105281, 0.01162438, 0.012198219999999999, 0.01277441, 
	0.01335305, 0.01393425, 0.014518120000000001, 0.0151048, 
	0.015694409999999999, 0.01628711, 0.016883080000000002, 0.01748251, 
	0.0180856, 0.018692609999999998, 0.019303799999999999, 
	0.019919490000000002, 0.020540050000000001, 0.02116591, 
	0.021797569999999999, 0.02243564, 0.02308087, 0.023734180000000001, 
	0.024396729999999998, 0.025070080000000002, 0.00051534339999999995, 
	0.001031882, 0.001549641, 0.0020686480000000002, 0.002588931, 
	0.0031105180000000001, 0.0036334409999999998, 0.0041577319999999999, 
	0.0046834240000000003, 0.0052105540000000001, 0.0057391589999999998, 
	0.0062692779999999997, 0.0068009519999999999, 0.0073342269999999996, 
	0.0078691490000000006, 0.0084057669999999998, 0.0089441339999999994, 
	0.0094843059999999996, 0.01002634, 0.010570309999999999, 
	0.011116269999999999, 0.011664310000000001, 0.01221449, 
	0.012766919999999999, 0.013321670000000001, 0.01387885, 
	0.014438579999999999, 0.015000970000000001, 0.015566150000000001, 
	0.016134269999999999, 0.016705500000000002, 0.01728002, 0.01785803, 
	0.018439759999999999, 0.019025480000000001, 0.019615489999999999, 
	0.02021013, 0.02080982, 0.021415050000000001, 0.02202639, 
	0.022644560000000001, 0.023270450000000002, 0.023905180000000002, 
	0.024550220000000001, 0.02520758, 0.00049417329999999998, 
	0.00098946119999999992, 0.001485887, 0.0019834750000000002, 
	0.0024822519999999999, 0.002982242, 0.0034834760000000001, 
	0.0039859810000000004, 0.0044897879999999998, 0.0049949299999999999, 
	0.0055014410000000001, 0.0060093560000000004, 0.0065187129999999998, 
	0.0070295510000000002, 0.0075419129999999999, 0.0080558439999999995, 
	0.0085713899999999999, 0.009088601, 0.0096075320000000002, 0.01012824, 
	0.01065078, 0.01117523, 0.011701649999999999, 0.012230120000000001, 
	0.01276072, 0.01329354, 0.013828679999999999, 0.014366240000000001, 
	0.014906340000000001, 0.0154491, 0.015994669999999999, 
	0.016543200000000001, 0.017094870000000002, 0.01764986, 
	0.018208410000000001, 0.018770769999999999, 0.019337210000000001, 
	0.01990809, 0.0204838, 0.02106479, 0.02165164, 0.022245020000000001, 
	0.022845790000000001, 0.023455030000000002, 0.024074180000000001, 
	0.02470514, 0.025350640000000001, 0.000474683, 0.00095040819999999999, 
	0.0014271970000000001, 0.0019050720000000001, 0.0023840549999999999, 
	0.0028641729999999998, 0.0033454489999999999, 0.0038279109999999998, 
	0.0043115860000000001, 0.004796504, 0.0052826959999999999, 
	0.0057701940000000002, 0.006259031, 0.0067492450000000001, 
	0.0072408730000000001, 0.0077339549999999998, 0.0082285339999999992, 
	0.0087246540000000001, 0.0092223640000000003, 0.009721716, 
	0.010222759999999999, 0.01072556, 0.011230179999999999, 
	0.011736679999999999, 0.01224514, 0.01275564, 0.013268250000000001, 
	0.01378308, 0.014300220000000001, 0.014819779999999999, 0.0153419, 
	0.015866689999999999, 0.016394309999999999, 0.016924939999999999, 
	0.01745874, 0.01799595, 0.018536799999999999, 0.019081560000000001, 
	0.01963057, 0.020184199999999999, 0.020742900000000002, 
	0.021307220000000002, 0.021877799999999999, 0.022455470000000002, 
	0.023041289999999999, 0.023636629999999999, 0.02424335, 0.02486408, 
	0.025502730000000001, 0.00045667949999999999, 0.00091433569999999997, 
	0.0013729879999999999, 0.001832658, 0.0022933649999999999, 
	0.0027551329999999999, 0.003217985, 0.0036819449999999998, 
	0.0041470379999999996, 0.0046132919999999997, 0.0050807339999999999, 
	0.005549394, 0.0060193019999999998, 0.0064904919999999996, 
	0.0069629979999999998, 0.007436855, 0.0079121039999999997, 
	0.0083887830000000004, 0.0088669379999999996, 0.0093466120000000007, 
	0.0098278570000000006, 0.010310720000000001, 0.010795269999999999, 
	0.01128155, 0.01176964, 0.012259590000000001, 0.012751500000000001, 
	0.013245430000000001, 0.01374148, 0.014239750000000001, 
	0.014740339999999999, 0.015243369999999999, 0.015748959999999999, 
	0.016257270000000001, 0.016768450000000001, 0.01728269, 
	0.017800179999999999, 0.01832116, 0.018845899999999999, 
	0.019374720000000002, 0.019907970000000001, 0.02044609, 
	0.020989600000000001, 0.02153915, 0.02209552, 0.022659729999999999, 
	0.023233119999999999, 0.02381749, 0.024415389999999999, 0.02503064, 
	0.02566937, 0.00043999829999999998, 0.000880914, 0.0013227650000000001, 
	0.0017655710000000001, 0.0022093500000000001, 0.0026541239999999999, 
	0.0030999130000000001, 0.003546741, 0.0039946299999999999, 
	0.0044436049999999998, 0.0048936910000000004, 0.0053449150000000004, 
	0.0057973060000000003, 0.0062508930000000004, 0.0067057080000000003, 
	0.0071617829999999997, 0.007619153, 0.0080778559999999996, 
	0.0085379300000000009, 0.0089994180000000003, 0.0094623620000000002, 
	0.0099268099999999995, 0.010392810000000001, 0.010860430000000001, 
	0.0113297, 0.011800710000000001, 0.01227351, 0.01274818, 0.01322479, 
	0.013703430000000001, 0.014184199999999999, 0.0146672, 
	0.015152540000000001, 0.015640339999999999, 0.016130740000000001, 
	0.0166239, 0.01712, 0.017619220000000001, 0.0181218, 
	0.018627999999999999, 0.019138100000000002, 0.01965248, 
	0.020171540000000002, 0.0206958, 0.021225870000000001, 0.02176252, 
	0.022306739999999999, 0.022859830000000001, 0.023423530000000001, 
	0.02400033, 0.02459395, 0.025210369999999999, 0.025860279999999999, 
	0.00042449840000000001, 0.00084986019999999998, 0.0012761020000000001, 
	0.001703242, 0.0021312969999999999, 0.0025602860000000002, 0.00299023, 
	0.0034211480000000002, 0.003853062, 0.0042859939999999996, 
	0.0047199679999999997, 0.0051550090000000003, 0.005591141, 
	0.0060283940000000003, 0.0064667939999999997, 0.006906372, 
	0.0073471600000000001, 0.0077891899999999997, 0.0082325000000000002, 
	0.0086771260000000003, 0.0091231079999999996, 0.0095704889999999997, 
	0.01001931, 0.010469630000000001, 0.010921490000000001, 0.01137495, 
	0.01183007, 0.01228692, 0.01274556, 0.01320606, 0.01366852, 0.01413302, 
	0.01459967, 0.01506856, 0.015539819999999999, 0.016013579999999999, 
	0.016490000000000001, 0.016969229999999998, 0.017451479999999998, 
	0.017936959999999998, 0.018425919999999998, 0.018918649999999999, 
	0.019415499999999999, 0.01991687, 0.020423239999999999, 
	0.020935229999999999, 0.02145358, 0.021979249999999999, 
	0.022513490000000001, 0.02305803, 0.023615270000000001, 
	0.024188850000000001, 0.024784609999999999, 0.025413000000000002, 
	0.026096100000000001, 0.00041005810000000002, 0.00082093059999999998, 
	0.0012326329999999999, 0.0016451809999999999, 0.0020585909999999998, 
	0.0024728810000000001, 0.0028880690000000001, 0.0033041730000000001, 
	0.003721214, 0.0041392130000000001, 0.0045581889999999998, 
	0.0049781679999999998, 0.00539917, 0.0058212230000000004, 
	0.0062443510000000004, 0.0066685829999999996, 0.0070939469999999998, 
	0.0075204740000000001, 0.0079481959999999994, 0.0083771469999999997, 
	0.0088073630000000003, 0.0092388839999999993, 0.0096717490000000003, 
	0.010106, 0.010541689999999999, 0.01097887, 0.01141758, 
	0.011857889999999999, 0.012299849999999999, 0.012743549999999999, 
	0.013189040000000001, 0.01363641, 0.014085749999999999, 0.01453714, 
	0.014990699999999999, 0.01544655, 0.0159048, 0.016365609999999999, 
	0.016829139999999999, 0.017295580000000001, 0.017765130000000001, 
	0.018238029999999999, 0.018714580000000001, 0.0191951, 
	0.019679990000000001, 0.020169719999999999, 0.020664869999999998, 
	0.021166190000000001, 0.021674590000000001, 0.022191309999999999, 
	0.022718019999999998, 0.023257079999999999, 0.023812030000000001, 
	0.024388610000000002, 0.024997040000000002, 0.02565895, 
	0.026435759999999999, 0.0003965722, 0.00079391360000000003, 0.001192039,
	0.001590962, 0.0019906989999999999, 0.002391266, 0.0027926800000000001, 
	0.0031949579999999999, 0.003598118, 0.0040021789999999998, 
	0.0044071609999999997, 0.0048130849999999999, 0.0052199730000000001, 
	0.0056278470000000001, 0.0060367320000000004, 0.0064466519999999998, 
	0.0068576339999999996, 0.0072697059999999999, 0.0076828970000000002, 
	0.0080972390000000009, 0.0085127640000000008, 0.0089295079999999992, 
	0.0093475069999999997, 0.0097668019999999998, 0.010187430000000001, 
	0.010609449999999999, 0.01103289, 0.011457820000000001, 
	0.011884280000000001, 0.01231234, 0.012742069999999999, 
	0.013173529999999999, 0.0136068, 0.014041959999999999, 0.01447911, 
	0.01491835, 0.01535979, 0.015803560000000001, 0.01624979, 
	0.016698649999999999, 0.017150309999999998, 0.017604979999999999, 
	0.0180629, 0.01852434, 0.018989610000000001, 0.01945912, 
	0.019933309999999999, 0.020412759999999999, 0.020898179999999999, 
	0.021390470000000002, 0.02189085, 0.022400940000000001, 0.02292305, 
	0.023460660000000001, 0.024019370000000002, 0.024609240000000001, 
	0.025251490000000001, 0.026006379999999999, 0.027262749999999999, 
	0.016407109999999999, 0.006143646, 0.012331150000000001, 
	0.018565950000000001, 0.0038831619999999999, 0.0077903929999999996, 
	0.0117229, 0.015682000000000001, 0.019669119999999998, 
	0.0028614159999999999, 0.0057387180000000003, 0.0086325929999999992, 
	0.01154378, 0.014473069999999999, 0.017421329999999999, 
	0.020389500000000001, 0.0022733440000000001, 0.0045582050000000001, 
	0.0068550349999999998, 0.0091643190000000006, 0.01148658, 0.01382238, 
	0.016172329999999999, 0.018537080000000001, 0.020917370000000001, 
	0.0018893460000000001, 0.0037875349999999999, 0.0056948900000000002, 
	0.0076117590000000001, 0.0095385120000000007, 0.011475549999999999, 
	0.013423300000000001, 0.01538222, 0.01735283, 0.019335669999999999, 
	0.021331329999999999, 0.0016181640000000001, 0.0032433879999999998, 
	0.0048759160000000001, 0.00651601, 0.0081639469999999995, 
	0.0098200260000000008, 0.01148457, 0.01315792, 0.01484044, 0.01653255, 
	0.018234690000000001, 0.019947320000000001, 0.021670970000000001, 
	0.001416102, 0.002838003, 0.0042658949999999996, 0.0056999809999999998, 
	0.0071404779999999996, 0.0085876159999999993, 0.010041649999999999, 
	0.01150283, 0.012971460000000001, 0.01444784, 0.015932310000000002, 
	0.01742523, 0.018926990000000001, 0.020438040000000001, 
	0.021958829999999999, 0.00125954, 0.0025239479999999998, 0.003793378, 
	0.0050679920000000003, 0.0063479649999999997, 0.0076334819999999996, 
	0.0089247389999999992, 0.01022195, 0.01152534, 0.01283515, 0.01415165, 
	0.01547511, 0.016805870000000001, 0.018144230000000001, 
	0.019490589999999999, 0.020845329999999999, 0.02220892, 
	0.0011345610000000001, 0.0022732799999999999, 0.0034162820000000001, 
	0.0045637009999999999, 0.0057156780000000001, 0.0068723639999999997, 
	0.00803392, 0.0092005179999999995, 0.010372340000000001, 0.01154959, 
	0.012732469999999999, 0.01392121, 0.015116070000000001, 0.0163173, 
	0.017525209999999999, 0.018740110000000001, 0.019962359999999998, 
	0.021192329999999999, 0.022430470000000001, 0.0010324240000000001, 
	0.0020684470000000002, 0.0031081749999999999, 0.0041517189999999999, 
	0.005199197, 0.006250734, 0.007306463, 0.0083665260000000009, 
	0.0094310739999999994, 0.010500270000000001, 0.011574289999999999, 
	0.012653309999999999, 0.013737549999999999, 0.01482722, 
	0.015922550000000001, 0.01702381, 0.01813128, 0.01924526, 
	0.020366100000000002, 0.021494180000000002, 0.022629920000000001, 
	0.00094735049999999997, 0.001897854, 0.0028515989999999998, 
	0.0038086800000000001, 0.0047691959999999999, 0.0057332520000000003, 
	0.0067009599999999997, 0.00767244, 0.0086478179999999998, 
	0.0096272300000000005, 0.01061082, 0.01159874, 0.01259117, 
	0.013588279999999999, 0.014590260000000001, 0.015597339999999999, 
	0.01660973, 0.0176277, 0.018651520000000001, 0.019681489999999999, 
	0.020717960000000001, 0.021761289999999999, 0.022811919999999999, 
	0.00087536920000000004, 0.001753527, 0.0026345489999999999, 
	0.0035185160000000002, 0.0044055120000000003, 0.0052956280000000001, 
	0.0061889579999999996, 0.0070856039999999997, 0.0079856719999999992, 
	0.0088892789999999999, 0.0097965450000000003, 0.010707599999999999, 
	0.01162259, 0.01254166, 0.01346498, 0.014392719999999999, 0.01532507, 
	0.016262249999999999, 0.017204469999999999, 0.018152000000000001, 
	0.0191051, 0.02006409, 0.021029300000000001, 0.022001110000000001, 
	0.022979960000000001, 0.00081365620000000002, 0.0016297989999999999, 
	0.0024484939999999998, 0.0032698110000000001, 0.0040938220000000004, 
	0.0049206060000000001, 0.0057502439999999998, 0.0065828220000000003, 
	0.007418432, 0.0082571729999999996, 0.0090991490000000008, 
	0.0099444709999999999, 0.010793260000000001, 0.011645640000000001, 
	0.012501750000000001, 0.01336175, 0.01422578, 0.01509403, 
	0.015966689999999999, 0.016843960000000002, 0.017726080000000002, 
	0.018613279999999999, 0.019505870000000002, 0.020404129999999999, 
	0.02130843, 0.02221915, 0.023136739999999999, 0.00076014840000000001, 
	0.00152253, 0.0022872029999999998, 0.0030542260000000002, 0.003823665, 
	0.0045955850000000001, 0.0053700579999999996, 0.0061471590000000001, 
	0.006926967, 0.0077095669999999996, 0.0084950479999999998, 
	0.0092835069999999999, 0.01007505, 0.010869770000000001, 
	0.011667810000000001, 0.012469279999999999, 0.013274319999999999, 
	0.01408308, 0.01489571, 0.015712400000000001, 0.016533340000000001, 
	0.017358729999999999, 0.01818881, 0.01902382, 0.019864070000000001, 
	0.02070986, 0.021561569999999999, 0.02241959, 0.0232844, 
	0.00071330259999999996, 0.0014286240000000001, 0.0021460139999999999, 
	0.0028655270000000001, 0.0035872170000000002, 0.0043111429999999999, 
	0.0050373680000000004, 0.0057659570000000004, 0.0064969800000000003, 
	0.0072305080000000001, 0.0079666219999999996, 0.0087054039999999999, 
	0.0094469410000000004, 0.01019133, 0.010938669999999999, 
	0.011689069999999999, 0.01244265, 0.013199539999999999, 
	0.013959869999999999, 0.014723780000000001, 0.01549145, 
	0.016263039999999999, 0.01703876, 0.017818819999999999, 
	0.018603450000000001, 0.019392909999999999, 0.02018752, 0.02098759, 
	0.021793509999999999, 0.022605719999999999, 0.023424710000000001, 
	0.0006719413, 0.001345717, 0.0020213729999999999, 0.0026989539999999999,
	0.0033785099999999999, 0.0040600940000000002, 0.0047437590000000002, 
	0.0054295630000000001, 0.006117567, 0.0068078349999999999, 
	0.0075004360000000001, 0.0081954420000000007, 0.0088929300000000003, 
	0.0095929819999999999, 0.01029569, 0.01100114, 0.01170944, 0.0124207, 
	0.013135030000000001, 0.01385256, 0.01457343, 0.01529779, 0.0160258, 
	0.016757660000000001, 0.017493539999999998, 0.018233679999999999, 
	0.018978330000000002, 0.019727749999999999, 0.02048227, 
	0.021242219999999999, 0.022008030000000001, 0.022780160000000001, 
	0.023559159999999999, 0.00063514979999999995, 0.0012719750000000001, 
	0.0019105159999999999, 0.0025508140000000002, 0.003192912, 
	0.0038368569999999999, 0.0044826969999999999, 0.0051304819999999996, 
	0.0057802670000000004, 0.0064321079999999997, 0.0070860660000000002, 
	0.0077422029999999996, 0.0084005880000000005, 0.0090612929999999998, 
	0.0097243950000000003, 0.01038998, 0.011058119999999999, 0.01172893, 
	0.0124025, 0.013078950000000001, 0.013758390000000001, 
	0.014440939999999999, 0.01512676, 0.015816, 0.01650882, 
	0.017205410000000001, 0.017905979999999998, 0.01861076, 
	0.019320009999999999, 0.02003402, 0.02075312, 0.021477699999999999, 
	0.022208189999999999, 0.0229451, 0.02368905, 0.00060220680000000004, 
	0.001205951, 0.001811268, 0.0024181939999999998, 0.0030267699999999998, 
	0.0036370360000000002, 0.0042490339999999996, 0.0048628100000000004, 
	0.0054784120000000002, 0.006095891, 0.0067152979999999998, 
	0.0073366919999999997, 0.0079601310000000005, 0.0085856790000000006, 
	0.0092134039999999997, 0.0098433770000000004, 0.010475679999999999, 
	0.01111038, 0.01174759, 0.01238739, 0.013029880000000001, 0.01367518, 
	0.01432341, 0.014974700000000001, 0.015629199999999999, 
	0.016287059999999999, 0.016948459999999999, 0.0176136, 
	0.018282690000000001, 0.018955980000000001, 0.01963374, 
	0.020316279999999999, 0.021003959999999999, 0.0216972, 
	0.022396490000000002, 0.02310239, 0.023815590000000001, 
	0.00057253570000000001, 0.0011464870000000001, 0.0017218870000000001, 
	0.0022987670000000002, 0.0028771640000000002, 0.0034571139999999998, 
	0.0040386550000000004, 0.0046218270000000002, 0.0052066739999999997, 
	0.0057932410000000002, 0.0063815740000000001, 0.006971723, 
	0.0075637430000000004, 0.0081576879999999997, 0.0087536200000000002, 
	0.0093516009999999993, 0.0099517000000000008, 0.010553989999999999, 
	0.01115855, 0.01176545, 0.0123748, 0.01298669, 0.013601230000000001, 
	0.01421852, 0.01483869, 0.015461890000000001, 0.016088249999999998, 
	0.01671796, 0.017351180000000001, 0.01798812, 0.018629030000000001, 
	0.019274139999999999, 0.01992377, 0.020578249999999999, 0.02123798, 
	0.0219034, 0.022575080000000001, 0.023253650000000001, 0.02393992, 
	0.00054566990000000002, 0.001092649, 0.0016409650000000001, 
	0.0021906500000000001, 0.0027417330000000001, 0.003294249, 0.003848232, 
	0.004403718, 0.0049607449999999999, 0.0055193539999999998, 0.006079587, 
	0.0066414880000000001, 0.0072051060000000002, 0.0077704899999999997, 
	0.0083376939999999997, 0.0089067739999999992, 0.0094777899999999998, 
	0.01005081, 0.010625890000000001, 0.01120312, 0.011782569999999999, 
	0.01236433, 0.01294848, 0.013535129999999999, 0.0141244, 
	0.014716379999999999, 0.01531122, 0.015909059999999999, 
	0.016510049999999998, 0.01711437, 0.017722209999999999, 
	0.018333800000000001, 0.01894937, 0.01956921, 0.020193639999999999, 
	0.020823040000000001, 0.021457839999999999, 0.02209856, 0.02274582, 
	0.023400379999999998, 0.02406318, 0.00052122799999999999, 0.00104367, 
	0.0015673519999999999, 0.002092301, 0.0026185459999999998, 
	0.0031461169999999999, 0.0036750440000000001, 0.0042053610000000003, 
	0.004737102, 0.0052703029999999996, 0.0058050030000000004, 
	0.0063412399999999997, 0.0068790600000000002, 0.0074185040000000002, 
	0.0079596219999999995, 0.0085024639999999995, 0.0090470819999999997, 
	0.0095935359999999997, 0.010141880000000001, 0.010692190000000001, 
	0.011244530000000001, 0.011798980000000001, 0.01235561, 
	0.012914510000000001, 0.01347578, 0.01403953, 0.01460585, 0.01517488, 
	0.015746759999999999, 0.016321619999999998, 0.016899649999999999, 
	0.017481010000000002, 0.018065919999999999, 0.01865462, 0.01924737, 
	0.019844489999999999, 0.020446309999999999, 0.021053269999999999, 
	0.021665859999999999, 0.022284669999999999, 0.022910420000000001, 
	0.023544019999999999, 0.024186619999999999, 0.00049889469999999997, 
	0.0009989186000000001, 0.001500096, 0.0020024499999999998, 
	0.0025060080000000001, 0.003010797, 0.0035168450000000002, 
	0.0040241820000000003, 0.004532838, 0.0050428469999999996, 
	0.0055542430000000004, 0.0060670619999999998, 0.0065813419999999996, 
	0.0070971230000000003, 0.0076144489999999997, 0.0081333640000000006, 
	0.0086539159999999993, 0.0091761570000000008, 0.0097001399999999995, 
	0.010225919999999999, 0.01075357, 0.011283140000000001, 
	0.011814720000000001, 0.012348369999999999, 0.01288418, 0.01342225, 
	0.01396266, 0.014505530000000001, 0.01505097, 0.015599109999999999, 
	0.016150100000000001, 0.016704090000000001, 0.017261249999999999, 
	0.017821799999999999, 0.018385950000000002, 0.018953950000000001, 
	0.019526109999999999, 0.020102760000000001, 0.020684310000000001, 
	0.02127122, 0.021864060000000001, 0.022463529999999999, 
	0.023070489999999999, 0.02368605, 0.024311650000000001, 
	0.00047840730000000002, 0.00095786799999999996, 0.0014384039999999999, 
	0.0019200370000000001, 0.0024027919999999999, 0.0028866920000000002, 
	0.0033717640000000002, 0.0038580350000000001, 0.004345532, 
	0.0048342860000000001, 0.0053243270000000002, 0.0058156889999999998, 
	0.0063084059999999999, 0.0068025129999999996, 0.0072980500000000004, 
	0.0077950579999999997, 0.0082935790000000006, 0.0087936579999999993, 
	0.0092953459999999995, 0.0097986919999999995, 0.01030375, 0.01081059, 
	0.011319259999999999, 0.011829839999999999, 0.01234239, 0.01285701, 
	0.01337377, 0.013892760000000001, 0.014414099999999999, 
	0.014937890000000001, 0.015464250000000001, 0.015993319999999998, 
	0.01652526, 0.017060229999999999, 0.017598430000000002, 0.01814006, 
	0.01868537, 0.019234649999999999, 0.019788219999999999, 0.02034646, 
	0.020909830000000001, 0.021478879999999999, 0.022054270000000001, 
	0.02263683, 0.023227640000000001, 0.02382807, 0.02444002, 
	0.00045954520000000002, 0.0009200756, 0.001381611, 0.001844172, 
	0.0023077800000000002, 0.0027724580000000002, 0.003238229, 
	0.0037051179999999999, 0.0041731499999999996, 0.0046423530000000001, 
	0.0051127539999999997, 0.0055843840000000004, 0.0060572730000000002, 
	0.0065314559999999997, 0.0070069650000000004, 0.0074838389999999999, 
	0.007962116, 0.0084418359999999994, 0.0089230449999999992, 
	0.0094057870000000005, 0.0098901130000000007, 0.010376079999999999, 
	0.01086373, 0.011353139999999999, 0.01184437, 0.01233749, 0.01283257, 
	0.0133297, 0.01382896, 0.01433047, 0.01483431, 0.015340619999999999, 
	0.015849510000000001, 0.016361150000000001, 0.016875680000000001, 
	0.017393289999999999, 0.01791419, 0.018438619999999999, 
	0.018966839999999999, 0.01949917, 0.02003597, 0.020577689999999999, 
	0.021124850000000001, 0.021678099999999999, 0.022238239999999999, 
	0.02280629, 0.023383600000000001, 0.023971989999999999, 
	0.024574039999999998, 0.00044212169999999999, 0.00088516690000000004, 
	0.0013291539999999999, 0.0017741009999999999, 0.0022200290000000001, 
	0.0026669580000000001, 0.0031149099999999998, 0.0035639059999999999, 
	0.0040139720000000002, 0.0044651300000000003, 0.0049174070000000004, 
	0.00537083, 0.0058254270000000002, 0.0062812290000000002, 
	0.0067382659999999997, 0.0071965730000000004, 0.0076561839999999999, 
	0.0081171360000000005, 0.0085794700000000005, 0.0090432250000000002, 
	0.0095084479999999992, 0.0099751849999999993, 0.01044349, 0.01091341, 
	0.011385009999999999, 0.01185835, 0.012333490000000001, 
	0.012810520000000001, 0.013289509999999999, 0.01377054, 
	0.014253709999999999, 0.01473912, 0.01522689, 0.015717140000000001, 
	0.016210019999999999, 0.016705669999999999, 0.017204270000000001, 
	0.017706030000000001, 0.018211160000000001, 0.018719929999999999, 
	0.01923265, 0.019749659999999999, 0.020271399999999998, 
	0.020798359999999998, 0.02133117, 0.02187062, 0.022417690000000001, 
	0.02297368, 0.023540370000000001, 0.024120249999999999, 
	0.024717059999999999, 0.00042597760000000001, 0.00085282279999999999, 
	0.0012805519999999999, 0.0017091840000000001, 0.0021387350000000001, 
	0.002569226, 0.003000675, 0.0034331029999999998, 0.0038665320000000002, 
	0.0043009839999999999, 0.0047364829999999997, 0.0051730539999999998, 
	0.0056107220000000003, 0.0060495159999999996, 0.0064894619999999997, 
	0.0069305929999999996, 0.0073729390000000002, 0.007816534, 
	0.0082614149999999994, 0.0087076180000000003, 0.0091551840000000002, 
	0.0096041560000000008, 0.01005458, 0.0105065, 0.010959979999999999, 
	0.011415059999999999, 0.01187181, 0.012330290000000001, 
	0.012790579999999999, 0.013252740000000001, 0.013716860000000001, 
	0.014183039999999999, 0.01465137, 0.01512196, 0.01559493, 
	0.016070419999999998, 0.016548569999999999, 0.017029559999999999, 
	0.017513569999999999, 0.018000829999999999, 0.018491589999999999, 
	0.018986139999999999, 0.019484830000000002, 0.019988059999999998, 
	0.020496319999999998, 0.02101022, 0.021530520000000001, 
	0.022058169999999998, 0.022594449999999999, 0.023141060000000001, 
	0.023700450000000001, 0.024276260000000001, 0.024874360000000002, 
	0.0004109766, 0.00082277000000000001, 0.0012353959999999999, 0.00164887,
	0.0020632089999999999, 0.0024784300000000002, 0.0028945519999999999, 
	0.0033115940000000002, 0.0037295750000000002, 0.004148517, 0.00456844, 
	0.0049893669999999998, 0.0054113219999999997, 0.0058343309999999999, 
	0.006258418, 0.0066836129999999997, 0.0071099429999999996, 
	0.0075374400000000003, 0.0079661349999999992, 0.008396064, 
	0.0088272620000000006, 0.0092597679999999998, 0.0096936230000000002, 
	0.01012887, 0.01056556, 0.01100374, 0.011443460000000001, 
	0.011884779999999999, 0.01232777, 0.012772479999999999, 0.01321901, 
	0.01366741, 0.01411779, 0.01457024, 0.015024859999999999, 
	0.015481760000000001, 0.015941090000000002, 0.016402980000000001, 
	0.0168676, 0.017335130000000001, 0.017805789999999998, 
	0.018279819999999999, 0.018757490000000002, 0.019239160000000002, 
	0.019725199999999998, 0.020216100000000001, 0.02071245, 
	0.021214980000000001, 0.021724609999999998, 0.022242600000000001, 
	0.022770599999999998, 0.02331099, 0.023867329999999999, 
	0.024445359999999999, 0.025055359999999999, 0.00039700089999999998, 
	0.00079477219999999997, 0.001193328, 0.001592684, 0.001992855, 
	0.0023938560000000002, 0.0027957059999999998, 0.0031984209999999999, 
	0.00360202, 0.0040065209999999999, 0.0044119440000000001, 
	0.0048183109999999996, 0.0052256430000000003, 0.0056339629999999996, 
	0.0060432949999999997, 0.0064536639999999996, 0.0068650960000000002, 
	0.0072776200000000003, 0.0076912650000000001, 0.0081060630000000002, 
	0.0085220450000000007, 0.0089392480000000003, 0.0093577090000000005, 
	0.0097774660000000003, 0.010198560000000001, 0.01062104, 0.01104496, 
	0.011470360000000001, 0.01189729, 0.012325829999999999, 0.01275604, 
	0.01318798, 0.01362173, 0.01405738, 0.014495020000000001, 0.01493476, 
	0.0153767, 0.015820959999999998, 0.0162677, 0.016717070000000001, 
	0.01716925, 0.017624440000000002, 0.018082879999999999, 0.01854484, 
	0.01901065, 0.019480689999999998, 0.01995543, 0.020435439999999999, 
	0.020921430000000001, 0.021414300000000001, 0.021915270000000001, 
	0.022425960000000002, 0.022948690000000001, 0.023486949999999999, 
	0.024046339999999999, 0.02463694, 0.02528002, 0.00038394870000000003, 
	0.00076862529999999999, 0.001154043, 0.0015402160000000001, 0.001927158,
	0.0023148840000000001, 0.0027034099999999998, 0.0030927519999999998, 
	0.0034829269999999998, 0.003873951, 0.0042658440000000004, 
	0.0046586249999999996, 0.0050523139999999996, 0.0054469310000000003, 
	0.0058424990000000001, 0.0062390400000000004, 0.0066365800000000004, 
	0.0070351440000000001, 0.0074347579999999996, 0.0078354510000000002, 
	0.0082372539999999994, 0.0086401970000000005, 0.0090443160000000002, 
	0.0094496449999999996, 0.0098562219999999996, 0.01026409, 0.01067329, 
	0.011083869999999999, 0.01149588, 0.011909370000000001, 
	0.012324409999999999, 0.01274105, 0.01315936, 0.01357943, 
	0.014001319999999999, 0.01442513, 0.01485095, 0.0152789, 
	0.015709109999999998, 0.01614169, 0.016576810000000001, 
	0.017014649999999999, 0.017455390000000001, 0.01789928, 0.01834657, 
	0.018797589999999999, 0.019252689999999999, 0.01971235, 
	0.020177110000000002, 0.020647660000000002, 0.021124899999999999, 
	0.021610000000000001, 0.022104550000000001, 0.022610829999999998, 
	0.023132239999999998, 0.023674279999999999, 0.024246839999999999, 
	0.024870779999999999, 0.025605449999999998, 0.0003717309, 
	0.00074415080000000001, 0.0011172720000000001, 0.001491107, 0.00186567, 
	0.0022409740000000002, 0.0026170329999999999, 0.0029938629999999998, 
	0.0033714790000000001, 0.0037498980000000002, 0.0041291349999999999, 
	0.0045092090000000001, 0.0048901389999999999, 0.0052719430000000003, 
	0.005654643, 0.0060382580000000003, 0.006422812, 0.0068083279999999998, 
	0.0071948300000000001, 0.0075823460000000002, 0.0079709010000000007, 
	0.0083605260000000001, 0.0087512500000000003, 0.0091431080000000005, 
	0.0095361319999999992, 0.0099303599999999992, 0.010325829999999999, 
	0.010722590000000001, 0.011120680000000001, 0.01152015, 
	0.011921050000000001, 0.01232343, 0.01272737, 0.013132919999999999, 
	0.013540160000000001, 0.01394916, 0.014360009999999999, 
	0.014772820000000001, 0.01518768, 0.015604710000000001, 0.01602404, 
	0.016445830000000002, 0.016870240000000002, 0.017297460000000001, 
	0.017727730000000001, 0.01816129, 0.018598460000000001, 
	0.019039589999999999, 0.019485140000000001, 0.019935629999999999, 
	0.02039175, 0.020854379999999999, 0.021324639999999999, 0.02180412, 
	0.022295019999999999, 0.0228007, 0.023326550000000001, 0.02388229, 
	0.02448842, 0.025203239999999998, 0.026402390000000001, 
	0.015886250000000001, 0.0059493860000000001, 0.01193992, 0.01797472, 
	0.0037607249999999999, 0.0075440480000000002, 0.01135107, 0.01518298, 
	0.019041059999999999, 0.002771398, 0.0055577220000000002, 
	0.0083595960000000004, 0.011177690000000001, 0.014012729999999999, 
	0.01686549, 0.01973683, 0.002201962, 0.0044147500000000003, 
	0.0066387779999999997, 0.0088744879999999998, 0.01112235, 0.01338288, 
	0.015656630000000001, 0.017944189999999999, 0.020246199999999999, 
	0.0018301179999999999, 0.0036685540000000001, 0.0055156040000000003, 
	0.0073715830000000001, 0.0092368299999999997, 0.01111171, 
	0.012996600000000001, 0.014891939999999999, 0.016798159999999999, 
	0.01871577, 0.020645299999999998, 0.00156751, 0.0031416640000000002, 
	0.0047226869999999997, 0.0063108160000000003, 0.0079063050000000006, 
	0.0095094250000000002, 0.01112047, 0.012739739999999999, 0.01436759, 
	0.01600437, 0.01765048, 0.019306340000000002, 0.020972419999999999, 
	0.0013718300000000001, 0.0027491210000000002, 0.0041320489999999996, 
	0.0055207980000000004, 0.0069155670000000001, 0.0083165659999999992, 
	0.0097240220000000006, 0.011138179999999999, 0.012559280000000001, 
	0.013987629999999999, 0.01542351, 0.016867259999999999, 
	0.018319220000000001, 0.019779789999999998, 0.021249379999999998, 
	0.001220208, 0.0024450029999999998, 0.0036745250000000001, 
	0.0049089229999999999, 0.0061483570000000001, 0.0073929929999999996, 
	0.0086430129999999997, 0.0098986089999999992, 0.01115998, 0.01242736, 
	0.01370098, 0.014981090000000001, 0.016267980000000001, 
	0.017561940000000002, 0.0188633, 0.020172430000000002, 
	0.021489709999999999, 0.00109917, 0.0022022589999999998, 
	0.0033093810000000001, 0.0044206599999999999, 0.0055362249999999997, 
	0.0066562130000000002, 0.0077807709999999997, 0.0089100559999999995, 
	0.010044229999999999, 0.011183480000000001, 0.012328, 
	0.013477980000000001, 0.01463365, 0.015795259999999998, 0.01696307, 
	0.01813735, 0.019318430000000001, 0.02050664, 0.02170236, 
	0.0010002500000000001, 0.002003894, 0.0030110290000000001, 
	0.0040217569999999999, 0.0050361850000000003, 0.0060544279999999997, 
	0.0070766079999999999, 0.0081028539999999996, 0.0091333030000000006, 
	0.010168099999999999, 0.011207409999999999, 0.012251400000000001, 
	0.01330025, 0.01435415, 0.015413319999999999, 0.016477990000000001, 
	0.01754841, 0.01862486, 0.01970763, 0.020797070000000001, 
	0.021893530000000001, 0.00091785450000000002, 0.001838683, 
	0.0027625670000000001, 0.003689594, 0.0046198530000000002, 
	0.0055534419999999996, 0.0064904630000000001, 0.007431025, 
	0.0083752419999999998, 0.0093232379999999993, 0.01027515, 
	0.011231100000000001, 0.012191270000000001, 0.013155790000000001, 
	0.014124859999999999, 0.01509866, 0.01607739, 0.01706129, 0.0180506, 
	0.019045579999999999, 0.02004653, 0.021053789999999999, 
	0.022067719999999999, 0.000848137, 0.0016989049999999999, 0.002552375, 
	0.0034086189999999999, 0.0042677169999999999, 0.0051297499999999998, 
	0.0059948049999999998, 0.006862974, 0.0077343560000000004, 
	0.0086090549999999991, 0.0094871820000000003, 0.010368860000000001, 
	0.011254200000000001, 0.012143360000000001, 0.01303648, 0.01393371, 
	0.01483523, 0.015741229999999998, 0.016651900000000001, 0.01756746, 
	0.01848818, 0.019414299999999999, 0.02034613, 0.021284000000000001, 
	0.02222828, 0.00078836339999999996, 0.001579074, 0.0023721929999999999, 
	0.003167783, 0.0039659120000000003, 0.0047666510000000002, 
	0.0055700749999999999, 0.0063762619999999997, 0.0071852970000000002, 
	0.0079972700000000008, 0.0088122749999999996, 0.0096304140000000003, 
	0.010451790000000001, 0.01127653, 0.012104749999999999, 0.01293659, 
	0.01377219, 0.0146117, 0.0154553, 0.016303169999999999, 0.01715552, 
	0.01801256, 0.018874539999999999, 0.019741729999999999, 
	0.020614440000000001, 0.021493000000000002, 0.0223778, 
	0.00073653599999999998, 0.0014751810000000001, 0.0022159879999999999, 
	0.0029590129999999999, 0.0037043129999999999, 0.004451951, 
	0.0052019919999999999, 0.0059545040000000002, 0.0067095599999999998, 
	0.0074672369999999998, 0.0082276180000000008, 0.0089907890000000008, 
	0.0097568429999999994, 0.01052588, 0.011298010000000001, 0.01207334, 
	0.012851990000000001, 0.01363411, 0.01441982, 0.0152093, 
	0.016002700000000002, 0.016800220000000001, 0.017602059999999999, 
	0.018408440000000002, 0.019219610000000002, 0.020035850000000001, 
	0.020857480000000001, 0.02168484, 0.022518340000000001, 
	0.00069116049999999997, 0.0013842279999999999, 0.002079249, 
	0.0027762709999999999, 0.0034753480000000001, 0.0041765309999999998, 
	0.0048798790000000002, 0.0055854520000000003, 0.0062933119999999997, 
	0.0070035280000000002, 0.0077161699999999996, 0.0084313129999999993, 
	0.0091490400000000006, 0.0098694339999999998, 0.010592590000000001, 
	0.0113186, 0.01204758, 0.01277963, 0.01351489, 0.014253480000000001, 
	0.01499554, 0.015741249999999998, 0.016490749999999998, 
	0.017244249999999999, 0.018001960000000001, 0.018764099999999999, 
	0.019530929999999998, 0.020302750000000001, 0.021079870000000001, 
	0.021862659999999999, 0.022651560000000001, 0.00065109640000000002, 
	0.001303926, 0.0019585309999999999, 0.0026149540000000001, 
	0.0032732400000000002, 0.0039334360000000002, 0.0045955939999999997, 
	0.0052597659999999999, 0.0059260069999999996, 0.0065943759999999999, 
	0.007264937, 0.007937754, 0.0086128990000000002, 0.0092904460000000008, 
	0.0099704749999999995, 0.010653070000000001, 0.011338330000000001, 
	0.01202634, 0.01271721, 0.013411060000000001, 0.014108010000000001, 
	0.014808200000000001, 0.015511769999999999, 0.01621887, 
	0.016929690000000001, 0.017644420000000001, 0.018363279999999999, 
	0.019086499999999999, 0.01981436, 0.02054715, 0.021285229999999999, 
	0.02202898, 0.02277887, 0.00061545800000000004, 0.0012325000000000001, 
	0.0018511619999999999, 0.0024714839999999999, 0.003093504, 
	0.0037172659999999999, 0.0043428140000000004, 0.0049701939999999998, 
	0.0055994560000000001, 0.0062306519999999997, 0.0068638370000000002, 
	0.00749907, 0.0081364109999999996, 0.0087759269999999993, 
	0.0094176869999999992, 0.010061769999999999, 0.010708240000000001, 
	0.01135721, 0.01200874, 0.012662959999999999, 0.013319950000000001, 
	0.01397984, 0.01464275, 0.015308820000000001, 0.015978200000000001, 
	0.016651050000000001, 0.017327559999999999, 0.01800792, 
	0.018692360000000002, 0.01938113, 0.020074519999999998, 
	0.020772849999999999, 0.021476490000000001, 0.02218587, 0.02290149, 
	0.00058354689999999998, 0.001168547, 0.0017550339999999999, 
	0.0023430410000000001, 0.002932605, 0.0035237630000000001, 0.004116555, 
	0.0047110219999999996, 0.0053072090000000002, 0.0059051609999999999, 
	0.0065049269999999998, 0.0071065599999999996, 0.0077101119999999999, 
	0.0083156429999999993, 0.008923215, 0.0095328909999999999, 
	0.010144739999999999, 0.01075885, 0.01137528, 0.01199413, 0.01261548, 
	0.01323945, 0.013866130000000001, 0.014495650000000001, 0.01512814, 
	0.015763719999999998, 0.016402570000000002, 0.017044839999999999, 
	0.01769074, 0.018340459999999999, 0.018994250000000001, 
	0.019652380000000001, 0.020315150000000001, 0.020982899999999999, 
	0.02165605, 0.022335069999999999, 0.023020510000000001, 
	0.00055480470000000002, 0.001110949, 0.001668461, 0.0022273729999999999,
	0.002787716, 0.0033495249999999999, 0.0039128349999999999, 0.004477684, 
	0.0050441089999999997, 0.0056121540000000003, 0.00618186, 
	0.0067532750000000004, 0.0073264460000000003, 0.0079014250000000001, 
	0.0084782659999999999, 0.009057028, 0.0096377719999999993, 0.01022056, 
	0.010805469999999999, 0.011392579999999999, 0.01198196, 0.0125737, 
	0.0131679, 0.01376465, 0.01436408, 0.0149663, 0.015571440000000001, 
	0.01617965, 0.016791090000000002, 0.01740595, 0.018024410000000001, 
	0.018646699999999999, 0.019273080000000001, 0.019903839999999999, 
	0.0205393, 0.02117985, 0.02182593, 0.022478080000000001, 
	0.023136940000000002, 0.00052877960000000004, 0.001058797, 0.00159008, 
	0.0021226550000000002, 0.002656552, 0.0031918010000000002, 0.003728435, 
	0.0042664859999999999, 0.0048059890000000001, 0.0053469829999999996, 
	0.0058895049999999997, 0.0064335970000000001, 0.0069793019999999997, 
	0.0075266660000000004, 0.0080757380000000007, 0.0086265679999999994, 
	0.0091792120000000008, 0.009733729, 0.010290179999999999, 0.01084863, 
	0.01140915, 0.011971829999999999, 0.012536729999999999, 0.01310396, 
	0.013673599999999999, 0.01424576, 0.01482057, 0.015398129999999999, 
	0.015978599999999999, 0.01656212, 0.017148859999999998, 
	0.017739020000000001, 0.0183328, 0.018930450000000001, 
	0.019532239999999999, 0.02013848, 0.020749529999999999, 
	0.021365829999999999, 0.021987880000000001, 0.022616279999999999, 
	0.02325178, 0.000505102, 0.001011353, 0.0015187759999999999, 
	0.0020273969999999998, 0.0025372429999999998, 0.003048341, 0.003560719, 
	0.0040744090000000002, 0.0045894409999999997, 0.005105849, 
	0.0056236680000000001, 0.0061429350000000004, 0.0066636890000000004, 
	0.0071859699999999999, 0.0077098230000000002, 0.0082352929999999994, 
	0.0087624299999999999, 0.0092912840000000003, 0.0098219109999999991, 
	0.01035437, 0.010888729999999999, 0.011425039999999999, 
	0.011963400000000001, 0.01250387, 0.013046540000000001, 
	0.013591489999999999, 0.01413884, 0.014688690000000001, 0.01524116, 
	0.015796379999999999, 0.016354489999999999, 0.016915659999999999, 
	0.01748007, 0.018047919999999999, 0.018619440000000001, 
	0.019194880000000001, 0.019774549999999998, 0.0203588, 
	0.020948029999999999, 0.021542720000000001, 0.022143449999999999, 
	0.022750940000000001, 0.023366060000000001, 0.00048346670000000002, 
	0.00096800219999999999, 0.001453628, 0.001940368, 0.0024282459999999998,
	0.0029172859999999998, 0.0034075149999999998, 0.0038989599999999999, 
	0.0043916500000000004, 0.0048856150000000003, 0.005380887, 
	0.0058774989999999996, 0.0063754850000000002, 0.0068748840000000004, 
	0.0073757329999999998, 0.0078780740000000005, 0.0083819510000000003, 
	0.0088874109999999996, 0.0093945020000000008, 0.0099032779999999997, 
	0.010413789999999999, 0.010926109999999999, 0.011440290000000001, 
	0.011956410000000001, 0.012474529999999999, 0.012994739999999999, 
	0.01351713, 0.0140418, 0.01456883, 0.01509836, 0.015630499999999999, 
	0.0161654, 0.016703200000000001, 0.017244079999999998, 0.01778824, 
	0.018335879999999999, 0.018887270000000001, 0.01944268, 0.02000244, 
	0.020566959999999999, 0.021136680000000001, 0.021712169999999999, 
	0.022294100000000001, 0.02288331, 0.023480899999999999, 
	0.00046361939999999999, 0.00092823600000000004, 0.00139387, 0.001860542,
	0.002328274, 0.002797089, 0.0032670099999999999, 0.0037380629999999998, 
	0.004210274, 0.00468367, 0.005158279, 0.005634132, 
	0.0061112600000000003, 0.0065896970000000003, 0.0070694779999999997, 
	0.00755064, 0.0080332230000000008, 0.0085172679999999997, 
	0.0090028190000000004, 0.0094899230000000008, 0.0099786319999999994, 
	0.010468999999999999, 0.01096108, 0.01145493, 0.01195063, 
	0.012448239999999999, 0.01294784, 0.01344951, 0.01395335, 0.01445946, 
	0.014967930000000001, 0.0154789, 0.015992490000000002, 
	0.016508849999999999, 0.017028149999999999, 0.01755058, 
	0.018076330000000002, 0.018605650000000001, 0.019138809999999999, 
	0.019676140000000002, 0.020218, 0.02076484, 0.02131719, 0.02187571, 
	0.022441200000000001, 0.023014719999999999, 0.02359762, 
	0.00044534620000000002, 0.00089162530000000005, 0.001338856, 
	0.001787056, 0.0022362469999999998, 0.002686449, 0.003137684, 
	0.003589975, 0.0040433439999999999, 0.0044978190000000001, 
	0.0049534230000000002, 0.0054101849999999996, 0.0058681339999999997, 
	0.0063272989999999998, 0.0067877129999999999, 0.0072494079999999997, 
	0.007712422, 0.0081767899999999998, 0.0086425540000000002, 
	0.0091097550000000006, 0.0095784389999999994, 0.010048649999999999, 
	0.010520450000000001, 0.010993879999999999, 0.011469, 
	0.011945890000000001, 0.012424599999999999, 0.01290521, 0.0133878, 
	0.01387246, 0.01435928, 0.01484836, 0.01533983, 0.015833799999999999, 
	0.016330419999999998, 0.016829859999999999, 0.01733227, 
	0.017837869999999999, 0.018346879999999999, 0.018859580000000001, 
	0.019376250000000001, 0.019897270000000002, 0.02042306, 0.02095414, 
	0.021491130000000001, 0.02203482, 0.022586209999999999, 
	0.023146630000000001, 0.023717849999999999, 0.00042846650000000002, 
	0.00085780760000000002, 0.0012880400000000001, 0.0017191820000000001, 
	0.0021512509999999999, 0.0025842669999999999, 0.0030182490000000002, 
	0.0034532180000000001, 0.0038891970000000001, 0.004326206, 0.004764272, 
	0.0052034170000000001, 0.0056436699999999999, 0.0060850560000000001, 
	0.0065276049999999997, 0.0069713479999999996, 0.0074163160000000001, 
	0.0078625440000000008, 0.0083100680000000003, 0.0087589250000000007, 
	0.0092091570000000008, 0.0096608059999999992, 0.01011392, 0.01056854, 
	0.01102473, 0.011482539999999999, 0.011942029999999999, 
	0.012403269999999999, 0.01286633, 0.013331279999999999, 0.01379821, 
	0.014267210000000001, 0.014738380000000001, 0.015211819999999999, 
	0.015687670000000001, 0.016166059999999999, 0.01664713, 
	0.017131070000000002, 0.01761805, 0.018108309999999999, 0.0186021, 
	0.019099720000000001, 0.019601500000000001, 0.020107860000000002, 
	0.0206193, 0.021136430000000001, 0.02166001, 0.022190999999999999, 
	0.022730690000000001, 0.023280809999999999, 0.02384381, 
	0.00041282610000000001, 0.000826474, 0.001240959, 0.0016562980000000001,
	0.0020725079999999998, 0.0024896050000000002, 0.0029076089999999998, 
	0.003326538, 0.0037464120000000002, 0.0041672530000000001, 
	0.0045890810000000001, 0.0050119199999999996, 0.0054357939999999999, 
	0.0058607269999999996, 0.0062867460000000002, 0.0067138800000000002, 
	0.0071421549999999999, 0.0075716050000000003, 0.0080022619999999996, 
	0.0084341590000000001, 0.0088673339999999993, 0.0093018249999999997, 
	0.009737674, 0.01017493, 0.010613630000000001, 0.011053820000000001, 
	0.01149558, 0.01193894, 0.012383979999999999, 0.01283076, 0.01327936, 
	0.01372985, 0.01418233, 0.01463689, 0.01509364, 0.015552689999999999, 
	0.016014170000000001, 0.016478240000000002, 0.01694505, 
	0.017414789999999999, 0.01788768, 0.018363959999999999, 0.01884392, 
	0.01932789, 0.019816259999999999, 0.020309529999999999, 
	0.020808279999999998, 0.021313240000000001, 0.021825359999999999, 
	0.02234589, 0.022876489999999999, 0.023419570000000001, 
	0.023978699999999999, 0.00039829280000000002, 0.00079735940000000001, 
	0.001197214, 0.001597872, 0.0019993490000000001, 0.0024016609999999998, 
	0.002804824, 0.0032088569999999999, 0.0036137769999999999, 
	0.0040196040000000004, 0.004426358, 0.0048340589999999999, 
	0.0052427289999999998, 0.005652392, 0.0060630720000000001, 
	0.0064747930000000004, 0.0068875830000000001, 0.0073014689999999997, 
	0.0077164820000000002, 0.0081326520000000006, 0.0085500130000000004, 
	0.0089686000000000002, 0.0093884499999999996, 0.0098096030000000001, 
	0.010232099999999999, 0.010655990000000001, 0.01108132, 0.01150814, 
	0.011936509999999999, 0.012366479999999999, 0.01279813, 0.01323152, 
	0.01366674, 0.014103859999999999, 0.01454298, 0.0149842, 
	0.015427639999999999, 0.015873419999999999, 0.016321680000000002, 
	0.016772579999999999, 0.0172263, 0.017683049999999999, 
	0.018143070000000001, 0.018606629999999999, 0.019074049999999999, 
	0.019545730000000001, 0.020022120000000001, 0.020503799999999999, 
	0.020991490000000002, 0.021486109999999999, 0.021988850000000001, 
	0.022501360000000001, 0.02302597, 0.023566170000000001, 
	0.024127619999999999, 0.0003847527, 0.00077023550000000004, 0.001156462,
	0.0015434450000000001, 0.0019312000000000001, 0.0023197410000000002, 
	0.002709085, 0.0030992459999999999, 0.0034902430000000001, 
	0.0038820920000000002, 0.0042748120000000002, 0.0046684229999999997, 
	0.0050629439999999998, 0.0054583959999999999, 0.0058548020000000001, 
	0.0062521850000000004, 0.0066505679999999999, 0.0070499789999999996, 
	0.0074504430000000002, 0.0078519890000000002, 0.0082546479999999998, 
	0.0086584509999999993, 0.0090634319999999997, 0.0094696280000000008, 
	0.0098770769999999997, 0.010285819999999999, 0.0106959, 0.01110736, 
	0.011520259999999999, 0.01193464, 0.01235057, 0.012768109999999999, 
	0.013187330000000001, 0.01360831, 0.014031109999999999, 
	0.014455839999999999, 0.014882599999999999, 0.015311490000000001, 
	0.015742630000000001, 0.016176159999999998, 0.01661224, 0.01705104, 
	0.01749276, 0.01793763, 0.018385909999999998, 0.018837929999999999, 
	0.019294059999999998, 0.01975474, 0.02022055, 0.020692160000000001, 
	0.02117049, 0.021656689999999999, 0.022152379999999999, 
	0.022659820000000001, 0.02318245, 0.02372577, 0.0242997, 
	0.00037210709999999997, 0.00074490419999999997, 0.0011184039999999999, 
	0.001492618, 0.001867561, 0.002243246, 0.0026196879999999998, 
	0.0029969010000000002, 0.0033749019999999999, 0.003753705, 
	0.0041333300000000002, 0.004513792, 0.0048951109999999997, 
	0.0052773050000000004, 0.0056603959999999998, 0.0060444050000000001, 
	0.0064293529999999996, 0.006815265, 0.0072021639999999996, 
	0.0075900780000000001, 0.0079790339999999994, 0.0083690599999999993, 
	0.0087601869999999991, 0.0091524499999999995, 0.0095458799999999996, 
	0.0099405169999999994, 0.010336400000000001, 0.01073357, 
	0.011132070000000001, 0.011531960000000001, 0.011933269999999999, 
	0.012336079999999999, 0.01274044, 0.013146410000000001, 0.01355408, 
	0.01396351, 0.0143748, 0.014788030000000001, 0.015203329999999999, 
	0.015620800000000001, 0.016040579999999999, 0.016462810000000001, 
	0.016887679999999999, 0.017315359999999998, 0.017746080000000001, 
	0.018180109999999999, 0.018617749999999999, 0.019059360000000001, 
	0.019505390000000001, 0.019956370000000001, 0.020412989999999999, 
	0.020876120000000001, 0.02134691, 0.021826910000000001, 
	0.022318359999999999, 0.022824609999999999, 0.02335106, 
	0.023907439999999999, 0.024514310000000001, 0.00036026990000000001, 
	0.00072119290000000004, 0.0010827810000000001, 0.0014450450000000001, 
	0.0018079979999999999, 0.002171652, 0.0025360220000000002, 0.002901121, 
	0.0032669629999999999, 0.0036335629999999998, 0.0040009370000000004, 
	0.0043691019999999997, 0.0047380740000000001, 0.0051078709999999999, 
	0.005478513, 0.0058500169999999999, 0.0062224059999999998, 
	0.0065957009999999998, 0.0069699239999999997, 0.0073450989999999999, 
	0.0077212510000000002, 0.0080984079999999996, 0.0084765959999999994, 
	0.0088558460000000006, 0.00923619, 0.0096176600000000001, 0.01000029, 
	0.01038413, 0.0107692, 0.01115556, 0.01154326, 0.01193233, 0.01232285, 
	0.01271486, 0.013108430000000001, 0.013503630000000001, 
	0.013900529999999999, 0.01429923, 0.014699810000000001, 0.01510238, 
	0.01550706, 0.015913960000000001, 0.016323230000000001, 
	0.016735050000000001, 0.017149589999999999, 0.017567079999999999, 
	0.01798777, 0.01841195, 0.018839979999999999, 0.019272299999999999, 
	0.01970943, 0.020152030000000001, 0.02060095, 0.021057320000000001, 
	0.021522670000000001, 0.021999189999999998, 0.022490139999999999, 
	0.02300085, 0.023540869999999998, 0.024130390000000002, 
	0.024826839999999999, 0.00034916569999999999, 0.00069895060000000004, 
	0.001049365, 0.001400421, 0.00175213, 0.0021045030000000002, 
	0.002457552, 0.002811292, 0.0031657339999999999, 0.0035208940000000001, 
	0.0038767850000000002, 0.0042334219999999997, 0.0045908219999999996, 
	0.0049490009999999997, 0.0053079759999999998, 0.0056677660000000003, 
	0.006028388, 0.0063898640000000003, 0.006752213, 0.0071154590000000002, 
	0.0074796230000000003, 0.0078447299999999994, 0.0082108059999999993, 
	0.0085778790000000001, 0.0089459759999999996, 0.0093151280000000006, 
	0.0096853689999999992, 0.01005673, 0.010429249999999999, 0.01080298, 
	0.011177940000000001, 0.011554190000000001, 0.01193177, 
	0.012310740000000001, 0.01269116, 0.013073090000000001, 
	0.013456589999999999, 0.01384175, 0.014228630000000001, 0.01461734, 
	0.015007970000000001, 0.01540063, 0.015795449999999999, 0.01619257, 
	0.01659215, 0.016994370000000002, 0.017399439999999999, 0.01780762, 
	0.018219180000000001, 0.01863449, 0.01905395, 0.019478079999999998, 
	0.019907540000000001, 0.020343159999999999, 0.02078603, 
	0.021237659999999998, 0.021700179999999999, 0.022176830000000002, 
	0.02267282, 0.023197550000000001, 0.023770889999999999, 
	0.024449309999999998, 0.025596270000000001, 0.01539744, 
	0.0057670350000000002, 0.01157275, 0.017419980000000002, 
	0.0036457740000000001, 0.0073128059999999998, 0.011002100000000001, 
	0.01471474, 0.018451889999999999, 0.0026868719999999999, 
	0.0053877939999999996, 0.0081033370000000004, 0.010834109999999999, 
	0.013580770000000001, 0.016344029999999999, 0.019124660000000002, 
	0.002134927, 0.004280051, 0.006435751, 0.0086024299999999995, 
	0.01078052, 0.01297048, 0.01517281, 0.01738806, 0.0196168, 
	0.0017744919999999999, 0.0035568230000000002, 0.0053472629999999997, 
	0.007146103, 0.0089536479999999998, 0.01077023, 0.0125962, 
	0.014431950000000001, 0.01627787, 0.01813441, 0.020002059999999999, 
	0.001519933, 0.0030461310000000001, 0.0045787989999999997, 
	0.0061181550000000001, 0.0076644299999999999, 0.0092178729999999997, 
	0.01077875, 0.01234734, 0.013923949999999999, 0.015508900000000001, 
	0.017102559999999999, 0.018705309999999999, 0.02031755, 
	0.0013302450000000001, 0.0026656409999999998, 0.0040063499999999997, 
	0.0053525409999999997, 0.0067043950000000001, 0.0080621059999999994, 
	0.0094258780000000004, 0.01079593, 0.012172499999999999, 0.01355584, 
	0.01494622, 0.01634393, 0.017749299999999999, 0.01916267, 
	0.020584410000000001, 0.0011832609999999999, 0.0023708510000000002, 
	0.003562899, 0.0047595409999999999, 0.0059609229999999999, 0.007167199, 
	0.0083785330000000005, 0.0095951000000000005, 0.01081709, 0.0120447, 
	0.013278140000000001, 0.01451765, 0.01576348, 0.017015889999999999, 
	0.018275179999999999, 0.019541679999999999, 0.020815730000000001, 
	0.0010659230000000001, 0.002135545, 0.0032089729999999999, 
	0.0042863190000000002, 0.0053677020000000002, 0.0064532490000000003, 
	0.0075430920000000004, 0.0086373749999999992, 0.0097362500000000001, 
	0.01083988, 0.011948429999999999, 0.0130621, 0.01418109, 
	0.015305610000000001, 0.0164359, 0.0175722, 0.018714809999999998, 
	0.01986402, 0.021020170000000001, 0.00097002350000000004, 0.001943253, 
	0.0029197770000000001, 0.0038996899999999999, 0.0048830899999999997, 
	0.0058700829999999999, 0.006860779, 0.0078552980000000001, 
	0.0088537640000000001, 0.0098563109999999995, 0.010863080000000001, 
	0.01187423, 0.012889930000000001, 0.01391034, 0.01493567, 
	0.015966109999999999, 0.0170019, 0.01804327, 0.0190905, 
	0.020143879999999999, 0.021203739999999999, 0.00089014230000000001, 
	0.0017830949999999999, 0.0026789320000000002, 0.0035777349999999999, 
	0.0044795859999999998, 0.005384575, 0.006292794, 0.0072043430000000002, 
	0.0081193280000000003, 0.0090378609999999995, 0.0099600620000000004, 
	0.010886059999999999, 0.01181599, 0.012749999999999999, 
	0.013688240000000001, 0.014630900000000001, 0.015578150000000001, 
	0.01653019, 0.017487249999999999, 0.01844956, 0.019417380000000001, 
	0.020391010000000001, 0.021370770000000001, 0.00082255060000000001, 
	0.001647588, 0.0024751780000000002, 0.0033053869999999999, 0.004138287, 
	0.0049739550000000004, 0.0058124689999999998, 0.0066539140000000004, 
	0.0074983810000000001, 0.0083459640000000009, 0.0091967639999999996, 
	0.01005089, 0.01090846, 0.01176959, 0.01263442, 0.013503090000000001, 
	0.01437575, 0.01525258, 0.016133749999999999, 0.01701946, 
	0.017909930000000001, 0.018805390000000002, 0.019706100000000001, 
	0.02061236, 0.021524499999999998, 0.00076459840000000004, 
	0.0015314160000000001, 0.00230051, 0.0030719369999999998, 
	0.0038457610000000001, 0.0046220460000000003, 0.0054008600000000004, 
	0.0061822780000000003, 0.0069663759999999998, 0.0077532349999999998, 
	0.0085429419999999995, 0.0093355899999999995, 0.010131279999999999, 
	0.01093011, 0.01173219, 0.012537660000000001, 0.01334663, 0.01415925, 
	0.01497567, 0.015796060000000001, 0.016620590000000001, 
	0.017449470000000002, 0.018282900000000001, 0.01912113, 
	0.019964429999999998, 0.020813080000000001, 0.02166742, 
	0.00071434920000000004, 0.001430693, 0.0021490810000000002, 
	0.0028695629999999999, 0.0035921949999999998, 0.0043170320000000002, 
	0.0050441349999999999, 0.0057735659999999999, 0.0065053919999999996, 
	0.0072396839999999997, 0.0079765170000000007, 0.00871597, 
	0.0094581289999999991, 0.01020308, 0.010950929999999999, 0.01170177, 
	0.01245572, 0.01321289, 0.01397342, 0.014737439999999999, 
	0.015505100000000001, 0.016276579999999999, 0.017052060000000001, 
	0.017831719999999999, 0.01861579, 0.019404520000000001, 
	0.020198170000000001, 0.02099705, 0.021801500000000001, 
	0.00067035439999999999, 0.001342513, 0.002016519, 0.002692416, 
	0.003370254, 0.0040500809999999996, 0.0047319490000000001, 0.005415914, 
	0.0061020349999999996, 0.0067903720000000002, 0.0074809910000000002, 
	0.0081739610000000004, 0.0088693560000000001, 0.0095672540000000007, 
	0.010267739999999999, 0.0109709, 0.011676829999999999, 0.01238563, 
	0.01309742, 0.01381231, 0.01453043, 0.01525192, 0.01597695, 
	0.016705660000000001, 0.017438249999999999, 0.018174920000000001, 
	0.018915890000000001, 0.019661419999999999, 0.020411780000000001, 
	0.0211673, 0.021928340000000001, 0.00063150860000000001, 
	0.0012646580000000001, 0.0018994859999999999, 0.002536033, 
	0.0031743399999999999, 0.0038144519999999999, 0.0044564139999999997, 
	0.0051002759999999999, 0.0057460879999999999, 0.0063939050000000001, 
	0.007043784, 0.0076957850000000001, 0.0083499720000000006, 
	0.0090064140000000008, 0.0096651840000000003, 0.01032636, 0.01099002, 
	0.01165626, 0.01232517, 0.012996850000000001, 0.01367142, 
	0.014349000000000001, 0.01502971, 0.015713700000000001, 
	0.016401120000000002, 0.01709215, 0.017786969999999999, 0.0184858, 
	0.019188859999999999, 0.019896420000000001, 0.02060878, 0.02132626, 
	0.022049269999999999, 0.00059695340000000003, 0.001195406, 0.001795392, 
	0.002396947, 0.003000108, 0.0036049150000000002, 0.0042114070000000003, 
	0.0048196280000000003, 0.0054296240000000001, 0.0060414420000000002, 
	0.0066551329999999997, 0.0072707500000000003, 0.0078883500000000006, 
	0.0085079920000000007, 0.0091297400000000008, 0.0097536629999999992, 
	0.01037983, 0.01100832, 0.01163922, 0.01227262, 0.012908609999999999, 
	0.01354729, 0.01418878, 0.0148332, 0.01548068, 0.016131369999999999, 
	0.016785419999999999, 0.01744302, 0.018104370000000002, 
	0.018769669999999999, 0.019439169999999999, 0.020113160000000001, 
	0.02079195, 0.021475890000000001, 0.022165420000000002, 
	0.00056601150000000001, 0.001133399, 0.001702194, 0.002272427, 
	0.0028441320000000001, 0.0034173430000000002, 0.0039920980000000003, 
	0.0045684339999999997, 0.0051463919999999996, 0.0057260150000000001, 
	0.0063073469999999996, 0.0068904350000000003, 0.0074753299999999996, 
	0.0080620840000000006, 0.0086507530000000006, 0.0092413979999999996, 
	0.0098340830000000004, 0.01042887, 0.01102584, 0.01162507, 0.01222664, 
	0.012830640000000001, 0.01343717, 0.014046329999999999, 0.01465823, 
	0.01527301, 0.015890809999999998, 0.01651176, 0.01713603, 0.01776382, 
	0.01839532, 0.019030769999999999, 0.019670429999999999, 0.02031459, 
	0.020963599999999999, 0.021617850000000001, 0.0222778, 
	0.00053814179999999996, 0.0010775520000000001, 0.001618258, 
	0.0021602879999999998, 0.0027036730000000002, 0.0032484419999999998, 
	0.0037946299999999998, 0.004342271, 0.0048913999999999997, 
	0.0054420559999999998, 0.0059942789999999999, 0.0065481100000000002, 
	0.0071035949999999999, 0.0076607799999999998, 0.0082197150000000007, 
	0.0087804530000000006, 0.0093430500000000003, 0.0099075670000000008, 
	0.01047407, 0.01104262, 0.01161329, 0.01218617, 0.012761339999999999, 
	0.013338890000000001, 0.01391891, 0.01450153, 0.015086850000000001, 
	0.015675000000000001, 0.01626613, 0.016860389999999999, 
	0.017457960000000002, 0.018059019999999999, 0.018663809999999999, 
	0.019272569999999999, 0.019885570000000002, 0.02050314, 
	0.021125660000000001, 0.02175355, 0.02238735, 0.00051290630000000003, 
	0.0010269859999999999, 0.0015422630000000001, 0.0020587639999999998, 
	0.0025765150000000001, 0.0030955449999999999, 0.0036158829999999999, 
	0.0041375609999999997, 0.0046606099999999999, 0.005185065, 
	0.0057109609999999996, 0.006238337, 0.0067672319999999998, 
	0.0072976880000000001, 0.0078297490000000004, 0.0083634629999999998, 
	0.0088988790000000002, 0.0094360510000000009, 0.0099750350000000002, 
	0.01051589, 0.011058689999999999, 0.011603489999999999, 
	0.012150370000000001, 0.01269941, 0.013250700000000001, 0.01380434, 
	0.014360410000000001, 0.01491904, 0.01548035, 0.01604448, 
	0.016611560000000001, 0.017181769999999999, 0.01775529, 
	0.018332319999999999, 0.01891311, 0.019497919999999998, 
	0.020087049999999999, 0.020680850000000001, 0.021279760000000002, 
	0.021884250000000001, 0.022494920000000002, 0.00048994670000000002, 
	0.00098098200000000003, 0.001473128, 0.0019664090000000001, 
	0.0024608479999999999, 0.002956471, 0.0034533060000000002, 
	0.0039513789999999997, 0.0044507210000000004, 0.0049513609999999996, 
	0.005453332, 0.0059566690000000004, 0.0064614060000000003, 
	0.0069675819999999999, 0.0074752359999999997, 0.0079844100000000008, 
	0.0084951499999999999, 0.0090075020000000006, 0.0095215170000000002, 
	0.010037249999999999, 0.01055475, 0.01107409, 0.011595329999999999, 
	0.012118540000000001, 0.0126438, 0.013171189999999999, 
	0.013700800000000001, 0.014232720000000001, 0.01476706, 0.01530395, 
	0.015843489999999998, 0.01638585, 0.016931169999999999, 
	0.017479629999999999, 0.018031419999999999, 0.018586780000000001, 
	0.01914594, 0.019709210000000001, 0.020276929999999999, 
	0.020849489999999998, 0.021427350000000001, 0.022011099999999999, 
	0.022601409999999999, 0.00046896710000000002, 0.00093894729999999997, 
	0.0014099609999999999, 0.00188203, 0.0023551750000000002, 
	0.0028294209999999999, 0.0033047910000000001, 0.00378131, 
	0.0042590060000000001, 0.0047379060000000001, 0.0052180389999999998, 
	0.0056994360000000004, 0.0061821289999999997, 0.0066661519999999998, 
	0.0071515399999999996, 0.0076383329999999998, 0.0081265690000000002, 
	0.0086162900000000004, 0.0091075440000000004, 0.0096003749999999995, 
	0.010094840000000001, 0.01059098, 0.011088870000000001, 
	0.011588569999999999, 0.012090129999999999, 0.01259364, 0.01309918, 
	0.01360682, 0.01411666, 0.014628810000000001, 0.01514336, 
	0.015660449999999999, 0.01618021, 0.016702789999999999, 0.01722835, 
	0.01775709, 0.01828921, 0.018824960000000002, 0.019364619999999999, 
	0.019908510000000001, 0.020457019999999999, 0.021010589999999999, 
	0.02156976, 0.022135200000000001, 0.022707740000000001, 
	0.00044972099999999999, 0.00090038749999999995, 0.001352018, 
	0.001804632, 0.0022582499999999998, 0.0027128930000000001, 0.003168583, 
	0.0036253430000000001, 0.0040831970000000002, 0.0045421699999999999, 
	0.005002289, 0.0054635819999999998, 0.0059260780000000004, 0.006389807, 
	0.0068548009999999998, 0.007321096, 0.0077887269999999996, 
	0.0082577310000000008, 0.0087281500000000005, 0.0092000269999999995, 
	0.0096734060000000007, 0.01014834, 0.01062487, 0.01110306, 0.01158298, 
	0.01206467, 0.012548220000000001, 0.013033690000000001, 
	0.013521180000000001, 0.014010750000000001, 0.01450252, 
	0.014996590000000001, 0.015493079999999999, 0.015992099999999999, 
	0.016493819999999999, 0.01699838, 0.017505969999999999, 
	0.018016790000000001, 0.01853107, 0.019049079999999999, 
	0.019571140000000001, 0.0200976, 0.020628899999999999, 0.02116556, 
	0.02170822, 0.022257679999999998, 0.022814950000000001, 
	0.00043200120000000001, 0.00086488699999999995, 0.0012986740000000001, 
	0.001733381, 0.0021690260000000001, 0.0026056289999999999, 
	0.0030432079999999999, 0.0034817870000000001, 0.0039213859999999998, 
	0.0043620280000000004, 0.0048037380000000001, 0.0052465410000000004, 
	0.0056904629999999998, 0.006135532, 0.0065817779999999999, 
	0.0070292310000000004, 0.0074779240000000004, 0.0079278920000000006, 
	0.00837917, 0.0088317970000000006, 0.0092858149999999993, 
	0.0097412669999999996, 0.010198199999999999, 0.01065666, 0.01111671, 
	0.011578389999999999, 0.01204178, 0.012506929999999999, 0.01297393, 
	0.013442839999999999, 0.013913750000000001, 0.01438676, 0.01486196, 
	0.015339469999999999, 0.015819409999999999, 0.016301909999999999, 
	0.016787139999999999, 0.017275260000000001, 0.017766469999999999, 
	0.018260990000000001, 0.018759089999999999, 0.019261049999999998, 
	0.01976723, 0.020278049999999999, 0.020794010000000002, 0.02131572, 
	0.021843959999999999, 0.022379710000000001, 0.022924259999999998, 
	0.00041563240000000001, 0.00083209430000000001, 0.001249401, 
	0.0016675699999999999, 0.0020866180000000002, 0.0025065619999999999, 
	0.0029274209999999999, 0.0033492130000000002, 0.0037719609999999999, 
	0.0041956830000000004, 0.0046204030000000004, 0.005046142, 
	0.0054729269999999998, 0.0059007809999999999, 0.0063297309999999999, 
	0.0067598060000000001, 0.0071910350000000001, 0.007623449, 
	0.0080570799999999995, 0.0084919660000000001, 0.0089281399999999993, 
	0.0093656439999999994, 0.0098045200000000006, 0.01024481, 
	0.010686559999999999, 0.01112983, 0.01157467, 0.01202113, 
	0.012469279999999999, 0.0129192, 0.01337094, 0.013824609999999999, 
	0.014280269999999999, 0.014738040000000001, 0.01519801, 
	0.015660319999999998, 0.01612508, 0.01659244, 0.017062589999999999, 
	0.01753569, 0.018011969999999999, 0.018491670000000002, 
	0.018975079999999998, 0.019462549999999999, 0.01995446, 
	0.020451319999999999, 0.02095371, 0.02146238, 0.021978279999999999, 
	0.022502660000000001, 0.023037220000000001, 0.0004004651, 
	0.00080170980000000001, 0.0012037490000000001, 0.001606597, 
	0.0020102700000000002, 0.0024147840000000001, 0.0028201569999999998, 
	0.0032264049999999999, 0.0036335479999999999, 0.0040416039999999999, 
	0.0044505940000000004, 0.0048605380000000002, 0.0052714600000000004, 
	0.0056833810000000004, 0.0060963270000000003, 0.0065103230000000002, 
	0.006925395, 0.0073415720000000002, 0.0077588850000000001, 0.008177363, 
	0.0085970419999999992, 0.0090179560000000006, 0.0094401429999999998, 
	0.0098636439999999995, 0.010288500000000001, 0.01071476, 0.01114247, 
	0.011571680000000001, 0.01200245, 0.012434840000000001, 
	0.012868920000000001, 0.013304750000000001, 0.01374242, 0.01418202, 
	0.01462362, 0.01506735, 0.015513310000000001, 0.015961630000000001, 
	0.016412449999999999, 0.016865930000000001, 0.017322250000000001, 
	0.01778163, 0.018244300000000001, 0.018710540000000001, 0.01918067, 
	0.01965509, 0.020134269999999999, 0.020618770000000002, 
	0.021109329999999999, 0.02160687, 0.0221126, 0.022628180000000001, 
	0.02315594, 0.00038637129999999998, 0.00077347679999999999, 
	0.0011613299999999999, 0.0015499450000000001, 0.0019393360000000001, 
	0.002329518, 0.0027205060000000001, 0.0031123180000000002, 
	0.0035049690000000001, 0.0038984789999999998, 0.0042928640000000004, 
	0.0046881450000000003, 0.005084341, 0.0054814750000000004, 
	0.0058795669999999996, 0.0062786420000000001, 0.0066787239999999996, 
	0.0070798399999999996, 0.0074820140000000004, 0.0078852780000000008, 
	0.0082896600000000008, 0.0086951939999999998, 0.0091019139999999991, 
	0.0095098539999999999, 0.0099190549999999995, 0.01032956, 0.0107414, 
	0.01115464, 0.011569329999999999, 0.0119855, 0.012403239999999999, 
	0.01282259, 0.013243639999999999, 0.01366644, 0.014091090000000001, 
	0.01451768, 0.014946310000000001, 0.01537707, 0.015810109999999999, 
	0.016245559999999999, 0.01668356, 0.017124299999999999, 0.01756798, 
	0.018014829999999999, 0.01846511, 0.018919149999999999, 0.01937732, 
	0.01984008, 0.020307990000000001, 0.020781750000000002, 0.02126225, 
	0.02175069, 0.02224866, 0.022758460000000001, 0.023283519999999999, 
	0.00037324050000000001, 0.00074717380000000001, 0.001121812, 
	0.001497169, 0.0018732569999999999, 0.0022500910000000001, 
	0.0026276839999999999, 0.0030060519999999999, 0.0033852109999999999, 
	0.0037651759999999999, 0.0041459660000000001, 0.0045275970000000004, 
	0.004910088, 0.0052934590000000004, 0.0056777299999999998, 
	0.0060629220000000001, 0.0064490579999999997, 0.0068361610000000003, 
	0.0072242570000000004, 0.0076133720000000002, 0.0080035320000000007, 
	0.0083947680000000004, 0.0087871100000000008, 0.0091805910000000001, 
	0.0095752470000000003, 0.0099711130000000002, 0.010368230000000001, 
	0.010766639999999999, 0.01116639, 0.011567529999999999, 
	0.011970099999999999, 0.01237417, 0.012779799999999999, 0.01318706, 
	0.01359601, 0.01400673, 0.014419319999999999, 0.014833870000000001, 
	0.01525049, 0.015669289999999999, 0.016090409999999999, 
	0.016513989999999999, 0.016940219999999999, 0.017369269999999999, 
	0.017801379999999999, 0.018236809999999999, 0.018675870000000001, 
	0.019118909999999999, 0.019566400000000001, 0.020018859999999999, 
	0.020476979999999999, 0.020941629999999999, 0.021413979999999999, 
	0.021895589999999999, 0.022388689999999999, 0.022896650000000001, 
	0.023424899999999999, 0.00036097689999999998, 0.00072260879999999997, 
	0.001084907, 0.001447884, 0.001811551, 0.0021759219999999998, 
	0.0025410099999999998, 0.0029068290000000001, 0.0032733929999999999, 
	0.0036407169999999999, 0.0040088179999999999, 0.0043777110000000003, 
	0.0047474140000000001, 0.0051179440000000001, 0.0054893210000000001, 
	0.0058615630000000002, 0.0062346930000000004, 0.0066087300000000002, 
	0.006983698, 0.0073596210000000002, 0.0077365239999999998, 
	0.0081144340000000002, 0.0084933779999999993, 0.0088733879999999994, 
	0.0092544940000000003, 0.0096367299999999996, 0.01002013, 
	0.010404740000000001, 0.010790589999999999, 0.01117773, 0.0115662, 
	0.011956069999999999, 0.01234737, 0.01274018, 0.01313454, 
	0.013530550000000001, 0.01392826, 0.01432778, 0.01472918, 0.01513257, 
	0.015538069999999999, 0.015945810000000001, 0.016355930000000001, 
	0.016768600000000002, 0.017184000000000001, 0.017602360000000001, 
	0.018023919999999999, 0.018448989999999998, 0.018877919999999999, 
	0.019311140000000001, 0.01974919, 0.020192720000000001, 
	0.020642600000000001, 0.021099949999999999, 0.0215663, 
	0.022043839999999999, 0.02253587, 0.023047700000000001, 
	0.023588930000000001, 0.00034949720000000001, 0.00069961450000000005, 
	0.001050362, 0.001401752, 0.001753796, 0.0021065039999999999, 
	0.0024598910000000001, 0.002813968, 0.0031687479999999999, 
	0.0035242469999999999, 0.003880479, 0.0042374580000000004, 
	0.0045951999999999998, 0.0049537230000000002, 0.0053130419999999996, 
	0.0056731769999999997, 0.0060341470000000001, 0.00639597, 
	0.0067586679999999998, 0.0071222639999999997, 0.0074867800000000002, 
	0.0078522399999999999, 0.0082186700000000008, 0.0085860970000000009, 
	0.0089545509999999998, 0.0093240619999999993, 0.0096946619999999997, 
	0.01006639, 0.01043927, 0.010813359999999999, 0.011188689999999999, 
	0.011565300000000001, 0.011943260000000001, 0.0123226, 0.01270339, 
	0.0130857, 0.01346958, 0.01385511, 0.014242380000000001, 
	0.014631470000000001, 0.01502248, 0.01541553, 0.015810749999999998, 
	0.016208259999999999, 0.01660824, 0.017010859999999999, 
	0.017416350000000001, 0.017824929999999999, 0.018236909999999999, 
	0.018652640000000002, 0.019072530000000001, 0.0194971, 
	0.019926989999999999, 0.020363059999999999, 0.020806390000000001, 
	0.02125848, 0.02172149, 0.022198639999999999, 0.022695159999999999, 
	0.023220459999999998, 0.023794450000000002, 0.00033872820000000001, 
	0.00067804439999999996, 0.0010179589999999999, 0.0013584809999999999, 
	0.0016996229999999999, 0.0020413940000000002, 0.0023838079999999998, 
	0.0027268750000000001, 0.0030706079999999998, 0.0034150199999999999, 
	0.0037601240000000001, 0.0041059349999999998, 0.0044524669999999999, 
	0.0047997359999999998, 0.0051477570000000002, 0.0054965470000000001, 
	0.0058461229999999999, 0.0061965049999999997, 0.00654771, 
	0.0068997599999999996, 0.0072526750000000001, 0.0076064770000000004, 
	0.0079611920000000006, 0.0083168419999999996, 0.0086734550000000001, 
	0.0090310589999999993, 0.0093896819999999999, 0.0097493570000000002, 
	0.01011012, 0.010472, 0.010835040000000001, 0.011199280000000001, 
	0.01156476, 0.011931539999999999, 0.01229966, 0.01266918, 0.01304015, 
	0.01341266, 0.01378676, 0.01416253, 0.01454007, 0.014919470000000001, 
	0.01530085, 0.01568431, 0.016070000000000001, 0.01645808, 
	0.016848720000000001, 0.01724212, 0.017638540000000001, 
	0.018038249999999999, 0.018441599999999999, 0.018848989999999999, 
	0.019260920000000001, 0.019678040000000001, 0.02010116, 
	0.020531359999999999, 0.02097011, 0.021419520000000001, 
	0.021882749999999999, 0.022364950000000001, 0.022875360000000001, 
	0.023433570000000001, 0.02409526, 0.00032860570000000001, 
	0.00065776989999999998, 0.00098750180000000006, 0.0013178109999999999, 
	0.001648708, 0.0019802019999999999, 0.0023123050000000002, 
	0.0026450269999999999, 0.002978381, 0.0033123779999999999, 
	0.0036470299999999999, 0.0039823510000000003, 0.0043183539999999999, 
	0.0046550539999999996, 0.0049924649999999998, 0.0053306029999999997, 
	0.0056694830000000003, 0.0060091240000000002, 0.0063495410000000002, 
	0.0066907549999999996, 0.0070327840000000003, 0.0073756489999999997, 
	0.0077193720000000004, 0.0080639749999999993, 0.0084094830000000006, 
	0.0087559200000000004, 0.0091033160000000002, 0.0094516970000000002, 
	0.0098010939999999998, 0.010151540000000001, 0.01050307, 
	0.010855719999999999, 0.011209530000000001, 0.01156454, 0.01192081, 
	0.01227837, 0.012637290000000001, 0.01299761, 0.01335941, 
	0.013722760000000001, 0.01408774, 0.014454409999999999, 0.0148229, 
	0.01519329, 0.01556571, 0.015940280000000001, 0.016317169999999999, 
	0.016696550000000001, 0.017078610000000001, 0.017463599999999999, 
	0.017851780000000001, 0.018243499999999999, 0.018639139999999998, 
	0.019039219999999999, 0.019444340000000001, 0.019855299999999999, 
	0.020273179999999998, 0.0206994, 0.02113605, 0.021586230000000001, 
	0.02205501, 0.02255149, 0.023094960000000001, 0.023740219999999999, 
	0.024839429999999999)
"covtable.cauchy" <-
c(0.5563805, 0.07412315, 0.01483400, 0.04205592, 0.08809336, 
0.02915369, 0.00666497, 0.01551341, 0.02628851, 0.0032219, 0.006991005, 
0.01156913, 0.01759364, 0.02723501, 0.01732993, 0.004169381, 
0.00906679, 0.01460002, 0.002082051, 0.004385687, 0.006980324, 
0.009972203, 0.01353913, 0.00136719, 0.002835652, 0.004430841, 
0.006193553, 0.008202176, 0.01066288, 0.01457463)
