#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <curses.h>

/* These are the definitions from the WaveThresh package. */

#define PERIODIC        1
#define SYMMETRIC       2

/* Increasing this value would remove some nearly empty diagonals */

double thr=0.0;

/* The doubledouble structure is used by the makegrid function for
   sorting the data with respect to the x-component. */

struct doubledouble
           {
		   double x;
		   double y;
		   } Doubledouble;

int zwpo[17] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768,65536};
double alg61quant[11]={1.956,1.984,1.985,1.982,1.980,1.977,1.976,1.974,1.973,1.972,1.971};

int dcomp(double *a, double *b)
  {
  if(*a>*b) return 1;
  else if(*a==*b) return 0;
  else return -1;
  }

void dqsort(double *x, int n)
  {
  qsort(x,n,sizeof(double),(void *)(*dcomp));
  }
  
double MED(double *x,int n)
  {
  double *xbak,res;
  
  xbak=(double *)malloc(n*sizeof(double));
  memcpy(xbak,x,n*sizeof(double));
  dqsort(xbak,n);
  if(n%2==0) 
    res= (xbak[n/2-1]+xbak[n/2])/2.0;
  else
    res= xbak[(n+1)/2-1];
  free(xbak);
  return res;
  }

void alg61(double *t, double *y, int *n, double *gamma, double *noiselevel, long *isoutl)
  {
  int i,left,right;
  double lambda;
  
  for(i=0,left=0,right=0;i<*n;i++)
    {
	while(t[left]<t[i]-*gamma) left++;
	while((right<=*n-2)&&(t[i]+*gamma>t[right+1])) right++;
    if(left<right+1)
      {
	  if((right-left)%2==1)
	    {
	    if(t[i]-t[left]<t[right]-t[i])
	      right--;
	    else
	      left++;
	    }

      if((right-left)/2<=11)
        lambda=alg61quant[(right-left)/2-1];
      else 
        lambda=1.97;
      if(fabs(MED(y+left,right-left+1)-y[i])>lambda**noiselevel)
        isoutl[i]=TRUE;
      else
        isoutl[i]=FALSE;

	  }
	}
  }

void alg63(double *t, double *y, int *n, double *kappa, double *mu, double *noiselevel, long *isoutl)
  {
  int k,i,j,WEITER;
  double *z, *ztilde,window[5],gamma;
  
  z=(double *)calloc(*n,sizeof(double));
  ztilde=(double *)calloc(*n,sizeof(double));
  for(i=0;i<*n;i++)
    isoutl[i]=FALSE;
  k=0;
  do
    {
	switch(k)
	  {
	  case 0 : gamma=1.984;
	           break;
	  case 1 : gamma=1.330;
	           break;
	  case 2 : gamma=0.911;
	           break;
	  case 3 : gamma=0.633;
	           break;
	  case 4 : gamma=0.444;
	           break;
          case 5 : gamma=0.312;
                   break;
          case 6 : gamma=0.220;
                   break;
          default: gamma=0.22*pow(0.705,(double)k-6.0);
	           break;
	  }
	WEITER=FALSE;
  
    for(i=zwpo[k]-1;i<=*n-zwpo[k];i++)
      z[i]=MED(&(y[i-zwpo[k]+1]),zwpo[k+1]-1);
    /* Main part */
    for(i=5*zwpo[k]-3;i<=*n-5*zwpo[k]+2;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-5*zwpo[k]+3]-t[i+5*zwpo[k]-3])<*kappa))
        {
		WEITER=TRUE;
	    window[0]=z[i-zwpo[k+2]+2];
  	    window[1]=z[i-zwpo[k+1]+1];
	    window[2]=z[i];
	    window[3]=z[i+zwpo[k+1]-1];
	    window[4]=z[i+zwpo[k+2]-2];
	    if(fabs(z[i]-MED(window,5))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }
    /* The extreme left border */
    for(i=zwpo[k]-1;i<3*zwpo[k]-2;i++)
      {
      if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
        (fabs(t[i-zwpo[k]+1]-t[i+9*zwpo[k]-5])<*kappa))
        {
        WEITER=TRUE;
	    window[0]=z[i-zwpo[k+2]+2];
  	    window[1]=z[i-zwpo[k+1]+1];
	    window[2]=z[i];
	    window[3]=z[i+zwpo[k+1]-1];
	    window[4]=z[i+zwpo[k+2]-2];
	    if(fabs(z[i]-MED(window,5))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
        }
      }
     /* The remaining points on the left */
    for(i=3*zwpo[k]-2;i<5*zwpo[k]-3;i++)
      {
      if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
        (fabs(t[i-3*zwpo[k]+2]-t[i+7*zwpo[k]-4])<*kappa))
        {
        WEITER=TRUE;
	    window[0]=z[i-zwpo[k+2]+2];
  	    window[1]=z[i-zwpo[k+1]+1];
	    window[2]=z[i];
	    window[3]=z[i+zwpo[k+1]-1];
	    window[4]=z[i+zwpo[k+2]-2];
	    if(fabs(z[i]-MED(window,5))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
        }
      }
    /* right*/
    for(i=*n-5*zwpo[k]+3;i<=*n-3*zwpo[k]+1;i++)
      {
      if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
        (fabs(t[i-7*zwpo[k]+4]-t[i+3*zwpo[k]-2])<*kappa))
        {
        WEITER=TRUE;
	    window[0]=z[i-zwpo[k+2]+2];
  	    window[1]=z[i-zwpo[k+1]+1];
	    window[2]=z[i];
	    window[3]=z[i+zwpo[k+1]-1];
	    window[4]=z[i+zwpo[k+2]-2];
	    if(fabs(z[i]-MED(window,5))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
        }
      }
    /* extreme right*/
    for(i=*n-3*zwpo[k]+2;i<=*n-1;i++)
      {
      if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
        (fabs(t[i-9*zwpo[k]+5]-t[i+zwpo[k]-1])<*kappa))
        {
        WEITER=TRUE;
	    window[0]=z[i-zwpo[k+2]+2];
  	    window[1]=z[i-zwpo[k+1]+1];
	    window[2]=z[i];
	    window[3]=z[i+zwpo[k+1]-1];
	    window[4]=z[i+zwpo[k+2]-2];
	    if(fabs(z[i]-MED(window,5))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
        }
      }


    k++;
	} while(WEITER);

  free(z);
  free(ztilde);
  }

void alg63s(double *t, double *y, int *n, double *kappa, double *mu, double *noiselevel, long *isoutl)
  {
  int k,i,j,WEITER;
  double *z, *ztilde,window[5],gamma;
  
  z=(double *)calloc(*n,sizeof(double));
  ztilde=(double *)calloc(*n,sizeof(double));
  for(i=0;i<*n;i++)
    isoutl[i]=FALSE;
  k=0;
  do
    {
	switch(k)
	  {
	  case 0 : gamma=1.984;
	           break;
	  case 1 : gamma=1.298;
	           break;
	  case 2 : gamma=0.870;
	           break;
	  case 3 : gamma=0.595;
	           break;
	  case 4 : gamma=0.405;
	           break;
          case 5 : gamma=0.275;
                   break;
          case 6 : gamma=0.192;
                   break;
          default: gamma=0.192*pow(0.705,(double)k-6.0);
	           break;
	  }
	WEITER=FALSE;
  
    for(i=zwpo[k]-1;i<=*n-zwpo[k];i++)
      z[i]=MED(&(y[i-zwpo[k]+1]),zwpo[k+1]-1);
    /* The main part*/
    for(i=5*zwpo[k]-3;i<=*n-5*zwpo[k]+2;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-5*zwpo[k]+3]-t[i+5*zwpo[k]-3])<*kappa))
        {
		WEITER=TRUE;
	    if(fabs(z[i]-MED(&(y[i-5*zwpo[k]+3]),5*(zwpo[k+1]-1)))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }
	/* The extreme left border */
    for(i=zwpo[k]-1;i<3*zwpo[k]-2;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-zwpo[k]+1]-t[i+9*zwpo[k]-5])<*kappa))
        {
		WEITER=TRUE;
	    if(fabs(z[i]-MED(&(y[i-zwpo[k]+1]),5*(zwpo[k+1]-1)))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }
	 /* The remaining points on the left */
    for(i=3*zwpo[k]-2;i<5*zwpo[k]-3;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-3*zwpo[k]+2]-t[i+7*zwpo[k]-4])<*kappa))
        {
		WEITER=TRUE;
	    if(fabs(z[i]-MED(&(y[i-3*zwpo[k]+2]),5*(zwpo[k+1]-1)))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }
    /* right*/
    for(i=*n-5*zwpo[k]+3;i<=*n-3*zwpo[k]+1;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-7*zwpo[k]+4]-t[i+3*zwpo[k]-2])<*kappa))
        {
		WEITER=TRUE;
	    if(fabs(z[i]-MED(&(y[i-7*zwpo[k]+4]),5*(zwpo[k+1]-1)))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }

    /* extreme right*/
    for(i=*n-3*zwpo[k]+2;i<=*n-1;i++)
      {
	  if((fabs(t[i-zwpo[k]+1]-t[i+zwpo[k]-1])<*mu)&&
	    (fabs(t[i-9*zwpo[k]+5]-t[i+zwpo[k]-1])<*kappa))
        {
		WEITER=TRUE;
	    if(fabs(z[i]-MED(&(y[i-9*zwpo[k]+5]),5*(zwpo[k+1]-1)))>*noiselevel*gamma)
	      for(j=-zwpo[k]+1;j<=zwpo[k]-1;j++)
	  	    isoutl[i-j]=TRUE;
	    }
	  }

    k++;
	} while(WEITER);

  free(z);
  free(ztilde);
  }

/* The ddcomp function is used by the makegrid function for sorting
   the data as an argument for qsort. */
		   
int ddcomp(struct doubledouble *q1, struct doubledouble *q2)
  {
  if(q1->x>q2->x)
    return 1;
  else
  if(q1->x<q2->x)
    return -1;
  else
    return 0;
  }

/* sigmastruct describes a covariance matrix of size n. diag is an n-vector
   of pointers to double vectors that correspond to the diagonals of the
   matrix. If diag[i]==NULL, then the i-th diagonal is empty. This
   representation is useful for covariance matrices with a band structure. */

struct sigmastruct 
          {
		  int n;
          double **diag;
		  };

/* createSigma allocates memory for a new covariance matrix of size n. */

void createSigma(struct sigmastruct *Sigma, int n)
  {
  int i;
  
  Sigma->n=n;
  if((Sigma->diag=malloc(n*sizeof(double *)))==NULL)
    {
	puts("Couldn't allocate memory in createSigma");
	exit(1L);
	}
  for(i=0;i<n;i++)
    (Sigma->diag)[i]=NULL;
  }
  
/* freeSigma releases the memory used by a sigmastruct element. */

void freeSigma(struct sigmastruct *Sigma)
  {
  int i;

  for(i=0;i<Sigma->n;i++)
    if(Sigma->diag[i]!=NULL)
      free((Sigma->diag)[i]);
  free(Sigma->diag);
  }

/* CleanupSigma removes diagonals that contain only elements < thr. */
   
void cleanupSigma(struct sigmastruct *Sigma)
  {
  int i,j,zaehler;

  for(i=0;i<Sigma->n;i++)
    if((Sigma->diag)[i]!=NULL)
      {
      j=0;
      while((j<Sigma->n-i)&&(fabs((Sigma->diag)[i][j])<thr))
        j++;
      if(j>=Sigma->n-i)
        {
        free(Sigma->diag[i]);
        Sigma->diag[i]=NULL;
        }
      }
  }
  
/* putSigma changes the entry in the i-th row and j-th column to s and
   allocates memory for the diagonal if necessary. */

void putSigma(struct sigmastruct *Sigma, int i, int j, double s)
  {
  int d=abs(i-j),min;
  
  if(fabs(s)>0.0000001)
  if((i>=Sigma->n)||(j>=Sigma->n))
    {
	puts("Error: This element does not exist.");
	exit(1L);
	}
  else
    {
    if((Sigma->diag)[d]==NULL)
	  if((Sigma->diag[d]=calloc(Sigma->n-d,sizeof(double)))==NULL)
	    exit(1L);
    (Sigma->diag)[d][(i+j-d)/2]=s;
    }
  }

/* allocateSigma allocates memory for diagonals of a covariance matrix,
   specified by the boolean vector d */
   

void allocateSigma(struct sigmastruct *Sigma, int *d)
  {
  int i;
  
  for(i=0;i<Sigma->n;i++)
    if(d[i]==TRUE)
      if((Sigma->diag[i]=calloc(Sigma->n-i,sizeof(double)))==NULL)
        exit(1L);
  }

/* computec is the function that computes the factors for the variances
   of the wavelet coefficients. 

   Gmatrix, Gindex describe the matrix that maps the original data
                   to the grid data as received by makegrid (s.o.)
   n, gridn        are the numbers of original and grid observations
   H, LengthH      describe the used wavelet filter. The filter coefficients
                   are stored in the vector H, their number in LengthH.
   bc              is either PERIODIC or SYMMETRIC, the boundary correction
                   to be used

   c contains afterwards the coefficients c_{jk}, such that
               Var(w_{jk})=c_{jk}\cdot\sigma^2
*/

double covindex(double *covs, int n1, int n2, int k)
  {
  int dummy,index=0,n1z,n2z,kz;
  double var,scalposition,scalvalue;

  if((n1>65)||(n2>65))
    {
    if(n1<85)
      var=0.0240+(n1-65)*(0.0185-0.0240)/20.0;
    else
    if(n1<105)
      var=0.0185+(n1-85)*(0.0150-0.0185)/20.0;
    else
    if(n1<125)
      var=0.0150+(n1-105)*(0.0126-0.0150)/20.0;
    else
    if(n1<155)
      var=0.0126+(n1-125)*(0.0102-0.0126)/30.0;
    else
    if(n1<185)
      var=0.0102+(n1-155)*(0.0085-0.0102)/30.0;
    else
    if(n1<215)
      var=0.0085+(n1-185)*(0.0073-0.0085)/30.0;
    else
    if(n1<255)
      var=0.0073+(n1-215)*(0.0062-0.0073)/40.0;
    else
    if(n1<355)
      var=0.0062+(n1-255)*(0.0044-0.0062)/100.0;
    else 
      var=0.0039;

    /*scalposition = k/(double)n1*64;
    scalvalue = covs[12464+(int)(scalposition)]+(scalposition-floor(scalposition))*(covs[12464+(int)(scalposition)+1]-covs[12464+(int)(scalposition)]);
    return var*scalvalue/covs[12528];*/

    if(k>n1-20)
      return var*covs[12528+k-n1]/covs[12528];
    else
      return var*covs[12508]/covs[12528]*k/(n1-20);
	}
  if(n1<n2)
    {
    dummy=n1;
    n1=n2;
    n2=dummy;
    }
if(k>=n2) k=n2;
  n1z=1;
  n2z=1;
  kz=1;
  while((n1z!=n1)||(n2z!=n2)||(kz!=k))
    {
    index++;
    kz++;
    if(kz>n2z)
      {
      kz=1;
      n2z+=2;
      if(n2z>n1z)
	{
	n2z=1;
	n1z+=2;
	}
      }
    }
  return covs[index];
  }

void computecalg65(double *c,long *gridn, long *leftbdr, long *rightbdr, long *widthes, double *covs,
              double *H, long *LengthH, long *bc)
  {
  int virtgn,i,j,k,l,d,testzaehler,zaehler=0,gn=*gridn,laststart=0;
  int ii,dd,jj,o1,o2,iiG,iiH,jjG,jjH,gn2,LengthH2=*LengthH/2,dH,dG;
  int *NEEDIT,offset,offset2,band,band1,band2;
  double *w,cell,cellC,cellD,sig,G[20];
  double ProductG[20][20],ProductH[20][20];
  char dummy[20];
  struct sigmastruct Sigma,Sigma2,Sigma3;

  if(*LengthH>20)
    {
    puts("Sorry, you can not use this procedure with more than 20 filter coefficients!");
    exit(1L); 
    }
  if((NEEDIT=malloc(*gridn*sizeof(int)))==NULL)
    exit(1L);

  /* First step: Compute Filter G from Filter H */
  sig=-1.0;
  for(k=0;k<*LengthH;k++)
    {
	G[*LengthH-k-1]=sig*H[k];
	sig=-sig;
	}

  for(k=0;k<*LengthH;k++)
    for(l=0;l<*LengthH;l++)
      {
      ProductG[k][l]=G[k]*G[l];
      ProductH[k][l]=H[k]*H[l];
      }

  /* Second step: Compute the variance/covariance-matrix of the grid data */

  createSigma(&Sigma,gn);
  for(i=0;i<*gridn;i++)
    {
    putSigma(&Sigma,i,i,covindex(covs,widthes[i],widthes[i],widthes[i]));
    for(j=0;j<i;j++)
      if(rightbdr[j]>=leftbdr[i])
	putSigma(&Sigma,i,j,covindex(covs,widthes[j],widthes[i],rightbdr[j]-leftbdr[i]+1));
    }
  
  /* And now the difficult part... */
  
  if(*bc==PERIODIC)
    {
    while(gn>=2) /* Apply the wavelet filters to the covariance matrix Sigma. */
      {
      gn2=gn/2; /* gn and gn2 are the sizes of Sigma and Sigma2 (or Sigma3). */ 
      createSigma(&Sigma2,gn2); /* Store the result of the high pass filter in
                                   sigma2... */
      createSigma(&Sigma3,gn2); /* ... and the result of the low pass filter
      cleanupSigma(&Sigma);        in sigma3. */

      /* First we need to know which diagonals in sigma2 and sigma3 will not
         be empty. */

	  band1=gn/2;
	  band2=gn/2+1;
	  while((band1>=0)&&(Sigma.diag[band1]==NULL))
	    band1--;
	  while((band2<=gn-1)&&(Sigma.diag[band2]==NULL))
	    band2++;
      if(band1<=gn-band2)
	    band=gn-band2;
      else
	    band=band1;
		
      if(band+*LengthH>gn)
        for(d=0;d<gn2;d++)
	      NEEDIT[d]=TRUE;
      else
	    {
        for(d=0;d<gn2;d++)
	      NEEDIT[d]=FALSE;
        for(d=0;(d<=(band+*LengthH)/2)&&(d<gn2);d++)
          NEEDIT[d]=TRUE;
        for(d=1;(d<=(band+*LengthH)/2)&&(d<gn2);d++)
          NEEDIT[gn2-d]=TRUE;
	    }

      /* We allocate memory only for these diagonals. */

      allocateSigma(&Sigma2,NEEDIT);
      allocateSigma(&Sigma3,NEEDIT);

      /* Every entry of Sigma is involved in the computation of (LengthH/2)^2
         entries of Sigma2 and Sigma3. We find out in which and do the
         necessary computaions. */

      /* Let's start with the main diagonal elements of Sigma. */

      if(Sigma.diag[0]!=NULL)
	    for(j=0;j<gn;j++)
		  if(fabs(sig=Sigma.diag[0][j])>thr)
		    {
		    o1=j%2;
            iiH=j/2;
            iiG=(iiH+LengthH2-1)%(gn2);

		    for(k=0;k<LengthH2;k++)
			  {
              Sigma3.diag[0][iiH]+=sig*ProductH[2*k+o1][2*k+o1];
              Sigma2.diag[0][iiG]+=sig*ProductG[2*k+o1][2*k+o1];
              jjH=((j-2*(k+1)+*gridn)/2)%(gn2);
              jjG=(jjH+LengthH2-1)%(gn2);
		      for(l=k+1;l<LengthH2;l++)
			    { 
				dH=abs(iiH-jjH);
				dG=abs(iiG-jjG);
				if(dH==0)
                  Sigma3.diag[dH][iiH]+=2*sig*ProductH[2*k+o1][2*l+o1];
				else       
                  Sigma3.diag[dH][(iiH+jjH-dH)/2]+=sig*ProductH[2*k+o1][2*l+o1];
				if(dG==0)
                  Sigma2.diag[dG][iiG]+=2*sig*ProductG[2*k+o1][2*l+o1];
				else         
                  Sigma2.diag[dG][(iiG+jjG-dG)/2]+=sig*ProductG[2*k+o1][2*l+o1];
            
                if((--jjH)<0) jjH=gn2-1;
                if((--jjG)<0) jjG=gn2-1;
				}
              if((--iiH)<0) iiH=gn2-1;
              if((--iiG)<0) iiG=gn2-1;
		      }
            }

      /* Now do the rest. */
      for(d=1;d<gn;d++)
        if(Sigma.diag[d]!=NULL)
	      for(j=0;j<gn-d;j++)
		    if(fabs(sig=Sigma.diag[d][j])>thr)
		      {
			  o1=(d+j)%2;
              iiH=((d+j+*gridn)/2)%(gn2);
              iiG=(iiH+LengthH2-1)%(gn2);

		      for(k=0;k<LengthH2;k++)
			    {
                jjH=((j+*gridn)/2)%(gn2);
                jjG=(jjH+LengthH2-1)%(gn2);
			    o2=j%2;
		        for(l=0;l<LengthH2;l++)
				  {
				  dH=abs(iiH-jjH);
				  dG=abs(iiG-jjG);
				  if(dH==0)
                    Sigma3.diag[dH][iiH]+=2*sig*ProductH[o1][o2];
				  else       
                    Sigma3.diag[dH][(iiH+jjH-dH)/2]+=sig*ProductH[o1][o2];
				  if(dG==0)
                    Sigma2.diag[dG][iiG]+=2*sig*ProductG[o1][o2];
				  else         
                    Sigma2.diag[dG][(iiG+jjG-dG)/2]+=sig*ProductG[o1][o2];
                  if((--jjH)<0) jjH=gn2-1;
                  if((--jjG)<0) jjG=gn2-1;
                  o2+=2;
                  }
                if((--iiH)<0) iiH=gn2-1;
                if((--iiG)<0) iiG=gn2-1;
				o1+=2;
				}
              }

      /* Now Sigma2 und Sigma3 should contain the right values. Store
         only the main diagonal of Sigma2 in c. */
	  for(j=0;j<gn2;j++)
        c[zaehler++]=Sigma2.diag[0][j];

      /* Sigma and Sigma2 are now redundant. */
      freeSigma(&Sigma);
      freeSigma(&Sigma2);

      /* Sigma3 becomes our new Sigma. */
      memcpy(&Sigma,&Sigma3,sizeof(Sigma));
  	  gn=gn2;
  	  }
	} /* end of the periodic case */
  else
  if(*bc==SYMMETRIC) /* The symmetric case is even more difficult... */
    {
    virtgn=gn; /* virtgn is used to determine when we can finish and takes
                  exactly the same values as gn in the periodic case. */
    offset=0; /* Symmetric boundary conditions provide extra coefficients
                 on both sides. offset gives the number of such extra
                 coeffs on the left-hand side. */
    while(virtgn>=2)
      {
      /* First of all, we want to know how many diagonals and extra coeffs
         Sigma2 and Sigma3 have. */

	  if(offset%2==0)
	    gn2=(gn+1)/2+LengthH2-1;
      else
	    gn2=(gn+2)/2+LengthH2-1;
	  offset2=(offset+*LengthH-1)/2;

      /* Now allocate memory for them. */
	  
      createSigma(&Sigma2,gn2);
      createSigma(&Sigma3,gn2);
      cleanupSigma(&Sigma);
      
      /* Again, we need to know which diagonals in sigma2 and sigma3 will not
         be empty. */

	  band=gn-1;
	  while((band>=0)&&(Sigma.diag[band]==NULL))
	    band--;
      if(band+2*(*LengthH)>gn)
        for(d=0;d<gn2;d++)
	      NEEDIT[d]=TRUE;
      else
	    {
        for(d=0;d<gn2;d++)
  	      NEEDIT[d]=FALSE;
        for(d=0;(d<=(band+*LengthH)/2)&&(d<gn2);d++)
          NEEDIT[d]=TRUE;
        }

      /* We allocate memory only for these diagonals. */

      allocateSigma(&Sigma2,NEEDIT);
      allocateSigma(&Sigma3,NEEDIT);

      /* Every entry of Sigma is involved in the computation of (LengthH/2)^2
         entries of Sigma2 and Sigma3. We find out in which and do the
         necessary computaions. */

      /* Let's start with the values that are not effected by boundary 
         correction.  First the main diagonal. */

      if(Sigma.diag[0]!=NULL)
	    for(j=0;j<gn;j++)
		  if(fabs(sig=Sigma.diag[0][j])>thr)
		    {
		    o1=(j+offset)%2;
            iiH=(j+offset%2)/2+LengthH2-1;
			iiG=iiH;

		    for(k=0;k<LengthH2;k++)
			  {
              Sigma3.diag[0][iiH]+=sig*ProductH[2*k+o1][2*k+o1];
              Sigma2.diag[0][iiG]+=sig*ProductG[2*k+o1][2*k+o1];
              jjH=(j+offset%2)/2+LengthH2-1-(k+1);
			  jjG=jjH;
		      for(l=k+1;l<LengthH2;l++)
			    { 
				if((iiH<0)||(jjH<0))
				  puts("ERROR");
				dH=abs(iiH-jjH);
				dG=abs(iiG-jjG);
				if(dH==0)
                  Sigma3.diag[dH][iiH]+=2*sig*ProductH[2*k+o1][2*l+o1];
				else       
                  Sigma3.diag[dH][(iiH+jjH-dH)/2]+=sig*ProductH[2*k+o1][2*l+o1];
				if(dG==0)
                  Sigma2.diag[dG][iiG]+=2*sig*ProductG[2*k+o1][2*l+o1];
				else       
                  Sigma2.diag[dG][(iiG+jjG-dG)/2]+=sig*ProductG[2*k+o1][2*l+o1];
                jjH--;
                jjG--;
				}
              iiH--;
              iiG--;
		      }
            }

      /* Now do the not-effected values on the other diagonals. */

      for(d=1;d<gn;d++)
        if(Sigma.diag[d]!=NULL)
	      /*for(j=*LengthH-2+offset%2;j<gn-d-(*LengthH-2+offset%2);j++)*/
	      for(j=0;j<gn-d;j++)
		    if(fabs(sig=Sigma.diag[d][j])>thr)
		      {
		      o1=(d+j+offset)%2;
              iiH=(d+j+offset%2)/2+LengthH2-1;
			  iiG=iiH;

		      for(k=0;k<LengthH2;k++)
			    {
                jjH=(j+offset%2)/2+LengthH2-1;
			    jjG=jjH;
			    o2=(j+offset)%2;
		        for(l=0;l<LengthH2;l++)
				  {
				  dH=abs(iiH-jjH);
				  dG=abs(iiG-jjG);
				  if(dH==0)
                    Sigma3.diag[dH][iiH]+=2*sig*ProductH[o1][o2];
				  else       
                    Sigma3.diag[dH][(iiH+jjH-dH)/2]+=sig*ProductH[o1][o2];
				  if(dG==0)
                    Sigma2.diag[dG][iiG]+=2*sig*ProductG[o1][o2];
				  else         
                    Sigma2.diag[dG][(iiG+jjG-dG)/2]+=sig*ProductG[o1][o2];
                  jjH--;
                  jjG--;
                  o2+=2;
                  }
				iiH--;
				iiG--;
				o1+=2;
				}
              }

      /* Finally, do the boundary entries. */

      for(d=0;d<gn2;d++)
        if(Sigma2.diag[d]!=NULL)
		  {
		  for(j=0;(j<gn2-d)&&(j<LengthH2-1+offset%2);j++)
		    {
			cellC=0;
			cellD=0;
			i=d+j;
			iiG=2*i-(*LengthH-2)-offset%2;
		    for(k=0;k<*LengthH;k++,iiG++)
              {
		      jjG=2*j-(*LengthH-2)-offset%2;
		      for(l=0;l<*LengthH;l++,jjG++)
			    {
                ii=iiG;
                jj=jjG;
				if(ii<0)
				  ii=-ii-1;
				if(jj<0)
				  jj=-jj-1;
				if(ii>=gn)
                  {
				  ii=2*gn-ii-1;
			      }
				if(jj>=gn)
                  {
				  jj=2*gn-jj-1;
			      }
				dd=abs(ii-jj);
                if(Sigma.diag[dd]!=NULL)
                  {
				  sig=(Sigma.diag)[dd][(ii+jj-dd)/2];
				  cellC+=sig*ProductH[k][l];
				  cellD+=sig*ProductG[k][l];
                  }
				}
              }
            Sigma2.diag[d][j]=cellD;
            Sigma3.diag[d][j]=cellC;
			}
		  for(j=gn2-d-1;(j>=0)&&(j>=gn2-d-LengthH2+1-offset%2);j--)
		    {
			cellC=0;
			cellD=0;
			i=d+j;
			iiG=2*i-(*LengthH-2)-offset%2;
		    for(k=0;k<*LengthH;k++,iiG++)
              {
		      jjG=2*j-(*LengthH-2)-offset%2;
		      for(l=0;l<*LengthH;l++,jjG++)
			    {
                ii=iiG;
                jj=jjG;
				if(ii<0)
				  ii=-ii-1;
				if(jj<0)
				  jj=-jj-1;
				if(ii>=gn)
                  {
				  ii=2*gn-ii-1;
			      }
				if(jj>=gn)
                  {
				  jj=2*gn-jj-1;
			      }
				dd=abs(ii-jj);
                if(Sigma.diag[dd]!=NULL)
                  {
				  sig=(Sigma.diag)[dd][(ii+jj-dd)/2];
				  cellC+=sig*ProductH[k][l];
				  cellD+=sig*ProductG[k][l];
                  }
				}
              }
            Sigma2.diag[d][j]=cellD;
            Sigma3.diag[d][j]=cellC;
			}
		  }

      /* This looks now pretty the same as in the periodic case. */

	  for(j=0;j<gn2;j++)
        c[zaehler++]=Sigma2.diag[0][j];
      freeSigma(&Sigma);
      freeSigma(&Sigma2);
      memcpy(&Sigma,&Sigma3,sizeof(Sigma));

      gn=gn2;
	  offset=offset2;
      virtgn=virtgn/2;
      }
	} /* end of the symmetric case */

  /* We are finished with the computation of c and can release any memory. */

  freeSigma(&Sigma);
  free(NEEDIT);
  }

void medfilter(double *t, double *y, int *n, int *gridn, double *width,
               double *outy, int *widthes, int *leftbdr, int *rightbdr, 
               double *outt)
  {
  int i,lb=0, rb=0;
  for(i=0;i<*gridn;i++)
    {
    outt[i]=(i+0.5)/(*gridn);
	while((lb<=*n-2)&&(outt[i]-t[lb]>*width))
	  lb++;
	while((rb<=*n-2)&&(t[rb+1]-outt[i]<=*width))
	  rb++;
	if(fabs(outt[i]-t[lb])>*width)
	  if(fabs(outt[i]-t[lb])<fabs(outt[i]-t[rb]))
		rb=lb;
      else
	    lb=rb;
	if((rb-lb)%2==1)
	  if(outt[i]-t[lb]<t[rb]-outt[i])
	    rb--;
      else
	    lb++;
    widthes[i] = rb-lb+1;     
    leftbdr[i] = lb+1;        
    rightbdr[i] = rb+1;        
	outy[i]=MED(&y[lb],rb-lb+1);
    }
  }
