\name{plot.paranomo}
\alias{axis.paranomo}
\alias{plot.paranomo}
\title{Plotting for parallel-axis nomograms}
\usage{
\method{plot}{paranomo}(x, labels, add = FALSE, ...)

axis.paranomo(pobj, side = c("x", "y", "z"), label, col = 1, n = 7,
  tick.level = 3, tcl = -c(0.75, 0.5, 0.25), lwd = 2, cex.axis = 0.8,
  offset = 1, cex.lab = 1, font.lab = 1, col.lab = col)
}
\arguments{
  \item{x,pobj}{object of class \code{paranomo}}

  \item{labels}{axis labels}

  \item{add}{add to existing plot?}

  \item{...}{arguments to \code{axis.paranomo}}

  \item{side}{axis identifier}

  \item{label}{axis label}

  \item{col}{axis colours}

  \item{n,tick.level}{arguments to
  \code{\link{fancyticks}}}

  \item{tcl}{tick lengths (vector the same length as
  \code{tick.level})}

  \item{lwd}{axis line width (ticks are \code{lwd = 1})}

  \item{cex.axis}{axis numbers expansion}

  \item{offset}{axis label placement (above axis)}

  \item{cex.lab}{axis label expansion}

  \item{font.lab}{axis label font}

  \item{col.lab}{axis label colours}
}
\description{
Plotting functions for parallel-axis nomogram object of
class \code{paranomo}, created with the \code{paranomo}
function.  \code{plot.paranomo} plots the whole diagram,
while \code{axis.paranomo} just plots one axis.
}
\details{
\code{axis.paranomo} uses \code{\link{fancyticks}} to
compute the ticks for each axis.  Fiddle with \code{n} (and
possibly the limits in \code{paranomo}) to get different
ticks. All of the axis parameters provided to
\code{plot.paranomo} can be three-vectors for individual
axis tuning.
}
\examples{
## ## Fig 3 in Doerfler (2009)

D <- function(D) 0.68 * log(1.2 * D + 0.47)
T <- function(T) (3/2) * log(0.91 * T)
N <- function(N) log(N)
foo <- paranomo(D, T, N,
                xlim = c(1, 8), ylim = c(1, 2), zlim = c(1, 11.5))

Dval <- 5; Tval <- 1.43; Nval <-exp(D(Dval) + T(Tval))
lines(rbind(foo$xput(Dval), foo$yput(Tval)), lty = 2)
points(rbind(foo$xput(Dval),
             foo$yput(Tval),
             foo$zput(Nval)), pch = 20, cex = 1.2)

## different colour, or colours?

plot(foo, col = "blue")
plot(foo, col = c("red", "gold", "green"))

## fool around with n to get the ticks right

plot(foo, n = 7)
plot(foo, n = c(7, 10, 10))

## include midpoints for different alignment

foo <- paranomo(D, T, N,
                xlim = c(1, 8), ylim = c(1, 2), zlim = c(1, 11.5),
                xmid = 2, ymid = 1.4)

## ## Nomogram of Body Mass Index (BMI), has decreasing y axis

Weight <- function(weight) log(weight) # in kg
Height <- function(height) -2 * log(height) # in m
BMI <- function(BMI) log(BMI)

bmi <- paranomo(Weight, Height, BMI,
                xlim = c(40, 160), ylim = c(1.5, 2), zlim = c(15, 40),
                n = c(10, 10, 7))
lines(rbind(bmi$xput(75), bmi$yput(1.82)), lty = 2) # me, roughly
}
\seealso{
\code{\link{paranomo}} for creating a parallel-axis
nomogram object.
}

