% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fancyticks.R
\name{fancyticks}
\alias{fancyticks}
\alias{is.wholenumber}
\title{Create fancy ticks like in cool engineering diagrams}
\usage{
fancyticks(x, n = 7, level = 3)
}
\arguments{
\item{x}{values for which ticks are required (could be an \code{xlim})}

\item{n}{resolution parameter, passed to \code{\link{pretty}}}

\item{level}{how many levels of ticks?}
}
\value{
A list of \code{level} components, where each components
contains that level's ticks, as a numerical vector (which may have
length zero). Also an \code{xlim} attribute.
}
\description{
Ticks of different sizes.  Big ticks are where \code{\link{pretty}}
wants to put them.  Medium ticks are on the halves, and small ticks
are on the fifths of the halves.  This function is a bit
hit-or-miss, since \code{pretty} is so deep, so try changing
\code{n} to get the ticks you want.
}
\section{Utilities}{

Uses the internal function
\code{is.wholenumber}, which does what you expect.
}
\examples{
fancyticks(c(85, 220), 10)
}
\author{
Jonathan Rougier <j.c.rougier@bristol.ac.uk>
}
\seealso{
\code{\link{axis.paranomo}}, which calls \code{fancyticks}
}

