% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paranomo.R
\name{paranomo}
\alias{paranomo}
\title{Parallel scale nomogram}
\usage{
paranomo(f, g, h, xlim, ylim, zlim, xmid = NULL, ymid = NULL, plot = TRUE,
  add = FALSE, ...)
}
\arguments{
\item{f,g,h}{monotonic functions taking vector arguments}

\item{xlim,ylim,zlim}{lower and upper limits of the three quantites}

\item{xmid,ymid}{Centre-points of x- and y-axes}

\item{plot}{plot the result?}

\item{add}{add to existing plot?}

\item{...}{additional arguments to \code{plot.paranomo}}
}
\value{
An object of class \code{paranomo}, which is a list of
three functions, \code{xput}, \code{yput}, and \code{zput}, which
share a common environment (plus other stuff).  \code{xput}, for
example, takes a vector of \eqn{x} values and returns a
corresponding matrix of horizontal and vertical ordinates on a
standardised frame, which is approximately \eqn{[-1, 1] \times [-1,
1]}{[-1, 1] x [-1, 1]}.
}
\description{
Return the functions necessary to construct a parallel-scale
nomogram of three quantities, which are related as \deqn{f(x) +
g(y) = h(z).}
}
\details{
Specifying \code{xmid} and \code{ymid} is useful for
aligning up the x- and y-axes so that typical (middle) evaluations
occur with fairly flat lines.  Otherwise, the x- and y-axes will be
aligned at the bottom and top.
}
\examples{
## Cite as
citation("paranomo")
}
\author{
Jonathan Rougier <j.c.rougier@bristol.ac.uk>
}
\references{
R. Doerfler, 2009, The lost art of nomography, UMAP Journal, 30(4), 457-493.
}
\seealso{
\code{\link{axis.paranomo}} and \code{\link{plot.paranomo}} for plotting, and examples.
}

