var Effusive="<em class='effusive'>Effusive</em>";
var Explosive="<strong class='explosive'>Explosive</strong>"

$(document).ready(function()
{
	$(".VolcIcon").click(function(e)
	{
		e.preventDefault();
		console.log($(this).attr('id'));
		OpenInfo($(this).attr('id'));
	});
	
	$("#InfoClose").click(function()
	{
		$("#InfoOverlay").css('width','0%');
	});
	
	$("#InfoOverlayClose").click(function()
	{
		$("#InfoOverlay").css('width','0%');
	});
});

function OpenInfo(Volcano)
{
	switch (Volcano)
	{
		case "Kilauea":
			$("#InfoHeading").html("Kilauea");
			$("#VolcanoName").html("Kilauea");
			$("#VolcanoPlace").html("Hawai'i, USA");
			$("#VolcanoElev").html("1222 m");
			$("#VolcanoType").html("Shield volcano");
			$("#VolcanoEruption").html("2018");
			$("#VolcanoEruptionType").html(Effusive + " &ndash; lava flows, fire fountains, lava lake.");
			$("#VolcanoPopulation10").html("3,122");
			$("#VolcanoPopulation30").html("8,495");
			$("#VolcanoPopulation100").html("169,550");
			$("#VolcanoPhoto").attr("src","./img/Photos/Kilauea.jpg");
			$("#VolcanoFlag").attr("src","./img/USAFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Kilauea has been the most active volcano on the Hawaiian islands in historical time.</p> \
			<hr> <p>Kilauea volcano produces lots of lava.  The name 'Kilauea' means 'spewing' or 'much spreading' in the Hawaiian language.</p> \
			<hr> <p>The current eruption of Kilauea started in January 1983.</p> \
			<hr> <p>Kilauea has a large summit caldera.</p> \
			<hr> <p>There is a lava lake in the Halema`uma`u crater on Kileuea.  You can see whats happening at the lava lake from <a href='https://volcanoes.usgs.gov/volcanoes/kilauea/multimedia_webcams.html'>webcams</a>.</p> \
			<hr> <p>Kileuea volcano is monitored by the <a href='https://volcanoes.usgs.gov/observatories/hvo/'>Hawaiian Volcano Observatory</a>, part of the <a href='https://www.usgs.gov'>US Geological Survey</a> who also monitor other volcanoes in USA.</p> \
			<hr> <p>Lots of tourist visit Kilauea, which is in the <a href='https://www.nps.gov/havo/index.htm'>Hawai'i Volcanoes National Park</a>.</p>")
			break;
		case "StHelens":
			$("#InfoHeading").html("Mount St. Helens");
			$("#VolcanoName").html("Mount St. Helens");
			$("#VolcanoPlace").html("Washington state, USA");
			$("#VolcanoElev").html("2549 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("2008");
			$("#VolcanoEruptionType").html(Explosive + " &ndash; ash, pyroclastic flows, lahars.");
			$("#VolcanoPopulation10").html("427");
			$("#VolcanoPopulation30").html("2,221");
			$("#VolcanoPopulation100").html("2,173,101");
			$("#VolcanoPhoto").attr("src","./img/Photos/StHelens.jpg");
			$("#VolcanoFlag").attr("src","./img/USAFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>There was a big eruption of Mount St. Helens in 1980.</p> \
			<hr> <p>The 1980 eruption started with the collapse of the side of the volcano (called a debris avalanche), causing a huge explosion and pyroclastic flows.</p> \
			<hr> <p>The debris avalanche had a volume of 2.9 km&sup3; and left a horseshoe shaped crater at the summit.</p> \
			<hr> <p>The pyroclastic flows flattened trees and buildings over an area of 600 km&sup2;.</p> \
			<hr> <p>Eruptions since 2004 have been building a new lava dome in the crater.</p> \
			<hr> <p><a href='https://volcanoes.usgs.gov/observatories/cvo/st_helens_videos.html'>You can watch videos about the eruptions</a>.</p> \
			<hr> <p>Mount St. Helens is monitored by the <a href='https://volcanoes.usgs.gov/observatories/cvo/'>Cascades Volcano Observatory</a>, part of the <a href='https://www.usgs.gov'>US Geological Survey</a> who also monitor other volcanoes in USA.</p> \
			<hr> <p>The <a href='https://www.fs.usda.gov/wps/portal/fsinternet/cs/main/!ut/p/z0/04_Sj9CPykssy0xPLMnMz0vMAfIjo8zijQwgwNHCwN_DI8zPwBcqYKBfkO2oCADIwpjI/?pname=Mt%20St.%20Helens%20National%20Volcanic%20Monument%20-%20Home&ss=110623&pnavid=null&navid=091000000000000&ttype=main&cid=null'>Mount St. Helens National Volcanic Monument</a> was created after the 1980 eruption so that scientists could study the eruption and the recovery of the environment.</p>")
			break;
		case "Cotopaxi":
			$("#InfoHeading").html("Cotopaxi");
			$("#VolcanoName").html("Cotopaxi");
			$("#VolcanoPlace").html("Cotopaxi Province, Ecuador");
			$("#VolcanoElev").html("5911 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("2016");
			$("#VolcanoEruptionType").html(Explosive + " &ndash; ash, pyroclastic flows, lahars.");
			$("#VolcanoPopulation10").html("7,299");
			$("#VolcanoPopulation30").html("152,139");
			$("#VolcanoPopulation100").html("3,631,492");
			$("#VolcanoPhoto").attr("src","./img/Photos/Cotopaxi.jpg");
			$("#VolcanoFlag").attr("src","./img/EcuadorFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Cotopaxi is one of the most active volcanoes in Ecuador.</p> \
			<hr> <p>There have been more than 50 eruptions of Cotopaxi since 1738.</p> \
			<hr> <p>Although Cotopaxi is near to the equator, it is very high so has a glacier on the top.</p> \
			<hr> <p>Eruptions of Cotopaxi have often produced big pyroclastic flows and lahars.</p> \
			<hr> <p>A big eruption of Cotopaxi happened in 1877.  Pyroclastic flows melted the ice on the summit glacier, making lahars that travelled more than 100 km and destroyed the city of Latacunga.</p> \
			<hr> <p>Cotopaxi is considered to be one of the most dangerous volcanoes in the world, because of the styles of eruption and the number of people living in hazardous areas.</p> \
			<hr> <p>Cotopaxi is monitored by the <a href='https://translate.google.co.uk/translate?hl=en&sl=es&u=http://www.igepn.edu.ec/&prev=search'>Instituto Geofisico Escuela Politecnica Nacional</a> who also monitor other volcanoes in Ecuador.</p> \
			<hr> <p>Cotopaxi volcano is in the <a href='http://www.ambiente.gob.ec/parque-nacional-cotopaxi/#'>Cotopaxi National Park</a>.</p>")
			break;
		case "Eyjafjallajokull":
			$("#InfoHeading").html("Eyjafjallaj&ouml;kull");
			$("#VolcanoName").html("Eyjafjallaj&ouml;kull");
			$("#VolcanoPlace").html("Su&eth;urland, Iceland");
			$("#VolcanoElev").html("1651 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("2010");
			$("#VolcanoEruptionType").html(Effusive + " &amp; " + Explosive + " &ndash; lava flows, ash.");
			$("#VolcanoPopulation10").html("4");
			$("#VolcanoPopulation30").html("786");
			$("#VolcanoPopulation100").html("18,516");
			$("#VolcanoPhoto").attr("src","./img/Photos/Eyjafjallajokull.jpg");
			$("#VolcanoFlag").attr("src","./img/IcelandFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Eyjafjallaj&ouml;kull became a famous volcano when it erupted in 2010.</p> \
			<hr> <p>The 2010 eruption started on 20 March and lasted until 23 June.</p> \
			<hr> <p>The eruption started with a effusive eruption, producing lava flows and fire fountains.  People when to watch the fire fountains.</p> \
			<hr> <p>On 14 April 2010 the eruption changed.  The magma started to come from a vent underneath the summit glacier, causing explosions and producing plumes of gas and ash.</p> \
			<hr> <p>The ash was blown by the wind over to Europe and aeroplane flights had to be stopped because ash can damage jet engines.</p> \
			<hr> <p>The flights were stopped until 20 April 2010 when the eruption stopped, but it then restarted again in May 2010 and more flights were cancelled.  </p> \
			<hr> <p>The disruption of flights is estimated to have cost $1 billion (about £750 million).  </p> \
			<hr> <p>Eyjafjallaj&ouml;kull is monitored by the <a href='http://en.vedur.is/'>Icelandic Met Office</a> who also monitor all the other volcanoes in Iceland.  You can find out more about <a href='http://futurevolc.vedur.is/'>Icelandic Volcanoes</a>.</p> \
			<hr> <p>Eyjafjallaj&ouml;kull means 'Island Mountain Glacier' in Icelandic.</p>")
			break;
		case "Vesuvius":
			$("#InfoHeading").html("Vesuvius");
			$("#VolcanoName").html("Vesuvius");
			$("#VolcanoPlace").html("Campania, Italy");
			$("#VolcanoElev").html("1281 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("1944");
			$("#VolcanoEruptionType").html(Effusive + " &amp; " + Explosive + " &ndash; lava flows, ash, pyroclastic flows.");
			$("#VolcanoPopulation10").html("675,705");
			$("#VolcanoPopulation30").html("3,907,941");
			$("#VolcanoPopulation100").html("6,009,961");
			$("#VolcanoPhoto").attr("src","./img/Photos/Vesuvius.jpg");
			$("#VolcanoFlag").attr("src","./img/ItalyFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Vesuvius is one of the most dangerous volcanoes in the world because it is very close to Naples, a big city in Italy.</p> \
			<hr> <p>There have been big eruptions in history at Vesuvius that have produced pyroclastic flows and ash fall in the Naples area.</p> \
			<hr> <p>In AD 79 an eruption of Vesuvius destroyed the Roman towns of <a href='https://en.wikipedia.org/wiki/Pompeii'>Pompeii</a> and <a href='https://en.wikipedia.org/wiki/Herculaneum'>Herculaneum</a>.</p> \
			<hr> <p>The last eruption in 1944 destroyed villages near to the volcano.</p> \
			<hr> <p>Vesuvius is monitored by the <a href='http://www.ov.ingv.it/ov/index.php'>Osservatorio Vesuviano</a> part of the <a href='http://www.ingv.it/en/'>Istituto Nazionale di Geofisica e Vulcanologia</a> who monitor other volcanoes in Italy too.</p> \
			<hr> <p>There is a detailed <a href='http://www.protezionecivile.gov.it/jcms/en/view_pde.wp?contentId=PDE12771'>evacuation plan</a> for Naples in case of an eruption of Vesuvius.</p>")
			break;
		case "Nyiragongo":
			$("#InfoHeading").html("Mount Nyiragongo");
			$("#VolcanoName").html("Mount Nyiragongo");
			$("#VolcanoPlace").html("Virunga National Park, Democratic Republic of the Congo");
			$("#VolcanoElev").html("3470 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("2018");
			$("#VolcanoEruptionType").html(Effusive + "&ndash; lava flows, lava lake.");
			$("#VolcanoPopulation10").html("31,145");
			$("#VolcanoPopulation30").html("1,006,436");
			$("#VolcanoPopulation100").html("9,087,529");
			$("#VolcanoPhoto").attr("src","./img/Photos/Nyiragongo.jpg");
			$("#VolcanoFlag").attr("src","./img/CongoFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Mount Nyiragongo is one of the most dangerous volcanoes in the world.</p> \
			<hr> <p>Nyiragongo has a lava lake in the summit crater, one of the worlds largest lava lakes.</p> \
			<hr> <p>Recent eruptions have produced lava flows from the lava lake that quickly flow down the steep slopes of the volcano.</p> \
			<hr> <p>At the bottom of the volcano is the city of Goma.</p> \
			<hr> <p>Eruptions in 1977 and 2002 produced lava that reached the city, causing many deaths.</p> \
			<hr> <p>Nyiragongo is monitored by the <a href='https://en-gb.facebook.com/Observatoire-Volcanologique-de-Goma-OVG-180016145663568/'>Observatoire Volcanologique de Goma</a>.</p>")
			break;
		case "Pinatubo":
			$("#InfoHeading").html("Pinatubo");
			$("#VolcanoName").html("Pinatubo");
			$("#VolcanoPlace").html("Luzon, Philippines");
			$("#VolcanoElev").html("1486 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("1993");
			$("#VolcanoEruptionType").html(Explosive + " &ndash; ash, pyroclastic flows, lahars.");
			$("#VolcanoPopulation10").html("3,808");
			$("#VolcanoPopulation30").html("1,148,684");
			$("#VolcanoPopulation100").html("21,875,048");
			$("#VolcanoPhoto").attr("src","./img/Photos/Pinatubo.jpg");
			$("#VolcanoFlag").attr("src","./img/PhilippinesFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>In 1991 there was a huge explosive eruption of Pinatubo, one of the biggest eruptions in the 20th century.</p> \
			<hr> <p>The plume from the 1991 eruption reached a height of 34 km.</p> \
			<hr> <p>The eruption also produced very large pyroclastic flows that travelled as far as 16 km from the volcano.</p> \
			<hr> <p>During the eruption there was a typoon that hit Luzon island.  The rain from the typhoon caused lahars when it mixed with the volcanic ash.</p> \
			<hr> <p>Lahars still happen around Pinatubo because of all the volcanic ash that is left around the volcano.</p> \
			<hr> <p>847 people were killed by the eruption, mostly because of roofs that collapsed when ash collected on them.</p> \
			<hr> <p>Pinatubo is monitored by the <a href='http://www.phivolcs.dost.gov.ph/html/update_VMEPD/vmepd/vmepd/pvo.htm'>Pinatubo Volcano Observatory</a> part of the <a href='http://www.phivolcs.dost.gov.ph/'>Philippine Institute of Volcanology and Seismology</a> which also monitors other volcanoes in the Philippines.</p>")
			break;
		case "Fuji":
			$("#InfoHeading").html("Mount Fuji");
			$("#VolcanoName").html("Fujisan");
			$("#VolcanoPlace").html("Honshu, Japan");
			$("#VolcanoElev").html("3776 m");
			$("#VolcanoType").html("Stratovolcano");
			$("#VolcanoEruption").html("1708");
			$("#VolcanoEruptionType").html(Effusive + " &amp; " + Explosive + " &ndash; lava flows, ash, pyroclastic flows.");
			$("#VolcanoPopulation10").html("1,759");
			$("#VolcanoPopulation30").html("906,969");
			$("#VolcanoPopulation100").html("25,022,187");
			$("#VolcanoPhoto").attr("src","./img/Photos/Fuji.jpg");
			$("#VolcanoFlag").attr("src","./img/JapanFlag.svg.png");
			$("#VolcanoMoreInfo").html("<p>Mount Fuji is one of the most famous volcanoes in the world, and is the highest mountain in Japan.</p> \
			<hr> <p>Mount Fuji hasn't erupted for a long time, but it is still considered active.</p> \
			<hr> <p>Mount Fuji is important in Japanese culture and is on lots of Japanese art.</p> \
			<hr> <p>Lots of people climb Mount Fuji every year.</p> \
			<hr> <p>The last eruption of Fuji produced ash, with some deposited on the city of Tokyo which is 100 km away.</p> \
			<hr> <p>Mount Fuji is monitored by the <a href='http://www.eri.u-tokyo.ac.jp/VRC/index_E.html'>Volcano Research Center</a> part of the <a href='http://www.eri.u-tokyo.ac.jp/en/'>Earthquake Research Institute, University of Tokyo</a> which also monitors other volcanoes in Japan.</p>")
			break;
			
	}
	$("#InfoOverlay").css('width','100%');
	
}
