
var npend=3;
var rad=1.0;
var d=0.1;
var R=0.04; // damping
var C=1.0; // spring

var xInit=1.0;
var yInit=1.0;

var Tend = 40.0;
var timesRun;
var outStep=0.1;
var timesToRun = Tend/outStep;

var pend=[];
for (var j=0; j<npend; j++) {
	pend[j] = {x: rad*Math.cos(2.0*Math.PI*(j+1)/(1.0*npend)-0.5*Math.PI), y: rad*Math.sin(2.0*Math.PI*(j+1)/npend - 0.5*Math.PI)};
}

var plotData=[];
var scatterChart;
var pplaneChart;
var isDown = false;
var x1, y1, x2, y2;     //to store the coords
var pplane0=[];
var pplane1=[];
var pplane2=[];

function derivs(y) {
	// y is a 4-vector in which y(1)=x, y(2)=xdot, y(3)=y, y(4)=ydot
	var yd = [];
	yd[0] = y[1];
	yd[1] =-R*y[1]-C*y[0];
	yd[2] = y[3];
	yd[3] =-R*y[3]-C*y[2];
	
	// add in the forces due to interaction with magnets
	var force
	for (j=0; j<npend; j++) {
		force = ((y[0]-pend[j].x)*(y[0]-pend[j].x)+(y[2]-pend[j].y)*(y[2]-pend[j].y)+d*d);
		force = Math.pow(force,1.5);
		yd[1] = yd[1]-(y[0]-pend[j].x)/force;
		yd[3] = yd[3]-(y[2]-pend[j].y)/force;
	}
	
	var dydt = [];
	dydt[0] = yd[0];
	dydt[1] = yd[1];
	dydt[2] = yd[2];
	dydt[3] = yd[3];
	
	return dydt;
}

function endPlot(k)
{
	var endPt=plotData.slice(k-1,k)[0];
	nearest = NearMagnet(endPt);
	if (nearest==0)
	{
		pplane0.push({x: xInit, y: yInit});
		scatterChart.data.datasets[0].borderColor="rgba(255,255,0,1)";
		pplaneChart.data.datasets[0].data=pplane0;
	}
	else if (nearest==1)
	{
		pplane1.push({x: xInit, y: yInit});
		scatterChart.data.datasets[0].borderColor="rgba(0,0,255,1)";
		pplaneChart.data.datasets[1].data=pplane1;
	}
	else
	{
		pplane2.push({x: xInit, y: yInit});
		scatterChart.data.datasets[0].borderColor="rgba(255,0,0,1)";
		pplaneChart.data.datasets[2].data=pplane2;
	}
	scatterChart.update();
	pplaneChart.update();
}

function NearMagnet(pt)
{
	var x = pt.x;
	var y = pt.y;
	var dist=[];
	for (var j=0; j<npend; j++) {
		dist[j] = (x-pend[j].x)*(x-pend[j].x) + (y-pend[j].y)*(y-pend[j].y)
	}
	var jj=indexOfMin(dist);
	return jj;
}

function indexOfMin(arr) {
	if (arr.length === 0) { return -1; }
	
	var min = arr[0];
	var minIndex = 0;
	
	for (var i = 1; i < arr.length; i++) {
		if (arr[i] < min) {
			minIndex = i;
			min = arr[i];
		}
	}
	return minIndex;
}

function Plot()
{
	var k=0;
	plotTimer = setInterval(function() {
		scatterChart.data.datasets[0].data=plotData.slice(0,k);
		scatterChart.data.datasets[1].data=plotData.slice(k-1,k);
		scatterChart.update();
		k++;
		timesRun++;
		if(timesRun >= timesToRun){
			endPlot(k);
			clearInterval(plotTimer);
			$("#Start").prop('disabled', false);
			}
	}, 1);
}

$(document).ready(function()
{
	
	//~ var soln = icsoln();
	//~ PlotSoln([{x:soln.y[0], y:soln.y[2]}]);
	
	var ctx = $("#plot");
	ctx.css('cursor','crosshair');
	ctx.width  = 100;
	ctx.height = 100;
	Chart.defaults.global.maintainAspectRatio = true;
	Chart.defaults.global.defaultFontFamily = "Source Sans Pro";
	Chart.defaults.global.defaultFontColor = "#000000";
	Chart.defaults.global.legend.display = false;
	Chart.defaults.global.animation.duration = 0;
	scatterChart = new Chart(ctx,
	{
		type: 'line',
		data: {
			datasets: [
			{
				fill: true,
				borderColor: "rgba(255,255,255,1)",//"#0067C8",
				borderWidth: 2,
				data: [{x:xInit, y:yInit}]
			},
			{
				fill: true,
				borderColor: "rgba(255,255,255,1)",//"#0067C8",
				borderWidth: 2,
				pointBorderColor: "rgba(255,255,255,1)",//"#0067C8",
				pointBackgroundColor: "rgba(255,255,255,1)",//"#0067C8",
				pointRadius: 10,
				data: [{x:xInit, y:yInit}]
			},
			{
				pointBorderColor: "rgba(255,255,0,1)",//"#0067C8",
				pointBackgroundColor: "rgba(255,255,0,1)",//"#0067C8",
				pointRadius: 20,
				data: [pend[0]]
			},
			{
				pointBorderColor: "rgba(0,0,255,1)",//"#0067C8",
				pointBackgroundColor: "rgba(0,0,255,1)",//"#0067C8",
				pointRadius: 20,
				data: [pend[1]]
			},
			{
				pointBorderColor: "rgba(255,0,0,1)",//"#0067C8",
				pointBackgroundColor: "rgba(255,0,0,1)",//"#0067C8",
				pointRadius: 20,
				data: [pend[2]]
			},
			]
		},
		options: {
			title: {
				fontFamily: "Source Sans Pro",
				display: false,
			},
			layout: {
				padding: {
					left: 0,
					right: 0,
					top: 0,
					bottom: 0
				}
			},
			responsive:true,
			maintainAspectRatio: true,
			scales: {
				xAxes: [{
					type: 'linear',
					position: 'bottom',
					ticks: {
						display: false,
						beginAtZero: false,
						min: -2,
						max: 2
					},
					gridLines: {
						zeroLineWidth: 4,
						tickMarkLength: 0,
						zeroLineColor: 'rgba(255, 255, 255, 1)'
					},
					scaleLabel: {
						display: false,
					},
					padding: 0
				}],
				yAxes: [{
					type: 'linear',
					position: 'left',
					ticks: {
						display: false,
						beginAtZero: false,
						min: -2,
						max: 2
					},
					gridLines: {
						zeroLineWidth: 4,
						tickMarkLength: 0,
						zeroLineColor: 'rgba(255, 255, 255, 1)'
					},
					scaleLabel: {
						display: false,
					},
					padding: 0
				}]
			},
			tooltips: {
				backgroundColor: "#efebe7",
				titleFontColor: "#000000",
				bodyFontColor: "#000000",
			},
		}
	});
	
	var ctx2 = $("#pplane");
	ctx2.width  = 100;
	ctx2.height = 100;
	pplaneChart = new Chart(ctx2,
	{
		type: 'scatter',
		data: {
			datasets: [
			{
				pointBorderColor: "rgba(255,255,0,1)",//"#0067C8",
				pointBackgroundColor: "rgba(255,255,0,1)",//"#0067C8",
				pointRadius: 10,
				data: pplane0
			},
			{
				pointBorderColor: "rgba(0,0,255,1)",//"#0067C8",
				pointBackgroundColor: "rgba(0,0,255,1)",//"#0067C8",
				pointRadius: 10,
				data: pplane1
			},
			{
				pointBorderColor: "rgba(255,0,0,1)",//"#0067C8",
				pointBackgroundColor: "rgba(255,0,0,1)",//"#0067C8",
				pointRadius: 10,
				data: pplane2
			},
			]
		},
		options: {
			title: {
				fontFamily: "Source Sans Pro",
				display: true,
				text: 'Test '
			},
			responsive:true,
			maintainAspectRatio: true,
			scales: {
				xAxes: [{
					type: 'linear',
					position: 'bottom',
					ticks: {
						beginAtZero: false,
						min: -2,
						max: 2
					},
					gridLines: {
						zeroLineWidth: 4,
						tickMarkLength: 0,
						zeroLineColor: 'rgba(255, 255, 255, 1)'
					},
					scaleLabel: {
						display: true,
					},
					padding: 0
				}],
				yAxes: [{
					type: 'linear',
					position: 'left',
					ticks: {
						beginAtZero: false,
						min: -2,
						max: 2
					},
					gridLines: {
						zeroLineWidth: 4,
						tickMarkLength: 0,
						zeroLineColor: 'rgba(255, 255, 255, 1)'
					},
					scaleLabel: {
						display: true,
					}
				}]
			},
			tooltips: {
				backgroundColor: "#efebe7",
				titleFontColor: "#000000",
				bodyFontColor: "#000000",
			}
		}
	});
	
	$('#plot').on('mousedown', function(e){
		if (isDown === false) {
			isDown = true;
			canvas = this[0];
			var pos = getMousePos(e);
			x1 = pos.x;
			y1 = pos.y;
		}
	});
	
	// when mouse button is released (note: window, not canvas here)
	$(window).on('mouseup', function(e){
		if (isDown === true) {
		
		var pos = getMousePos(e);
		x2 = pos.x;
		y2 = pos.y;
		
		isDown = false;
		//we got two sets of coords, process them
		xInit=pos.x;
		yInit=pos.y;
		
		plotData=[];
		plotData = [{x:xInit, y:yInit}];
		scatterChart.data.datasets[0].data=plotData;
		scatterChart.data.datasets[1].data=plotData;
		scatterChart.update();
		}
	});
	
	$("#Start").click(function(){
		$("#Start").prop('disabled', true);
		Integrate();
		timesRun=0;
		scatterChart.data.datasets[0].borderColor="rgba(255,255,255,1)";
		scatterChart.update();
		Plot()
	});
}
);

// get mouse pos relative to canvas
function getMousePos(evt) {
	var rect = $("#plot")[0].getBoundingClientRect();
	
	var xN = (evt.clientX-rect.left)/rect.width;
	var yN = (evt.clientY-rect.top)/rect.height;
	
	var xMin = scatterChart.options.scales.xAxes[0].ticks.min;
	var xMax = scatterChart.options.scales.xAxes[0].ticks.max;
	var yMin = scatterChart.options.scales.yAxes[0].ticks.min;
	var yMax = scatterChart.options.scales.yAxes[0].ticks.max;
	
	var x = xMin + xN*(xMax-xMin);
	var y = yMax - yN*(yMax-yMin);
	
	return { x: x, y: y};
}

var rkck = function CashKarp(y,h)
{
	var i;
	var n=y.length;
	var a2=0.2, a3=0.3, a4=0.6, a5=1.0, a6=0.875;
	var b21=0.2, b31=3.0/40.0, b32=9.0/40.0, b41=0.3, b42 = -0.9, b43=1.2;
	var b51 = -11.0/54.0, b52=2.5, b53 = -70.0/27.0, b54=35.0/27.0;
	var b61=1631.0/55296.0, b62=175.0/512.0, b63=575.0/13824.0;
	var b64=44275.0/110592.0, b65=253.0/4096.0;
	var c1=37.0/378.0, c3=250.0/621.0, c4=125.0/594.0, c6=512.0/1771.0, dc5 = -277.00/14336.0;
	var dc1=c1-2825.0/27648.0, dc3=c3-18575.0/48384.0, dc4=c4-13525.0/55296.0,dc6=c6-0.25;
	
	var ak2=[], ak3=[], ak4=[], ak5=[], ak6=[], ytemp=[];
	var yout=[], yerr=[];
	
	dydx=derivs(y); // First  step.
	for (i=0; i<n; i++) { ytemp[i]=y[i]+b21*h*dydx[i]; }
	ak2=derivs(ytemp); // Second step.
	
	for (i=0;i<n;i++) { ytemp[i]=y[i]+h*(b31*dydx[i]+b32*ak2[i]); }
	ak3=derivs(ytemp); // Third  step.
	
	for (i=0;i<n;i++) { ytemp[i]=y[i]+h*(b41*dydx[i]+b42*ak2[i]+b43*ak3[i]); }
	ak4 = derivs(ytemp); // Fourth  step.
	
	for (i=0;i<n;i++) { ytemp[i]=y[i]+h*(b51*dydx[i]+b52*ak2[i]+b53*ak3[i]+b54*ak4[i]); }
	ak5 = derivs(ytemp); // Fifth  step.
	
	for (i=0;i<n;i++) { ytemp[i]=y[i]+h*(b61*dydx[i]+b62*ak2[i]+b63*ak3[i]+b64*ak4[i]+b65*ak5[i]); }
	ak6 = derivs(ytemp); // Sixth  step.
	
	for (i=0;i<n;i++) { // Accumulate increments with proper weights.
		yout[i]=y[i]+h*(c1*dydx[i]+c3*ak3[i]+c4*ak4[i]+c6*ak6[i]);
	}
	
	for (i=0;i<n;i++) {
		yerr[i]=h*(dc1*dydx[i]+dc3*ak3[i]+dc4*ak4[i]+dc5*ak5[i]+dc6*ak6[i]);
		// Estimate error as difference between fourth and fifth order methods.
	}
	
	return {y: yout, err: yerr};
}

var rkqs = function RKstep(y,t,htry,eps,yscal)
{
	var SAFETY=0.9;
	var PGROW=-0.2;
	var PSHRNK=-0.25;
	var ERRCON=1.89e-4;
	
	var i;
	var n=y.length;
	var errmax,h,htemp,tnew;
	var yerr=[], ytemp=[];
	var error;
	
	h=htry;
	done = false
	do {
		step=rkck(y,h);
		errmax=0.0;
		for (i=0; i<n; i++) { errmax=Math.max(errmax,Math.abs(step.err[i]/yscal[i])); }
		errmax = errmax/eps;
		if (errmax <= 1.0) { done = true; break; }
		htemp=SAFETY*h*Math.pow(errmax,PSHRNK); //Truncation error too large, reduce stepsize. No more than a factor of 10.
		if (h>=0) { h = Math.max(htemp,0.1*h); }
		else { h = Math.min(htemp,0.1*h); }
		tnew=t+h;
		if (tnew == t) {error='Step-size underflow'; break;}
	}
	while (!done)
	
	if (errmax > ERRCON) { hnext=SAFETY*h*Math.pow(errmax,PGROW); }
	else { hnext=5.0*h; } // No more than a factor of 5 increase
	
	t += h;
	hdid=h;
	for (i=0;i<n;i++) { y[i]=step.y[i]; }
	
	return {t: t, y: y, dx: hdid, dt_next: hnext, error: error}
}

var icsoln = function InitialCondition()
{
	var y=[];
	y[0]=xInit;
	y[1]=0.0;
	y[2]=yInit;
	y[3]=0.0;
	
	var t;
	var dt;
	t = 0.0;
	dt = 1.0/50.0;
	
	var t;
	var dt;
	t = 0.0;
	dt = 1.0/50.0;
	
	return {t: t, y: y, dt: dt};
}

function Integrate()
{
	var soln;
	soln = icsoln();
	plotData = [{x:soln.y[0], y:soln.y[2]}];
	
	t = soln.t;
	
	do {
		soln = solnT(soln,t+outStep);
		t=soln.t;
		var x=soln.y[0];
		var y=soln.y[2];
		plotData.push({x:x, y:y});
	}
	while (t<Tend);
	return;
}

var solnT = function IntegrateTo(solnIn,tend)
{
	var y=solnIn.y;
	var t = solnIn.t;
	var dt = Math.min(solnIn.dt,tend-t);
	
	do {
		rkstep = rkqs(y,t,dt,1e-6,[1,1,1,1])
		y = rkstep.y;
		t = rkstep.t;
		dt = Math.min(rkstep.dt_next,tend-t);
	}
	while (t<tend)
	
	return {t: t, y: y, dt: rkstep.dt_next};
}
