# common functions for beta-binomials and t-beta-binomials

# runs if it is thought the modal value has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
replot.maybe.mode.val <- function(...)
	{
		if(as.numeric(tclvalue(mode.val)) != as.numeric(tclvalue(mode.val.save)))
			{

			alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val)), as.numeric(tclvalue(var.val)))

			# calculate the betas to check for NaNs if so reset the var
			beta.y <- dbeta(beta.x, alphabet[1], alphabet[2])
	
				if(any(is.nan(beta.y)))
					{
					alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val.save)), as.numeric(tclvalue(var.val)))
					tclvalue(mode.val) <- as.numeric(tclvalue(mode.val.save))
					}

			BetaB <<- plot.betas(beta.x, alphabet[1], alphabet[2])
			tclvalue(mode.val.save) <- as.numeric(tclvalue(mode.val))
			repost.output.alpha.beta(alphabet[1], alphabet[2])
			repost.output.summary()
			}
	}




# runs if it is thought the varience value has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
replot.maybe.var.val <- function(...)
	{
		if(as.numeric(tclvalue(var.val)) != as.numeric(tclvalue(var.val.save)))
			{

			alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val)), as.numeric(tclvalue(var.val)))

			# calculate the betas to check for NaNs if so reset the var
			beta.y <- dbeta(beta.x, alphabet[1], alphabet[2])
	
				if(any(is.nan(beta.y)))
					{
					alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val)), as.numeric(tclvalue(var.val.save)))
					tclvalue(var.val) <- as.numeric(tclvalue(var.val.save))
					}

			tclvalue(var.val.save) <- as.numeric(tclvalue(var.val))
			BetaB <<- plot.betas(beta.x, alphabet[1], alphabet[2])
			repost.output.alpha.beta(alphabet[1], alphabet[2])
			repost.output.summary()
			}
	}


# calculate the values of alpha and beta from the mode
# and varience linked variables
# outputs a vector of alpha and beta
calc.alpha.beta <- function(mode, var)
	{
	alpha <<- var
	beta <<- (var/mode) - (1/mode) + 2 - var
	return(c(alpha, beta))
	}


# the beta plotting function I'm not sure how plot
# plots things - if it clears the plot area before
# calculating dbeta then this should prove slighty
# less flickery than the #ed out line
plot.betas <- function(beta.x, alpha, beta)
	{
	beta.y <- dbeta(beta.x, alpha, beta)
	beta.labels <- c(0.0, 0.2, 0.4, 0.6, 0.8, 1.0)

	N <- as.numeric(tclvalue(N.val))
	ss <- as.numeric(tclvalue(sample.size.val))
	pos <- as.numeric(tclvalue(positives.val))
	betab <- beta.binom(N, ss, pos, alpha, beta)

	maxy <- max(betab$py) + (max(betab$py) / 10)
	beta.binomial.labels <- round(pretty(betab$py, n=3), 2)

	par(fig=c(0.00, 1.00, 0.60, 1.00))
	plot(beta.x, beta.y, type="l", axes=F, xlab="proportion", ylab="", xlim=c(0,1),col='red')
	title(ylab="density", line=2)
	axis(1, at=beta.labels, labels=beta.labels)
	box()

	par(fig=c(0.00, 1.00, 0.00, 0.60), new=TRUE)
	barplot(betab$py, names.arg=betab$y, xlab="additional positives in consignment", ylab="", ylim=c(0, maxy), col='lightblue', axes=FALSE)
	axis(2, at=beta.binomial.labels, labels=beta.binomial.labels, las=2)
	title(ylab="probability", line=2)
	box()

	return(betab)
	}



# quits cleanly taking the X11 window down with it
# if the quit button is pressed
quit <- function(...)
	{
	tkdestroy(control)
	if(exists("helpscreen")){tkdestroy(helpscreen)}
	dev.off()
	}




# runs if it is thought the N has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
replot.maybe.N.val <- function(...)
	{

		
		if(as.numeric(tclvalue(N.val)) != as.numeric(tclvalue(N.val.save)))
			{
			# update the saved position of N.val
			tclvalue(N.val.save) <- as.numeric(tclvalue(N.val))

			# test to see if N has fallen below sample size if so reduce sample size
			if(as.numeric(tclvalue(N.val)) < as.numeric(tclvalue(sample.size.val)))
				{tclvalue(sample.size.val) <- as.numeric(tclvalue(N.val))}

			# test to see if N has fallen below positives if so reduce positives
			if(as.numeric(tclvalue(N.val)) < as.numeric(tclvalue(positives.val)))
				{tclvalue(positives.val) <- as.numeric(tclvalue(N.val))}

			# replotting code here
			BetaB <<- plot.betas(beta.x, alpha, beta)
			repost.output.N()
			repost.output.summary()
			repost.output.sample.size()
			repost.output.positives()
			}
	}




# runs if it is thought the sample size has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
replot.maybe.sample.size.val <- function(...)
	{
		if(as.numeric(tclvalue(sample.size.val)) != as.numeric(tclvalue(sample.size.val.save)))
			{
			tclvalue(sample.size.val.save) <- as.numeric(tclvalue(sample.size.val))

			# test to see if sample size has gone above N if so increase N
			if(as.numeric(tclvalue(N.val)) < as.numeric(tclvalue(sample.size.val)))
				{tclvalue(N.val) <- as.numeric(tclvalue(sample.size.val))}

			# test to see if sample size has fallen below positives if so reduce positives
			if(as.numeric(tclvalue(sample.size.val)) < as.numeric(tclvalue(positives.val)))
				{tclvalue(positives.val) <- as.numeric(tclvalue(sample.size.val))}

			# replotting code here
			BetaB <<- plot.betas(beta.x, alpha, beta)
			repost.output.summary()
			repost.output.N()
			repost.output.positives()
			repost.output.sample.size()
			}
	}




# runs if it is thought the positives has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
replot.maybe.positives.val <- function(...)
	{
		if(as.numeric(tclvalue(positives.val)) != as.numeric(tclvalue(positives.val.save)))
			{
			tclvalue(positives.val.save) <- as.numeric(tclvalue(positives.val))

			# test to see if positives has gone above N if so increase N
			if(as.numeric(tclvalue(N.val)) < as.numeric(tclvalue(positives.val)))
				{tclvalue(N.val) <- as.numeric(tclvalue(positives.val))}

			# test to see if positives has fallen below sample.size if so increase sample size
			if(as.numeric(tclvalue(sample.size.val)) < as.numeric(tclvalue(positives.val)))
				{tclvalue(sample.size.val) <- as.numeric(tclvalue(positives.val))}

			# replotting code here
			BetaB <<- plot.betas(beta.x, alpha, beta)
			repost.output.summary()
			repost.output.sample.size()
			repost.output.N()
			repost.output.positives()
			}
	}








# Calculates the p.d.f of the beta-binomial distribution
# basically for prior parameters alpha and beta a distribution
# can be calculated which gives the probability of each possibility
# for the remaining units given the total consignment size, the size
# of the sample, and how many positives have been observed
#
# this function returns three vectors, y is an index for each
# remaining unit - py is the probability of observing so many y's
# in the remainder of the consignment, sigma is the culmulative
# of that distribution
#
# this particular version is a cut down one from a more general function
# because it it being invoked from TclTk it doesn't need all the data
# validation of the more general version
beta.binom <- function(N, sample.size, positives, alpha, beta)
{
remaining.units <- N - sample.size

prob.at.y <- rep(0, length=(remaining.units)+1)
denom <- gamma(positives + alpha) * gamma(sample.size - positives + beta) * gamma(sample.size + (remaining.units) + alpha + beta)
num1 <- gamma(sample.size + alpha + beta)

	for(y in 0:(remaining.units))
		{
		num <- num1 * choose(remaining.units, y) * gamma(y + positives + alpha) * gamma(sample.size + remaining.units - positives - y + beta)
		prob.at.y[y+1] <- num/denom
		}

y <- 0:remaining.units
sigma <- cumsum(prob.at.y)
py <- prob.at.y

return(list(y=y, py=py, sigma=sigma))
}





# allow users to reset the prior parameters to unity
# by invoking this function
reset.priors <- function(...)
	{
	# reassign the variable for alpha and its saved value
	tclvalue(mode.val) <- 0.5
	tclvalue(mode.val.save) <- 0.5

	# reassign the variable for beta and its saved value
	tclvalue(var.val) <- 1
	tclvalue(var.val.save) <- 1

	# recalculate the values of alpha and beta and replot
	alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val)), as.numeric(tclvalue(var.val)))
	Beta.B <<- plot.betas(beta.x, alphabet[1], alphabet[2])
	repost.output.alpha.beta(alphabet[1], alphabet[2])
	repost.output.summary()
	}






# whenever alpha and beta are changed this puts up
# their modified values
repost.output.alpha.beta <- function(alpha, beta)
	{
	altxt <- paste("alpha is ", round(as.numeric(alpha), digits=2))
	tkconfigure(alpha.text, text=altxt)
	betxt <- paste("beta is ", round(as.numeric(beta), digits=2))
	tkconfigure(beta.text, text=betxt)
	}



# whenever the consignment size changes this puts
# up the new value
repost.output.N <- function(...)
	{
	Ntxt <- paste("total consignment size ", tclvalue(N.val))
	tkconfigure(N.text, text=Ntxt)
	}




# re-calculate the output display for sample size
repost.output.sample.size <- function(...)
	{
	samplesizetxt <- paste("sample size ", tclvalue(sample.size.val))
	tkconfigure(sample.size.text, text=samplesizetxt)
	}




# re-calculate the output display for positives
repost.output.positives <- function(...)
	{
	positivestxt <- paste("positives ", tclvalue(positives.val))
	tkconfigure(positives.text, text=positivestxt)
	}



# per.r find the value of the ith percentage point of a probability distribution
# this version is a variation on the per() distributed with GenKern
# for use with the TclTk functions for sample size estimation where we
# know the bin centres are of equal spacing
# the main adaptation is therefore to get rid of the extra c object as it is no longer
# needed - and makes the package far easier to maintain and install under the target
# windows systems
per <- function(den, vals, point)
	{
	den[which(den == "NA")] <- 0
	den[which(den < 0)] <- 0

	## get the standardised culmulative density
	culden <- cumsum(den)
	culden <- culden / max(culden)

	## find the bin with the point-th culmulative sum in it
	bin <- which(culden > point)[1]

	xvalue <- vals[bin]
	return(xvalue)
	}






# runs if it is thought the level value has changed
# don't want to run the full thing every time the 
# button is activated hence the test against a stored
# value
repost.output.level.val <- function(...)
	{
		if(as.numeric(tclvalue(level.val)) != as.numeric(tclvalue(level.val.save)))
			{
			tclvalue(level.val.save) <- as.numeric(tclvalue(level.val))
			leveltxt <- paste("level ", (as.numeric(tclvalue(level.val)))/100)
			tkconfigure(level.text, text=leveltxt)
			repost.output.summary()
			}
	}





# updates the summary statistic at the bottom of the output
# window
repost.output.summary <- function(...)
	{
	tclvalue(summary.val) <- per(BetaB$py, BetaB$y, (1-(as.numeric(tclvalue(level.val))/100)))
	summarytxt <- paste("there is a ", as.numeric(tclvalue(level.val)), " percent chance there are ", as.numeric(tclvalue(summary.val)), " or more, additional illegal units in the consignment")
	tkconfigure(summary.text, text=summarytxt)
	}



# just for exiting the help screen
quit.help <- function(...)
		{
		tkdestroy(helpscreen)
		rm(helpscreen, inherits=TRUE)
		}


# general purpose exit function
quit.all <- function(...)
	{
	tkdestroy(helpscreen)
	tkdestroy(control)
	# for non-interactive mode you don't need this
		if(sys == "Linux"){dev.off()}
	}



# provides for a text file of help to be displayed copied from
# the tkrfaq example and seem to work really well - one modification 
# is to pack the scrollbar before the text or else the text squeezes 
# the scrollbar if you reduce the size of the window
help <- function(...)
{
helpscreen <<- tktoplevel()
tktitle(helpscreen) <- "Help for beta-binomial calculations"

frame10 <- tkframe(helpscreen, relief="raised", borderwidth=2)

exit.button <- tkbutton(frame10, text="Exit help", command=quit.help, font=fnt)
exit.all.button <- tkbutton(frame10, text="Exit all", command=quit.all, font=fnt)

tkgrid(exit.button, exit.all.button)
tkpack(frame10, side="bottom")

txt <- tktext(helpscreen, font=fnt, bg="grey")

scr <- tkscrollbar(helpscreen, repeatinterval=5, command=function(...)tkyview(txt,...))

## Safest to make sure scr exists before setting yscrollcommand
tkconfigure(txt, yscrollcommand=function(...)tkset(scr,...))

tkpack(scr, side="right", fill="y")
tkpack(txt, side="left", fill="both", expand=TRUE)

chn <- tkcmd("open", file.path(".","beta-binomial-help.txt"))

tkinsert(txt, "end", tkcmd("read", chn))
tkcmd("close", chn)
 
tkconfigure(txt, state="disabled")
tkmark.set(txt,"insert","0.0")
tkfocus(txt)
}


press.return <- function(...)
{
alphabet <- calc.alpha.beta(as.numeric(tclvalue(mode.val)), as.numeric(tclvalue(var.val)))
BetaB <<- plot.betas(beta.x, alphabet[1], alphabet[2])
}
