# script for doing the priors on the beta-binomial and t-beta-binomial
# roughly analogous to the first sheet on the Excel products

# stop if library tcltk is unavailible if it is load it
require(tcltk) || stop("tcltk support is absent")

# source common functions - may move them to within this
# file so the whole function can become localised
source("beta-binomial-functions.r")

# define the graphical window with title
control <- tktoplevel()
tktitle(control) <- "Beta binomial calculation"

# a few system constants
#fnt <- "8x16"
#fnt <- "fixed"
fnt <- "arial 10"
sys <- c("Windows")
#sys <- c("Linux")
wraplen <- 300

# assign the variables linked to Tk widgets
mode.val <- tclVar(0.5)
mode.val.save <- tclVar(0.5)

var.val <- tclVar(1)
var.val.save <- tclVar(1)

N.val <- tclVar(1)
N.val.save <- tclVar(1)

sample.size.val <- tclVar(1)
sample.size.val.save <- tclVar(1)

positives.val <- tclVar(1)
positives.val.save <- tclVar(1)

level.val <- tclVar(95)
level.val.save <- tclVar(95)

summary.val <- tclVar(0)

# assign R variables
alpha <- 1
beta <- 1

# assign a vector of x ordinates
beta.x <- seq(0, 1, length=100)



# split screen works well except it has to render everything which has been
# in the particular screen each time it updates - worth bearing in mind 
# for future use
#split.screen(figs = matrix(c(0.0, 0.0, 1.0, 1.0, 0.0, 0.6, 0.6, 1.0), nrow=2))

	# initial plot of the beta distributions for windows rem out for unix
	if(sys == "Windows")
		{
		windows(width=4.25, height=4, pointsize=12, rescale=c("R"))
		par(bg="white", cex=1, mar=c(3,3,1,1), lwd=1, mgp=c(1.2,0.25,0), oma=c(0,0,0,0), tcl=-0.25)
		par(font=1)
		}

	# initial plot of the beta distributions for unix rem out for windows
	if(sys == "Linux"){par(bg="grey", cex=1.5, mar=c(3,3,1,1), lwd=2, mgp=c(1.2,0.25,0), oma=c(0,0,0,0), tcl=-0.25)}

# frame 1 has the controls for the prior in it
frame1 <- tkframe(control, relief="groove", borderwidth=2)
# frame 2 has the quit button in it
frame2 <- tkframe(control, relief="groove", borderwidth=2)
# frame 3 has the sliders for selecting N, sample size and number
# of positives
frame3 <- tkframe(control, relief="groove", borderwidth=2)
# frame 4 has the slider for output
frame4 <- tkframe(control, relief="groove", borderwidth=2)
# frame 5 has the slider for selecting the level
frame5 <- tkframe(control, relief="groove", borderwidth=2)


########################################################################
# construct frame 1 ####################################################
# pack the vertical scale bar which inputs the varience of the beta
tkpack(tkscale(frame1, command=replot.maybe.var.val, from=20.00, to=0.05,
		showvalue=F, variable=var.val, resolution=0.05,
		orient="vertical", font=fnt), side="left")

# pack the text message at the top of the window
tkpack(tklabel(frame1, text="Prior: adjust the horizontal slider to set the mean and the vertical slider to set the dispersion", wraplength=wraplen, justify="left", font=fnt))

# pack the horizontal scale bar which inputs the mode of the beta distribution
tkpack(tkscale(frame1, command=replot.maybe.mode.val, from=0.05, to=0.95,
		showvalue=T, variable=mode.val, resolution=0.01,
		orient="horiz", font=fnt), fill="x")

# give some means of resetting the priors at the press of a button
reset.but <- tkbutton(frame1, text="Reset priors", command=reset.priors, font=fnt)
tkpack(frame1, reset.but)

tkpack(frame1, fill="x")
########################################################################



########################################################################
# construct frame 3 ####################################################
#
# pack the text message at the top of the window
selector.text <- tklabel(frame3, text="Adjust the sliders to select N, sample size, and the number of positives", wraplength=wraplen, justify="left", font=fnt)
tkgrid(selector.text, columnspan=3)

# labels for the three scale bars
aa <- tklabel(frame3, text="N", font=fnt)
ab <- tklabel(frame3, text="sample size", font=fnt)
ac <- tklabel(frame3, text="positives", font=fnt)
tkgrid(aa, ab, ac)

# pack the vertical scale bar which inputs the total N
N.selector <- tkscale(frame3, command=replot.maybe.N.val, from=50, to=3,
		showvalue=T, variable=N.val, resolution=1,
		orient="vertical", label="", font=fnt)

# pack the vertical scale bar which inputs the sample size
sample.size.selector <- tkscale(frame3, command=replot.maybe.sample.size.val, from=50, to=1,
		showvalue=T, variable=sample.size.val, resolution=1,
		orient="vertical", label="", font=fnt)

# pack the vertical scale bar which inputs the number of positives
positives.selector <- tkscale(frame3, command=replot.maybe.positives.val, from=50, to=1,
		showvalue=T, variable=positives.val, resolution=1,
		orient="vertical", label="",
		sliderrelief="raised", font=fnt)

tkgrid(N.selector, sample.size.selector, positives.selector, ipadx=10)

########################################################################






########################################################################
# construct frame 5 ####################################################
#
# pack the text message at the top of the window
tkpack(tklabel(frame5, text="Level selection", font=fnt))

# pack the horizontal scale bar which inputs the level
tkpack(tkscale(frame5, command=repost.output.level.val, from=50, to=99,
		showvalue=T, variable=level.val, resolution=1,
		orient="horizontal", label="", font=fnt), fill="x")

tkpack(frame5, fill="x")
########################################################################




########################################################################
# construct frame 4 ####################################################
#
altxt <- paste("alpha is ", alpha)
alpha.text <- tklabel(frame4, text=altxt, font=fnt)

betxt <- paste("beta is ", beta)
beta.text <- tklabel(frame4, text=betxt, font=fnt)

Ntxt <- paste("total consignment size ", tclvalue(N.val))
N.text <- tklabel(frame4, text=Ntxt, font=fnt)

leveltxt <- paste("level ", (as.numeric(tclvalue(level.val))/100))
level.text <- tklabel(frame4, text=leveltxt, font=fnt)

samplesizetxt <- paste("sample size ", tclvalue(sample.size.val))
sample.size.text <- tklabel(frame4, text=samplesizetxt, font=fnt)

positivestxt <- paste("positives ", tclvalue(positives.val))
positives.text <- tklabel(frame4, text=positivestxt, font=fnt)

summarytxt <- paste("there is a ", as.numeric(tclvalue(level.val)), " percent chance there are ", as.numeric(tclvalue(summary.val)), " or more, additional illegal units in the consignment")
summary.text <- tklabel(frame4, text=summarytxt, wraplength=wraplen, font=fnt, justify="left")



tkgrid(alpha.text, beta.text, sticky="w", padx=10)
tkgrid(N.text, sample.size.text, sticky="w", padx=10)
tkgrid(positives.text, level.text, sticky="w", padx=10)
tkgrid(summary.text, columnspan=2, padx=10)

tkpack(frame4, fill="x")
tkpack(frame3, fill="x")

########################################################################





########################################################################
# construct frame 2 ####################################################
# put a quit button in frame 2 and put frame 2 on control
quit.but <- tkbutton(frame2,text="Exit", command=quit, font=fnt, padx=60)
help.but <- tkbutton(frame2,text="Help", command=help, font=fnt, padx=60)
tkgrid(quit.but, help.but, padx=10)
tkpack(frame2, fill="x")
########################################################################

# actually do the initial plot
BetaB <- plot.betas(beta.x, alpha, beta)

# put code to prevent resizing here
#tkwm.resizable(control, c(FALSE, FALSE))

# put code to bind return to plot.betas() here
tkbind(control, "<Return>", press.return)

# use tkwait to keep the function
# hanging around whilst in batch mode
tkwait.window(control)








