"LinaMayrand3" <-
structure(list(S = structure(c(-0.0662912607362388-0.0855811337270078i, 
-0.0662912607362388+0.0855811337270078i, 0.0352266456251514+0i, 
0.332671113131273+0i, 0.110485434560398-0.0855811337270078i, 
0.110485434560398+0.0855811337270078i, -0.0854411265843329+0i, 
0.806890861720468+0i, 0.662912607362388+0.171163681667578i, 0.662912607362388-0.171163681667578i, 
-0.135010726159072+0i, 0.45987820885317+0i, 0.662912607362388+0.171163681667578i, 
0.662912607362388-0.171163681667578i, 0.45987820885317+0i, -0.135010726159072+0i, 
0.110485434560398-0.0855811337270078i, 0.110485434560398+0.0855811337270078i, 
0.806890861720468+0i, -0.0854411265843329+0i, -0.0662912607362388-0.0855811337270078i, 
-0.0662912607362388+0.0855811337270078i, 0.332671113131273+0i, 
0.0352266456251514+0i), .Dim = as.integer(c(4, 6))), W = structure(c(-0.0662912607362388+0.0855811337270078i, 
-0.0662912607362388-0.0855811337270078i, 0.332671113131273+0i, 
0.0352266456251514+0i, -0.110485434560398-0.0855811337270078i, 
-0.110485434560398+0.0855811337270078i, -0.806890861720468+0i, 
0.0854411265843329+0i, 0.662912607362388-0.171163681667578i, 
0.662912607362388+0.171163681667578i, 0.45987820885317+0i, -0.135010726159072+0i, 
-0.662912607362388+0.171163681667578i, -0.662912607362388-0.171163681667578i, 
0.135010726159072+0i, -0.45987820885317+0i, 0.110485434560398+0.0855811337270078i, 
0.110485434560398-0.0855811337270078i, -0.0854411265843329+0i, 
0.806890861720468+0i, 0.0662912607362388-0.0855811337270078i, 
0.0662912607362388+0.0855811337270078i, -0.0352266456251514+0i, 
-0.332671113131273+0i), .Dim = as.integer(c(4, 6)))), .Names = c("S", 
"W"))
"LinaMayrand4" <-
structure(list(S = structure(c(-0.0177682977370364-0.0843076215447475i, 
0.102008915752387-0.140888496674900i, 0.512949613906065+0.139761114430506i, 
0.682186908447622+0.309503739778537i, 0.261320230715269-0.0265993641984858i, 
-0.0829326081014193-0.196341989489948i, -0.0493947656694662-0.0288541287014151i, 
0.00584356522937926+0.0277267464287373i), .Dim = as.integer(c(1, 
8))), W = structure(c(-0.00584356522937926+0.0277267464287373i, 
-0.0493947656694662+0.0288541287014151i, 0.0829326081014193-0.196341989489948i, 
0.261320230715269+0.0265993641984858i, -0.682186908447622+0.309503739778537i, 
0.512949613906065-0.139761114430506i, -0.102008915752387-0.140888496674900i, 
-0.0177682977370364+0.0843076215447475i), .Dim = as.integer(c(1, 
8)))), .Names = c("S", "W"))
"LinaMayrand5" <-
structure(list(S = structure(c(0.0104924505144049+0.0205904370844365i, 
-0.0131549130788862+0.0190001547113654i, -0.0480171707489855-0.0286805385686857i, 
0.00443868969370267-0.0660029379744943i, -0.0171289081256946+0.00872852869497756i, 
-0.0407762717133288-0.0282317864304761i, -0.0457735601342806-0.0701496826501424i, 
0.109045176430938-0.153497807951817i, -0.080639704153759-0.117947473548549i, 
0.0139497502179911-0.217696442313413i, 0.342248869674118+0.0140988497709936i, 
0.423036269003173+0.0594750872271794i, 0.151379708479645-0.0942236567554891i, 
0.245969162830182-0.123232560001445i, 0.772484323772727+0.144605393302011i, 
0.642829163846022+0.350360717350611i, 0.643003234585088+0.182852164538766i, 
0.501119052917861+0.350160634132963i, 0.479618312994977+0.059046616665079i, 
0.375016379640746+0.0994046669755474i, 0.643003234585088+0.182852164538766i, 
0.501119052917861+0.350160634132963i, -0.0564771558731019-0.0836581495806555i, 
-0.0349735956831048-0.248283003884364i, 0.151379708479645-0.0942236567554891i, 
0.245969162830182-0.123232560001445i, -0.0809927427988999-0.0456676283259696i, 
-0.106064370637416-0.113222843833651i, -0.080639704153759-0.117947473548549i, 
0.0139497502179911-0.217696442313413i, 0.0450707806910314+0.0140988497709936i, 
-0.0103356606306847+0.0594750872271794i, -0.0171289081256946+0.00872852869497756i, 
-0.0407762717133288-0.0282317864304761i, 0.0142495119522009+0.00120270047413905i, 
0.0106798133845187+0.0203460275629919i, 0.0104924505144049+0.0205904370844365i, 
-0.0131549130788862+0.0190001547113654i, -0.00819760743953431-0.00489641086342034i, 
0.000541697299744814-0.00805499281231948i), .Dim = as.integer(c(4, 
10))), W = structure(c(0.0104924505144049-0.0205904370844365i, 
-0.0131549130788862-0.0190001547113654i, -0.00819760743953431+0.00489641086342034i, 
0.000541697299744814+0.00805499281231948i, 0.0171289081256946+0.00872852869497756i, 
0.0407762717133288-0.0282317864304761i, -0.0142495119522009+0.00120270047413905i, 
-0.0106798133845187+0.0203460275629919i, -0.080639704153759+0.117947473548549i, 
0.0139497502179911+0.217696442313413i, 0.0450707806910314-0.0140988497709936i, 
-0.0103356606306847-0.0594750872271794i, -0.151379708479645-0.0942236567554891i, 
-0.245969162830182-0.123232560001445i, 0.0809927427988999-0.0456676283259696i, 
0.106064370637416-0.113222843833651i, 0.643003234585088-0.182852164538766i, 
0.501119052917861-0.350160634132963i, -0.0564771558731019+0.0836581495806555i, 
-0.0349735956831048+0.248283003884364i, -0.643003234585088+0.182852164538766i, 
-0.501119052917861+0.350160634132963i, -0.479618312994977+0.059046616665079i, 
-0.375016379640746+0.0994046669755474i, 0.151379708479645+0.0942236567554891i, 
0.245969162830182+0.123232560001445i, 0.772484323772727-0.144605393302011i, 
0.642829163846022-0.350360717350611i, 0.080639704153759-0.117947473548549i, 
-0.0139497502179911-0.217696442313413i, -0.342248869674118+0.0140988497709936i, 
-0.423036269003173+0.0594750872271794i, -0.0171289081256946-0.00872852869497756i, 
-0.0407762717133288+0.0282317864304761i, -0.0457735601342806+0.0701496826501424i, 
0.109045176430938+0.153497807951817i, -0.0104924505144049+0.0205904370844365i, 
0.0131549130788862+0.0190001547113654i, 0.0480171707489855-0.0286805385686857i, 
-0.00443868969370267-0.0660029379744943i), .Dim = as.integer(c(4, 
10)))), .Names = c("S", "W"))
"comp.theta" <-
function(djk, Sigma.inv)
{
	#
	# Takes in the complex wavelet coefficient d_{j,k} and the inverse 
	# of the covariance matrix Sigma.  Returns the scalar statistic
	# theta_{j,k}; this is \chi^2_2 if the coefficient contains 
	# only noise.
	#
	if(!is.complex(djk)) stop(
			"comp.theta should only be used on complex wavelet coefficients."
			)
	tmp <- cbind(Re(djk), Im(djk))
	tmp <- diag(tmp %*% Sigma.inv %*% t(tmp))
	return(tmp)
}
"cthr.negloglik" <-
function(parvec, dstarvec, Sigma, Sigma.inv, twopirtdetS, code)
{
	#
	# Compute -log likelihood of sample dstar from 
	# mixture of bivariate normal distributions.
	#
	# Each row of dstarvec should contain one coefficient.
	#
	if(code == "C") {
		SigVec <- c(Sigma[1, 1], Sigma[1, 2], Sigma[2, 2])
		di <- dstarvec[, 2]
		dr <- dstarvec[, 1]
		pnd <- length(di)
		pans <- 0
		Cout <- .C("Ccthrnegloglik",
			parvec = as.double(parvec),
			SigVec = as.double(SigVec),
			di = as.double(di),
			dr = as.double(dr),
			pnd = as.integer(pnd),
			pans = as.double(pans))
		return(Cout$pans)
	}
	else {
		p <- parvec[1]
		tmp <- parvec[3] * sqrt(parvec[2] * parvec[4])
		V <- matrix(c(parvec[2], tmp, tmp, parvec[4]), byrow = TRUE, ncol
			 = 2)
		VpS <- V + Sigma
		detVpS <- VpS[1, 1] * VpS[2, 2] - VpS[1, 2] * VpS[2, 1]
		VpS.inv <- matrix(c(VpS[2, 2],  - VpS[1, 2],  - VpS[2, 1],
			VpS[1, 1]), ncol = 2, byrow = TRUE)/detVpS
		twopirtdetVpS <- 2 * pi * sqrt(detVpS)
		tmp <- apply(dstarvec, 1, cthreb.mixden, p = p, twopirtdetS = 
			twopirtdetS, twopirtdetVpS = twopirtdetVpS, Sigma.inv
			 = Sigma.inv, VpS.inv = VpS.inv)
		return( - sum(log(tmp)))
	}
}
"cthreb.mixden" <-
function(dstar, p, twopirtdetS, twopirtdetVpS, Sigma.inv, VpS.inv)
{
	#
	# Compute density fn. of dstar from normal mixture
	#
	den1 <- exp(-0.5 * t(dstar) %*% VpS.inv %*% dstar)/twopirtdetVpS
	den2 <- exp(-0.5 * t(dstar) %*% Sigma.inv %*% dstar)/twopirtdetS
	return(p * den1 + (1 - p) * den2)
}
"cthreb.odds" <-
function(coefs, p, V, Sig, code = "NAG")
{
	#
	# Takes in coefs from a given level with EB-chosen prior parameters
	# p and V and DWT covariance matrix Sig.
	#
	# Returns posterior weights of coefficients being non-zero.
	#
	if(code == "C" || code == "NAG") {
		dr <- coefs[, 1]
		di <- coefs[, 2]
		nd <- length(dr)
		SigVec <- c(Sig[1, 1], Sig[1, 2], Sig[2, 2])
		VVec <- c(V[1, 1], V[1, 2], V[2, 2])
		pp <- p
		ans <- rep(0, nd)
		odds <- rep(0, nd)
		Cout <- .C("Ccthrcalcodds",
			pnd = as.integer(nd),
			dr = as.double(dr),
			di = as.double(di),
			VVec = as.double(VVec),
			SigVec = as.double(SigVec),
			pp = as.double(p),
			ans = as.double(ans),
			odds = as.double(odds))
		ptilde <- Cout$ans
	}
	else {
		VpS <- V + Sig
		detS <- Sig[1, 1] * Sig[2, 2] - Sig[1, 2]^2
		detVpS <- VpS[1, 1] * VpS[2, 2] - VpS[1, 2]^2
		mat <- solve(Sig) - solve(V + Sig)
		odds <- apply(coefs, 1, odds.matrix.mult, mat = mat)
		# Take care of excessively huge odds giving NAs in exp(odds/2)
		odds[odds > 1400] <- 1400
		odds <- p/(1 - p) * sqrt(detS/detVpS) * exp(odds/2)
		ptilde <- odds/(1 + odds)
	}
	if(any(is.na(ptilde))) {
		print("NAs in ptilde; setting those values to one")
		ptilde[is.na(ptilde)] <- 1
	}
	return(ptilde)
}
"cthreb.thresh" <-
function(coefs, ptilde, V, Sig, rule, code)
{
	#
	# Takes in coefs from a given level with EB-chosen 
	# prior covariance matrix V, posterior weights ptilde 
	# and DWT covariance matrix Sig.
	#
	# Returns thresholded coefficients; how the thresholding is
	# done depends on rule:
	#	rule == "hard": ptilde < 1/2 -> zero, otherwise
	#			keep unchanged (kill or keep).
	#	rule == "soft": ptilde < 1/2 -> zero, otherwise
	#			use posterior mean (kill or shrink).
	#	rule == "mean": use posterior mean (no zeros).
	#
	if(rule == "hard") {
		coefs[ptilde <= 0.5,  ] <- 0
		return(coefs)
	}
	else if(code == "C" || code == "NAG") {
		nd <- length(coefs[, 1])
		dr <- coefs[, 1]
		di <- coefs[, 2]
		ansr <- rep(0, nd)
		ansi <- rep(0, nd)
		VVec <- c(V[1, 1], V[1, 2], V[2, 2])
		SigVec <- c(Sig[1, 1], Sig[1, 2], Sig[2, 2])
		Cout <- .C("Cpostmean",
			pnd = as.integer(nd),
			dr = as.double(dr),
			di = as.double(di),
			VVec = as.double(VVec),
			SigVec = as.double(SigVec),
			ptilde = as.double(ptilde),
			ansr = as.double(ansr),
			ansi = as.double(ansi))
		coefs <- cbind(Cout$ansr, Cout$ansi)
	}
	else {
		coefs <- ptilde * t(apply(coefs, 1, cthreb.postmean, V = V,
			Sig = Sig))
	}
	if(rule == "mean")
		return(coefs)
	coefs[ptilde <= 0.5,  ] <- 0
	return(coefs)
}
"cthresh" <-
function(data, j0 = 3, dwwt = NULL, dev = madmad, rule = "hard", filter.number
	 = 3.1, family = "LinaMayrand", plotfn = FALSE, TI = FALSE,
	details = FALSE, policy = "mws", code = "NAG", tol = 0.01)
{
	#
	# Limited parameter checking
	#
	n <- length(data)
	nlevels <- IsPowerOfTwo(n)
	if(is.na(nlevels))
		stop("Data should be of length a power of two.")
	if((rule != "hard") & (rule != "soft") & (rule != "mean")) {
		warning(paste("Unknown rule", rule, "so hard thresholding used"
			))
		rule <- "hard"
	}
	if((policy != "mws") & (policy != "ebayes")) {
		warning(paste("Unknown policy", policy, 
			"so using multiwavelet style thresholding"))
		policy <- "mws"
	}
	#
	# If 5 vanishing moments is called for, average over all 
	# Lina-Mayrand wavelets with 5 vanishing moments by recursively
	# calling cthresh; if filter.number=0 use all LimaMayrand wavelets
	#
	if(filter.number == 3 & ((family == "LinaMayrand") || (family = 
		"Lawton"))) {
		filter.number <- 3.1
		family <- "LinaMayrand"
	}
	else if(filter.number == 4 & family == "LinaMayrand")
		filter.number <- 4.1
	else if((filter.number == 5) & (family == "LinaMayrand")) {
		est1 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.1, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est2 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.2, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est3 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.3, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est4 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.4, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		estimate <- (est1 + est2 + est3 + est4)/4
		if(plotfn) {
			x <- (1:n)/n
			plot(x, data, ylim = range(data, Re(estimate)))
			lines(x, Re(estimate), lwd = 2, col = 2)
		}
		return(estimate)
	}
	else if((filter.number == 0) & (family == "LinaMayrand")) {
		est1 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 3.1, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est2 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 4.1, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est3 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.1, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est4 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.2, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est5 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.3, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		est6 <- cthresh(data, j0 = j0, dev = dev, rule = rule, 
			filter.number = 5.4, TI = TI, policy = 
			policy, details = FALSE, plotfn = FALSE, code = code, tol = tol
			)
		estimate <- (est1 + est2 + est3 + est4 + est5 + est6)/6
		if(plotfn) {
			x <- (1:n)/n
			plot(x, data, ylim = range(data, Re(estimate)))
			lines(x, Re(estimate), lwd = 2, col = 2)
		}
		return(estimate)
	}
	#
	# Take required type of wavelet transform.
	#
	if(TI) data.wd <- wst(data, filter.number = filter.number, family = 
			family) else data.wd <- wd(data, filter.number = 
			filter.number, family = family)
	#
	# Generate covariance matrices
	#
	if(is.null(dwwt)) dwwt <- make.dwwt(nlevels = nlevels, filter.number = 
			filter.number, family = family)
	sigsq <- dev(Re(accessD(data.wd, level = nlevels - 1))) + dev(Im(
		accessD(data.wd, level = nlevels - 1)))
	Sigma <- array(0, c(nlevels, 2, 2))
	Sigma[, 1:2, 1:2] <- (sigsq * Im(dwwt))/2
	Sigma[, 1, 1] <- (sigsq * (1 + Re(dwwt)))/2
	Sigma[, 2, 2] <- (sigsq * (1 - Re(dwwt)))/2
	thr.wd <- data.wd
	if(policy == "mws") {
		#
		# Do multiwavelet style universal thresholding 
		#
		if(rule == "mean") {
			warning("Can't use posterior mean with multiwavelet style thresholding.  Using soft thresholding instead"
				)
			rule <- "soft"
		}
		lambda <- 2 * log(n)
		for(j in j0:(nlevels - 1)) {
			coefs <- accessD(data.wd, level = j)
			Sigma.inv <- solve(Sigma[j + 1,  ,  ])
			thetaj <- comp.theta(coefs, Sigma.inv)
			if(rule == "hard")
				coefs[abs(thetaj) < lambda] <- 0
			else {
				k <- Re(coefs)/Im(coefs)
				thetahat <- pmax(0, thetaj - lambda)
				varr <- Sigma[j + 1, 1, 1]
				vari <- Sigma[j + 1, 2, 2]
				covar <- Sigma[j + 1, 1, 2]
				bhatsq <- (varr * vari - covar^2) * thetahat
				bhatsq <- bhatsq/(vari * k^2 - 2 * covar * k +
					varr)
				coefs <- complex(mod = sqrt(bhatsq * (k^2 +
					1)), arg = Arg(coefs))
			}
			thr.wd <- putD(thr.wd, level = j, v = coefs)
		}
	}
	else {
		#
		# Do empirical Bayes shrinkage/thresholding.
		# Start by finding parameters:
		#
		EBpars <- find.parameters(data.wd = data.wd, dwwt = dwwt, j0 = 
			j0, code = code, tol = tol, Sigma = Sigma)
		p <- c(EBpars$pars[, 1])
		Sigma <- EBpars$Sigma
		V <- array(0, dim = c(nlevels - 1, 2, 2))
		for(i in j0:(nlevels - 1))
			V[i,  ,  ] <- matrix(EBpars$pars[i, c(2, 3, 3, 4)],
				ncol = 2)
		#
		# Do thresholding.
		#
		for(j in j0:(nlevels - 1)) {
			coefs <- accessD(data.wd, level = j)
			coefs <- cbind(Re(coefs), Im(coefs))
			ptilde <- cthreb.odds(coefs, p = p[j], V = V[j,  ,
				], Sig = Sigma[j + 1,  ,  ], code = code)
			coefs.thr <- cthreb.thresh(coefs, ptilde = ptilde,
				V = V[j,  ,  ], Sig = Sigma[j,  ,  ], rule = 
				rule, code = code)
			thr.wd <- putD(thr.wd, level = j, v = complex(real = 
				coefs.thr[, 1], imag = coefs.thr[, 2]))
		}
	}
	#
	# Reconstruct
	#
	if(TI) data.rec <- AvBasis(thr.wd) else data.rec <- wr(thr.wd)
	#
	# Plot data and estimate
	#
	if(plotfn) {
		x <- (1:n)/n
		plot(x, data, ylim = range(data, Re(data.rec)))
		lines(x, Re(data.rec), lwd = 2, col = 2)
	}
	#
	# Return either just the estimate or an unweildy list.
	#
	if(details == FALSE) invisible(data.rec) else if(policy == "ebayes")
		invisible(list(data = data, data.wd = data.wd, thr.wd = thr.wd,
			estimate = data.rec, Sigma = Sigma, sigsq = sigsq,
			rule = rule, EBpars = EBpars$pars, wavelet = list(
			filter.number, family)))
	else invisible(list(data = data, data.wd = data.wd, thr.wd = thr.wd,
			estimate = data.rec, Sigma = Sigma, sigsq = sigsq,
			rule = rule, wavelet = list(filter.number, family)))
}
"filter.select" <-
function(filter.number, family = "DaubLeAsymm", constant = 1)
{
	G <- NULL
	if(family == "DaubExPhase") {
		family <- "DaubExPhase"
		#
		#
		#	The following wavelet coefficients are taken from
		#	Daubechies, I (1988) Orthonormal Bases of Wavelets
		#	Communications on Pure and Applied Mathematics. Page 980
		#	or Ten Lectures on Wavelets, Daubechies, I, 1992
		#	CBMS-NSF Regional Conference Series, page 195, Table 6.1
		#
		#	Comment from that table reads:
		#		"The filter coefficients for the compactly supported wavelets
		#		with extremal phase and highest number of vanishing moments
		#		compatible with their support width".
		#
		if(filter.number == 1) {
			#
			#
			#	This is for the Haar basis. (not in Daubechies).
			#
			H <- rep(0, 2)
			H[1] <- 1/sqrt(2)
			H[2] <- H[1]
			filter.name <- c("Haar wavelet")
		}
		else if(filter.number == 2) {
			H <- rep(0, 4)
			H[1] <- 0.482962913145
			H[2] <- 0.836516303738
			H[3] <- 0.224143868042
			H[4] <- -0.129409522551
			filter.name <- c("Daub cmpct on ext. phase N=2")
		}
		else if(filter.number == 3) {
			H <- rep(0, 6)
			H[1] <- 0.33267055295
			H[2] <- 0.806891509311
			H[3] <- 0.459877502118
			H[4] <- -0.13501102001
			H[5] <- -0.085441273882
			H[6] <- 0.035226291882
			filter.name <- c("Daub cmpct on ext. phase N=3")
		}
		else if(filter.number == 4) {
			H <- rep(0, 8)
			H[1] <- 0.230377813309
			H[2] <- 0.714846570553
			H[3] <- 0.63088076793
			H[4] <- -0.027983769417
			H[5] <- -0.187034811719
			H[6] <- 0.030841381836
			H[7] <- 0.032883011667
			H[8] <- -0.010597401785
			filter.name <- c("Daub cmpct on ext. phase N=4")
		}
		else if(filter.number == 5) {
			H <- rep(0, 10)
			H[1] <- 0.160102397974
			H[2] <- 0.603829269797
			H[3] <- 0.724308528438
			H[4] <- 0.138428145901
			H[5] <- -0.242294887066
			H[6] <- -0.032244869585
			H[7] <- 0.07757149384
			H[8] <- -0.006241490213
			H[9] <- -0.012580752
			H[10] <- 0.003335725285
			filter.name <- c("Daub cmpct on ext. phase N=5")
		}
		else if(filter.number == 6) {
			H <- rep(0, 12)
			H[1] <- 0.11154074335
			H[2] <- 0.494623890398
			H[3] <- 0.751133908021
			H[4] <- 0.315250351709
			H[5] <- -0.226264693965
			H[6] <- -0.129766867567
			H[7] <- 0.097501605587
			H[8] <- 0.02752286553
			H[9] <- -0.031582039318
			H[10] <- 0.000553842201
			H[11] <- 0.004777257511
			H[12] <- -0.001077301085
			filter.name <- c("Daub cmpct on ext. phase N=6")
		}
		else if(filter.number == 7) {
			H <- rep(0, 14)
			H[1] <- 0.077852054085
			H[2] <- 0.396539319482
			H[3] <- 0.729132090846
			H[4] <- 0.469782287405
			H[5] <- -0.143906003929
			H[6] <- -0.224036184994
			H[7] <- 0.071309219267
			H[8] <- 0.080612609151
			H[9] <- -0.038029936935
			H[10] <- -0.016574541631
			H[11] <- 0.012550998556
			H[12] <- 0.000429577973
			H[13] <- -0.001801640704
			H[14] <- 0.0003537138
			filter.name <- c("Daub cmpct on ext. phase N=7")
		}
		else if(filter.number == 8) {
			H <- rep(0, 16)
			H[1] <- 0.054415842243
			H[2] <- 0.312871590914
			H[3] <- 0.675630736297
			H[4] <- 0.585354683654
			H[5] <- -0.015829105256
			H[6] <- -0.284015542962
			H[7] <- 0.000472484574
			H[8] <- 0.12874742662
			H[9] <- -0.017369301002
			H[10] <- -0.044088253931
			H[11] <- 0.013981027917
			H[12] <- 0.008746094047
			H[13] <- -0.004870352993
			H[14] <- -0.000391740373
			H[15] <- 0.000675449406
			H[16] <- -0.000117476784
			filter.name <- c("Daub cmpct on ext. phase N=8")
		}
		else if(filter.number == 9) {
			H <- rep(0, 18)
			H[1] <- 0.038077947364
			H[2] <- 0.243834674613
			H[3] <- 0.60482312369
			H[4] <- 0.657288078051
			H[5] <- 0.133197385825
			H[6] <- -0.293273783279
			H[7] <- -0.096840783223
			H[8] <- 0.148540749338
			H[9] <- 0.030725681479
			H[10] <- -0.067632829061
			H[11] <- 0.000250947115
			H[12] <- 0.022361662124
			H[13] <- -0.004723204758
			H[14] <- -0.004281503682
			H[15] <- 0.001847646883
			H[16] <- 0.000230385764
			H[17] <- -0.000251963189
			H[18] <- 3.934732e-05
			filter.name <- c("Daub cmpct on ext. phase N=9")
		}
		else if(filter.number == 10) {
			H <- rep(0, 20)
			H[1] <- 0.026670057901
			H[2] <- 0.188176800078
			H[3] <- 0.527201188932
			H[4] <- 0.688459039454
			H[5] <- 0.281172343661
			H[6] <- -0.249846424327
			H[7] <- -0.195946274377
			H[8] <- 0.127369340336
			H[9] <- 0.093057364604
			H[10] <- -0.071394147166
			H[11] <- -0.029457536822
			H[12] <- 0.033212674059
			H[13] <- 0.003606553567
			H[14] <- -0.010733175483
			H[15] <- 0.001395351747
			H[16] <- 0.001992405295
			H[17] <- -0.000685856695
			H[18] <- -0.000116466855
			H[19] <- 9.358867e-05
			H[20] <- -1.3264203e-05
			filter.name <- c("Daub cmpct on ext. phase N=10")
		}
		else {
			stop("Unknown filter number for Daubechies wavelets with extremal phase and highest number of vanishing moments..."
				)
		}
	}
	else if(family == "DaubLeAsymm") {
		family <- "DaubLeAsymm"
		#
		#
		#       The following wavelet coefficients are taken from
		#       Ten Lectures on Wavelets, Daubechies, I, 1992
		#       CBMS-NSF Regional Conference Series, page 198, Table 6.3
		#
		#       Comment from that table reads:
		# 		"The low pass filter coefficients for the "least-asymmetric"
		#		compactly supported wavelets with maximum number of
		#		vanishing moments, for N = 4 to 10
		#
		if(filter.number == 4) {
			H <- rep(0, 8)
			H[1] <- -0.107148901418
			H[2] <- -0.041910965125
			H[3] <- 0.703739068656
			H[4] <- 1.136658243408
			H[5] <- 0.421234534204
			H[6] <- -0.140317624179
			H[7] <- -0.017824701442
			H[8] <- 0.045570345896
			filter.name <- c("Daub cmpct on least asymm N=4")
			H <- H/sqrt(2)
		}
		else if(filter.number == 5) {
			H <- rep(0, 10)
			H[1] <- 0.038654795955
			H[2] <- 0.041746864422
			H[3] <- -0.055344186117
			H[4] <- 0.281990696854
			H[5] <- 1.023052966894
			H[6] <- 0.89658164838
			H[7] <- 0.023478923136
			H[8] <- -0.247951362613
			H[9] <- -0.029842499869
			H[10] <- 0.027632152958
			filter.name <- c("Daub cmpct on least asymm N=5")
			H <- H/sqrt(2)
		}
		else if(filter.number == 6) {
			H <- rep(0, 12)
			H[1] <- 0.021784700327
			H[2] <- 0.004936612372
			H[3] <- -0.166863215412
			H[4] <- -0.068323121587
			H[5] <- 0.694457972958
			H[6] <- 1.113892783926
			H[7] <- 0.477904371333
			H[8] <- -0.102724969862
			H[9] <- -0.029783751299
			H[10] <- 0.06325056266
			H[11] <- 0.002499922093
			H[12] <- -0.011031867509
			filter.name <- c("Daub cmpct on least asymm N=6")
			H <- H/sqrt(2)
		}
		else if(filter.number == 7) {
			H <- rep(0, 14)
			H[1] <- 0.003792658534
			H[2] <- -0.001481225915
			H[3] <- -0.017870431651
			H[4] <- 0.043155452582
			H[5] <- 0.096014767936
			H[6] <- -0.070078291222
			H[7] <- 0.024665659489
			H[8] <- 0.758162601964
			H[9] <- 1.085782709814
			H[10] <- 0.408183939725
			H[11] <- -0.198056706807
			H[12] <- -0.152463871896
			H[13] <- 0.005671342686
			H[14] <- 0.014521394762
			filter.name <- c("Daub cmpct on least asymm N=7")
			H <- H/sqrt(2)
		}
		else if(filter.number == 8) {
			H <- rep(0, 16)
			H[1] <- 0.002672793393
			H[2] <- -0.0004283943
			H[3] <- -0.021145686528
			H[4] <- 0.005386388754
			H[5] <- 0.069490465911
			H[6] <- -0.038493521263
			H[7] <- -0.073462508761
			H[8] <- 0.515398670374
			H[9] <- 1.099106630537
			H[10] <- 0.68074534719
			H[11] <- -0.086653615406
			H[12] <- -0.202648655286
			H[13] <- 0.010758611751
			H[14] <- 0.044823623042
			H[15] <- -0.000766690896
			H[16] <- -0.004783458512
			filter.name <- c("Daub cmpct on least asymm N=8")
			H <- H/sqrt(2)
		}
		else if(filter.number == 9) {
			H <- rep(0, 18)
			H[1] <- 0.001512487309
			H[2] <- -0.000669141509
			H[3] <- -0.014515578553
			H[4] <- 0.012528896242
			H[5] <- 0.087791251554
			H[6] <- -0.02578644593
			H[7] <- -0.270893783503
			H[8] <- 0.049882830959
			H[9] <- 0.873048407349
			H[10] <- 1.015259790832
			H[11] <- 0.337658923602
			H[12] <- -0.077172161097
			H[13] <- 0.000825140929
			H[14] <- 0.042744433602
			H[15] <- -0.016303351226
			H[16] <- -0.018769396836
			H[17] <- 0.000876502539
			H[18] <- 0.001981193736
			filter.name <- c("Daub cmpct on least asymm N=9")
			H <- H/sqrt(2)
		}
		else if(filter.number == 10) {
			H <- rep(0, 20)
			H[1] <- 0.001089170447
			H[2] <- 0.000135245020
			H[3] <- -0.01222064263
			H[4] <- -0.002072363923
			H[5] <- 0.064950924579
			H[6] <- 0.016418869426
			H[7] <- -0.225558972234
			H[8] <- -0.100240215031
			H[9] <- 0.667071338154
			H[10] <- 1.0882515305
			H[11] <- 0.542813011213
			H[12] <- -0.050256540092
			H[13] <- -0.045240772218
			H[14] <- 0.07070356755
			H[15] <- 0.008152816799
			H[16] <- -0.028786231926
			H[17] <- -0.001137535314
			H[18] <- 0.006495728375
			H[19] <- 8.0661204e-05
			H[20] <- -0.000649589896
			filter.name <- c("Daub cmpct on least asymm N=10")
			H <- H/sqrt(2)
		}
		else {
			stop("Unknown filter number for Daubechies wavelets with\n least asymmetry and highest number of vanishing moments..."
				)
		}
	}
	else if(family == "MagKing") {
		family <- "MagKing"
		if(filter.number == 4) {
			H <- c(1-1i, 4-1i, 4+1i, 1+1i)/10
			G <- c(-1-2i, 5+2i, -5+2i, 1-2i)/14
			filter.name <- c("MagareyKingsbury Wavelet 4-tap")
		}
		else stop("Only have 4-tap filter at present")
	}
	else if(family == "Nason") {
		family <- "Nason"
		if(filter.number == 3) {
			H <- c(-0.066291+0.085581i,
				0.110485+0.085558i, 
				0.662912-0.171163i, 
				0.662912-0.171163i, 
				0.110485+0.085558i, 
				-0.066291+0.085581i)
			G <- c(-0.066291+0.085581i,
				-0.110485-0.085558i, 
				0.662912-0.171163i, 
				-0.662912+0.171163i
				, 0.110485+0.085558i, 
				0.066291-0.085581i)
			filter.name <- c("Nason Complex Wavelet 6-tap")
		}
		else stop("Only have 6-tap filter at present")
	}
	else if(family == "Lawton") {
		family <- "Lawton"
		if(filter.number == 3) {
			H <- c(-0.066291+0.085581i,
				0.110485+0.085558i,
				0.662912-0.171163i,
				0.662912-0.171163i,
				0.110485+0.085558,
				-0.066291+0.085581i)
			G <- c(-0.066291-0.085581i,
				-0.110485+0.085558i, 
				0.662912+0.171163i, 
				-0.662912-0.171163i
				, 0.110485-0.085558i, 
				0.066291+0.085581i)
			filter.name <- c("Lawton Complex Wavelet 6-tap")
		}
		else stop("Only have 6-tap filter at present")
	}
	else if(family == "LittlewoodPaley") {
		family <- "LittlewoodPaley"
		#
		#
		#		Define the function that computes the coefficients
		#
		hn <- function(n)
		{
			if(n == 0)
				return(1)
			else {
				pin2 <- (pi * 1:n)/2
				pin2 <- (sin(pin2)/pin2)
				return(c(rev(pin2), 1, pin2))
			}
		}
		H <- hn(filter.number)
		filter.name <- paste("Littlewood-Paley, N=", filter.number)
	}
	else if(family == "Yates") {
		if(filter.number != 1)
			stop("Only filter number 1 exists for Yates wavelet")
		family <- "Yates"
		H <- c(-1, 1)/sqrt(2)
		filter.name <- "Yates"
	}
	else if(family == "LinaMayrand") {
		origfn <- filter.number
		nsolution <- as.character(filter.number)
		dotpos <- regexpr("\\.", nsolution)
		leftint <- substring(nsolution, first = 1, last = dotpos - 1)
		rightint <- substring(nsolution, first = dotpos + 1, last = 
			nchar(nsolution))
		if(nchar(nsolution) == 0)
			nsolution <- 1
		else nsolution <- as.numeric(rightint)
		filter.number <- as.numeric(leftint)
		matname <- paste(family, filter.number, sep = "")
		if(!exists(matname)) {
			stop(paste("Filter matrix \"", matname, 
				"\" does not exist", sep = ""))
		}
		else {
			fm <- get(matname)
			if(nsolution > nrow(fm$S))
				stop(paste("Solution number ", nsolution, 
					" is too big. Filter matrix ", matname,
					" only has ", nrow(fm$S), " solutions")
					)
			H <- fm$S[nsolution,  ]
			G <- fm$W[nsolution,  ]
			filter.name <- paste("Lina Mayrand, J=", filter.number,
				" (nsolution=", nsolution, ")", sep = "")
		}
		filter.number <- origfn
	}
	else {
		stop("Unknown family")
	}
	H <- H/constant
	return(list(H = H, G = G, name = filter.name, family = family, 
		filter.number = filter.number))
}
"find.parameters" <-
function(data.wd, dwwt, j0, code, tol, Sigma)
{
	#
	# Preliminaries
	#
	nlevels <- nlevels(data.wd)
	pars <- matrix(0, ncol = 4, nrow = nlevels - 1)
	dimnames(pars) <- list(paste("level", 1:(nlevels - 1)), c("p", 
		"var(re)", "covar(re,im)", "var(im)"))
	lower <- c(tol, tol, tol - 1, tol)
	upper <- c(1 - tol, 1000, 1 - tol, 1000)
	#
	# Calculate the covariance matrix of white noise put
	# through the DWT:
	#
	detSigma <- rep(0, nlevels)
	Sigma.inv <- array(0, c(nlevels, 2, 2))
	for(i in 1:nlevels) {
		detSigma[i] <- Sigma[i, 1, 1] * Sigma[i, 2, 2] - Sigma[i, 1,
			2]^2
		Sigma.inv[i,  ,  ] <- solve(Sigma[i,  ,  ])
	}
	#
	# Now search at each level in turn.
	#
	for(j in j0:(nlevels - 1)) {
		#
		# Get a starting point for the 
		# search over p_j and V_j 
		#
		coefs <- accessD(data.wd, level = j)
		re <- Re(coefs)
		im <- Im(coefs)
		start <- c(min(1 - 10 * tol, 0.5^(j - j0)), var(re), cor(re,
			im), var(im))
		#
		# Find the MML parameter values
		#
		coefs <- accessD(data.wd, level = j)
		dstarvec <- cbind(Re(coefs), Im(coefs))
		if(code == "NAG") {
			write(c(Sigma[j + 1, 1, 1], Sigma[j + 1, 1, 2], Sigma[
				j + 1, 2, 2]), file = "cthresh.maxloglik.data")
			write(length(re), file = "cthresh.maxloglik.data",
				append = TRUE)
			write(t(cbind(re, im)), file = "cthresh.maxloglik.data",
				append = TRUE, ncolumns = 2)
			write(start, file = "cthresh.maxloglik.start")
			write(t(cbind(lower, upper)), file = 
				"cthresh.maxloglik.start", append = TRUE)
			system("./cthresh.maxloglik")
			tmp <- scan(file = "cthresh.maxloglik.out", multi.line
				 = TRUE, quiet = TRUE)
			pars[j,  ] <- tmp[1:4]
			pars[j, 3] <- pars[j, 3] * sqrt(pars[j, 2] * pars[
				j, 4])
			ifail <- tmp[6]
			if(ifail > 0)
				warning(paste("At level", j, 
					"NAG routine e04jyf returned ifail",
					ifail))
			system("rm cthresh.maxloglik.out cthresh.maxloglik.data cthresh.maxloglik.start"
				)
		}
		else {
			if(exists("optim"))
			tmp <- optim(start, cthr.negloglik, method = 
				"L-BFGS-B", lower = lower,
				upper = upper, dstarvec = dstarvec, Sigma = 
				Sigma[j + 1,  ,  ], Sigma.inv = Sigma.inv[
				j + 1,  ,  ], twopirtdetS = 2 * pi * sqrt(
				detSigma[j + 1]), code = code)$par
			else
			tmp <- nlminb(start, cthr.negloglik, lower = lower,
				upper = upper, dstarvec = dstarvec, Sigma = 
				Sigma[j + 1,  ,  ], Sigma.inv = Sigma.inv[
				j + 1,  ,  ], twopirtdetS = 2 * pi * sqrt(
				detSigma[j + 1]), code = code)$parameters
			pars[j,  ] <- tmp
			pars[j, 3] <- pars[j, 3] * sqrt(pars[j, 2] * pars[
				j, 4])
		}
	}
	invisible(list(pars = pars, Sigma = Sigma))
}
"make.dwwt" <-
function(nlevels, filter.number = 3.1, family = "LinaMayrand")
{
	#
	# Given a choice of wavelet and number of 
	# resolution levels, compute the distinct 
	# elements of diag(WW^T).
	#
	zero.wd <- wd(rep(0, 2^nlevels), filter.number = filter.number, family
		 = family)
	dwwt <- rep(0, nlevels)
	tmp.wd <- putD(zero.wd, v = 1, level = 0)
	tmp <- Conj(wr(tmp.wd))
	#
	# tmp contains the row of W which gives the mother wavelet
	# coefficient.  Need Conj() as the inverse DWT corresponds to
	# Conj(W^T).  Now get the corresponding element of diag(WW^T)
	# by summing the squared elements of tmp.
	#
	# Then repeat for each resolution level.
	#
	dwwt[1] <- sum(tmp * tmp)
	for(lev in 1:(nlevels - 1)) {
		tmp.wd <- putD(zero.wd, v = c(1, rep(0, 2^lev - 1)), level = 
			lev)
		tmp <- Conj(wr(tmp.wd))
		dwwt[lev + 1] <- sum(tmp * tmp)
	}
	return(dwwt)
}
"odds.matrix.mult" <-
function(coef, mat)
{
	return(t(coef) %*% mat %*% coef)
}
"test.data" <-
function(type = "ppoly", n = 512, signal = 1, rsnr = 7, plotfn = FALSE)
{
	x <- seq(0., 1., length = n + 1)[1:n]
	if(type == "ppoly") {
		y <- rep(0., n)
		xsv <- (x <= 0.5)
		y[xsv] <- -16. * x[xsv]^3. + 12. * x[xsv]^2.
		xsv <- (x > 0.5) & (x <= 0.75)
		y[xsv] <- (x[xsv] * (16. * x[xsv]^2. - 40. * x[xsv] + 28.))/
			3. - 1.5
		xsv <- x > 0.75
		y[xsv] <- (x[xsv] * (16. * x[xsv]^2. - 32. * x[xsv] + 16.))/
			3.
	}
	else if(type == "blocks") {
		t <- c(0.1, 0.13, 0.15, 0.23, 0.25, 0.4, 0.44,
			0.65, 0.76, 0.78, 0.81)
		h <- c(4., -5., 3., -4., 5., -4.2, 2.1, 4.3, 
			-3.1, 2.1, -4.2)
		y <- rep(0., n)
		for(i in seq(1., length(h))) {
			y <- y + (h[i] * (1. + sign(x - t[i])))/2.
		}
	}
	else if(type == "bumps") {
		t <- c(0.1, 0.13, 0.15, 0.23, 0.25, 0.4, 0.44,
			0.65, 0.76, 0.78, 0.81)
		h <- c(4., 5., 3., 4., 5., 4.2,	2.1, 4.3, 
			3.1, 5.1, 4.2)
		w <- c(0.005, 0.005, 0.006, 0.01, 0.01, 0.03,
			0.01, 0.01, 0.005, 0.008, 0.005)
		y <- rep(0, n)
		for(j in 1:length(t)) {
			y <- y + h[j]/(1. + abs((x - t[j])/w[j]))^4.
		}
	}
	else if(type == "heavi")
		y <- 4. * sin(4. * pi * x) - sign(x - 0.3) -
			sign(0.72 - x)
	else if(type == "doppler") {
		eps <- 0.05
		y <- sqrt(x * (1. - x)) * sin((2. * pi * (1. + eps))/(x + eps))
	}
	else {
		cat(c("test.data: unknown test function type", type, "\n"))
		cat(c("Terminating\n"))
		return("NoType")
	}
	y <- y/sqrt(var(y)) * signal
	ynoise <- y + rnorm(n, 0, signal/rsnr)
	if(plotfn == TRUE) {
		if(type == "ppoly")
			mlab <- "Piecewise polynomial"
		if(type == "blocks")
			mlab <- "Blocks"
		if(type == "bumps")
			mlab <- "Bumps"
		if(type == "heavi")
			mlab <- "HeaviSine"
		if(type == "doppler")
			mlab <- "Doppler"
		plot(x, y, type = "l", lwd = 2, main = mlab, ylim = range(
			c(y, ynoise)))
		lines(x, ynoise, col = 2)
		lines(x, y)
	}
	return(list(x = x, y = y, ynoise = ynoise, type = type, rsnr = rsnr))
}
