### Name: GenW
### Title: Generate (inverse) discrete wavelet transform matrix.
### Aliases: GenW
### Keywords: array

### ** Examples

#
# Generate the wavelet transform matrix corresponding to the Haar wavelet
# transform of order 8
#
#haarmat <- GenW(8, filter.number=1, family="DaubExPhase")
#
# Let's look at this matrix
#
#haarmat
#          [,1]       [,2]       [,3]       [,4]       [,5] [,6] [,7]       [,8] 
#[1,] 0.3535534  0.7071068  0.0000000  0.0000000  0.0000000  0.5  0.0  0.3535534
#[2,] 0.3535534 -0.7071068  0.0000000  0.0000000  0.0000000  0.5  0.0  0.3535534
#[3,] 0.3535534  0.0000000  0.7071068  0.0000000  0.0000000 -0.5  0.0  0.3535534
#[4,] 0.3535534  0.0000000 -0.7071068  0.0000000  0.0000000 -0.5  0.0  0.3535534
#[5,] 0.3535534  0.0000000  0.0000000  0.7071068  0.0000000  0.0  0.5 -0.3535534
#[6,] 0.3535534  0.0000000  0.0000000 -0.7071068  0.0000000  0.0  0.5 -0.3535534
#[7,] 0.3535534  0.0000000  0.0000000  0.0000000  0.7071068  0.0 -0.5 -0.3535534
#[8,] 0.3535534  0.0000000  0.0000000  0.0000000 -0.7071068  0.0 -0.5 -0.3535534
#
# As noted above the first column is the l.c. corresponding to the scaling
# function coefficient and then the l.c.s corresponding to the wavelet
# coefficients from the finest to the coarsest.
#
# The above matrix represented the inverse DWT. Let's compute the forward
# transform matrix representation:
#
#t(haarmat)
#          [,1]       [,2]       [,3]       [,4]       [,5]       [,6]       [,7]       [,8] 
#[1,] 0.3535534  0.3535534  0.3535534  0.3535534  0.3535534  0.3535534  0.3535534  0.3535534
#[2,] 0.7071068 -0.7071068  0.0000000  0.0000000  0.0000000  0.0000000  0.0000000  0.0000000
#[3,] 0.0000000  0.0000000  0.7071068 -0.7071068  0.0000000  0.0000000  0.0000000  0.0000000
#[4,] 0.0000000  0.0000000  0.0000000  0.0000000  0.7071068 -0.7071068  0.0000000  0.0000000
#[5,] 0.0000000  0.0000000  0.0000000  0.0000000  0.0000000  0.0000000  0.7071068 -0.7071068
#[6,] 0.5000000  0.5000000 -0.5000000 -0.5000000  0.0000000  0.0000000  0.0000000  0.0000000
#[7,] 0.0000000  0.0000000  0.0000000  0.0000000  0.5000000  0.5000000 -0.5000000 -0.5000000
#[8,] 0.3535534  0.3535534  0.3535534  0.3535534 -0.3535534 -0.3535534 -0.3535534 -0.3535534
#
#



