### Name: plot.wd
### Title: Plot wavelet transform coefficients.
### Aliases: plot.wd
### Keywords: hplot smooth

### ** Examples

#
# Generate some test data
#
#test.data <- example.1()$y
#ts.plot(test.data)
#
# Decompose test.data and plot the wavelet coefficients
#
#wds <- wd(test.data)
#plot(wds)
#
# Now do the time-ordered non-decimated wavelet transform of the same thing
#
#wdS <- wd(test.data, type="station")
#plot(wdS)
#
# Next example
# ------------
# The chirp signal is also another good example to use.
#
# Generate some test data
#
#test.chirp <- simchirp()$y
#ts.plot(test.chirp, main="Simulated chirp signal")
#
# Now let's do the time-ordered non-decimated wavelet transform.
# For a change let's use Daubechies least-asymmetric phase wavelet with 8
# vanishing moments (a totally arbitrary choice, please don't read
# anything into it).
#
#chirpwdS <- wd(test.chirp, filter.number=8, family="DaubLeAsymm", type="station")
#plot(chirpwdS, main="TOND WT of Chirp signal")



