### Name: wst2D
### Title: (Packet-ordered) 2D non-decimated wavelet transform.
### Aliases: wst2D
### Keywords: math smooth nonlinear

### ** Examples

#
# We shall use the ua image of
# the University coat of arms.
#
#image(ua)
#
#
# Now let's apply the (packet-ordered) 2D non-decimated DWT to it...
# (using the default wavelets)
#
#uawst2D <- wst2D(ua)
#
# One can use the function plot.wst2D to get
# a picture of all the resolution levels. However, let's just look at them
# one at a time.
#
# How many levels does our uawst2D object have? 
#
#nlevels(uawst2D)
#[1] 8
#
# O.k. Let's look at resolution level 7
#
#image(uawst2D$wst2D[8,,])
#
#
# There are four main blocks here (each of 256x256 pixels) which themselves
# contain four sub-blocks. The primary blocks correspond to the no shift,
# horizontal shift, vertical shift and "horizontal and vertical" shifts
# generated by the shift S operator. Within each of the 256x256 blocks
# we have the "usual" Mallat smooth, horizontal, vertical and diagonal
# detail, with the smooth in the top left of each block.
#
# Let's extract the smooth, with no shifts at level 7 and display it
#
#image(getpacket(uawst2D, level=7, index=0, type="S"))
#
#
# Now if we go two more resolution levels deeper we have now 64x64 blocks
# which contain 32x32 subblocks corresponding to the smooth, horizontal,
# vertical and diagonal detail. 
#
#immagic(uawst2D$wst2D[6,,])
#
#
# Groovy eh?



